/*
 * File:     AbstractComplexSearchFrame.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.content.viewer;

import mpi.search.SearchLocale;

import mpi.util.gui.SimpleHtmlViewer;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;


/**
 * DOCUMENT ME!
 * $Id: jalopy_gnu_src_dist.xml 11222 2007-12-11 15:57:47Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class AbstractComplexSearchFrame extends JFrame {
    private Action helpAction;

    /** Holds value of property DOCUMENT ME! */
    protected final AbstractComplexSearchPanel searchPanel;

    /** Holds value of property DOCUMENT ME! */
    public AbstractComplexSearchFrame(AbstractComplexSearchPanel searchPanel) {
        super(SearchLocale.getString("SearchDialog.Title"));
        this.searchPanel = searchPanel;
        getContentPane().add(searchPanel);
        createMenuBar();
        addWindowListener(new WindowAdapter() {
                public void windowClosing(WindowEvent event) {
                    AbstractComplexSearchFrame.this.searchPanel.stopSearch();
                }
            });
    }

    private void createMenuBar() {
        helpAction = new AbstractAction(SearchLocale.getString("Action.Help")) {
                    public void actionPerformed(ActionEvent e) {
                        showInfoDialog();
                    }
                };
        helpAction.putValue(Action.SHORT_DESCRIPTION,
            SearchLocale.getString("Action.Tooltip.Help"));

        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(SearchLocale.getString("SearchDialog.File"));
        fileMenu.add(searchPanel.getCloseAction());
        menuBar.add(fileMenu);

        JMenu queryMenu = new JMenu(SearchLocale.getString("SearchDialog.Query"));
        queryMenu.add(searchPanel.getStartAction());
        queryMenu.add(searchPanel.zoomAction);
        queryMenu.addSeparator();
        queryMenu.add(searchPanel.saveAction);
        queryMenu.add(searchPanel.readAction);
        queryMenu.add(searchPanel.getExportAction());
        menuBar.add(queryMenu);

        JMenu helpMenu = new JMenu(SearchLocale.getString("SearchDialog.Help"));
        helpMenu.add(helpAction);
        menuBar.add(helpMenu);

        setJMenuBar(menuBar);
    }

    private void showInfoDialog() {
        JDialog infoDialog = new SimpleHtmlViewer(this, "Search Info", false,
                "/mpi/eudico/client/annotator/resources/SearchHelp.html");
        infoDialog.pack();
        infoDialog.setSize(600, 400);
        infoDialog.setVisible(true);
    }
}
