/*
 * File:     SearchController.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.model;

import mpi.search.query.model.Query;

import mpi.search.result.model.Result;


/**
 * $Id: SearchController.java 8348 2007-03-09 09:43:13Z klasal $
 *
 * @author Alexander Klassmann
 * @version July 2004
 */
public interface SearchController {
    /** Holds value of property DOCUMENT ME! */
    static public int INIT = 0;

    /** Holds value of property DOCUMENT ME! */
    static public int ACTIVE = 1;

    /** Holds value of property DOCUMENT ME! */
    static public int FINISHED = 2;

    /** Holds value of property DOCUMENT ME! */
    static public int INTERRUPTED = 3;

    /**
     * Execute a query tree on behalf of forQManager.
     * @param query
     */
    public void execute(Query query);

    /**
     * checks if search is running
     * @return true if in process
     */
    public boolean isExecuting();

    /**
     * Stop searching.
     */
    public void stopExecution();

    /**
     * Returns result. Contains all matches found until stopped.
     * @return Result
     */
    public Result getResult();

    /**
     * set a GUI for showing progress of search
     * @param o
     */
    public void setProgressListener(ProgressListener o);

    /**
     * get current search duration
     * @return search duration in ms
     */
    public long getSearchDuration();
}
