/*
 * File:     StringUtil.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Id: StringUtil.java 8222 2007-02-22 10:20:51Z klasal $
 */
package mpi.util;


/**
 * Static methods for java.lang.String objects.
 *
 * <p>
 * NOTE The methods contains(), stringToArr(), and replace() should not be used
 * - use the String class equivalents whenever possible.
 * </p>
 */
public final class StringUtil {
    /**
     * Returns the list of all integers i where myself.indexOf(i) is true.
     *
     * @param in String that is to be searched
     * @param substr The search term
     *
     * @return An array of all indices in the searched String where the search
     *         term was found.
     */
    public final static int[] indexesOf(String in, String substr) {
        if ((in == null) || (substr == null) || (in.length() == 0) ||
                (substr.length() == 0)) {
            return null;
        }

        int[] result = new int[(in.length() / substr.length()) + 1];
        int nrHits = 0;

        int i = in.indexOf(substr, 0);

        while (i != -1) {
            result[nrHits] = i;
            i = in.indexOf(substr, i + 1);
            nrHits++;
        }

        return result;
    }

    /**
     * DOCUMENT ME!
     *
     * @param s DOCUMENT ME!
     * @param ch DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public final static boolean contains(String s, int ch) {
        return (s != null) && (s.indexOf(ch) != -1);
    }

    // MK 2002/04/08
    // QUICK FIX for TLC, Sonja Eisenbeis asec directory.
    // ALPHA version: use at own risc
    public final static boolean contains(String s, String ch) {
        return (s != null) && (s.indexOf(ch) != -1);
    }

    /**
     * Transforms a given String and seperator into an array of Strings. Two
     * seperators following each other are interpreted as seperator, empty
     * String, seperator. A leading/trailing seperator will introduce a
     * leading/trailing empty string.
     * <pre>
     *  "tic tac toe",  ' ' --> {"tic", "tac", "toe"}
     *  "tic tac  toe", ' ' --> {"tic", "tac", "", "toe"}
     *  </pre>
     * Effeciency: to be improved.
     *
     * <p>
     * NOTE The conversion of a String to a String[] is provided by String's
     * split(String regex) method. The nr of elements would also be the same
     * in a case like the second example above, but not in case of a string
     * like "one two    ", so I did not take the risk of substituting it. TODO
     * check whether it can safely be substituted.
     * </p>
     *
     * @param s DOCUMENT ME!
     * @param seperator DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @deprecated Use String.split(String regex) instead whenever possible!
     */
    public final static String[] stringToArr(String s, char seperator) {
        if (s == null) {
            return null;
        }

        int seperators = 0;

        for (int i = 0; i < s.length(); i++) {
            if (s.charAt(i) == seperator) {
                seperators += 1;
            }
        }

        String[] result = new String[seperators + 1];
        int iResult = 0;
        String element = "";

        for (int i = 0; i < s.length(); i++) {
            if (s.charAt(i) == seperator) {
                result[iResult++] = new String(element);
                element = "";
            } else {
                element = element.concat(s.charAt(i) + "");
            }
        }

        result[iResult] = new String(element);

        return result;
    }

    /**
     * DOCUMENT ME!
     *
     * @param tthis the source
     * @param search search
     * @param replace replace
     *
     * @return DOCUMENT ME! TODO Use String.replaceAll(regex, substitution)
     *         whenever possible.
     */
    public final static String replace(String tthis, String search,
        String replace) {
        if ((tthis == null) || (search == null) || search.equals("")) {
            return tthis;
        }

        int tlen = search.length();
        int clen = replace.length();
        int pos = tthis.indexOf(search);

        while (pos != -1) {
            tthis = tthis.substring(0, pos) + replace +
                tthis.substring(pos + tlen);

            int next = tthis.substring(pos + clen).indexOf(search);

            if (next == -1) {
                pos = -1;
            } else {
                pos += (next + clen);
            }
        }

        return tthis;
    }

    /**
     * Transforms a given Array of Strings and a seperator into a String.
     * <pre>
     *  {"tic", "tac", "toe"} ' ' --> "tic tac toe"
     *  </pre>
     * Effeciency: to be improved.
     *
     * @param arr DOCUMENT ME!
     * @param seperator DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public final static String arrToString(String[] arr, char seperator) {
        if (arr.length == 0) {
            return "";
        }

        StringBuffer result = new StringBuffer();

        for (int i = 0; i < (arr.length - 1); i++) {
            result.append(arr[i]).append(seperator);
        }

        result = result.append(arr[arr.length - 1]);

        return result.toString();
    }

    /**
     * Removes the last character from the String
     *
     * @param s the given String, Nullable
     *
     * @return s without the last character, or null
     */
    public final static String chop(String s) {
        if (s == null) {
            return null;
        }

        if (s.length() == 0) {
            return s;
        }

        return s.substring(0, s.length() - 1);
    }

    /**
     * Removes the last character from the String, if it is a \n character.
     *
     * @param s the given String, Nullable
     *
     * @return s without the last \n, or null
     */
    public final static String chomp(String s) {
        if (s == null) {
            return null;
        }

        if (s.endsWith("\n")) {
            return s.substring(0, s.length() - 1);
        }

        return s;
    }
}
