/*
 * File:     XMLUtil.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.util;


/**
 *
 * class XMLUtil
 *
 * implements  XML utilities
 * @author Daan Broeder
 */
public class XMLUtil {
    /**
     * toStdEnt()
     * replace all & by &amp;
     * replace all < by &lt;
     */
    public static String toStdEnt(String str) {
        str = replace(str, "&", "&amp;");
        str = replace(str, "<", "&lt;");
        str = replace(str, ">", "&gt;");

        return str;
    }

    private static String replace(String str, String target, String substitute) {
        int oldidx = 0;
        int idx = 0;
        StringBuffer sb = new StringBuffer("");

        while (idx < str.length()) {
            if ((idx = str.indexOf(target, oldidx)) == -1) {
                idx = str.length();
                sb.append(str.substring(oldidx, idx));
            } else {
                sb.append(str.substring(oldidx, idx));
                sb.append(substitute);
            }

            oldidx = idx + 1;
        }

        return new String(sb);
    }

    /**
     * You cannot use characters like &amp; and &lt; in XML text.  Use this
     * function to escape the characters. This function is not contained in
     * JAXP 1.0.1
     *
     * @param s DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public final static String encodeXMLtext(String s) {
        if (s == null) {
            return s;
        }

        s = StringUtil.replace(s, "&", "&amp;");
        s = StringUtil.replace(s, "<", "&lt;");

        return s;
    }

    /**
     * From some &amp;xyz; encodings back to normal characters.
     *
     * @param s DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public final static String decodeXMLtext(String s) {
        if (s == null) {
            return s;
        }

        s = StringUtil.replace(s, "&amp;", "&");
        s = StringUtil.replace(s, "&lt;", "<");

        return s;
    }
}
 //XMLUtil
