/*
 * File:     FileAndEncodingChooser.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.util.gui;

import java.awt.BorderLayout;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;


/**
 * $Id: FileAndEncodingChooser.java 10723 2007-10-29 13:50:40Z hasloe $
 * JFileChooser extended with the option to select an encoding
 *
 * @author $author$
 * @version $Revision$
 */
public class FileAndEncodingChooser extends JFileChooser {
    /** Holds value of property DOCUMENT ME! */
    public static final String UTF_8 = "UTF-8";

    /** Holds value of property DOCUMENT ME! */
    public static final String UTF_16 = "UTF-16";

    /** Holds value of property DOCUMENT ME! */
    public static final String ISO_LATIN = "ISO-8859-1";

    /** Holds value of property DOCUMENT ME! */
    public static final String[] encodings = new String[] {
            UTF_8, UTF_16, ISO_LATIN
        };

    /** Holds value of property DOCUMENT ME! */
    private final JComboBox comboBox = new JComboBox(encodings);

    /**
     * Creates a new FileAndEncodingChooser object.
     */
    public FileAndEncodingChooser() {
        super();
        addComboBox();
    }

    /**
     * for debugging
     *
     * @param args DOCUMENT ME!
     */
    public static void main(String[] args) {
        javax.swing.JFrame frame = new javax.swing.JFrame();
        FileAndEncodingChooser f = new FileAndEncodingChooser();

        if (f.showSaveDialog(frame) == JFileChooser.APPROVE_OPTION) {
            System.out.println(f.getSelectedEncoding());
        }
    }

    /**
     * Sets the encoding to select in the combobox.
     *
     * @param item the encoding to select in the combobox
     */
    public void setSelectedEncoding(String item) {
        comboBox.setSelectedItem(item);
    }

    /**
     * Returns the selected encoding.
     *
     * @return the selected encoding
     */
    public String getSelectedEncoding() {
        return (String) comboBox.getSelectedItem();
    }

    /**
     * Specifies a custom set of encodings.
     *
     * @param encs the encodings
     */
    public void setEncodings(String[] encs) {
        if ((encs != null) && (encs.length > 0)) {
            comboBox.removeAllItems();

            for (int i = 0; i < encs.length; i++) {
                comboBox.addItem(encs[i]);
            }

            comboBox.setSelectedIndex(0);
        }
    }

    /**
     * dirty yet short hack to include encodings into UI
     */
    private void addComboBox() {
        JComponent component = ((JComponent) getComponent(getComponentCount() -
                1));

        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(5, 0, 0, 0));
        panel.add(new JLabel("Encoding:   "), BorderLayout.WEST);
        panel.add(comboBox, BorderLayout.CENTER);
        component.add(panel, component.getComponentCount() - 1);
        comboBox.setSelectedIndex(0);
    }
}
