/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.value;

import java.util.Iterator;
import org.apache.batik.css.CSSOMReadOnlyStyleDeclaration;
import org.apache.batik.css.CSSOMReadOnlyValue;
import org.apache.batik.css.value.CommonCSSContext;
import org.apache.batik.css.value.FontFamilyFactory;
import org.apache.batik.css.value.ImmutableString;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.ImmutableValueList;
import org.apache.batik.css.value.RelativeValueResolver;
import org.w3c.dom.Element;
import org.w3c.dom.css.ViewCSS;

public class FontFamilyResolver
implements RelativeValueResolver {
    protected CommonCSSContext context;

    public FontFamilyResolver(CommonCSSContext commonCSSContext) {
        this.context = commonCSSContext;
    }

    public boolean isInheritedProperty() {
        return true;
    }

    public String getPropertyName() {
        return "font-family";
    }

    public CSSOMReadOnlyValue getDefaultValue() {
        ImmutableValueList immutableValueList = new ImmutableValueList();
        Iterator iterator = this.context.getDefaultFontFamilyValue().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            immutableValueList.append(new CSSOMReadOnlyValue(this.createFontFamilyValue(string)));
        }
        return new CSSOMReadOnlyValue(immutableValueList);
    }

    public void resolveValue(Element element, String string, ViewCSS viewCSS, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration, CSSOMReadOnlyValue cSSOMReadOnlyValue, String string2, int n) {
    }

    protected ImmutableValue createFontFamilyValue(String string) {
        ImmutableValue immutableValue = (ImmutableValue)FontFamilyFactory.values.get(string.toLowerCase().intern());
        if (immutableValue != null) {
            return immutableValue;
        }
        return new ImmutableString(19, string);
    }
}

