/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.Serializable;
import org.apache.batik.dom.events.DocumentEventSupport;
import org.apache.batik.dom.util.HashTable;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public abstract class AbstractDOMImplementation
implements DOMImplementation,
Serializable {
    protected final HashTable features = new HashTable();

    protected void registerFeature(String string, Object object) {
        this.features.put(string.toLowerCase(), object);
    }

    protected AbstractDOMImplementation() {
        this.registerFeature("XML", new String[]{"1.0", "2.0"});
        this.registerFeature("Events", "2.0");
        this.registerFeature("MouseEvents", "2.0");
        this.registerFeature("MutationEvents", "2.0");
        this.registerFeature("Traversal", "2.0");
        this.registerFeature("UIEvents", "2.0");
    }

    public boolean hasFeature(String string, String string2) {
        Object object = this.features.get(string.toLowerCase());
        if (object == null) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return true;
        }
        if (object instanceof String) {
            return string2.equals(object);
        }
        String[] stringArray = (String[])object;
        int n = 0;
        while (n < stringArray.length) {
            if (object.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public DocumentEventSupport createDocumentEventSupport() {
        return new DocumentEventSupport();
    }

    public abstract Document createDocument(String var1, String var2, DocumentType var3) throws DOMException;

    public abstract DocumentType createDocumentType(String var1, String var2, String var3) throws DOMException;
}

