/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import java.util.Set;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.AltGlyphHandler;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.text.ArabicTextHandler;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.gvt.text.TextSpanLayout;

public class GlyphLayout
implements TextSpanLayout {
    private GVTGlyphVector gv;
    private GVTFont font;
    private GVTLineMetrics metrics;
    private AttributedCharacterIterator aci;
    private FontRenderContext frc;
    private AffineTransform transform;
    private Point2D advance;
    private Point2D offset;
    private Point2D prevCharPosition;
    private TextPath textPath;
    private Point2D textPathAdvance;
    private int[] charMap;
    private boolean vertical;
    private static final AttributedCharacterIterator.Attribute X = GVTAttributedCharacterIterator.TextAttribute.X;
    private static final AttributedCharacterIterator.Attribute Y = GVTAttributedCharacterIterator.TextAttribute.Y;
    private static final AttributedCharacterIterator.Attribute DX = GVTAttributedCharacterIterator.TextAttribute.DX;
    private static final AttributedCharacterIterator.Attribute DY = GVTAttributedCharacterIterator.TextAttribute.DY;
    private static final AttributedCharacterIterator.Attribute ROTATION = GVTAttributedCharacterIterator.TextAttribute.ROTATION;
    private static final AttributedCharacterIterator.Attribute BASELINE_SHIFT = GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT;
    private static final AttributedCharacterIterator.Attribute WRITING_MODE = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE;
    private static final Integer WRITING_MODE_TTB = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB;
    static Set runAtts = new HashSet();
    public static final float eps = 1.0E-5f;

    public GlyphLayout(AttributedCharacterIterator attributedCharacterIterator, int[] nArray, Point2D point2D, FontRenderContext fontRenderContext) {
        this.aci = attributedCharacterIterator;
        this.frc = fontRenderContext;
        this.offset = point2D;
        this.transform = null;
        this.font = this.getFont(this.aci);
        this.charMap = nArray;
        this.metrics = this.font.getLineMetrics(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), fontRenderContext);
        this.gv = null;
        this.aci.first();
        this.vertical = attributedCharacterIterator.getAttribute(WRITING_MODE) == WRITING_MODE_TTB;
        AltGlyphHandler altGlyphHandler = (AltGlyphHandler)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER);
        if (altGlyphHandler != null) {
            this.gv = altGlyphHandler.createGlyphVector(fontRenderContext, this.font.getSize(), this.aci);
        }
        if (this.gv == null) {
            this.gv = this.font.createGlyphVector(fontRenderContext, this.aci);
        }
        this.gv.performDefaultLayout();
        this.doExplicitGlyphLayout(false);
        this.adjustTextSpacing();
        this.doPathLayout(false);
    }

    public void draw(Graphics2D graphics2D) {
        if (this.transform != null) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.transform(this.transform);
            this.gv.draw(graphics2D, this.aci);
            graphics2D.setTransform(affineTransform);
        } else {
            this.gv.draw(graphics2D, this.aci);
        }
    }

    public Shape getOutline() {
        Shape shape = this.gv.getOutline();
        if (this.transform != null) {
            shape = this.transform.createTransformedShape(shape);
        }
        return shape;
    }

    public Point2D getOffset() {
        return this.offset;
    }

    public void setOffset(Point2D point2D) {
        this.offset = point2D;
        this.gv.performDefaultLayout();
        this.doExplicitGlyphLayout(true);
        this.adjustTextSpacing();
        this.doPathLayout(true);
    }

    public Shape getDecorationOutline(int n) {
        Shape shape = new GeneralPath();
        if ((n & 1) != 0) {
            shape.append(this.getUnderlineShape(), false);
        }
        if ((n & 2) != 0) {
            shape.append(this.getStrikethroughShape(), false);
        }
        if ((n & 4) != 0) {
            shape.append(this.getOverlineShape(), false);
        }
        if (this.transform != null) {
            shape = this.transform.createTransformedShape(shape);
        }
        return shape;
    }

    public Rectangle2D getBounds() {
        Rectangle2D rectangle2D = this.gv.getVisualBounds();
        if (this.transform != null) {
            rectangle2D = this.transform.createTransformedShape(rectangle2D).getBounds2D();
        }
        return rectangle2D;
    }

    public Rectangle2D getDecoratedBounds() {
        return this.getBounds().createUnion(this.getDecorationOutline(7).getBounds2D());
    }

    public Point2D getAdvance2D() {
        return this.advance;
    }

    public Point2D getTextPathAdvance() {
        if (this.textPath != null) {
            return this.textPathAdvance;
        }
        return this.getAdvance2D();
    }

    public int getGlyphIndex(int n) {
        int n2 = this.getGlyphCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.getCharacterCount(n4, n4);
            int n6 = 0;
            while (n6 < n5) {
                int n7;
                if (n == (n7 = this.charMap[n3++])) {
                    return n4;
                }
                if (n3 >= this.charMap.length) {
                    return -1;
                }
                ++n6;
            }
            ++n4;
        }
        return -1;
    }

    public Shape getHighlightShape(int n, int n2) {
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        GeneralPath generalPath = null;
        int n4 = this.aci.getBeginIndex();
        int n5 = this.getGlyphCount();
        boolean bl = this.isGlyphOrientationAuto();
        int n6 = 90;
        if (!bl) {
            n6 = this.getGlyphOrientationAngle();
        }
        Point2D.Float[] floatArray = new Point2D.Float[2 * n5];
        Point2D.Float[] floatArray2 = new Point2D.Float[2 * n5];
        int n7 = 0;
        int n8 = n4;
        int n9 = 0;
        while (n9 < n5) {
            Shape shape;
            char c = this.aci.setIndex(n8);
            int n10 = this.charMap[n8 - n4];
            if (n10 >= n && n10 <= n2 && (shape = this.gv.getGlyphLogicalBounds(n9)) != null) {
                if (generalPath == null) {
                    generalPath = new GeneralPath();
                }
                float[] fArray = new float[6];
                int n11 = 0;
                int n12 = -1;
                PathIterator pathIterator = shape.getPathIterator(null);
                Point2D.Float float_ = null;
                if (this.isVertical() && bl) {
                    n6 = this.isLatinChar(c) ? 90 : 0;
                }
                while (!pathIterator.isDone()) {
                    n12 = pathIterator.currentSegment(fArray);
                    if (n12 == 0 || n12 == 1) {
                        if (n11 > 4) break;
                        if (n11 == 4) {
                            if (float_ == null || float_.x != fArray[0] || float_.y != fArray[1]) {
                                break;
                            }
                        } else {
                            Point2D.Float float_2 = new Point2D.Float(fArray[0], fArray[1]);
                            if (n11 == 0) {
                                float_ = float_2;
                            }
                            block0 : switch (n6) {
                                case 0: {
                                    switch (n11) {
                                        case 0: {
                                            floatArray2[n7] = float_2;
                                            break block0;
                                        }
                                        case 1: {
                                            floatArray[n7] = float_2;
                                            break block0;
                                        }
                                        case 2: {
                                            floatArray[n7 + 1] = float_2;
                                            break block0;
                                        }
                                        case 3: {
                                            floatArray2[n7 + 1] = float_2;
                                        }
                                    }
                                    break;
                                }
                                case 90: {
                                    switch (n11) {
                                        case 0: {
                                            floatArray[n7] = float_2;
                                            break block0;
                                        }
                                        case 1: {
                                            floatArray[n7 + 1] = float_2;
                                            break block0;
                                        }
                                        case 2: {
                                            floatArray2[n7 + 1] = float_2;
                                            break block0;
                                        }
                                        case 3: {
                                            floatArray2[n7] = float_2;
                                        }
                                    }
                                    break;
                                }
                                case 180: {
                                    switch (n11) {
                                        case 0: {
                                            floatArray2[n7 + 1] = float_2;
                                            break block0;
                                        }
                                        case 1: {
                                            floatArray[n7 + 1] = float_2;
                                            break block0;
                                        }
                                        case 2: {
                                            floatArray[n7] = float_2;
                                            break block0;
                                        }
                                        case 3: {
                                            floatArray2[n7] = float_2;
                                        }
                                    }
                                    break;
                                }
                                case 270: {
                                    switch (n11) {
                                        case 0: {
                                            floatArray[n7 + 1] = float_2;
                                            break block0;
                                        }
                                        case 1: {
                                            floatArray[n7] = float_2;
                                            break block0;
                                        }
                                        case 2: {
                                            floatArray2[n7] = float_2;
                                            break block0;
                                        }
                                        case 3: {
                                            floatArray2[n7 + 1] = float_2;
                                        }
                                    }
                                }
                            }
                        }
                    } else if (n12 != 4 || n11 < 4 || n11 > 5) break;
                    ++n11;
                    pathIterator.next();
                }
                if (pathIterator.isDone()) {
                    if (floatArray2[n7] != null && (floatArray[n7].x != floatArray[n7 + 1].x || floatArray[n7].y != floatArray[n7 + 1].y)) {
                        n7 += 2;
                    }
                } else {
                    GlyphLayout.addPtsToPath(generalPath, floatArray, floatArray2, n7);
                    n7 = 0;
                    generalPath.append(shape, false);
                }
            }
            n8 += this.getCharacterCount(n9, n9);
            ++n9;
        }
        GlyphLayout.addPtsToPath(generalPath, floatArray, floatArray2, n7);
        if (this.transform != null) {
            return this.transform.createTransformedShape(generalPath);
        }
        return generalPath;
    }

    /*
     * Unable to fully structure code
     */
    public static int makeConvexHull(Point2D.Float[] var0, int var1_1) {
        var3_2 = 1;
        while (var3_2 < var1_1) {
            if (var0[var3_2].x < var0[var3_2 - 1].x || var0[var3_2].x == var0[var3_2 - 1].x && var0[var3_2].y < var0[var3_2 - 1].y) {
                var2_3 = var0[var3_2];
                var0[var3_2] = var0[var3_2 - 1];
                var0[var3_2 - 1] = var2_3;
                var3_2 = 0;
            }
            ++var3_2;
        }
        var4_4 = var0[0];
        var5_5 = var0[var1_1 - 1];
        var6_6 = new Point2D.Float(var5_5.x - var4_4.x, var5_5.y - var4_4.y);
        var8_7 = var6_6.y * var4_4.x - var6_6.x * var4_4.y;
        var9_8 = new Point2D.Float[var1_1];
        var10_9 = new Point2D.Float[var1_1];
        var10_9[0] = var9_8[0] = var0[0];
        var11_10 = 1;
        var12_11 = 1;
        var13_12 = 1;
        while (var13_12 < var1_1 - 1) {
            block13: {
                var14_14 = var0[var13_12];
                var7_13 = var6_6.x * var14_14.y - var6_6.y * var14_14.x + var8_7;
                if (!(var7_13 < 0.0f)) ** GOTO lbl54
                while (var12_11 >= 2) {
                    var4_4 = var10_9[var12_11 - 2];
                    var5_5 = var10_9[var12_11 - 1];
                    var15_15 = var5_5.x - var4_4.x;
                    var16_17 = var5_5.y - var4_4.y;
                    var17_19 = var16_17 * var4_4.x - var15_15 * var4_4.y;
                    var7_13 = var15_15 * var14_14.y - var16_17 * var14_14.x + var17_19;
                    if (var7_13 > 1.0E-5f) break;
                    if (var7_13 > -1.0E-5f) {
                        if (!(var5_5.y < var14_14.y)) break;
                        var14_14 = var5_5;
                        break;
                    }
                    --var12_11;
                }
                v0 = --var12_11;
                ++var12_11;
                var10_9[v0] = var14_14;
                break block13;
lbl-1000:
                // 1 sources

                {
                    var4_4 = var9_8[var11_10 - 2];
                    var5_5 = var9_8[var11_10 - 1];
                    var15_15 = var5_5.x - var4_4.x;
                    var16_17 = var5_5.y - var4_4.y;
                    var17_19 = var16_17 * var4_4.x - var15_15 * var4_4.y;
                    var7_13 = var15_15 * var14_14.y - var16_17 * var14_14.x + var17_19;
                    if (var7_13 < -1.0E-5f) break;
                    if (var7_13 < 1.0E-5f) {
                        if (!(var5_5.y > var14_14.y)) break;
                        var14_14 = var5_5;
                        break;
                    }
                    --var11_10;
lbl54:
                    // 2 sources

                    ** while (var11_10 >= 2)
                }
lbl55:
                // 4 sources

                v1 = --var11_10;
                ++var11_10;
                var9_8[v1] = var14_14;
            }
            ++var13_12;
        }
        var14_14 = var0[var1_1 - 1];
        while (var12_11 >= 2) {
            var4_4 = var10_9[var12_11 - 2];
            var5_5 = var10_9[var12_11 - 1];
            var15_15 = var5_5.x - var4_4.x;
            var16_17 = var5_5.y - var4_4.y;
            var17_19 = var16_17 * var4_4.x - var15_15 * var4_4.y;
            var7_13 = var15_15 * var14_14.y - var16_17 * var14_14.x + var17_19;
            if (var7_13 > 1.0E-5f) break;
            if (var7_13 > -1.0E-5f) {
                if (!(var5_5.y >= var14_14.y)) break;
                --var12_11;
                break;
            }
            --var12_11;
        }
        while (var11_10 >= 2) {
            var4_4 = var9_8[var11_10 - 2];
            var5_5 = var9_8[var11_10 - 1];
            var15_15 = var5_5.x - var4_4.x;
            var16_17 = var5_5.y - var4_4.y;
            var17_19 = var16_17 * var4_4.x - var15_15 * var4_4.y;
            var7_13 = var15_15 * var14_14.y - var16_17 * var14_14.x + var17_19;
            if (var7_13 < -1.0E-5f) break;
            if (var7_13 < 1.0E-5f) {
                if (!(var5_5.y <= var14_14.y)) break;
                --var11_10;
                break;
            }
            --var11_10;
        }
        var15_16 = 0;
        while (var15_16 < var11_10) {
            var0[var15_16] = var9_8[var15_16];
            ++var15_16;
        }
        var0[var15_16++] = var0[var1_1 - 1];
        var16_18 = var12_11 - 1;
        while (var16_18 > 0) {
            var0[var15_16] = var10_9[var16_18];
            --var16_18;
            ++var15_16;
        }
        return var15_16;
    }

    public static void addPtsToPath(GeneralPath generalPath, Point2D.Float[] floatArray, Point2D.Float[] floatArray2, int n) {
        if (n < 2) {
            return;
        }
        if (n == 2) {
            generalPath.moveTo(floatArray[0].x, floatArray[0].y);
            generalPath.lineTo(floatArray[1].x, floatArray[1].y);
            generalPath.lineTo(floatArray2[1].x, floatArray2[1].y);
            generalPath.lineTo(floatArray2[0].x, floatArray2[0].y);
            generalPath.lineTo(floatArray[0].x, floatArray[0].y);
            return;
        }
        Point2D.Float[] floatArray3 = new Point2D.Float[8];
        Point2D.Float[] floatArray4 = new Point2D.Float[8];
        floatArray3[4] = floatArray[0];
        floatArray3[5] = floatArray[1];
        floatArray3[6] = floatArray2[1];
        floatArray3[7] = floatArray2[0];
        Area[] areaArray = new Area[n / 2];
        int n2 = 0;
        int n3 = 2;
        while (n3 < n) {
            floatArray3[0] = floatArray3[4];
            floatArray3[1] = floatArray3[5];
            floatArray3[2] = floatArray3[6];
            floatArray3[3] = floatArray3[7];
            floatArray3[4] = floatArray[n3];
            floatArray3[5] = floatArray[n3 + 1];
            floatArray3[6] = floatArray2[n3 + 1];
            floatArray3[7] = floatArray2[n3];
            float f = floatArray3[2].x - floatArray3[0].x;
            float f2 = f * f;
            f = floatArray3[2].y - floatArray3[0].y;
            float f3 = (float)Math.sqrt(f2 += f * f);
            f = floatArray3[6].x - floatArray3[4].x;
            f2 = f * f;
            f = floatArray3[6].y - floatArray3[4].y;
            f3 += (float)Math.sqrt(f2 += f * f);
            f = (floatArray3[0].x + floatArray3[1].x + floatArray3[2].x + floatArray3[3].x - (floatArray3[4].x + floatArray3[5].x + floatArray3[6].x + floatArray3[7].x)) / 4.0f;
            f2 = f * f;
            f = (floatArray3[0].y + floatArray3[1].y + floatArray3[2].y + floatArray3[3].y - (floatArray3[4].y + floatArray3[5].y + floatArray3[6].y + floatArray3[7].y)) / 4.0f;
            f2 += f * f;
            f2 = (float)Math.sqrt(f2);
            GeneralPath generalPath2 = new GeneralPath();
            if (f2 < 2.0f * f3) {
                System.arraycopy(floatArray3, 0, floatArray4, 0, 8);
                int n4 = GlyphLayout.makeConvexHull(floatArray4, 8);
                generalPath2.moveTo(floatArray4[0].x, floatArray4[0].y);
                int n5 = 1;
                while (n5 < n4) {
                    generalPath2.lineTo(floatArray4[n5].x, floatArray4[n5].y);
                    ++n5;
                }
                generalPath2.closePath();
            } else {
                GlyphLayout.mergeAreas(generalPath, areaArray, n2);
                n2 = 0;
                if (n3 == 2) {
                    generalPath2.moveTo(floatArray3[0].x, floatArray3[0].y);
                    generalPath2.lineTo(floatArray3[1].x, floatArray3[1].y);
                    generalPath2.lineTo(floatArray3[2].x, floatArray3[2].y);
                    generalPath2.lineTo(floatArray3[3].x, floatArray3[3].y);
                    generalPath2.closePath();
                    generalPath.append(generalPath2, false);
                    generalPath2.reset();
                }
                generalPath2.moveTo(floatArray3[4].x, floatArray3[4].y);
                generalPath2.lineTo(floatArray3[5].x, floatArray3[5].y);
                generalPath2.lineTo(floatArray3[6].x, floatArray3[6].y);
                generalPath2.lineTo(floatArray3[7].x, floatArray3[7].y);
                generalPath2.closePath();
            }
            areaArray[n2++] = new Area(generalPath2);
            n3 += 2;
        }
        GlyphLayout.mergeAreas(generalPath, areaArray, n2);
    }

    public static void mergeAreas(GeneralPath generalPath, Area[] areaArray, int n) {
        while (n > 1) {
            int n2 = 0;
            int n3 = 1;
            while (n3 < n) {
                areaArray[n3 - 1].add(areaArray[n3]);
                areaArray[n2++] = areaArray[n3 - 1];
                areaArray[n3] = null;
                n3 += 2;
            }
            if ((n & 1) == 1) {
                areaArray[n2 - 1].add(areaArray[n - 1]);
            }
            n /= 2;
        }
        if (n == 1) {
            generalPath.append(areaArray[0], false);
        }
    }

    public TextHit hitTestChar(float f, float f2) {
        TextHit textHit = null;
        if (this.transform != null) {
            try {
                Point2D.Float float_ = new Point2D.Float(f, f2);
                this.transform.inverseTransform(float_, float_);
                f = (float)((Point2D)float_).getX();
                f2 = (float)((Point2D)float_).getY();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.gv.getNumGlyphs()) {
            Shape shape = this.gv.getGlyphLogicalBounds(n2);
            if (shape != null) {
                Rectangle2D rectangle2D = shape.getBounds2D();
                if (shape.contains(f, f2)) {
                    boolean bl = (double)f > rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                    boolean bl2 = !bl;
                    int n3 = this.charMap[n];
                    textHit = new TextHit(n3, bl2);
                    return textHit;
                }
            }
            n += this.getCharacterCount(n2, n2);
            ++n2;
        }
        return textHit;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public boolean isOnATextPath() {
        return this.textPath != null;
    }

    public int getGlyphCount() {
        return this.gv.getNumGlyphs();
    }

    public int getCharacterCount(int n, int n2) {
        return this.gv.getCharacterCount(n, n2);
    }

    public boolean isLeftToRight() {
        this.aci.first();
        int n = (Integer)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL);
        return Math.floor((double)n / 2.0) == Math.floor((double)(n + 1) / 2.0);
    }

    protected Shape getOverlineShape() {
        double d = this.metrics.getOverlineOffset();
        float f = this.metrics.getOverlineThickness();
        BasicStroke basicStroke = new BasicStroke(f);
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f / 2.0, this.offset.getY() + (d += (double)f), rectangle2D.getMaxX() - (double)f / 2.0, this.offset.getY() + d));
    }

    protected Shape getUnderlineShape() {
        double d = this.metrics.getUnderlineOffset();
        float f = this.metrics.getUnderlineThickness();
        BasicStroke basicStroke = new BasicStroke(f);
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f / 2.0, this.offset.getY() + (d += (double)f * 1.5), rectangle2D.getMaxX() - (double)f / 2.0, this.offset.getY() + d));
    }

    protected Shape getStrikethroughShape() {
        double d = this.metrics.getStrikethroughOffset();
        float f = this.metrics.getStrikethroughThickness();
        BasicStroke basicStroke = new BasicStroke(f);
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f / 2.0, this.offset.getY() + d, rectangle2D.getMaxX() - (double)f / 2.0, this.offset.getY() + d));
    }

    protected GVTFont getFont(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        GVTFont gVTFont = (GVTFont)attributedCharacterIterator.getAttributes().get(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT);
        if (gVTFont != null) {
            return gVTFont;
        }
        return new AWTGVTFont(attributedCharacterIterator.getAttributes());
    }

    protected void doPathLayout(boolean bl) {
        Point2D point2D;
        this.aci.first();
        this.textPath = (TextPath)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH);
        if (this.textPath == null) {
            return;
        }
        boolean bl2 = !this.isVertical();
        boolean bl3 = this.isGlyphOrientationAuto();
        int n = 0;
        if (!bl3) {
            n = this.getGlyphOrientationAngle();
        }
        float f = this.textPath.lengthOfPath();
        float f2 = this.textPath.getStartOffset();
        int n2 = 0;
        while (n2 < this.gv.getNumGlyphs()) {
            this.gv.setGlyphVisible(n2, true);
            ++n2;
        }
        float f3 = bl2 ? (float)this.gv.getLogicalBounds().getWidth() : (float)this.gv.getLogicalBounds().getHeight();
        if (f == 0.0f || f3 == 0.0f) {
            return;
        }
        float f4 = bl2 ? (float)this.offset.getX() + f2 : (float)this.offset.getY() + f2;
        int n3 = this.aci.getBeginIndex();
        Point2D point2D2 = this.gv.getGlyphPosition(0);
        float f5 = 0.0f;
        if (bl) {
            f5 = bl2 ? (float)point2D2.getY() : (float)point2D2.getX();
        }
        char c = this.aci.first();
        int n4 = -1;
        float f6 = 0.0f;
        int n5 = 0;
        while (n5 < this.gv.getNumGlyphs()) {
            Object object;
            point2D = this.gv.getGlyphPosition(n5);
            float f7 = 0.0f;
            float f8 = 0.0f;
            if (n5 < this.gv.getNumGlyphs() - 1) {
                object = this.gv.getGlyphPosition(n5 + 1);
                if (bl2) {
                    f7 = (float)(((Point2D)object).getX() - point2D.getX());
                    f8 = (float)(((Point2D)object).getY() - point2D.getY());
                } else {
                    f7 = (float)(((Point2D)object).getY() - point2D.getY());
                    f8 = (float)(((Point2D)object).getX() - point2D.getX());
                }
            } else {
                object = this.gv.getGlyphMetrics(n5);
                f7 = bl2 ? ((GVTGlyphMetrics)object).getHorizontalAdvance() : (bl3 ? (this.isLatinChar(c) ? ((GVTGlyphMetrics)object).getHorizontalAdvance() : ((GVTGlyphMetrics)object).getVerticalAdvance()) : (n == 0 || n == 180 ? ((GVTGlyphMetrics)object).getVerticalAdvance() : ((GVTGlyphMetrics)object).getHorizontalAdvance()));
            }
            object = this.gv.getGlyphOutline(n5).getBounds2D();
            float f9 = (float)((RectangularShape)object).getWidth();
            float f10 = (float)((RectangularShape)object).getHeight();
            float f11 = bl2 ? f4 + f9 / 2.0f : f4 + f10 / 2.0f;
            Point2D point2D3 = this.textPath.pointAtLength(f11);
            if (point2D3 != null) {
                float f12 = this.textPath.angleAtLength(f11);
                AffineTransform affineTransform = new AffineTransform();
                if (bl2) {
                    affineTransform.rotate(f12);
                } else {
                    affineTransform.rotate((double)f12 - 1.5707963267948966);
                }
                if (bl2) {
                    affineTransform.translate(0.0, f5);
                } else {
                    affineTransform.translate(f5, 0.0);
                }
                if (bl2) {
                    affineTransform.translate(f9 / -2.0f, 0.0);
                } else if (bl3) {
                    if (this.isLatinChar(c)) {
                        affineTransform.translate(0.0, -f10 / 2.0f);
                    } else {
                        affineTransform.translate(0.0, f10 / 2.0f);
                    }
                } else if (n == 0) {
                    affineTransform.translate(0.0, f10 / 2.0f);
                } else {
                    affineTransform.translate(0.0, -f10 / 2.0f);
                }
                AffineTransform affineTransform2 = this.gv.getGlyphTransform(n5);
                if (affineTransform2 != null) {
                    affineTransform.concatenate(affineTransform2);
                }
                this.gv.setGlyphTransform(n5, affineTransform);
                this.gv.setGlyphPosition(n5, new Point2D.Double(point2D3.getX(), point2D3.getY()));
                n4 = n5;
                f6 = f7;
            } else {
                this.gv.setGlyphVisible(n5, false);
            }
            f4 += f7;
            f5 += f8;
            n3 += this.gv.getCharacterCount(n5, n5);
            c = this.aci.setIndex(this.aci.getBeginIndex() + n5 + this.gv.getCharacterCount(n5, n5));
            ++n5;
        }
        if (n4 > -1) {
            point2D = this.gv.getGlyphPosition(n4);
            this.textPathAdvance = bl2 ? new Point2D.Double(point2D.getX() + (double)f6, point2D.getY()) : new Point2D.Double(point2D.getX(), point2D.getY() + (double)f6);
        } else {
            this.textPathAdvance = new Point2D.Double(0.0, 0.0);
        }
    }

    protected void adjustTextSpacing() {
        this.aci.first();
        Boolean bl = (Boolean)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING);
        Float f = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH);
        Integer n = (Integer)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST);
        if (bl != null && bl.booleanValue()) {
            this.applySpacingParams(f, n, (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.KERNING), (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING), (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING));
        }
        if (n == GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL) {
            this.applyStretchTransform(f);
        }
    }

    protected void applyStretchTransform(Float f) {
        if (f != null && !f.isNaN()) {
            double d = 1.0;
            double d2 = 1.0;
            if (this.vertical) {
                d2 = (double)f.floatValue() / this.gv.getVisualBounds().getHeight();
            } else {
                d = (double)f.floatValue() / this.gv.getVisualBounds().getWidth();
            }
            Point2D point2D = this.gv.getGlyphPosition(0);
            int n = 0;
            while (n < this.gv.getNumGlyphs()) {
                Point2D point2D2 = this.gv.getGlyphPosition(n);
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY());
                affineTransform.scale(d, d2);
                affineTransform.translate(-point2D.getX(), -point2D.getY());
                Point2D.Float float_ = new Point2D.Float();
                affineTransform.transform(point2D2, float_);
                this.gv.setGlyphPosition(n, float_);
                AffineTransform affineTransform2 = this.gv.getGlyphTransform(n);
                if (affineTransform2 != null) {
                    affineTransform2.preConcatenate(AffineTransform.getScaleInstance(d, d2));
                    this.gv.setGlyphTransform(n, affineTransform2);
                } else {
                    this.gv.setGlyphTransform(n, AffineTransform.getScaleInstance(d, d2));
                }
                ++n;
            }
        }
    }

    protected void applySpacingParams(Float f, Integer n, Float f2, Float f3, Float f4) {
        this.advance = this.doSpacing(f2, f3, f4);
        if (n == GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING && f != null && !f.isNaN()) {
            float f5 = 1.0f;
            float f6 = 1.0f;
            if (!this.vertical) {
                float f7 = (float)this.gv.getGlyphMetrics(this.gv.getNumGlyphs() - 1).getBounds2D().getWidth();
                f5 = (f.floatValue() - f7) / (float)(this.gv.getVisualBounds().getWidth() - (double)f7);
            } else {
                f6 = f.floatValue() / (float)this.gv.getVisualBounds().getHeight();
            }
            this.rescaleSpacing(f5, f6);
        }
    }

    protected Point2D doSpacing(Float f, Float f2, Float f3) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (f instanceof Float && !f.isNaN()) {
            f4 = f.floatValue();
            bl = false;
        }
        if (f2 instanceof Float && !f2.isNaN()) {
            f5 = f2.floatValue();
            bl3 = true;
        }
        if (f3 instanceof Float && !f3.isNaN()) {
            f6 = f3.floatValue();
            bl2 = true;
        }
        int n = this.gv.getNumGlyphs();
        float f7 = 0.0f;
        float f8 = 0.0f;
        Point2D[] point2DArray = new Point2D[n];
        Point2D point2D = this.gv.getGlyphPosition(0);
        float f9 = (float)point2D.getX();
        float f10 = (float)point2D.getY();
        Point2D.Double double_ = new Point2D.Double(this.advance.getX() - (this.gv.getGlyphPosition(n - 1).getX() - (double)f9), this.advance.getY() - (this.gv.getGlyphPosition(n - 1).getY() - (double)f10));
        try {
            int n2;
            if (n > 1 && (bl3 || !bl)) {
                n2 = 1;
                while (n2 < n) {
                    Point2D point2D2 = this.gv.getGlyphPosition(n2);
                    f7 = (float)point2D2.getX() - (float)point2D.getX();
                    f8 = (float)point2D2.getY() - (float)point2D.getY();
                    if (bl) {
                        if (this.vertical) {
                            f8 += f5;
                        } else {
                            f7 += f5;
                        }
                    } else if (this.vertical) {
                        f8 = (float)this.gv.getGlyphMetrics(n2 - 1).getBounds2D().getHeight() + f4 + f5;
                    } else {
                        f7 = (float)this.gv.getGlyphMetrics(n2 - 1).getBounds2D().getWidth() + f4 + f5;
                    }
                    point2DArray[n2] = new Point2D.Float(f9 += f7, f10 += f8);
                    point2D = point2D2;
                    ++n2;
                }
                int n3 = 1;
                while (n3 < n) {
                    if (point2DArray[n3] != null) {
                        this.gv.setGlyphPosition(n3, point2DArray[n3]);
                    }
                    ++n3;
                }
            }
            if (bl) {
                if (this.vertical) {
                    ((Point2D)double_).setLocation(((Point2D)double_).getX(), ((Point2D)double_).getY() + (double)f5);
                } else {
                    ((Point2D)double_).setLocation(((Point2D)double_).getX() + (double)f5, ((Point2D)double_).getY());
                }
            } else if (this.vertical) {
                ((Point2D)double_).setLocation(((Point2D)double_).getX(), this.gv.getGlyphMetrics(n - 2).getBounds2D().getHeight() + (double)f4 + (double)f5);
            } else {
                ((Point2D)double_).setLocation(this.gv.getGlyphMetrics(n - 2).getBounds2D().getWidth() + (double)f4 + (double)f5, ((Point2D)double_).getY());
            }
            f7 = 0.0f;
            f8 = 0.0f;
            point2D = this.gv.getGlyphPosition(0);
            f9 = (float)point2D.getX();
            f10 = (float)point2D.getY();
            if (n > 1 && bl2) {
                n2 = 1;
                while (n2 < n) {
                    Point2D point2D3 = this.gv.getGlyphPosition(n2);
                    f7 = (float)point2D3.getX() - (float)point2D.getX();
                    f8 = (float)point2D3.getY() - (float)point2D.getY();
                    boolean bl4 = false;
                    int n4 = n2;
                    int n5 = n2;
                    GVTGlyphMetrics gVTGlyphMetrics = this.gv.getGlyphMetrics(n2);
                    while (gVTGlyphMetrics.getBounds2D().getWidth() < 0.01 || gVTGlyphMetrics.isWhitespace()) {
                        if (!bl4) {
                            bl4 = true;
                        }
                        if (n2 == n - 1) break;
                        ++n5;
                        point2D3 = this.gv.getGlyphPosition(++n2);
                        gVTGlyphMetrics = this.gv.getGlyphMetrics(n2);
                    }
                    if (bl4) {
                        int n6 = n5 - n4;
                        float f11 = (float)point2D.getX();
                        float f12 = (float)point2D.getY();
                        f7 = (float)(point2D3.getX() - (double)f11) / (float)(n6 + 1);
                        f8 = (float)(point2D3.getY() - (double)f12) / (float)(n6 + 1);
                        if (this.vertical) {
                            f8 += f3.floatValue() / (float)(n6 + 1);
                        } else {
                            f7 += f3.floatValue() / (float)(n6 + 1);
                        }
                        int n7 = n4;
                        while (n7 <= n5) {
                            point2DArray[n7] = new Point2D.Float(f9 += f7, f10 += f8);
                            ++n7;
                        }
                    } else {
                        f7 = (float)(point2D3.getX() - point2D.getX());
                        f8 = (float)(point2D3.getY() - point2D.getY());
                        point2DArray[n2] = new Point2D.Float(f9 += f7, f10 += f8);
                    }
                    point2D = point2D3;
                    ++n2;
                }
                int n8 = 1;
                while (n8 < n) {
                    if (point2DArray[n8] != null) {
                        this.gv.setGlyphPosition(n8, point2DArray[n8]);
                    }
                    ++n8;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        double d = this.gv.getGlyphPosition(n - 1).getX() - this.gv.getGlyphPosition(0).getX();
        double d2 = this.gv.getGlyphPosition(n - 1).getY() - this.gv.getGlyphPosition(0).getY();
        Point2D.Double double_2 = new Point2D.Double(d + ((Point2D)double_).getX(), d2 + ((Point2D)double_).getY());
        return double_2;
    }

    protected void rescaleSpacing(float f, float f2) {
        Rectangle2D rectangle2D = this.gv.getVisualBounds();
        float f3 = (float)rectangle2D.getX();
        float f4 = (float)rectangle2D.getY();
        int n = this.gv.getNumGlyphs();
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n2 = 0;
        while (n2 < n) {
            Point2D point2D = this.gv.getGlyphPosition(n2);
            f5 = (float)point2D.getX() - f3;
            f6 = (float)point2D.getY() - f4;
            this.gv.setGlyphPosition(n2, new Point2D.Float(f3 + f5 * f, f4 + f6 * f2));
            ++n2;
        }
        this.advance = new Point2D.Float((float)((double)(f3 + f5 * f) - this.offset.getX()), (float)((double)(f4 + f6 * f2) - this.offset.getY()));
    }

    protected boolean isLatinChar(char c) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        return unicodeBlock == Character.UnicodeBlock.BASIC_LATIN || unicodeBlock == Character.UnicodeBlock.LATIN_1_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_A || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_B;
    }

    protected boolean isGlyphOrientationAuto() {
        boolean bl = true;
        this.aci.first();
        if (this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION) != null) {
            bl = this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION) == GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_AUTO;
        }
        return bl;
    }

    protected int getGlyphOrientationAngle() {
        int n = 0;
        this.aci.first();
        Float f = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE);
        if (f != null) {
            n = (int)f.floatValue();
        }
        if (n != 0 || n != 90 || n != 180 || n != 270) {
            while (n < 0) {
                n += 360;
            }
            while (n >= 360) {
                n -= 360;
            }
            n = n <= 45 || n > 315 ? 0 : (n > 45 && n <= 135 ? 90 : (n > 135 && n <= 225 ? 180 : 270));
        }
        return n;
    }

    protected void doExplicitGlyphLayout(boolean bl) {
        float f = this.vertical ? (float)this.gv.getLogicalBounds().getWidth() : this.metrics.getAscent() + Math.abs(this.metrics.getDescent());
        this.textPath = (TextPath)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH);
        int n = this.gv.getNumGlyphs();
        float[] fArray = new float[n * 2];
        fArray = (float[])this.gv.getGlyphPositions(0, n, fArray).clone();
        float f2 = (float)this.offset.getX();
        float f3 = (float)this.offset.getY();
        float f4 = f2;
        float f5 = f3;
        float f6 = 0.0f;
        float f7 = 0.0f;
        boolean bl2 = this.isGlyphOrientationAuto();
        int n2 = 0;
        if (!bl2) {
            n2 = this.getGlyphOrientationAngle();
        }
        int n3 = 0;
        int n4 = this.aci.getBeginIndex();
        char c = this.aci.first();
        int n5 = n4;
        Float f8 = null;
        Float f9 = null;
        Float f10 = null;
        Float f11 = null;
        Float f12 = null;
        Object object = null;
        boolean bl3 = true;
        while (n3 < n) {
            float f13;
            if (n4 >= n5) {
                n5 = this.aci.getRunLimit(runAtts);
                f8 = (Float)this.aci.getAttribute(X);
                f9 = (Float)this.aci.getAttribute(Y);
                f10 = (Float)this.aci.getAttribute(DX);
                f11 = (Float)this.aci.getAttribute(DY);
                f12 = (Float)this.aci.getAttribute(ROTATION);
                object = this.aci.getAttribute(BASELINE_SHIFT);
            }
            GVTGlyphMetrics gVTGlyphMetrics = this.gv.getGlyphMetrics(n3);
            if (bl3) {
                f6 = bl2 ? (this.isLatinChar(c) ? 0.0f : (float)gVTGlyphMetrics.getBounds2D().getHeight()) : (n2 == 0 ? (float)gVTGlyphMetrics.getBounds2D().getHeight() : 0.0f);
            } else if (bl2 && f6 == 0.0f && !this.isLatinChar(c)) {
                f6 = (float)gVTGlyphMetrics.getBounds2D().getHeight();
            }
            float f14 = 0.0f;
            float f15 = 0.0f;
            float f16 = 0.0f;
            float f17 = 0.0f;
            if (c != '\uffff') {
                if (this.vertical) {
                    f16 = bl2 ? (this.isLatinChar(c) ? 1.5707964f : 0.0f) : (float)Math.toRadians(n2);
                    if (this.textPath != null) {
                        f8 = null;
                    }
                } else if (this.textPath != null) {
                    f9 = null;
                }
                f17 = f12 == null || f12.isNaN() ? f16 : f12.floatValue() + f16;
                if (f8 != null && !f8.isNaN()) {
                    if (n3 == 0) {
                        if (bl) {
                            f4 = (float)this.offset.getX();
                        } else {
                            f2 = f4 = f8.floatValue();
                        }
                    } else {
                        f4 = f8.floatValue();
                    }
                } else if (f10 != null && !f10.isNaN()) {
                    f4 += f10.floatValue();
                }
                if (f9 != null && !f9.isNaN()) {
                    if (n3 == 0) {
                        if (bl) {
                            f5 = (float)this.offset.getY();
                        } else {
                            f3 = f5 = f9.floatValue();
                        }
                    } else {
                        f5 = f9.floatValue();
                    }
                } else if (f11 != null && !f11.isNaN()) {
                    f5 += f11.floatValue();
                } else if (n3 > 0) {
                    f5 += fArray[n3 * 2 + 1] - fArray[n3 * 2 - 1];
                }
                f13 = 0.0f;
                if (object != null) {
                    if (object instanceof Integer) {
                        if (object == TextAttribute.SUPERSCRIPT_SUPER) {
                            f13 = f * 0.5f;
                        } else if (object == TextAttribute.SUPERSCRIPT_SUB) {
                            f13 = -f * 0.5f;
                        }
                    } else if (object instanceof Float) {
                        f13 = ((Float)object).floatValue();
                    }
                    if (this.vertical) {
                        f14 = f13;
                    } else {
                        f15 = -f13;
                    }
                }
                if (this.vertical) {
                    Point2D point2D;
                    Rectangle2D rectangle2D;
                    f15 += f6;
                    if (bl2) {
                        if (this.isLatinChar(c)) {
                            f14 += this.metrics.getStrikethroughOffset();
                        } else {
                            rectangle2D = this.gv.getGlyphVisualBounds(n3).getBounds2D();
                            point2D = this.gv.getGlyphPosition(n3);
                            f14 -= (float)(rectangle2D.getMaxX() - point2D.getX() - rectangle2D.getWidth() / 2.0);
                        }
                    } else {
                        rectangle2D = this.gv.getGlyphVisualBounds(n3).getBounds2D();
                        point2D = this.gv.getGlyphPosition(n3);
                        f14 = n2 == 0 ? (f14 -= (float)(rectangle2D.getMaxX() - point2D.getX() - rectangle2D.getWidth() / 2.0)) : (n2 == 180 ? (f14 += (float)(rectangle2D.getMaxX() - point2D.getX() - rectangle2D.getWidth() / 2.0)) : (n2 == 90 ? (f14 += this.metrics.getStrikethroughOffset()) : (f14 -= this.metrics.getStrikethroughOffset())));
                    }
                }
            }
            this.gv.setGlyphPosition(n3, new Point2D.Float(f4 + f14, f5 + f15));
            if (!ArabicTextHandler.arabicCharTransparent(c)) {
                if (this.vertical) {
                    f13 = 0.0f;
                    if (bl2) {
                        f13 = this.isLatinChar(c) ? gVTGlyphMetrics.getHorizontalAdvance() : gVTGlyphMetrics.getVerticalAdvance();
                    } else if (n2 == 0 || n2 == 180) {
                        f13 = gVTGlyphMetrics.getVerticalAdvance();
                    } else if (n2 == 90) {
                        f13 = gVTGlyphMetrics.getHorizontalAdvance();
                    } else {
                        f13 = gVTGlyphMetrics.getHorizontalAdvance();
                        this.gv.setGlyphTransform(n3, AffineTransform.getTranslateInstance(0.0, f13));
                    }
                    f5 += f13;
                } else {
                    f4 += gVTGlyphMetrics.getHorizontalAdvance();
                }
            }
            if (f17 != 0.0f) {
                AffineTransform affineTransform = this.gv.getGlyphTransform(n3);
                if (affineTransform == null) {
                    affineTransform = new AffineTransform();
                }
                affineTransform.rotate(f17);
                this.gv.setGlyphTransform(n3, affineTransform);
            }
            c = this.aci.setIndex(n4 += this.gv.getCharacterCount(n3, n3));
            ++n3;
            bl3 = false;
        }
        this.offset = new Point2D.Float(f2, f3);
        this.advance = new Point2D.Float((float)((double)f4 - this.offset.getX()), (float)((double)f5 - this.offset.getY()));
    }

    static {
        runAtts.add(X);
        runAtts.add(Y);
        runAtts.add(DX);
        runAtts.add(DY);
        runAtts.add(ROTATION);
        runAtts.add(BASELINE_SHIFT);
    }
}

