/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.parser.DefaultErrorHandler;
import org.apache.batik.parser.ErrorHandler;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.Parser;

public abstract class AbstractParser
implements Parser {
    public static final String BUNDLE_CLASSNAME = "org.apache.batik.parser.resources.Messages";
    protected ErrorHandler errorHandler = new DefaultErrorHandler();
    protected LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.parser.resources.Messages");
    protected Reader reader;
    protected int line = 1;
    protected int column;
    protected char[] buffer;
    protected int position;
    protected int count;
    protected int current;

    public int getCurrent() {
        return this.current;
    }

    public void setLocale(Locale locale) {
        this.localizableSupport.setLocale(locale);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        return this.localizableSupport.formatMessage(string, objectArray);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void parse(Reader reader) throws ParseException {
        this.reader = reader;
        this.buffer = new char[4096];
        this.doParse();
    }

    public void parse(String string) throws ParseException {
        this.reader = null;
        this.buffer = string.toCharArray();
        this.count = this.buffer.length;
        this.collapseCRNL(0, this.count);
        this.doParse();
    }

    protected abstract void doParse() throws ParseException;

    protected final void collapseCRNL(int n, int n2) {
        while (n < n2) {
            if (this.buffer[n] != '\r') {
                ++n;
                continue;
            }
            this.buffer[n] = 10;
            if (++n >= n2) break;
            if (this.buffer[n] != '\n') continue;
            int n3 = n++;
            while (n < n2) {
                if (this.buffer[n] == '\r') {
                    this.buffer[n3++] = 10;
                    if (++n >= n2) break;
                    if (this.buffer[n] != '\n') continue;
                    ++n;
                    continue;
                }
                this.buffer[n3++] = this.buffer[n++];
            }
            n2 = n3;
            break;
        }
    }

    protected final boolean fillBuffer() {
        try {
            int n;
            if (this.count != 0) {
                if (this.position == this.count) {
                    this.buffer[0] = this.buffer[this.count - 1];
                    this.count = 1;
                    this.position = 1;
                } else {
                    System.arraycopy(this.buffer, this.position - 1, this.buffer, 0, this.count - this.position + 1);
                    this.count = this.count - this.position + 1;
                    this.position = 1;
                }
            }
            if (this.reader == null) {
                return this.count != this.position;
            }
            int n2 = this.count - 1;
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n = this.reader.read(this.buffer, this.count, this.buffer.length - this.count)) == -1) {
                return this.count != this.position;
            }
            this.count += n;
            this.collapseCRNL(n2, this.count);
        }
        catch (IOException iOException) {
            this.errorHandler.error(new ParseException(this.createErrorMessage("io.exception", null), iOException));
        }
        return this.count != this.position;
    }

    protected void read() {
        if (this.position == this.count && !this.fillBuffer()) {
            this.current = -1;
            return;
        }
        if (this.current == 10) {
            ++this.line;
            this.column = 1;
        } else {
            ++this.column;
        }
        this.current = this.buffer[this.position++];
    }

    protected void reportError(String string, Object[] objectArray) throws ParseException {
        this.errorHandler.error(new ParseException(this.createErrorMessage(string, objectArray), this.line, this.column));
    }

    protected String createErrorMessage(String string, Object[] objectArray) {
        try {
            return this.formatMessage(string, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    protected String getBundleClassName() {
        return BUNDLE_CLASSNAME;
    }

    protected void skipSpaces() {
        switch (this.current) {
            default: {
                return;
            }
            case 9: 
            case 10: 
            case 13: 
            case 32: 
        }
        while (true) {
            if (this.position == this.count && !this.fillBuffer()) {
                this.current = -1;
                return;
            }
            if (this.current == 10) {
                ++this.line;
                this.column = 1;
            } else {
                ++this.column;
            }
            this.current = this.buffer[this.position++];
            switch (this.current) {
                default: {
                    return;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
            }
        }
    }

    protected void skipCommaSpaces() {
        switch (this.current) {
            default: {
                return;
            }
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                break;
            }
            case 44: {
                while (true) {
                    if (this.position == this.count && !this.fillBuffer()) {
                        this.current = -1;
                        return;
                    }
                    if (this.current == 10) {
                        ++this.line;
                        this.column = 1;
                    } else {
                        ++this.column;
                    }
                    this.current = this.buffer[this.position++];
                    switch (this.current) {
                        default: {
                            return;
                        }
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: 
                    }
                }
            }
        }
        block15: while (true) {
            if (this.position == this.count && !this.fillBuffer()) {
                this.current = -1;
                return;
            }
            if (this.current == 10) {
                ++this.line;
                this.column = 1;
            } else {
                ++this.column;
            }
            this.current = this.buffer[this.position++];
            switch (this.current) {
                default: {
                    return;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block15;
                }
                case 44: 
            }
            break;
        }
        while (true) {
            if (this.position == this.count && !this.fillBuffer()) {
                this.current = -1;
                return;
            }
            if (this.current == 10) {
                ++this.line;
                this.column = 1;
            } else {
                ++this.column;
            }
            this.current = this.buffer[this.position++];
            switch (this.current) {
                default: {
                    return;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
            }
        }
    }
}

