/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.imp;

import com.sun.jmfsound.imp.AbstractDataLine;
import com.sun.jmfsound.imp.Printer;
import com.sun.jmfsound.sampled.AudioFormat;
import com.sun.jmfsound.sampled.AudioSystem;
import com.sun.jmfsound.sampled.Control;
import com.sun.jmfsound.sampled.DataLine;
import com.sun.jmfsound.sampled.Line;
import com.sun.jmfsound.sampled.LineUnavailableException;
import com.sun.jmfsound.sampled.Mixer;
import java.util.Vector;

abstract class AbstractMixer
extends AbstractDataLine
implements Mixer {
    protected static final int PCM = 0;
    protected static final int ULAW = 1;
    protected static final int ALAW = 2;
    private final Mixer.Info mixerInfo;
    protected Line.Info[] sourceLineInfo;
    protected Line.Info[] targetLineInfo;
    protected Vector formats = new Vector();
    protected Vector sourceLines = new Vector();
    protected Vector targetLines = new Vector();

    protected AbstractMixer(DataLine.Info info, Control[] controls, AudioFormat format, int bufferSize, Mixer.Info mixerInfo, Line.Info[] sourceLineInfo, Line.Info[] targetLineInfo) {
        super(info, null, controls, format, bufferSize);
        this.mixer = this;
        if (controls == null) {
            controls = new Control[]{};
        }
        this.mixerInfo = mixerInfo;
        this.sourceLineInfo = sourceLineInfo;
        this.targetLineInfo = targetLineInfo;
    }

    public Mixer.Info getMixerInfo() {
        return this.mixerInfo;
    }

    public Line.Info[] getSourceLineInfo() {
        Line.Info[] localArray = new Line.Info[this.sourceLineInfo.length];
        System.arraycopy(this.sourceLineInfo, 0, localArray, 0, this.sourceLineInfo.length);
        return localArray;
    }

    public Line.Info[] getTargetLineInfo() {
        Line.Info[] localArray = new Line.Info[this.targetLineInfo.length];
        System.arraycopy(this.targetLineInfo, 0, localArray, 0, this.targetLineInfo.length);
        return localArray;
    }

    public Line.Info[] getSourceLineInfo(Line.Info info) {
        Vector<Line.Info> vec = new Vector<Line.Info>();
        int i = 0;
        while (i < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[i])) {
                vec.addElement(this.sourceLineInfo[i]);
            }
            ++i;
        }
        Line.Info[] returnedArray = new Line.Info[vec.size()];
        i = 0;
        while (i < returnedArray.length) {
            returnedArray[i] = (Line.Info)vec.elementAt(i);
            ++i;
        }
        return returnedArray;
    }

    public Line.Info[] getTargetLineInfo(Line.Info info) {
        Vector<Line.Info> vec = new Vector<Line.Info>();
        int i = 0;
        while (i < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[i])) {
                vec.addElement(this.targetLineInfo[i]);
            }
            ++i;
        }
        Line.Info[] returnedArray = new Line.Info[vec.size()];
        i = 0;
        while (i < returnedArray.length) {
            returnedArray[i] = (Line.Info)vec.elementAt(i);
            ++i;
        }
        return returnedArray;
    }

    public boolean isLineSupported(Line.Info info) {
        int i = 0;
        while (i < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[i])) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract Line getLine(Line.Info var1) throws LineUnavailableException;

    public abstract int getMaxLines(Line.Info var1);

    public Line[] getSourceLines() {
        Line[] localLines;
        Vector vector = this.sourceLines;
        synchronized (vector) {
            localLines = new Line[this.sourceLines.size()];
            int i = 0;
            while (i < localLines.length) {
                localLines[i] = (Line)this.sourceLines.elementAt(i);
                ++i;
            }
        }
        return localLines;
    }

    public Line[] getTargetLines() {
        Line[] localLines;
        Vector vector = this.targetLines;
        synchronized (vector) {
            localLines = new Line[this.targetLines.size()];
            int i = 0;
            while (i < localLines.length) {
                localLines[i] = (Line)this.targetLines.elementAt(i);
                ++i;
            }
        }
        return localLines;
    }

    public void synchronize(Line[] lines, boolean maintainSync) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    public void unsynchronize(Line[] lines) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    public boolean isSynchronizationSupported(Line[] lines, boolean maintainSync) {
        return false;
    }

    public synchronized void open(AudioFormat format, int bufferSize) throws LineUnavailableException {
        AudioFormat systemFormat;
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: open(format = " + format + "), bufferSize = " + bufferSize);
        }
        if ((systemFormat = AbstractMixer.getSystemFormat()) != null && !format.matches(systemFormat)) {
            throw new LineUnavailableException("Requested format incompatible with already established device format: " + systemFormat);
        }
        super.open(format, bufferSize);
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: open(format = " + format + "), bufferSize = " + bufferSize + " succeeded");
        }
    }

    public synchronized void open() throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: open()");
        }
        try {
            this.open(this.format, this.bufferSize);
        }
        catch (LineUnavailableException e) {
            AudioFormat systemFormat = null;
            systemFormat = AbstractMixer.getSystemFormat();
            if (systemFormat != null) {
                this.open(systemFormat, -1);
            }
            throw e;
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: open() succeeded");
        }
    }

    protected void open(Line line) throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: open(line = " + line + ")");
        }
        if (this.equals(line)) {
            return;
        }
        if (this.isSourceLine(line.getLineInfo())) {
            if (!this.sourceLines.contains(line)) {
                this.open();
                this.sourceLines.addElement(line);
            }
        } else if (this.isTargetLine(line.getLineInfo())) {
            if (!this.targetLines.contains(line)) {
                this.open();
                this.targetLines.addElement(line);
            }
        } else if (Printer.err) {
            Printer.err("Unknown line received for AbstractMixer.open(Line): " + line);
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: open(" + line + ") completed");
        }
    }

    protected void open(DataLine line, AudioFormat format, int bufferSize) throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: open(line = " + line + ")");
        }
        this.open(line);
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: open(line, format, bufferSize) completed");
        }
    }

    protected void close(Line line) {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: close(" + line + ")");
        }
        if (this.equals(line)) {
            return;
        }
        this.sourceLines.removeElement(line);
        this.targetLines.removeElement(line);
        if (Printer.debug) {
            Printer.debug("AbstractMixer: close(line): sourceLines.size() now: " + this.sourceLines.size());
        }
        if (Printer.debug) {
            Printer.debug("AbstractMixer: close(line): targetLines.size() now: " + this.targetLines.size());
        }
        if (this.sourceLines.isEmpty() && this.targetLines.isEmpty()) {
            this.close();
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: close(" + line + ") succeeded");
        }
    }

    protected void start(Line line) {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: start(" + line + ")");
        }
        if (this.equals(line)) {
            return;
        }
        if (!this.isStartedRunning()) {
            if (Printer.debug) {
                Printer.debug("AbstractMixer: start(line): starting the mixer");
            }
            this.start();
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: start(" + line + ") succeeded");
        }
    }

    protected void stop(Line line) {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: stop(" + line + ")");
        }
        if (this.equals(line)) {
            return;
        }
        Vector localSourceLines = (Vector)this.sourceLines.clone();
        int i = 0;
        while (i < localSourceLines.size()) {
            AbstractDataLine sourceLine;
            if (localSourceLines.elementAt(i) instanceof AbstractDataLine && (sourceLine = (AbstractDataLine)localSourceLines.elementAt(i)).isStartedRunning() && !sourceLine.equals(line)) {
                return;
            }
            ++i;
        }
        Vector localTargetLines = (Vector)this.targetLines.clone();
        int i2 = 0;
        while (i2 < localTargetLines.size()) {
            AbstractDataLine targetLine = (AbstractDataLine)localTargetLines.elementAt(i2);
            if (targetLine.isStartedRunning() && !targetLine.equals(line)) {
                if (Printer.trace) {
                    Printer.trace("<< AbstractMixer: stop(" + line + ") found running targetLine: " + targetLine);
                }
                return;
            }
            ++i2;
        }
        if (Printer.debug) {
            Printer.debug("AbstractMixer: stop(line): stopping the mixer");
        }
        this.stop();
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: stop(" + line + ") succeeded");
        }
    }

    boolean isSourceLine(Line.Info info) {
        int i = 0;
        while (i < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean isTargetLine(Line.Info info) {
        int i = 0;
        while (i < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    Line.Info getLineInfo(Line.Info info) {
        int i = 0;
        while (i < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[i])) {
                return this.sourceLineInfo[i];
            }
            ++i;
        }
        i = 0;
        while (i < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[i])) {
                return this.targetLineInfo[i];
            }
            ++i;
        }
        return null;
    }

    static AudioFormat getSystemFormat() {
        Mixer.Info[] mixerInfoList = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < mixerInfoList.length) {
            Mixer currentMixer = AudioSystem.getMixer(mixerInfoList[i]);
            if (currentMixer.isOpen() && currentMixer instanceof DataLine) {
                return ((DataLine)((Object)currentMixer)).getFormat();
            }
            ++i;
        }
        return null;
    }
}

