/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.imp;

import com.sun.jmfsound.imp.DataPusher;
import com.sun.jmfsound.imp.Printer;
import com.sun.jmfsound.midi.InvalidMidiDataException;
import com.sun.jmfsound.midi.MetaEventListener;
import com.sun.jmfsound.midi.MetaMessage;
import com.sun.jmfsound.midi.MidiFileFormat;
import com.sun.jmfsound.midi.MidiSystem;
import com.sun.jmfsound.midi.MidiUnavailableException;
import com.sun.jmfsound.midi.Sequencer;
import com.sun.jmfsound.sampled.AudioFormat;
import com.sun.jmfsound.sampled.AudioInputStream;
import com.sun.jmfsound.sampled.AudioSystem;
import com.sun.jmfsound.sampled.Clip;
import com.sun.jmfsound.sampled.DataLine;
import com.sun.jmfsound.sampled.LineEvent;
import com.sun.jmfsound.sampled.LineListener;
import com.sun.jmfsound.sampled.LineUnavailableException;
import com.sun.jmfsound.sampled.SourceDataLine;
import com.sun.jmfsound.sampled.UnsupportedAudioFileException;
import java.applet.AudioClip;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class JavaSoundAudioClip
implements AudioClip,
MetaEventListener,
LineListener {
    private Clip clip = null;
    private Sequencer sequencer = null;
    private SourceDataLine sourceline = null;
    private DataPusher datapusher = null;
    private boolean sequencerloop = false;
    private boolean streamloop = false;
    private byte[] loadedAudio = null;
    private long clipthresh = 0x100000L;
    static /* synthetic */ Class class$com$sun$jmfsound$sampled$SourceDataLine;
    static /* synthetic */ Class class$com$sun$jmfsound$sampled$Clip;

    public JavaSoundAudioClip(InputStream in) throws IOException {
        BufferedInputStream bis = null;
        int bufferSize = 1024;
        AudioInputStream as = null;
        AudioFormat format = null;
        if (Printer.debug) {
            Printer.debug("Instantiating com.sun.jmfsound.imp.JavaSoundAudioClip");
        }
        bis = new BufferedInputStream(in, bufferSize);
        bis.mark(bufferSize);
        try {
            as = AudioSystem.getAudioInputStream(bis);
            format = as.getFormat();
            long tmplength = as.getFrameLength();
            if (tmplength > 0L && tmplength < this.clipthresh ? this.openAsClip(as) < 0 : this.openAsStream(as) < 0) {
                throw new IOException("Unable to create AudioClip from input stream");
            }
        }
        catch (UnsupportedAudioFileException e) {
            try {
                MidiFileFormat mff = MidiSystem.getMidiFileFormat(bis);
                if (this.openAsSequence(bis) < 0) {
                    throw new IOException("Unable to create AudioClip from input stream");
                }
            }
            catch (InvalidMidiDataException e1) {
                throw new IOException("Unable to create AudioClip from input stream");
            }
        }
    }

    public synchronized void play() {
        if (Printer.debug) {
            Printer.debug("JavaSoundAudioClip->play()");
        }
        if (this.clip != null) {
            this.stop();
            this.clip.start();
            if (Printer.debug) {
                Printer.debug("Clip should be playing");
            }
        } else if (this.datapusher != null) {
            this.stop();
            this.streamloop = false;
            this.sourceline.start();
            this.datapusher.start();
            if (Printer.debug) {
                Printer.debug("Clip should be playing");
            }
        } else if (this.sequencer != null) {
            this.stop();
            this.sequencerloop = false;
            this.sequencer.start();
            if (Printer.debug) {
                Printer.debug("Clip should be playing");
            }
        }
    }

    public synchronized void loop() {
        if (Printer.debug) {
            Printer.debug("JavaSoundAudioClip->loop()");
        }
        if (this.clip != null) {
            this.stop();
            this.clip.loop(-1);
            if (Printer.debug) {
                Printer.debug("Clip should be looping");
            }
        } else if (this.datapusher != null) {
            this.stop();
            this.streamloop = true;
            this.sourceline.start();
            this.datapusher.start();
            if (Printer.debug) {
                Printer.debug("Clip should be playing");
            }
        } else if (this.sequencer != null) {
            this.stop();
            this.sequencerloop = true;
            this.sequencer.start();
            if (Printer.debug) {
                Printer.debug("Clip should be looping");
            }
        }
    }

    public synchronized void stop() {
        if (Printer.debug) {
            Printer.debug("JavaSoundAudioClip->stop()");
        }
        if (this.clip != null) {
            this.clip.stop();
            this.clip.setFramePosition(0);
            if (Printer.debug) {
                Printer.debug("Clip should be stopped");
            }
        } else if (this.datapusher != null) {
            this.streamloop = false;
            this.datapusher.stop();
        } else if (this.sequencer != null) {
            this.sequencer.stop();
            this.sequencer.setMicrosecondPosition(0L);
            if (Printer.debug) {
                Printer.debug("Clip should be stopped");
            }
        }
    }

    public synchronized void update(LineEvent event) {
        if (Printer.debug) {
            Printer.debug("LINE EVENT RECEIVED!!!!!");
        }
        if (this.streamloop && this.datapusher != null && event.getType() == LineEvent.Type.STOP) {
            this.loop();
        }
    }

    public synchronized void meta(MetaMessage message) {
        if (Printer.debug) {
            Printer.debug("META EVENT RECEIVED!!!!! ");
        }
        if (message.getType() == 47) {
            if (this.sequencerloop) {
                this.sequencer.setMicrosecondPosition(0L);
                this.loop();
            } else {
                this.stop();
            }
        }
    }

    public String toString() {
        return this.getClass().toString();
    }

    protected void finalize() {
        if (this.clip != null) {
            this.clip.close();
        }
    }

    private int openAsStream(AudioInputStream as) throws IOException, UnsupportedAudioFileException {
        if (Printer.debug) {
            Printer.debug("JavaSoundAudioClip->openAsStream()");
        }
        DataLine.Info info = null;
        AudioFormat format = as.getFormat();
        if ((as = this.convertToPlayableStream(as)) == null) {
            return -1;
        }
        if (this.loadStreamIntoMemory(as) <= 0) {
            return -1;
        }
        try {
            info = new DataLine.Info(class$com$sun$jmfsound$sampled$SourceDataLine == null ? (class$com$sun$jmfsound$sampled$SourceDataLine = JavaSoundAudioClip.class$("com.sun.jmfsound.sampled.SourceDataLine")) : class$com$sun$jmfsound$sampled$SourceDataLine, as.getFormat());
            if (!AudioSystem.isLineSupported(info)) {
                return -1;
            }
            this.sourceline = (SourceDataLine)AudioSystem.getLine(info);
            this.sourceline.addLineListener(this);
            this.datapusher = new DataPusher(this.sourceline, this.loadedAudio);
            this.sourceline.open();
        }
        catch (LineUnavailableException e) {
            return -1;
        }
        if (this.datapusher == null) {
            return -1;
        }
        if (Printer.debug) {
            Printer.debug("Loaded as stream.");
        }
        return 0;
    }

    private int loadStreamIntoMemory(AudioInputStream as) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[16834];
        int bytesRead = 0;
        int totalBytesRead = 0;
        while (true) {
            if ((bytesRead = as.read(buffer, 0, buffer.length)) <= 0) break;
            totalBytesRead += bytesRead;
            baos.write(buffer, 0, bytesRead);
        }
        as.close();
        this.loadedAudio = baos.toByteArray();
        return totalBytesRead;
    }

    private int openAsClip(AudioInputStream as) throws IOException, UnsupportedAudioFileException {
        if (Printer.debug) {
            Printer.debug("JavaSoundAudioClip->openAsClip()");
        }
        DataLine.Info info = null;
        if ((as = this.convertToPlayableStream(as)) == null) {
            return -1;
        }
        try {
            info = new DataLine.Info(class$com$sun$jmfsound$sampled$Clip == null ? (class$com$sun$jmfsound$sampled$Clip = JavaSoundAudioClip.class$("com.sun.jmfsound.sampled.Clip")) : class$com$sun$jmfsound$sampled$Clip, as.getFormat(), (int)as.getFrameLength());
            if (!AudioSystem.isLineSupported(info)) {
                return -1;
            }
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.open(as);
        }
        catch (LineUnavailableException e) {
            return -1;
        }
        if (this.clip == null) {
            return -1;
        }
        if (Printer.debug) {
            Printer.debug("Loaded as clip.");
        }
        return 0;
    }

    private AudioInputStream convertToPlayableStream(AudioInputStream as) {
        if (as.getFormat().getEncoding() == AudioFormat.Encoding.ULAW || as.getFormat().getEncoding() == AudioFormat.Encoding.ALAW) {
            AudioFormat af = as.getFormat();
            AudioInputStream asold = as;
            as = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, af.getSampleRate(), af.getSampleSizeInBits() * 2, af.getChannels(), af.getFrameSize() * 2, af.getFrameRate(), true), asold);
        }
        return as;
    }

    private int openAsSequence(BufferedInputStream in) throws IOException {
        if (Printer.debug) {
            Printer.debug("JavaSoundAudioClip->openAsSequence()");
        }
        try {
            this.sequencer = MidiSystem.getSequencer();
        }
        catch (MidiUnavailableException me) {
            return -1;
        }
        if (this.sequencer == null) {
            return -1;
        }
        this.sequencer.addMetaEventListener(this);
        try {
            this.sequencer.open();
            this.sequencer.setSequence(in);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return -1;
        }
        catch (MidiUnavailableException e1) {
            e1.printStackTrace();
            return -1;
        }
        if (Printer.debug) {
            Printer.debug("Loaded as sequence.");
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

