/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.imp;

import com.sun.jmfsound.imp.DisabledSecurity;
import com.sun.jmfsound.imp.JDK12;
import com.sun.jmfsound.imp.JDK12ConfigureThreadAction;
import com.sun.jmfsound.imp.JDK12NewMixerThreadAction;
import com.sun.jmfsound.imp.JDK12TopmostThreadGroupAction;
import com.sun.jmfsound.imp.JSSecurity;
import com.sun.jmfsound.imp.JSSecurityManager;
import com.sun.jmfsound.imp.Printer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;

class MixerThread
extends Thread {
    private static Vector threadObjects = new Vector();
    private static ThreadGroup topmostThreadGroup = null;
    private static String threadName = "Headspace mixer frame proc thread";
    private static JSSecurity jsSecurity = null;
    private static boolean securityPrivilege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private boolean paused;
    private int frameProc;

    protected MixerThread() {
        super(topmostThreadGroup, "");
        if (Printer.trace) {
            Printer.trace(">> MixerThread() CONSTRUCTOR");
        }
        if (jsSecurity == null || !(jsSecurity instanceof DisabledSecurity)) {
            if (jsSecurity != null && jsSecurity.getName().startsWith("JDK12")) {
                try {
                    if (Printer.debug) {
                        Printer.debug("Configuring thread with 1.2 style security");
                    }
                    Constructor cons = JDK12ConfigureThreadAction.cons;
                    JDK12.doPrivM.invoke((Object)JDK12.ac, cons.newInstance(this, threadName));
                    if (Printer.debug) {
                        Printer.debug("Configured thread with 1.2 style security");
                    }
                }
                catch (Exception e) {
                    if (Printer.debug) {
                        Printer.debug("Exception configuring thread with 1.2 style security");
                    }
                    this.configureThread();
                }
            } else {
                this.configureThread();
            }
        }
        this.paused = false;
        if (Printer.trace) {
            Printer.trace(">> MixerThread() CONSTRUCTOR completed");
        }
    }

    private void setFrameProc(int frameProc) {
        this.frameProc = frameProc;
    }

    private static MixerThread getExistingThreadObject(int frameProc) {
        if (Printer.trace) {
            Printer.trace(">> MixerThread: getExistingThreadObject(" + frameProc + ")");
        }
        Vector vector = threadObjects;
        synchronized (vector) {
            int i = 0;
            while (i < threadObjects.size()) {
                MixerThread currentThreadObject = (MixerThread)threadObjects.elementAt(i);
                if (currentThreadObject.frameProc == frameProc) {
                    if (Printer.trace) {
                        Printer.trace("<< MixerThread: getExistingThreadObject() returning existing object: " + currentThreadObject);
                    }
                    MixerThread mixerThread = currentThreadObject;
                    return mixerThread;
                }
                ++i;
            }
        }
        return null;
    }

    private static MixerThread getNewThreadObject(int frameProc) {
        Method[] m = new Method[1];
        Class[] cl = new Class[1];
        Object[][] args = new Object[1][0];
        MixerThread newThreadObject = null;
        if (Printer.trace) {
            Printer.trace(">> MixerThread: getNewThreadObject(" + frameProc + ")");
        }
        if (Printer.debug) {
            Printer.debug("MixerThread.getNewThreadObject: asking for permissions");
        }
        if (securityPrivilege && jsSecurity != null) {
            if (jsSecurity.getName().startsWith("JDK12")) {
                try {
                    Constructor cons = JDK12NewMixerThreadAction.cons;
                    newThreadObject = (MixerThread)JDK12.doPrivM.invoke((Object)JDK12.ac, cons.newInstance(new Object[0]));
                    if (Printer.debug) {
                        Printer.debug("Got mixer thread object with 1.2 style security");
                    }
                }
                catch (Exception e) {
                    if (Printer.debug) {
                        Printer.debug("Exception getting mixer thread object with 1.2 style security");
                    }
                    newThreadObject = new MixerThread();
                    newThreadObject.setFrameProc(frameProc);
                }
                newThreadObject.setFrameProc(frameProc);
            } else {
                block14: {
                    try {
                        jsSecurity.requestPermission(m, cl, args, 16);
                        m[0].invoke((Object)cl[0], args[0]);
                        jsSecurity.requestPermission(m, cl, args, 32);
                        m[0].invoke((Object)cl[0], args[0]);
                        if (Printer.debug) {
                            Printer.debug("MixerThread.getNewThreadObject: got THREAD, THREAD_GROUP permissions");
                        }
                    }
                    catch (Exception e) {
                        if (!Printer.debug) break block14;
                        Printer.debug("MixerThread.getNewThreadObject: could not get THREAD, THREAD_GROUP permissions");
                    }
                }
                newThreadObject = new MixerThread();
                newThreadObject.setFrameProc(frameProc);
            }
        } else {
            if (Printer.debug) {
                Printer.debug("MixerThread.getNewThreadObject: no securityPrivilege or jsSecurity=null, not using security");
            }
            newThreadObject = new MixerThread();
            newThreadObject.setFrameProc(frameProc);
        }
        threadObjects.addElement(newThreadObject);
        return newThreadObject;
    }

    private void configureThread() {
        if (Printer.trace) {
            Printer.trace(">> MixerThread: configureThread()");
        }
        this.setDaemon(true);
        this.setPriority(10);
        this.setName(threadName);
        if (Printer.trace) {
            Printer.trace("<< MixerThread: configureThread() completed");
        }
    }

    private static ThreadGroup getTopmostThreadGroup() {
        if (Printer.trace) {
            Printer.trace(">> MixerThread: getTopmostThreadGroup()");
        }
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        while (g.getParent() != null && g.getParent().getParent() != null) {
            g = g.getParent();
        }
        if (Printer.trace) {
            Printer.trace("<< MixerThread: getTopmostThreadGroup() completed");
        }
        return g;
    }

    public void run() {
        if (Printer.trace) {
            Printer.trace(">> MixerThread: run()");
        }
        while (true) {
            if (Printer.debug) {
                Printer.debug("MixerThread: run(): calling runNative()");
            }
            this.runNative(this.frameProc);
            if (Printer.debug) {
                Printer.debug("MixerThread: run(): runNative() returned");
            }
            MixerThread mixerThread = this;
            synchronized (mixerThread) {
                this.paused = true;
                while (this.paused) {
                    try {
                        if (Printer.debug) {
                            Printer.debug("MixerThread: run(): calling wait()");
                        }
                        this.wait();
                        if (!Printer.debug) continue;
                        Printer.debug("MixerThread: run(): returned from wait()");
                    }
                    catch (InterruptedException e) {
                        if (!Printer.debug) continue;
                        Printer.debug("MixerThread: run(): wait() interrupted");
                    }
                }
                if (Printer.debug) {
                    Printer.debug("MixerThread: run(): exited while(paused)");
                }
            }
            if (!Printer.debug) continue;
            Printer.debug("MixerThread: run(): exited synchronized block");
        }
    }

    private synchronized void unpause() {
        if (Printer.trace) {
            Printer.trace(">> MixerThread: unpause() called, notifying...");
        }
        this.paused = false;
        this.notify();
        if (Printer.trace) {
            Printer.trace("<< MixerThread: unpause() completed");
        }
    }

    private native void runNative(int var1);

    static {
        Method[] m = new Method[1];
        Class[] cl = new Class[1];
        Object[][] args = new Object[1][0];
        securityPrivilege = true;
        if (Printer.debug) {
            Printer.debug("MixerThread.static: securityPrivilege = " + securityPrivilege);
        }
        try {
            jsSecurity = JSSecurityManager.getJSSecurity();
            if (jsSecurity != null && !(jsSecurity instanceof DisabledSecurity)) {
                jsSecurity.requestPermission(m, cl, args, 32);
                m[0].invoke((Object)cl[0], args[0]);
            }
        }
        catch (Exception e) {
            if (Printer.debug) {
                Printer.debug("Exception caught: " + e);
            }
            if (Printer.debug) {
                Printer.debug("Setting securityPrivilege to false");
            }
            securityPrivilege = false;
        }
        if (securityPrivilege) {
            if (Printer.debug) {
                Printer.debug("MixerThread.java: getting the real topmost thread group");
            }
            if (jsSecurity == null || !(jsSecurity instanceof DisabledSecurity)) {
                if (jsSecurity != null && jsSecurity.getName().startsWith("JDK12")) {
                    try {
                        Constructor cons = JDK12TopmostThreadGroupAction.cons;
                        topmostThreadGroup = (ThreadGroup)JDK12.doPrivM.invoke((Object)JDK12.ac, cons.newInstance(new Object[0]));
                        if (Printer.debug) {
                            Printer.debug("Got topmost thread group with 1.2 style security");
                        }
                    }
                    catch (Exception e) {
                        if (Printer.debug) {
                            Printer.debug("Exception getting topmost thread group with 1.2 style security");
                        }
                        topmostThreadGroup = MixerThread.getTopmostThreadGroup();
                    }
                } else {
                    topmostThreadGroup = MixerThread.getTopmostThreadGroup();
                }
            }
        } else {
            if (Printer.debug) {
                Printer.debug("MixerThread.java: no securityPrivilege, settling for current threadgroup");
            }
            topmostThreadGroup = Thread.currentThread().getThreadGroup();
        }
    }
}

