/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.imp;

import com.sun.jmfsound.imp.DisabledSecurity;
import com.sun.jmfsound.imp.JDK12;
import com.sun.jmfsound.imp.JDK12PropertyAction;
import com.sun.jmfsound.imp.JSSecurity;
import com.sun.jmfsound.imp.JSSecurityManager;
import com.sun.jmfsound.imp.Printer;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

class Platform {
    private static final String[] libraries;
    private static boolean signed8;
    private static boolean bigEndian;
    private static String javahome;
    private static String classpath;
    private static JSSecurity jsSecurity;
    private static boolean securityPrivilege;

    private Platform() {
    }

    static void initialize() {
        if (Printer.trace) {
            Printer.trace("Platform: initialize()");
        }
    }

    static boolean isBigEndian() {
        return bigEndian;
    }

    static boolean isSigned8() {
        return signed8;
    }

    static String getJavahome() {
        return javahome;
    }

    static String getClasspath() {
        return classpath;
    }

    private static void loadLibraries() {
        if (Printer.trace) {
            Printer.trace(">>Platform.loadLibraries");
        }
        try {
            int i = 0;
            while (i < libraries.length) {
                try {
                    if (securityPrivilege) {
                        if (jsSecurity != null) {
                            if (Printer.debug) {
                                Printer.debug("using security manager to load libraries");
                            }
                            jsSecurity.loadLibrary(libraries[i]);
                        } else {
                            if (Printer.debug) {
                                Printer.debug("not using security manager to load libraries");
                            }
                            System.loadLibrary(libraries[i]);
                        }
                        if (Printer.debug) {
                            Printer.debug("loaded library " + libraries[i]);
                        }
                    } else if (Printer.debug) {
                        Printer.debug("no security privilege, did not load library " + libraries[i]);
                    }
                }
                catch (UnsatisfiedLinkError e2) {
                    if (Printer.err) {
                        Printer.err("UnsatisfiedLinkError loading native library " + libraries[i]);
                    }
                    throw e2;
                }
                ++i;
            }
        }
        catch (SecurityException e) {
            if (Printer.err) {
                Printer.err("Security exception loading native libraries.  JavaSound requires access to these resources.");
            }
            throw e;
        }
    }

    private static void readProperties() {
        try {
            bigEndian = false;
            signed8 = false;
            String arch = null;
            if (securityPrivilege && jsSecurity != null) {
                if (jsSecurity.getName().startsWith("JDK12")) {
                    if (Printer.debug) {
                        Printer.debug("using 12 security to get properties");
                    }
                    try {
                        Constructor cons = JDK12PropertyAction.cons;
                        arch = (String)JDK12.doPrivM.invoke((Object)JDK12.ac, cons.newInstance("os.arch"));
                        javahome = (String)JDK12.doPrivM.invoke((Object)JDK12.ac, cons.newInstance("java.home"));
                        classpath = (String)JDK12.doPrivM.invoke((Object)JDK12.ac, cons.newInstance("java.class.path"));
                        classpath = classpath + File.pathSeparator + (String)JDK12.doPrivM.invoke((Object)JDK12.ac, cons.newInstance("java.home")) + File.separator + "lib";
                    }
                    catch (Exception e) {
                        if (Printer.debug) {
                            Printer.debug("not using security to get properties");
                        }
                        arch = System.getProperty("os.arch");
                        javahome = System.getProperty("java.home");
                        classpath = System.getProperty("java.class.path") + File.pathSeparator + System.getProperty("java.home") + File.separator + "lib";
                    }
                } else {
                    if (Printer.debug) {
                        Printer.debug("using security to get properties");
                    }
                    arch = jsSecurity.readProperty("os.arch");
                    javahome = jsSecurity.readProperty("java.home");
                    classpath = jsSecurity.readProperty("java.class.path");
                }
            } else {
                if (Printer.debug) {
                    Printer.debug("not using security to get properties");
                }
                arch = System.getProperty("os.arch");
                javahome = System.getProperty("java.home");
                classpath = System.getProperty("java.class.path");
            }
            if (arch != null) {
                if (arch.equals("x86")) {
                    if (Printer.debug) {
                        Printer.debug("found x86 hardware");
                    }
                    bigEndian = false;
                    signed8 = false;
                } else if (arch.equals("sparc")) {
                    if (Printer.debug) {
                        Printer.debug("found sparc hardware");
                    }
                    bigEndian = true;
                    signed8 = true;
                } else if (Printer.err) {
                    Printer.err("could not determine hardware architecture");
                }
            }
        }
        catch (SecurityException e) {
            if (Printer.err) {
                Printer.err("Security exception getting system properties.  JavaSound requires access to these resources.");
            }
            throw e;
        }
    }

    static {
        Object[][] args;
        Class[] cl;
        Method[] m;
        block12: {
            libraries = new String[]{"jmsound"};
            jsSecurity = null;
            securityPrivilege = false;
            m = new Method[1];
            cl = new Class[1];
            args = new Object[1][0];
            if (Printer.trace) {
                Printer.trace(">> Platform.java: static");
            }
            try {
                jsSecurity = JSSecurityManager.getJSSecurity();
                securityPrivilege = true;
            }
            catch (SecurityException e) {
                if (!Printer.err) break block12;
                Printer.err("Platform.java: Security Exception: " + e);
            }
        }
        if (Printer.debug) {
            Printer.debug("jsSecurity: " + jsSecurity);
        }
        if (Printer.debug) {
            Printer.debug("securityPrivilege: " + securityPrivilege);
        }
        if (securityPrivilege && jsSecurity != null) {
            if (!(jsSecurity instanceof DisabledSecurity)) {
                if (jsSecurity.getName().startsWith("JDK12")) {
                    Platform.loadLibraries();
                    Platform.readProperties();
                } else {
                    block13: {
                        try {
                            jsSecurity.requestPermission(m, cl, args, 1);
                            m[0].invoke((Object)cl[0], args[0]);
                            jsSecurity.requestPermission(m, cl, args, 64);
                            m[0].invoke((Object)cl[0], args[0]);
                        }
                        catch (Exception e) {
                            if (!Printer.err) break block13;
                            Printer.err("Unable to get read property privilege: " + e);
                        }
                    }
                    Platform.loadLibraries();
                    Platform.readProperties();
                }
            }
        } else {
            Platform.loadLibraries();
            Platform.readProperties();
        }
    }
}

