/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.midi;

import com.sun.jmfsound.midi.InvalidMidiDataException;
import com.sun.jmfsound.midi.MidiMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SysexMessage
extends MidiMessage {
    public static final int SYSTEM_EXCLUSIVE = 240;
    public static final int SPECIAL_SYSTEM_EXCLUSIVE = 247;
    private static byte[] defaultMessage = new byte[]{-16, -9};

    public SysexMessage() {
        this(defaultMessage);
    }

    protected SysexMessage(byte[] data) {
        super(data);
    }

    public void setMessage(byte[] data, int length) throws InvalidMidiDataException {
        int status = 0;
        try {
            ByteArrayInputStream bas = new ByteArrayInputStream(data, 0, length);
            DataInputStream das = new DataInputStream(bas);
            das.reset();
            status = das.readUnsignedByte();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (status != 240 && status != 247) {
            throw new InvalidMidiDataException("Invalid status byte for sysex message: " + status);
        }
        this.length = length;
        if (this.data.length < this.length) {
            this.data = new byte[this.length];
        }
        System.arraycopy(data, 0, this.data, 0, length);
    }

    public void setMessage(int status, byte[] data, int length) throws InvalidMidiDataException {
        if (status != 240 && status != 247) {
            throw new InvalidMidiDataException("Invalid status byte for sysex message: " + status);
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeByte(status);
            dos.write(data, 0, length);
            this.data = bos.toByteArray();
            this.length = this.data.length;
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public byte[] getData() {
        byte[] returnedArray = new byte[this.length - 1];
        System.arraycopy(this.data, 1, returnedArray, 0, this.length - 1);
        return returnedArray;
    }

    public Object clone() {
        byte[] newData = new byte[this.length];
        System.arraycopy(this.data, 0, newData, 0, newData.length);
        SysexMessage event = new SysexMessage(newData);
        return event;
    }
}

