/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.sampled;

import com.sun.jmfsound.sampled.AudioFormat;
import com.sun.jmfsound.sampled.Line;

public interface DataLine
extends Line {
    public void drain();

    public void flush();

    public void start();

    public void stop();

    public boolean isRunning();

    public boolean isActive();

    public AudioFormat getFormat();

    public int getBufferSize();

    public int available();

    public int getFramePosition();

    public long getMicrosecondPosition();

    public float getLevel();

    public static class Info
    extends Line.Info {
        private AudioFormat[] formats;
        private int minBufferSize;
        private int maxBufferSize;

        public Info(Class lineClass, AudioFormat[] formats, int minBufferSize, int maxBufferSize) {
            super(lineClass);
            this.formats = formats == null ? new AudioFormat[0] : formats;
            this.minBufferSize = minBufferSize;
            this.maxBufferSize = maxBufferSize;
        }

        public Info(Class lineClass, AudioFormat format, int bufferSize) {
            super(lineClass);
            if (format == null) {
                this.formats = new AudioFormat[0];
            } else {
                AudioFormat[] formats = new AudioFormat[]{format};
                this.formats = formats;
            }
            this.minBufferSize = bufferSize;
            this.maxBufferSize = bufferSize;
        }

        public Info(Class lineClass, AudioFormat format) {
            this(lineClass, format, -1);
        }

        public AudioFormat[] getFormats() {
            AudioFormat[] returnedArray = new AudioFormat[this.formats.length];
            System.arraycopy(this.formats, 0, returnedArray, 0, this.formats.length);
            return returnedArray;
        }

        public boolean isFormatSupported(AudioFormat format) {
            int i = 0;
            while (i < this.formats.length) {
                if (format.matches(this.formats[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public int getMinBufferSize() {
            return this.minBufferSize;
        }

        public int getMaxBufferSize() {
            return this.maxBufferSize;
        }

        public boolean matches(Line.Info info) {
            if (!super.matches(info)) {
                return false;
            }
            Info dataLineInfo = (Info)info;
            if (this.getMaxBufferSize() != -1 && dataLineInfo.getMaxBufferSize() != -1 && this.getMaxBufferSize() > dataLineInfo.getMaxBufferSize()) {
                return false;
            }
            if (this.getMinBufferSize() != -1 && dataLineInfo.getMinBufferSize() != -1 && this.getMinBufferSize() < dataLineInfo.getMinBufferSize()) {
                return false;
            }
            AudioFormat[] localFormats = this.getFormats();
            if (localFormats != null) {
                int i = 0;
                while (i < localFormats.length) {
                    if (localFormats[i] != null && !dataLineInfo.isFormatSupported(localFormats[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.formats.length == 1 && this.formats[0] != null) {
                buf.append(" supporting format " + this.formats[0]);
            } else if (this.getFormats().length > 1) {
                buf.append(" supporting " + this.getFormats().length + " audio formats");
            }
            if (this.minBufferSize != -1 && this.maxBufferSize != -1) {
                buf.append(", and buffers of " + this.minBufferSize + " to " + this.maxBufferSize + " bytes");
            } else if (this.minBufferSize != -1 && this.minBufferSize > 0) {
                buf.append(", and buffers of at least " + this.minBufferSize + " bytes");
            } else if (this.maxBufferSize != -1) {
                buf.append(", and buffers of up to " + this.minBufferSize + " bytes");
            }
            return new String(super.toString() + buf);
        }
    }
}

