/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.mpa;

import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.codec.audio.AudioCodec;
import com.sun.media.codec.audio.mpa.MpegAudio;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class NativeDecoder
extends AudioCodec {
    private int pendingDataSize = 0;
    private static final int OUTSIZE = 32768;
    private byte[] pendingData = new byte[131072];
    private MpegAudio mpa;
    private int nativeData = 0;
    private boolean expectingSameInputBuffer = false;
    private long accumTS = 0L;
    private AudioFormat aFormat = null;
    int[] inRead = new int[1];
    int[] inReq = new int[1];
    int[] outWritten = new int[1];

    public NativeDecoder() {
        this.inputFormats = new Format[]{new AudioFormat("mpeglayer3", 16000.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 22050.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 24000.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 32000.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 44100.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 48000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 16000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 22050.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 24000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 32000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 44100.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 48000.0, -1, -1, -1, 1)};
    }

    public String getName() {
        return "MPEG Layer 3 Decoder";
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return new Format[]{new AudioFormat("LINEAR")};
        }
        if (format instanceof AudioFormat) {
            AudioFormat audioFormat = (AudioFormat)format;
            AudioFormat audioFormat2 = new AudioFormat("LINEAR", audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), 1, 1);
            this.outputFormats = new Format[]{audioFormat2};
        } else {
            this.outputFormats = new Format[0];
        }
        return this.outputFormats;
    }

    public synchronized void open() throws ResourceUnavailableException {
        if (this.nativeData != 0) {
            this.close();
        }
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmmpa");
            this.mpa = new MpegAudio();
            this.nativeData = MpegAudio.nOpen(new int[1]);
            if (this.nativeData == 0) {
                throw new ResourceUnavailableException("could not open " + this.getName());
            }
            this.pendingDataSize = 0;
            this.expectingSameInputBuffer = false;
            this.accumTS = 0L;
            this.aFormat = (AudioFormat)this.outputFormat;
            return;
        }
        catch (Throwable throwable) {
            throw new ResourceUnavailableException("could not open " + this.getName());
        }
    }

    public synchronized void close() {
        if (this.nativeData != 0) {
            MpegAudio.nClose(this.nativeData);
            this.nativeData = 0;
        }
    }

    public synchronized void reset() {
        if (this.nativeData != 0) {
            this.close();
            try {
                this.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                Log.error("MP3 Decoder: " + resourceUnavailableException);
            }
        }
    }

    public synchronized int process(Buffer buffer, Buffer buffer2) {
        boolean bl = false;
        if (this.isEOM(buffer)) {
            if (this.pendingDataSize == 0) {
                this.propagateEOM(buffer2);
                return 0;
            }
            bl = true;
        }
        Object object = buffer.getData();
        Object object2 = buffer2.getData();
        if (object2 == null) {
            object2 = new byte[32768];
            buffer2.setData(object2);
        }
        if (!(object instanceof byte[]) || !(object2 instanceof byte[])) {
            return 1;
        }
        byte[] byArray = (byte[])object;
        byte[] byArray2 = (byte[])object2;
        int n2 = buffer.getOffset();
        int n3 = buffer.getLength();
        int n4 = byArray2.length;
        int n5 = 0;
        int n6 = 0;
        if (!this.expectingSameInputBuffer) {
            System.arraycopy(byArray, n2, this.pendingData, this.pendingDataSize, n3);
            this.pendingDataSize += n3;
        }
        this.inReq[0] = 21;
        if (this.nativeData != 0) {
            while (n5 + 5000 <= n4 && this.pendingDataSize >= this.inReq[0]) {
                boolean bl2 = MpegAudio.nConvert(this.nativeData, this.pendingData, n6, this.pendingDataSize, byArray2, n5, n4 - n5, this.inRead, this.outWritten, n6, this.inReq);
                if (bl2) {
                    if (this.inRead[0] > this.pendingDataSize) break;
                    n5 += this.outWritten[0];
                    n6 += this.inRead[0];
                    this.pendingDataSize -= this.inRead[0];
                    if (this.inReq[0] == 0) {
                        this.inReq[0] = 21;
                    }
                    if (this.pendingDataSize >= this.inRead[0] + 9) continue;
                    break;
                }
                if (n5 > 0) break;
                this.pendingDataSize = 0;
                if (bl) {
                    n5 = 0;
                    break;
                }
                return 1;
            }
        }
        if (n6 != 0) {
            System.arraycopy(this.pendingData, n6, this.pendingData, 0, this.pendingDataSize);
        }
        buffer2.setLength(n5);
        buffer2.setFormat(this.outputFormat);
        if (this.aFormat != null && this.accumTS != 0L && buffer.getTimeStamp() > 0L) {
            buffer2.setTimeStamp(buffer.getTimeStamp() + this.aFormat.computeDuration(this.accumTS));
        }
        if (bl) {
            if (n5 == 0) {
                this.pendingDataSize = 0;
                this.propagateEOM(buffer2);
                return 0;
            }
            this.expectingSameInputBuffer = true;
            this.accumTS += (long)buffer2.getLength();
            return 2;
        }
        if (this.pendingDataSize > 1024) {
            this.expectingSameInputBuffer = true;
            this.accumTS += (long)buffer2.getLength();
            return 2;
        }
        this.expectingSameInputBuffer = false;
        this.accumTS = 0L;
        return 0;
    }
}

