/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.mpa;

import com.sun.media.BasicPlugIn;
import com.sun.media.JMFSecurityManager;
import com.sun.media.codec.audio.AudioCodec;
import com.sun.media.controls.BitRateAdapter;
import com.sun.media.util.Arch;
import java.util.Hashtable;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.Owned;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class NativeEncoder
extends AudioCodec {
    private int nativeData = 0;
    protected int INSIZE = 0;
    protected int OUTSIZE = 0;
    byte[] encData;
    int encDataLen = 0;
    BitRateControl bra;
    Control[] controls;
    boolean settingsChanged = false;
    private int numFramesPerOutputBuffer = 2;
    private int numFramesInBuffer = 0;
    private int outOffset = 0;
    static Hashtable bitRateTable = new Hashtable();

    public native int nOpen(AudioFormat var1);

    public native boolean nClose(int var1);

    public native int nConvert(int var1, byte[] var2, int var3, int var4, byte[] var5, int var6);

    public native int nFlush(int var1, byte[] var2);

    public NativeEncoder() {
        this.inputFormats = new Format[]{new AudioFormat("LINEAR", 22050.0, 16, -1, Arch.isBigEndian() ? 1 : 0, 1), new AudioFormat("LINEAR", 24000.0, 16, -1, Arch.isBigEndian() ? 1 : 0, 1), new AudioFormat("LINEAR", 44100.0, 16, -1, Arch.isBigEndian() ? 1 : 0, 1), new AudioFormat("LINEAR", 48000.0, 16, -1, Arch.isBigEndian() ? 1 : 0, 1)};
        this.outputFormats = new Format[]{new AudioFormat("mpeglayer3", -1.0, -1, -1, 1, -1), new AudioFormat("mpegaudio", -1.0, -1, -1, 1, -1)};
        this.bra = new BitRateControl(this, 64000, 24000, 128000);
    }

    public String getName() {
        return "MPEG Layer 3 Encoder";
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (format instanceof AudioFormat) {
            AudioFormat audioFormat = (AudioFormat)format;
            Format[] formatArray = new Format[]{new AudioFormat("mpeglayer3", audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), 1, 1), new AudioFormat("mpegaudio", audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), 1, 1)};
            return formatArray;
        }
        return new Format[0];
    }

    public int getBitRate() {
        return this.bra.getBitRate();
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = this.bra;
        }
        return this.controls;
    }

    public int isLayer3() {
        if (this.outputFormat != null && this.outputFormat.getEncoding().equalsIgnoreCase("mpeglayer3")) {
            return 1;
        }
        return 0;
    }

    public synchronized void open() throws ResourceUnavailableException {
        if (this.nativeData != 0) {
            this.close();
        }
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmmpa");
            this.nativeData = this.nOpen((AudioFormat)this.outputFormat);
            if (this.nativeData == 0) {
                throw new ResourceUnavailableException("could not open " + this.getName());
            }
            this.encData = new byte[this.INSIZE * this.numFramesPerOutputBuffer];
            return;
        }
        catch (Throwable throwable) {
            throw new ResourceUnavailableException("could not open " + this.getName());
        }
    }

    public synchronized void close() {
        if (this.nativeData != 0) {
            this.nClose(this.nativeData);
            this.nativeData = 0;
        }
    }

    public synchronized void reset() {
        if (this.nativeData != 0) {
            this.close();
            try {
                this.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                System.err.println("MP3 Encoder: " + resourceUnavailableException);
            }
        }
    }

    public Format setOutputFormat(Format format) {
        if (BasicPlugIn.matches(format, this.getSupportedOutputFormats(this.inputFormat)) == null) {
            return null;
        }
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        AudioFormat audioFormat = (AudioFormat)format;
        double d2 = audioFormat.getSampleRate();
        int n2 = audioFormat.getChannels();
        int n3 = this.computeBitRate((int)d2, n2);
        this.bra.setBitRate(n3);
        this.outputFormat = new AudioFormat(audioFormat.getEncoding(), d2, audioFormat.getSampleSizeInBits(), n2, audioFormat.getEndian(), audioFormat.getSigned(), 8, this.getBitRate() / 8, audioFormat.getDataType());
        return this.outputFormat;
    }

    public synchronized int process(Buffer buffer, Buffer buffer2) {
        if (this.isEOM(buffer)) {
            int n2 = this.nFlush(this.nativeData, (byte[])buffer2.getData());
            if (n2 > 0) {
                buffer2.setOffset(0);
                buffer2.setLength(n2);
            } else {
                buffer2.setLength(0);
            }
            buffer2.setFormat(this.outputFormat);
            buffer2.setEOM(true);
            if (this.settingsChanged) {
                this.reset();
                this.settingsChanged = false;
            }
            return 0;
        }
        if (!(buffer.getData() instanceof byte[])) {
            return 1;
        }
        int n3 = buffer.getOffset();
        int n4 = buffer.getLength();
        byte[] byArray = (byte[])buffer.getData();
        byte[] byArray2 = (byte[])buffer2.getData();
        if (byArray2 == null || byArray2.length < this.OUTSIZE * this.numFramesPerOutputBuffer) {
            byArray2 = new byte[this.OUTSIZE * this.numFramesPerOutputBuffer];
            buffer2.setData(byArray2);
        }
        int n5 = 0;
        if (this.nativeData != 0) {
            while (this.encDataLen < this.INSIZE * this.numFramesPerOutputBuffer && n3 < n4) {
                this.encData[this.encDataLen] = byArray[n3];
                ++n3;
                ++this.encDataLen;
            }
            if (this.encDataLen >= this.INSIZE * this.numFramesPerOutputBuffer) {
                int n6 = 0;
                while (n6 < this.numFramesPerOutputBuffer) {
                    int n7 = this.nConvert(this.nativeData, this.encData, this.INSIZE * n6, this.INSIZE, (byte[])buffer2.getData(), this.outOffset);
                    if (n7 < 0) {
                        return 1;
                    }
                    ++this.numFramesInBuffer;
                    this.outOffset += n7;
                    ++n6;
                }
                this.encDataLen = 0;
                this.numFramesInBuffer = 0;
                if (this.outOffset == 0) {
                    n5 |= 4;
                } else {
                    buffer2.setOffset(0);
                    buffer2.setLength(this.outOffset);
                    buffer2.setFormat(this.outputFormat);
                    this.outOffset = 0;
                }
            } else {
                n5 |= 4;
            }
        }
        if (n3 < n4) {
            buffer.setOffset(n3);
            n5 |= 2;
        }
        if (n5 == 0 && this.settingsChanged) {
            this.reset();
            this.settingsChanged = false;
        }
        return n5;
    }

    private int computeBitRate(int n2, int n3) {
        int n4;
        Object v = bitRateTable.get(new Integer(n2));
        if (v != null) {
            n4 = (Integer)v;
            n4 *= n3;
        } else {
            n4 = 64000;
        }
        return n4;
    }

    static {
        bitRateTable.put(new Integer(32000), new Integer(48000));
        bitRateTable.put(new Integer(44100), new Integer(64000));
        bitRateTable.put(new Integer(48000), new Integer(64000));
        bitRateTable.put(new Integer(16000), new Integer(24000));
        bitRateTable.put(new Integer(22050), new Integer(32000));
        bitRateTable.put(new Integer(24000), new Integer(32000));
    }

    class BitRateControl
    extends BitRateAdapter
    implements Owned {
        NativeEncoder encoder;

        public BitRateControl(NativeEncoder nativeEncoder2, int n2, int n3, int n4) {
            super(n2, n3, n4, true);
            this.encoder = nativeEncoder2;
        }

        public int setBitRate(int n2) {
            int n3 = super.setBitRate(n2);
            this.encoder.settingsChanged = true;
            return n3;
        }

        public Object getOwner() {
            return this.encoder;
        }
    }
}

