/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.ExclusiveUse;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.content.application.x_shockwave_flash.AudioCodecPipe;
import com.sun.media.content.application.x_shockwave_flash.JavaSoundPlayer;
import com.sun.media.content.application.x_shockwave_flash.JavaSoundTester;
import com.sun.media.content.application.x_shockwave_flash.SoundMixer;
import com.sun.media.content.application.x_shockwave_flash.SunAudioTester;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12PriorityAction;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.media.Format;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.format.AudioFormat;
import sun.audio.AudioPlayer;

public class FlashAudioPlayer {
    public static String MDAR = "com.sun.media.renderer.audio.MixedDirectAudioRenderer";
    public static String DAR = "com.sun.media.renderer.audio.DirectAudioRenderer";
    static AudioCodecPipe codecPipe;
    static AudioFormat ulaw_af;
    static AudioFormat pcm_af;
    public static int rendererUsed;
    public static int ULAWBS;
    public static Vector soundStreams;
    public static FlashAudioPlayer player;
    private static JMFSecurity jmfSecurity;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private int[] slock = new int[0];
    static /* synthetic */ Class class$com$sun$media$util$MediaThread;

    private FlashAudioPlayer() {
        Object object;
        boolean bl = false;
        Vector vector = PlugInManager.getPlugInList(null, null, 4);
        ULAWBS = 80;
        String string = null;
        String string2 = null;
        boolean bl2 = false;
        try {
            string = System.getProperty("java.version");
            string2 = string.length() < 3 ? string : string.substring(0, 3);
        }
        catch (Throwable throwable) {
            string = null;
            string2 = null;
        }
        bl2 = string2 != null && string2.compareTo("1.3") >= 0;
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                String string3 = (String)vector.elementAt(n2);
                if (string3.indexOf("audio") >= 0 || string3.indexOf("Audio") >= 0) {
                    if (string3.indexOf("JavaSound") > 0 && FlashAudioPlayer.javasoundAvailable()) {
                        rendererUsed = 1;
                        soundStreams = new Vector();
                        bl = true;
                        System.out.println("using JavaSound as audio renderer");
                        break;
                    }
                    if (string3.indexOf("DirectAudio") > 0) {
                        object = null;
                        boolean bl3 = true;
                        try {
                            object = Class.forName(DAR);
                            bl3 = ((ExclusiveUse)((Class)object).newInstance()).isExclusive();
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        if (!bl3) {
                            rendererUsed = 4;
                            ULAWBS = 800;
                            bl = true;
                            System.out.println("using DirectAudioRenderer");
                            break;
                        }
                        rendererUsed = 3;
                        ULAWBS = 80;
                        bl = true;
                        System.out.println("using MixedDirectAudioRenderer");
                        break;
                    }
                    if (bl2) {
                        rendererUsed = 1;
                        soundStreams = new Vector();
                        bl = true;
                        System.out.println("using JavaSound as audio renderer");
                        break;
                    }
                    if (string3.indexOf("SunAudio") > 0 && FlashAudioPlayer.sunaudioAvailable()) {
                        rendererUsed = 2;
                        soundStreams = new Vector();
                        bl = true;
                        System.out.println("using Sun.Audio as audio renderer");
                        break;
                    }
                }
                ++n2;
            }
        }
        if (!bl) {
            System.out.println("no audio renderer available");
        } else if (rendererUsed == 3 || rendererUsed == 4) {
            soundStreams = new Vector();
            try {
                Class<?> clazz = null;
                clazz = rendererUsed == 3 ? Class.forName(MDAR) : Class.forName(DAR);
                object = (Renderer)clazz.newInstance();
                ulaw_af = new AudioFormat("ULAW", 8000.0, 8, 1);
                Format[] formatArray = object.getSupportedInputFormats();
                AudioFormat[] audioFormatArray = new AudioFormat[formatArray.length];
                int n3 = 0;
                while (n3 < formatArray.length) {
                    audioFormatArray[n3] = (AudioFormat)formatArray[n3];
                    ++n3;
                }
                codecPipe = new AudioCodecPipe(ulaw_af, audioFormatArray, 0);
                pcm_af = (AudioFormat)codecPipe.getOutputFormat();
                object.setInputFormat(pcm_af);
                if (rendererUsed == 3) {
                    object.open();
                    object.start();
                    object.stop();
                    object.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static boolean javasoundAvailable() {
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName("com.sun.media.content.application.x_shockwave_flash.JavaSoundTester");
            JavaSoundTester javaSoundTester = (JavaSoundTester)clazz.newInstance();
            bl = javaSoundTester.isSupported();
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    static boolean sunaudioAvailable() {
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName("com.sun.media.content.application.x_shockwave_flash.SunAudioTester");
            SunAudioTester sunAudioTester = (SunAudioTester)clazz.newInstance();
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    public int getActiveSoundNum() {
        return soundStreams.size();
    }

    public int getRendererUsed() {
        return rendererUsed;
    }

    public void removeSoundStream(SoundMixer soundMixer) {
        int[] nArray = this.slock;
        synchronized (nArray) {
            soundStreams.removeElement(soundMixer);
        }
    }

    public void start(byte[] byArray, int n2) {
        switch (rendererUsed) {
            case 1: {
                JavaSoundPlayer javaSoundPlayer = new JavaSoundPlayer(byArray, n2);
                int[] nArray = this.slock;
                synchronized (nArray) {
                    soundStreams.addElement(javaSoundPlayer);
                    this.slock.notifyAll();
                }
                javaSoundPlayer.play();
                break;
            }
            case 2: {
                SoundMixer soundMixer = new SoundMixer(byArray, n2);
                int[] nArray = this.slock;
                synchronized (nArray) {
                    soundStreams.addElement(soundMixer);
                    this.slock.notifyAll();
                }
                AudioPlayer.player.start((InputStream)soundMixer);
                break;
            }
            case 3: 
            case 4: {
                Object object;
                AudioCodecPipe audioCodecPipe = (AudioCodecPipe)codecPipe.clone();
                audioCodecPipe.setBufferSize(ULAWBS);
                Renderer renderer = null;
                try {
                    Class<?> clazz = rendererUsed == 3 ? Class.forName(MDAR) : Class.forName(DAR);
                    renderer = (Renderer)clazz.newInstance();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                if (renderer == null) break;
                SoundMixer soundMixer = new SoundMixer(byArray, n2, false, renderer, audioCodecPipe, ULAWBS);
                try {
                    renderer.setInputFormat(pcm_af);
                    renderer.open();
                    if (rendererUsed == 4) {
                        soundMixer.prefetch();
                    }
                    renderer.start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                MediaThread mediaThread = null;
                if (jmfSecurity != null) {
                    object = null;
                    try {
                        if (jmfSecurity.getName().startsWith("jmf-security")) {
                            object = "thread";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                            object = "thread group";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        } else if (jmfSecurity.getName().startsWith("internet")) {
                            PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                            PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                        }
                    }
                    catch (Throwable throwable) {
                        securityPrivelege = false;
                    }
                }
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    try {
                        object = jdk12CreateThreadRunnableAction.cons;
                        mediaThread = (MediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$util$MediaThread == null ? (class$com$sun$media$util$MediaThread = FlashAudioPlayer.class$("com.sun.media.util.MediaThread")) : class$com$sun$media$util$MediaThread, soundMixer));
                        object = jdk12PriorityAction.cons;
                        jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(mediaThread, new Integer(MediaThread.getAudioPriority())));
                    }
                    catch (Exception exception) {}
                } else {
                    mediaThread = new MediaThread(soundMixer);
                    mediaThread.useAudioPriority();
                }
                mediaThread.setName("SoundStream Thread");
                object = this.slock;
                synchronized (object) {
                    soundStreams.addElement(soundMixer);
                    mediaThread.start();
                    this.slock.notifyAll();
                    break;
                }
            }
        }
    }

    public void stop() {
        if (soundStreams.size() <= 0) {
            return;
        }
        switch (rendererUsed) {
            case 1: {
                int[] nArray = this.slock;
                synchronized (nArray) {
                    try {
                        int n2 = 0;
                        while (n2 < soundStreams.size()) {
                            JavaSoundPlayer javaSoundPlayer = (JavaSoundPlayer)soundStreams.elementAt(n2);
                            if (javaSoundPlayer != null) {
                                javaSoundPlayer.stop();
                            }
                            ++n2;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    soundStreams.removeAllElements();
                    this.slock.notifyAll();
                    break;
                }
            }
            case 2: {
                int[] nArray = this.slock;
                synchronized (nArray) {
                    int n3 = 0;
                    while (n3 < soundStreams.size()) {
                        SoundMixer soundMixer = (SoundMixer)soundStreams.elementAt(n3);
                        if (soundMixer != null) {
                            AudioPlayer.player.stop((InputStream)soundMixer);
                            try {
                                soundMixer.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        ++n3;
                    }
                    soundStreams.removeAllElements();
                    this.slock.notifyAll();
                    break;
                }
            }
            case 3: 
            case 4: {
                int[] nArray = this.slock;
                synchronized (nArray) {
                    int n4 = 0;
                    while (n4 < soundStreams.size()) {
                        SoundMixer soundMixer = (SoundMixer)soundStreams.elementAt(n4);
                        SoundMixer.StopAllStreams();
                        try {
                            soundMixer.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        soundMixer.getMDAR().stop();
                        soundMixer.getMDAR().close();
                        ++n4;
                    }
                    soundStreams.removeAllElements();
                    break;
                }
            }
        }
    }

    public void closeMixedRenderer() {
        if (rendererUsed == 3) {
            int[] nArray = this.slock;
            synchronized (nArray) {
                if (soundStreams.size() > 0) {
                    return;
                }
                try {
                    Class[] classArray = new Class[]{};
                    Object[] objectArray = new Object[]{};
                    Class<?> clazz = Class.forName(MDAR);
                    Method method = clazz.getMethod("closeRenderer", classArray);
                    method.invoke(null, objectArray);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        rendererUsed = 0;
        ULAWBS = 80;
        soundStreams = new Vector();
        player = new FlashAudioPlayer();
        jmfSecurity = null;
        securityPrivelege = false;
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

