/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.jmfsound.sampled.AudioFormat;
import com.sun.jmfsound.sampled.AudioInputStream;
import com.sun.jmfsound.sampled.AudioSystem;
import com.sun.jmfsound.sampled.Clip;
import com.sun.jmfsound.sampled.DataLine;
import com.sun.jmfsound.sampled.Line;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class JavaSoundPlayer {
    static final int kHeaderSize = 28;
    static byte[] lutTableL = new byte[256];
    static byte[] lutTableH = new byte[256];
    byte[] mulawData = null;
    byte[] pcmData = null;
    int loopCount;
    Clip source = null;
    boolean zeroLoop = false;
    static /* synthetic */ Class class$com$sun$jmfsound$sampled$Clip;

    public JavaSoundPlayer(byte[] byArray, int n2) {
        this.mulawData = byArray;
        if (n2 < 0) {
            this.loopCount = -1;
        } else if (n2 > 0) {
            this.loopCount = n2 - 1;
        } else {
            this.zeroLoop = true;
        }
        if (!this.zeroLoop) {
            int n3 = 2 * (byArray.length - 28);
            this.pcmData = new byte[n3];
            this.createTable();
            this.decodeMulaw();
        }
    }

    private void createTable() {
        int n2 = 0;
        while (n2 < 256) {
            int n3 = ~n2;
            int n4 = ((n3 & 0xF) << 3) + 132;
            int n5 = (n3 & 0x70) >> 4;
            int n6 = n4 << n5;
            n6 -= 132;
            if ((n3 & 0x80) != 0) {
                n6 = -n6;
            }
            JavaSoundPlayer.lutTableL[n2] = (byte)n6;
            JavaSoundPlayer.lutTableH[n2] = (byte)(n6 >> 8);
            ++n2;
        }
    }

    private void decodeMulaw() {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n2 = 28;
        while (n2 < this.mulawData.length) {
            n4 = this.mulawData[n2] & 0xFF;
            this.pcmData[n3++] = lutTableL[n4];
            this.pcmData[n3++] = lutTableH[n4];
            ++n2;
        }
    }

    public void play() {
        if (this.zeroLoop) {
            return;
        }
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream((InputStream)new ByteArrayInputStream(this.mulawData));
            AudioFormat audioFormat = audioInputStream.getFormat();
            AudioFormat audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits() * 2, audioFormat.getChannels(), audioFormat.getFrameSize() * 2, audioFormat.getFrameRate(), false);
            AudioInputStream audioInputStream2 = AudioSystem.getAudioInputStream((AudioFormat)audioFormat2, (AudioInputStream)audioInputStream);
            if (audioInputStream2 == null) {
                System.out.println("Can't convert from ulaw to pcm");
                return;
            }
            DataLine.Info info = new DataLine.Info(class$com$sun$jmfsound$sampled$Clip == null ? (class$com$sun$jmfsound$sampled$Clip = JavaSoundPlayer.class$("com.sun.jmfsound.sampled.Clip")) : class$com$sun$jmfsound$sampled$Clip, audioInputStream2.getFormat());
            if (!AudioSystem.isLineSupported((Line.Info)info)) {
                System.out.println("Not Support Line Info : " + info);
                return;
            }
            this.source = (Clip)AudioSystem.getLine((Line.Info)info);
            this.source.open(audioInputStream2);
            this.source.loop(this.loopCount);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stop() throws Exception {
        if (this.source == null) {
            return;
        }
        this.source.stop();
        this.source.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

