/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.AudioCodecPipe;
import com.sun.media.content.application.x_shockwave_flash.Flash;
import com.sun.media.content.application.x_shockwave_flash.FlashAudioPlayer;
import com.sun.media.renderer.audio.AudioRenderer;
import java.io.ByteArrayInputStream;
import javax.media.Buffer;
import javax.media.Renderer;
import javax.media.format.AudioFormat;

final class SoundMixer
extends ByteArrayInputStream
implements Runnable {
    private static final int kHeaderSize = 28;
    private int length;
    private int index;
    private int ULAWBS = 80;
    AudioCodecPipe acpipe = null;
    Renderer mdar = null;
    int[] readLock = null;

    SoundMixer(byte[] byArray, int n2, boolean bl) {
        super(byArray);
        this.length = byArray.length;
        this.count = n2 < 0 ? Integer.MAX_VALUE : this.length * n2 - (n2 - 1) * 28;
        Flash.stopAllSoundStreams = false;
        this.index = bl ? 0 : 28;
        this.acpipe = null;
        this.mdar = null;
        this.readLock = new int[0];
        this.ULAWBS = 80;
    }

    SoundMixer(byte[] byArray, int n2) {
        this(byArray, n2, true);
    }

    SoundMixer(byte[] byArray, int n2, boolean bl, Renderer renderer, AudioCodecPipe audioCodecPipe) {
        this(byArray, n2, bl);
        this.mdar = renderer;
        this.acpipe = audioCodecPipe;
    }

    SoundMixer(byte[] byArray, int n2, boolean bl, Renderer renderer, AudioCodecPipe audioCodecPipe, int n3) {
        this(byArray, n2, bl);
        this.mdar = renderer;
        this.acpipe = audioCodecPipe;
        this.ULAWBS = n3;
    }

    public void setULAWBS(int n2) {
        this.ULAWBS = n2;
    }

    public synchronized int read() {
        if (Flash.stopAllSoundStreams) {
            return -1;
        }
        if (this.pos < this.count) {
            ++this.pos;
            if (this.index >= this.length) {
                this.index = 28;
            }
            return this.buf[this.index++] & 0xFF;
        }
        return -1;
    }

    private int localRead(byte[] byArray, int n2, int n3) {
        if (this.index >= this.length) {
            return -1;
        }
        if (this.index + n3 > this.length) {
            n3 = this.length - this.index;
        }
        if (n3 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.index, byArray, n2, n3);
        this.index += n3;
        return n3;
    }

    public synchronized int read(byte[] byArray, int n2, int n3) {
        if (Flash.stopAllSoundStreams) {
            return -1;
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n3 > this.count) {
            n3 = this.count - this.pos;
        }
        if (n3 <= 0) {
            return 0;
        }
        if (this.index + n3 <= this.length) {
            System.arraycopy(this.buf, this.index, byArray, n2, n3);
            this.index += n3;
        } else {
            int n4 = 0;
            while (n4 < n3) {
                int n5 = this.localRead(byArray, n2 + n4, n3 - n4);
                if (n5 > 0) {
                    n4 += n5;
                    continue;
                }
                this.index = 28;
            }
        }
        this.pos += n3;
        return n3;
    }

    public synchronized long skip(long l2) {
        if (Flash.stopAllSoundStreams) {
            return 0L;
        }
        if ((long)this.pos + l2 > (long)this.count) {
            l2 = this.count - this.pos;
        }
        if (l2 < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l2);
        if (this.pos < this.length) {
            this.index = this.pos;
        } else {
            int n2 = this.pos - this.length + 1;
            int n3 = this.length - 28;
            this.index = n2 % n3 + 28 - 1;
        }
        return l2;
    }

    public synchronized int available() {
        if (Flash.stopAllSoundStreams) {
            return 0;
        }
        return this.count - this.pos;
    }

    public synchronized void reset() {
        this.index = 0;
        this.pos = 0;
    }

    public void stopStream() {
        int[] nArray = this.readLock;
        synchronized (nArray) {
            Flash.stopAllSoundStreams = true;
        }
    }

    public static synchronized void StopAllStreams() {
        Flash.stopAllSoundStreams = true;
    }

    public Renderer getMDAR() {
        return this.mdar;
    }

    public void prefetch() {
        int n2;
        AudioFormat audioFormat = (AudioFormat)this.acpipe.getInputFormat();
        AudioFormat audioFormat2 = (AudioFormat)this.acpipe.getOutputFormat();
        byte[] byArray = new byte[this.ULAWBS];
        Buffer buffer = new Buffer();
        Buffer buffer2 = new Buffer();
        buffer.setFormat(audioFormat);
        buffer2.setFormat(audioFormat2);
        int[] nArray = this.readLock;
        synchronized (nArray) {
            n2 = this.read(byArray, 0, this.ULAWBS);
        }
        if (n2 <= 0) {
            return;
        }
        buffer.setData(byArray);
        buffer.setLength(n2);
        buffer.setOffset(0);
        this.acpipe.process(buffer);
        byte[] byArray2 = (byte[])this.acpipe.getOutputBuffer().getData();
        buffer2.setData(byArray2);
        buffer2.setLength(2 * n2);
        buffer2.setOffset(0);
        int n3 = this.mdar.process(buffer2);
    }

    public void run() {
        AudioFormat audioFormat = (AudioFormat)this.acpipe.getInputFormat();
        AudioFormat audioFormat2 = (AudioFormat)this.acpipe.getOutputFormat();
        byte[] byArray = new byte[this.ULAWBS];
        Buffer buffer = new Buffer();
        Buffer buffer2 = new Buffer();
        buffer.setFormat(audioFormat);
        buffer2.setFormat(audioFormat2);
        while (true) {
            int n2;
            int[] nArray = this.readLock;
            synchronized (nArray) {
                n2 = this.read(byArray, 0, this.ULAWBS);
            }
            if (n2 <= 0) break;
            buffer.setData(byArray);
            buffer.setLength(n2);
            buffer.setOffset(0);
            this.acpipe.process(buffer);
            byte[] byArray2 = (byte[])this.acpipe.getOutputBuffer().getData();
            buffer2.setData(byArray2);
            buffer2.setLength(2 * n2);
            buffer2.setOffset(0);
            int n3 = this.mdar.process(buffer2);
            Thread.currentThread();
            Thread.yield();
        }
        if (this.mdar instanceof AudioRenderer) {
            ((AudioRenderer)this.mdar).drain();
        }
        this.mdar.stop();
        this.mdar.close();
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        FlashAudioPlayer.player.removeSoundStream(this);
    }
}

