/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import jmapps.ui.ImageArea;

public class TreeNode
extends Vector {
    public static final int MARGIN_HORZ = 6;
    public static final int MARGIN_VERT = 2;
    public static final int BOXSIZE = 8;
    public static final String ACTION_NODE_ADDED = "Node Added";
    public static final String ACTION_NODE_REMOVED = "Node Removed";
    public static final String ACTION_NODE_EXPANDED = "Node Expanded";
    public static final String ACTION_NODE_COLLAPSED = "Node Collapsed";
    public static final String ACTION_NODE_SETCURRENT = "Node Set Current";
    public static final String ACTION_NODE_RESETCURRENT = "Node Reset Current";
    public static final Color colorBg = Color.lightGray;
    public static final Color colorCurBg = new Color(0, 0, 128);
    public static final Color colorFg = Color.black;
    public static final Color colorCurFg = Color.yellow;
    public static final Color colorLines = Color.darkGray;
    private Component componentOwner;
    private Vector vectorActionListeners = new Vector();
    private boolean boolExpanded = false;
    private boolean boolCurrent = false;
    private boolean boolVisible = true;
    private Image imageTreeElement = null;
    private Image imageTreeElementCur = null;
    private int nWidthImage = 0;
    private int nHeightImage = 0;
    private Rectangle rectElement = null;
    private Rectangle rectElementFull = null;
    private String strName;
    private Object objUserData = null;
    private TreeNode nodeOwner;

    public TreeNode(String string, Component component) {
        this.strName = new String(string);
        this.componentOwner = component;
        this.rectElement = new Rectangle(0, 0, 0, 0);
        this.rectElementFull = new Rectangle(0, 0, 0, 0);
        this.setImage(ImageArea.loadImage("treeNode.gif", component, true));
        this.setImageCur(ImageArea.loadImage("treeNodeCur.gif", component, true));
    }

    public void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.vectorActionListeners.addElement(actionListener);
    }

    public void rewmoveActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.vectorActionListeners.removeElement(actionListener);
    }

    public String getName() {
        return this.strName;
    }

    public String getFullPathName() {
        String string = this.nodeOwner != null ? this.nodeOwner.getFullPathName() : new String();
        string = string + "/" + this.strName;
        return string;
    }

    public TreeNode getOwner() {
        return this.nodeOwner;
    }

    public TreeNode getRoot() {
        TreeNode treeNode = this;
        while (treeNode.getOwner() != null) {
            treeNode = treeNode.getOwner();
        }
        return treeNode;
    }

    public Object getUserData() {
        return this.objUserData;
    }

    public TreeNode getSubElement(int n2) {
        int n3 = this.size();
        if (n2 >= n3 || n2 < 0) {
            return null;
        }
        TreeNode treeNode = (TreeNode)this.elementAt(n2);
        return treeNode;
    }

    public TreeNode getSubElement(String string) {
        String string2 = null;
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            TreeNode treeNode = (TreeNode)this.elementAt(n3);
            string2 = treeNode.getName();
            if (string2.equals(string)) {
                return treeNode;
            }
            ++n3;
        }
        return null;
    }

    public boolean isSubElement(String string) {
        String string2 = null;
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            TreeNode treeNode = (TreeNode)this.elementAt(n3);
            string2 = treeNode.getName();
            if (string2.equals(string)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public TreeNode findElement(String string) {
        TreeNode treeNode = null;
        if (string.equals("/" + this.strName)) {
            return this;
        }
        if (!string.startsWith("/" + this.strName)) {
            return null;
        }
        string = string.substring(this.strName.length() + 1);
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2 && treeNode == null) {
            treeNode = (TreeNode)this.elementAt(n3);
            treeNode = treeNode.findElement(string);
            ++n3;
        }
        return treeNode;
    }

    public TreeNode addSubElement(TreeNode treeNode) {
        if (treeNode.nodeOwner != null) {
            treeNode.nodeOwner.removeSubElement(treeNode);
        }
        this.addElement(treeNode);
        treeNode.nodeOwner = this;
        ActionEvent actionEvent = new ActionEvent(this, 1001, ACTION_NODE_ADDED);
        this.fireActionEvent(actionEvent);
        return treeNode;
    }

    public TreeNode addSubElement(String string) {
        TreeNode treeNode = new TreeNode(string, this.componentOwner);
        this.addSubElement(treeNode);
        return treeNode;
    }

    public TreeNode insertSubElement(int n2, TreeNode treeNode) {
        if (treeNode.nodeOwner != null) {
            treeNode.nodeOwner.removeSubElement(treeNode);
        }
        int n3 = this.size();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        this.insertElementAt(treeNode, n2);
        treeNode.nodeOwner = this;
        return treeNode;
    }

    public TreeNode insertSubElement(int n2, String string) {
        TreeNode treeNode = new TreeNode(string, this.componentOwner);
        this.insertSubElement(n2, treeNode);
        return treeNode;
    }

    public void removeSubElement(TreeNode treeNode) {
        boolean bl = this.removeElement(treeNode);
        if (bl) {
            treeNode.nodeOwner = null;
            ActionEvent actionEvent = new ActionEvent(this, 1001, ACTION_NODE_REMOVED);
            this.fireActionEvent(actionEvent);
        }
    }

    public void destroySubElement(TreeNode treeNode) {
        treeNode.destroyAllSubElements();
        treeNode.nodeOwner = null;
        this.removeSubElement(treeNode);
    }

    public void destroySubElement(int n2) {
        int n3 = this.size();
        if (n2 >= n3 || n2 < 0) {
            return;
        }
        TreeNode treeNode = (TreeNode)this.elementAt(n2);
        this.destroySubElement(treeNode);
    }

    public void destroyAllSubElements() {
        int n2 = this.size();
        while (n2 > 0) {
            this.destroySubElement(--n2);
        }
    }

    public void sortSubElements() {
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            TreeNode treeNode = (TreeNode)this.elementAt(n3);
            String string = treeNode.getName();
            this.removeElementAt(n3);
            int n4 = 0;
            while (n4 < n3) {
                TreeNode treeNode2 = (TreeNode)this.elementAt(n4);
                String string2 = treeNode2.getName();
                int n5 = string.compareTo(string2);
                if (n5 < 0) break;
                ++n4;
            }
            this.insertElementAt(treeNode, n4);
            treeNode.sortSubElements();
            ++n3;
        }
    }

    public int getImmediateSubElementsCount() {
        int n2 = this.size();
        return n2;
    }

    public int getRecursiveSubElementsCount() {
        int n2;
        int n3 = n2 = this.size();
        int n4 = 0;
        while (n4 < n2) {
            Object e2 = this.elementAt(n4);
            if (e2 != null && e2 instanceof TreeNode) {
                n3 += ((TreeNode)e2).getRecursiveSubElementsCount();
            }
            ++n4;
        }
        return n3;
    }

    public int getExpandedSubElementsCount() {
        int n2;
        int n3 = n2 = this.size();
        int n4 = 0;
        while (n4 < n2) {
            Object e2 = this.elementAt(n4);
            if (e2 != null && e2 instanceof TreeNode && ((TreeNode)e2).isExpanded()) {
                n3 += ((TreeNode)e2).getExpandedSubElementsCount();
            }
            ++n4;
        }
        return n3;
    }

    public boolean isRecursiveSubElement(Object object) {
        boolean bl = false;
        if (object == this) {
            return true;
        }
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2 && !bl) {
            Object e2 = this.elementAt(n3);
            if (object == e2) {
                return true;
            }
            if (e2 != null && e2 instanceof TreeNode) {
                bl = ((TreeNode)e2).isRecursiveSubElement(object);
            }
            ++n3;
        }
        return bl;
    }

    public void setUserData(Object object) {
        this.objUserData = object;
    }

    public boolean isVisible() {
        return this.boolVisible;
    }

    public void setVisible(boolean bl) {
        if (this.boolVisible == bl) {
            return;
        }
        this.boolVisible = bl;
        if (!bl && !this.boolExpanded) {
            this.switchExpanded();
        }
    }

    public boolean isExpanded() {
        return this.boolExpanded;
    }

    public void setExpanded(boolean bl) {
        if (this.boolExpanded != bl) {
            this.switchExpanded();
        }
    }

    public boolean switchExpanded() {
        ActionEvent actionEvent;
        if (this.boolExpanded) {
            this.boolExpanded = false;
            actionEvent = new ActionEvent(this, 1001, ACTION_NODE_COLLAPSED);
        } else {
            this.boolExpanded = true;
            actionEvent = new ActionEvent(this, 1001, ACTION_NODE_EXPANDED);
        }
        this.fireActionEvent(actionEvent);
        return this.boolExpanded;
    }

    public void setCurrent(boolean bl) {
        ActionEvent actionEvent;
        if (this.boolCurrent == bl) {
            return;
        }
        if (bl) {
            TreeNode treeNode = this.getRoot();
            if ((treeNode = treeNode.getCurrent()) != null) {
                treeNode.setCurrent(false);
            }
            treeNode = this.nodeOwner;
            while (treeNode != null && treeNode instanceof TreeNode) {
                if (!treeNode.isExpanded()) {
                    treeNode.setExpanded(true);
                }
                treeNode = treeNode.nodeOwner;
            }
            actionEvent = new ActionEvent(this, 1001, ACTION_NODE_SETCURRENT);
        } else {
            actionEvent = new ActionEvent(this, 1001, ACTION_NODE_RESETCURRENT);
        }
        this.boolCurrent = bl;
        this.computeImageSize();
        this.fireActionEvent(actionEvent);
    }

    public TreeNode getCurrent() {
        TreeNode treeNode = null;
        if (this.boolCurrent) {
            return this;
        }
        int n2 = this.getImmediateSubElementsCount();
        int n3 = 0;
        while (n3 < n2 && treeNode == null) {
            TreeNode treeNode2 = this.getSubElement(n3);
            treeNode = treeNode2.getCurrent();
            ++n3;
        }
        return treeNode;
    }

    public void setImage(Image image) {
        this.imageTreeElement = image;
        this.computeImageSize();
    }

    public void setImageCur(Image image) {
        this.imageTreeElementCur = image;
        this.computeImageSize();
    }

    public Rectangle getNodeBounds() {
        return new Rectangle(this.rectElement);
    }

    public Rectangle getNodeBoundsFull() {
        return new Rectangle(this.rectElementFull);
    }

    public void onMouseDoubleclick(Point point) {
        int n2 = this.getImmediateSubElementsCount();
        if (!this.rectElementFull.contains(point)) {
            return;
        }
        if (this.rectElement.contains(point) && point.x >= this.rectElement.x + 12 + 8 && n2 > 0) {
            this.switchExpanded();
            return;
        }
        if (!this.boolExpanded) {
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            TreeNode treeNode = this.getSubElement(n3);
            treeNode.onMouseDoubleclick(point);
            ++n3;
        }
    }

    public void onMousePressedLeft(Point point, boolean bl, boolean bl2, boolean bl3) {
        int n2 = this.getImmediateSubElementsCount();
        if (!this.rectElementFull.contains(point)) {
            return;
        }
        if (this.rectElement.contains(point)) {
            if (point.x >= this.rectElement.x + 12 + 8) {
                this.setCurrent(true);
            } else if (n2 > 0) {
                this.switchExpanded();
            }
            return;
        }
        if (!this.boolExpanded) {
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            TreeNode treeNode = this.getSubElement(n3);
            treeNode.onMousePressedLeft(point, bl, bl2, bl3);
            ++n3;
        }
    }

    public void onMousePressedRight(Point point, boolean bl, boolean bl2, boolean bl3) {
    }

    public void drawElement(Graphics graphics, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.getImmediateSubElementsCount();
        Rectangle rectangle = new Rectangle(this.rectElement);
        rectangle.x -= n2;
        rectangle.y -= n3;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(colorLines);
        if (n8 > 0) {
            n7 = rectangle.x + 6;
            n6 = rectangle.y + (rectangle.height - 8) / 2;
            n5 = 8;
            n4 = 8;
            graphics.setColor(colorBg);
            graphics.fillRect(n7, n6, n5, n4);
            graphics.setColor(colorLines);
            graphics.drawRect(n7, n6, n5, n4);
            n7 = rectangle.x + 6 + 8;
            n6 = rectangle.y + rectangle.height / 2;
            this.drawDottedLine(graphics, n7, n6, n7 + 6, n6);
        } else {
            n7 = rectangle.x + 6 + 4;
            n6 = rectangle.y + rectangle.height / 2;
            this.drawDottedLine(graphics, n7, n6, n7 + 6, n6);
        }
        if (n8 > 0 && this.boolExpanded) {
            TreeNode treeNode = this.getSubElement(n8 - 1);
            Rectangle rectangle2 = treeNode.getNodeBounds();
            n7 = rectangle.x + 12 + 8 + this.nWidthImage / 2;
            n6 = rectangle.y + (rectangle.height - this.nHeightImage) / 2 + this.nHeightImage + 1;
            n4 = rectangle2.y - n3 - n6 + rectangle2.height / 2;
            this.drawDottedLine(graphics, n7, n6, n7, n6 + n4);
        }
        graphics.setColor(colorFg);
        if (n8 > 0) {
            n7 = rectangle.x + 6 + 2;
            n6 = rectangle.y + rectangle.height / 2;
            n5 = 4;
            graphics.drawLine(n7, n6, n7 + n5, n6);
            if (!this.boolExpanded) {
                n7 = rectangle.x + 6 + 4;
                n6 = rectangle.y + (rectangle.height - 8) / 2 + 2;
                n4 = 4;
                graphics.drawLine(n7, n6, n7, n6 + n4);
            }
        }
        n7 = rectangle.x + 12 + 8;
        n6 = rectangle.y + (rectangle.height - this.nHeightImage) / 2;
        Image image = this.boolCurrent ? this.imageTreeElementCur : this.imageTreeElement;
        if (image != null) {
            graphics.drawImage(image, n7, n6, colorBg, this.componentOwner);
        }
        if (this.nWidthImage < 0 || this.nHeightImage < 0) {
            this.nWidthImage = image.getWidth(this.componentOwner);
            this.nHeightImage = image.getHeight(this.componentOwner);
        }
        n7 = rectangle.x + 18 + 8 + this.nWidthImage - 3;
        n6 = rectangle.y + 2;
        n5 = fontMetrics.stringWidth(this.strName) + 6;
        n4 = rectangle.height - 3;
        if (this.boolCurrent) {
            graphics.setColor(colorCurBg);
            graphics.fillRect(n7, n6, n5, n4);
            graphics.setColor(colorCurFg);
        } else {
            graphics.setColor(colorFg);
        }
        if (this.boolCurrent && this.hasOwnerFocus()) {
            this.drawDottedRectangle(graphics, n7, n6, n5, n4);
        }
        n4 = fontMetrics.getAscent();
        n7 = rectangle.x + 18 + 8 + this.nWidthImage;
        n6 = rectangle.y + (rectangle.height - n4) / 2 + n4;
        graphics.drawString(this.strName, n7, n6);
    }

    public void drawDottedRectangle(Graphics graphics, int n2, int n3, int n4, int n5) {
        this.drawDottedLine(graphics, n2, n3, n2 + n4 - 1, n3);
        this.drawDottedLine(graphics, n2 + n4 - 1, n3, n2 + n4 - 1, n3 + n5 - 1);
        this.drawDottedLine(graphics, n2 + n4 - 1, n3 + n5 - 1, n2, n3 + n5 - 1);
        this.drawDottedLine(graphics, n2, n3 + n5 - 1, n2, n3);
    }

    public void drawDottedLine(Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        if (n2 == n4 && n3 == n5) {
            this.drawDot(graphics, n2, n3);
            return;
        }
        if (n2 > n4) {
            n7 = n2;
            n2 = n4;
            n4 = n7;
        }
        if (n3 > n5) {
            n6 = n3;
            n3 = n5;
            n5 = n6;
        }
        if (n4 - n2 > n5 - n3) {
            double d2 = (double)(n5 - n3) / (double)(n4 - n2);
            n7 = n2;
            while (n7 <= n4) {
                n6 = (int)Math.rint((double)n3 + (double)(n7 - n2) * d2);
                this.drawDot(graphics, n7, n6);
                ++n7;
            }
        } else {
            double d3 = (n4 - n2) / (n5 - n3);
            n6 = n3;
            while (n6 <= n5) {
                n7 = (int)Math.rint((double)n2 + (double)(n6 - n3) * d3);
                this.drawDot(graphics, n7, n6);
                ++n6;
            }
        }
    }

    public void drawDot(Graphics graphics, int n2, int n3) {
        if ((n2 + n3) % 2 == 0) {
            graphics.drawLine(n2, n3, n2, n3);
        }
    }

    public void computeImageSize() {
        if (!this.boolCurrent && this.imageTreeElement != null) {
            this.nWidthImage = this.imageTreeElement.getWidth(this.componentOwner);
            this.nHeightImage = this.imageTreeElement.getHeight(this.componentOwner);
        } else if (this.boolCurrent && this.imageTreeElementCur != null) {
            this.nWidthImage = this.imageTreeElementCur.getWidth(this.componentOwner);
            this.nHeightImage = this.imageTreeElementCur.getHeight(this.componentOwner);
        } else {
            this.nWidthImage = 0;
            this.nHeightImage = 0;
        }
    }

    public Rectangle recomputeLayout(Rectangle rectangle, FontMetrics fontMetrics) {
        this.computeImageSize();
        this.rectElement.x = rectangle.x;
        this.rectElement.y = rectangle.y;
        if (this.boolVisible) {
            this.rectElement.height = Math.max(fontMetrics.getHeight(), 12);
            this.rectElement.height = Math.max(this.rectElement.height, this.nHeightImage + 4);
            this.rectElement.width = 8 + this.nWidthImage + fontMetrics.stringWidth(this.strName) + 24;
        } else {
            this.rectElement.height = 0;
            this.rectElement.width = 0;
        }
        this.rectElementFull.setBounds(this.rectElement);
        if (this.boolExpanded) {
            int n2 = this.boolVisible ? 10 + this.nWidthImage / 2 : 0;
            int n3 = this.rectElement.height;
            Rectangle rectangle2 = new Rectangle(rectangle);
            rectangle2.x += n2;
            rectangle2.y += n3;
            int n4 = this.getImmediateSubElementsCount();
            int n5 = 0;
            while (n5 < n4) {
                TreeNode treeNode = this.getSubElement(n5);
                rectangle2 = treeNode.recomputeLayout(rectangle2, fontMetrics);
                this.rectElementFull.height += rectangle2.height;
                rectangle2.y += rectangle2.height;
                if (this.rectElementFull.width < n2 + rectangle2.width) {
                    this.rectElementFull.width = n2 + rectangle2.width;
                }
                ++n5;
            }
        }
        return new Rectangle(this.rectElementFull);
    }

    public void addToTreeElList(Vector vector) {
        if (this.boolVisible) {
            vector.addElement(this);
        }
        if (!this.boolExpanded) {
            return;
        }
        int n2 = this.getImmediateSubElementsCount();
        int n3 = 0;
        while (n3 < n2) {
            TreeNode treeNode = this.getSubElement(n3);
            treeNode.addToTreeElList(vector);
            ++n3;
        }
    }

    private boolean hasOwnerFocus() {
        boolean bl = false;
        if (this.componentOwner == null) {
            return false;
        }
        Component component = this.componentOwner;
        while (component != null) {
            if (component instanceof Window) {
                bl = ((Window)component).getFocusOwner() == this.componentOwner;
                break;
            }
            component = component.getParent();
        }
        return bl;
    }

    private void fireActionEvent(ActionEvent actionEvent) {
        int n2 = this.vectorActionListeners.size();
        int n3 = 0;
        while (n3 < n2) {
            ActionListener actionListener = (ActionListener)this.vectorActionListeners.elementAt(n3);
            actionListener.actionPerformed(actionEvent);
            ++n3;
        }
    }
}

