/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32;

import com.jniwrapper.Function;
import com.jniwrapper.IntBool;
import com.jniwrapper.NativeResourceCollector;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.ShortInt;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.IntPtr;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.MessageLoopListener;
import com.jniwrapper.win32.Msg;
import com.jniwrapper.win32.system.EventObject;
import com.jniwrapper.win32.system.Kernel32;
import com.jniwrapper.win32.ui.User32;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MessageLoopThread {
    protected static final Logger _log = Logger.getInstance((Class)(class$com$jniwrapper$win32$MessageLoopThread == null ? (class$com$jniwrapper$win32$MessageLoopThread = MessageLoopThread.class$("com.jniwrapper.win32.MessageLoopThread")) : class$com$jniwrapper$win32$MessageLoopThread));
    private static final FunctionName FUNCTION_GetMessage = new FunctionName("GetMessage");
    private static final FunctionName FUNCTION_PeekMessage = new FunctionName("PeekMessage");
    private static final String FUNCTION_TranslateMessage = "TranslateMessage";
    private static final FunctionName FUNCTION_DispatchMessage = new FunctionName("DispatchMessage");
    private static final FunctionName FUNCTION_PostThreadMessage = new FunctionName("PostThreadMessage");
    private static final String FUNCTION_GetCurrentThreadId = "GetCurrentThreadId";
    private static final int PM_NOREMOVE = 0;
    private static int _threadIndex = 1;
    private static Function _getMessageFunction;
    private static Function _peekMessageFunction;
    private static Function _translateMessage;
    private static Function _dispatchMessage;
    private static Function _postThreadMessageFunction;
    private static Function _getCurrentThreadId;
    private String _name;
    private boolean _daemon = true;
    private boolean _processing;
    private boolean _isRunning;
    private List _actionsQueue = Collections.synchronizedList(new LinkedList());
    private List _messageListeners = new LinkedList();
    private LoopThread _messageLoopThread;
    private static Map _messageLoops;
    static /* synthetic */ Class class$com$jniwrapper$win32$MessageLoopThread;

    public MessageLoopThread() {
        this("Main message loop");
    }

    public MessageLoopThread(String name) {
        this._name = name;
    }

    public MessageLoopThread(boolean daemon) {
        this._name = "Main message loop";
        this._daemon = daemon;
    }

    private void put(MessageLoopThread loop, Thread thread) {
        _messageLoops.put(thread, loop);
    }

    protected static Map getMessageLoops() {
        return _messageLoops;
    }

    public synchronized void doStart() {
        if (this._messageLoopThread == null) {
            this._messageLoopThread = new LoopThread(this._name, this._daemon);
            this.put(this, this._messageLoopThread);
        }
        if (this._messageLoopThread.isAlive()) {
            return;
        }
        this._messageLoopThread.start();
        this._isRunning = this._messageLoopThread.isAlive();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        NativeResourceCollector.getInstance().addShutdownAction(new Runnable(){

            public void run() {
                MessageLoopThread.this.doStop();
            }
        });
    }

    public synchronized void doStop() {
        if (this._messageLoopThread == null) {
            return;
        }
        this._isRunning = false;
        try {
            this._messageLoopThread.stopThread();
            this._messageLoopThread.join();
            this._messageLoopThread = null;
            this.put(this, null);
        }
        catch (InterruptedException e) {
            _log.error((Object)"", (Throwable)e);
            this._isRunning = this._messageLoopThread.isAlive();
        }
    }

    public boolean isStarted() {
        return this._isRunning;
    }

    public synchronized boolean isDispatchThread() {
        return Thread.currentThread() == this._messageLoopThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInvokeAndWait(Runnable action) throws InterruptedException, InvocationTargetException {
        ThreadSynchronizedAction synchronizedAction;
        this.checkRunning();
        if (this.isDispatchThread()) {
            try {
                action.run();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        boolean[] lock = new boolean[1];
        if (action instanceof MethodInvocationAction) {
            synchronizedAction = (ThreadSynchronizedAction)action;
            synchronizedAction._lock = lock;
        } else {
            synchronizedAction = new ThreadSynchronizedAction(lock, action);
        }
        boolean[] blArray = lock;
        synchronized (lock) {
            this._actionsQueue.add(synchronizedAction);
            this.pingMessageLoopThread();
            int cycleCount = 0;
            while (!lock[0]) {
                lock.wait(0L, 1);
                if (++cycleCount % 100 != 0) continue;
                this.pingMessageLoopThread();
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            Exception exception = synchronizedAction.getException();
            if (exception != null) {
                throw new InvocationTargetException(exception);
            }
            return;
        }
    }

    protected synchronized void pingMessageLoopThread() {
        if (this._messageLoopThread != null) {
            this._messageLoopThread.pingThread();
        }
    }

    public void doInvokeLater(Runnable action) {
        this.checkRunning();
        ThreadAction threadAction = new ThreadAction(action);
        this._actionsQueue.add(threadAction);
        if (!this._processing) {
            this.pingMessageLoopThread();
        }
    }

    private void checkRunning() {
        if (!this._isRunning) {
            throw new IllegalStateException(this._name + " thread is already stopped.");
        }
    }

    public Object doInvokeMethod(Object object, String methodName) throws InterruptedException, InvocationTargetException {
        return this.doInvokeMethod(object, methodName, null);
    }

    public Object doInvokeMethod(Object object, String methodName, Object[] parameters) throws InterruptedException, InvocationTargetException {
        MethodInvocationAction action = new MethodInvocationAction(object, methodName, parameters);
        this.doInvokeAndWait(action);
        return action.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAddMessageListener(MessageLoopListener listener) {
        List list = this._messageListeners;
        synchronized (list) {
            if (!this._messageListeners.contains(listener)) {
                this._messageListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveMessageListener(MessageLoopListener listener) {
        List list = this._messageListeners;
        synchronized (list) {
            this._messageListeners.remove(listener);
        }
    }

    protected synchronized void postSyncThreadMessage(int message, int wParam, int lParam) {
        this.postSyncThreadMessage(message, (long)wParam, (long)lParam);
    }

    protected synchronized void postSyncThreadMessage(int message, long wParam, long lParam) {
        if (this._messageLoopThread != null) {
            this._messageLoopThread.postThreadMessage(message, wParam, lParam);
        }
    }

    protected void onStart() {
    }

    protected void onStop() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        User32 user32 = User32.getInstance();
        _peekMessageFunction = user32.getFunction(FUNCTION_PeekMessage.toString());
        _getMessageFunction = user32.getFunction(FUNCTION_GetMessage.toString());
        _translateMessage = user32.getFunction(FUNCTION_TranslateMessage);
        _dispatchMessage = user32.getFunction(FUNCTION_DispatchMessage.toString());
        _postThreadMessageFunction = user32.getFunction(FUNCTION_PostThreadMessage.toString());
        _getCurrentThreadId = Kernel32.getInstance().getFunction(FUNCTION_GetCurrentThreadId);
        _messageLoops = new HashMap();
    }

    private static class MethodInvocationAction
    extends ThreadSynchronizedAction {
        private Object _object;
        private Method _method;
        private Object[] _parameters;
        private Object _result;

        MethodInvocationAction(Object object, String methodName, Object[] parameters) {
            block4: {
                Class[] argumentClasses;
                super(null, null);
                this._object = object;
                this._parameters = parameters == null ? new Object[]{} : parameters;
                Class[] classArray = argumentClasses = parameters == null ? null : new Class[this._parameters.length];
                if (argumentClasses != null) {
                    for (int i = 0; i < this._parameters.length; ++i) {
                        argumentClasses[i] = this._parameters[i].getClass();
                    }
                }
                try {
                    this._method = object.getClass().getMethod(methodName, argumentClasses);
                }
                catch (Exception e) {
                    this._exception = e;
                    this._method = this.findMethod(object, methodName, argumentClasses);
                    if (this._method == null) break block4;
                    this._exception = null;
                }
            }
        }

        private Method findMethod(Object object, String methodName, Class[] argumentClasses) {
            Method[] methods = object.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals(methodName)) continue;
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (argumentClasses == null || parameterTypes.length != argumentClasses.length) continue;
                boolean parametersMatched = true;
                for (int j = 0; j < parameterTypes.length; ++j) {
                    if (parameterTypes[j].isAssignableFrom(argumentClasses[j])) continue;
                    parametersMatched = false;
                    break;
                }
                if (!parametersMatched) continue;
                return method;
            }
            return null;
        }

        public void run() {
            if (this._exception != null) {
                return;
            }
            try {
                this._method.setAccessible(true);
                this._result = this._method.invoke(this._object, this._parameters);
            }
            catch (Exception e) {
                this._exception = e;
            }
        }

        public Object getResult() {
            return this._result;
        }
    }

    private static class ThreadSynchronizedAction
    extends ThreadAction {
        protected Exception _exception;
        protected Object _lock;

        ThreadSynchronizedAction(Object lock, Runnable action) {
            super(action);
            this._lock = lock;
        }

        public void run() {
            try {
                this._action.run();
            }
            catch (Exception e) {
                this._exception = e;
            }
        }

        public Exception getException() {
            return this._exception;
        }
    }

    private static class ThreadAction
    implements Runnable {
        protected Runnable _action;

        ThreadAction(Runnable action) {
            this._action = action;
        }

        public void run() {
            this._action.run();
        }
    }

    private class LoopThread
    extends Thread {
        private EventObject _messageQueueIsReady;
        private long _threadID;
        private boolean _running;

        LoopThread() {
            this((class$com$jniwrapper$win32$MessageLoopThread == null ? (class$com$jniwrapper$win32$MessageLoopThread = MessageLoopThread.class$("com.jniwrapper.win32.MessageLoopThread")) : class$com$jniwrapper$win32$MessageLoopThread).getName(), true);
        }

        LoopThread(String name, boolean daemon) {
            this.setName(name);
            this.setPriority(5);
            this.setDaemon(daemon);
            this._messageQueueIsReady = new EventObject("MessageQueueIsReady." + _threadIndex++);
        }

        public void postThreadMessage(int message, int wParam, int lParam) {
            this.postThreadMessage(message, (long)wParam, (long)lParam);
        }

        public void postThreadMessage(int message, long wParam, long lParam) {
            this._messageQueueIsReady.waitFor();
            IntBool result = new IntBool();
            long errorCode = _postThreadMessageFunction.invoke((Parameter)result, new Parameter[]{new UInt32(this._threadID), new UInt((long)message), new IntPtr(wParam), new IntPtr(lParam)});
            if (result.getValue() == 0L) {
                _log.error((Object)("Failed to post the message to the thread. ThreadID = " + this._threadID + ", errorCode = " + errorCode), (Throwable)new LastErrorException(errorCode));
            }
        }

        public long getThreadID() {
            return this._threadID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean notifyListeners(Msg msg) {
            boolean isProcessed = false;
            List list = MessageLoopThread.this._messageListeners;
            synchronized (list) {
                Iterator i = MessageLoopThread.this._messageListeners.iterator();
                while (i.hasNext()) {
                    MessageLoopListener listener = (MessageLoopListener)i.next();
                    if (!listener.onMessage(msg)) continue;
                    isProcessed = true;
                }
            }
            return isProcessed;
        }

        public void stopThread() {
            this._running = false;
            MessageLoopThread.this.pingMessageLoopThread();
        }

        void pingThread() {
            MessageLoopThread.this.postSyncThreadMessage(1024, 0, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            _log.debug((Object)"MessageLoopThread.run()");
            MessageLoopThread.this.onStart();
            UInt32 threadID = new UInt32();
            _getCurrentThreadId.invoke((Parameter)threadID);
            this._threadID = threadID.getValue();
            _log.debug((Object)("MessageLoopThread.run(): got threadID = " + this._threadID));
            Handle wnd = new Handle();
            ShortInt result = new ShortInt();
            Msg msg = new Msg();
            Pointer msgPointer = new Pointer((Parameter)msg);
            UInt32 nullValue = new UInt32();
            _peekMessageFunction.invoke((Parameter)result, new Parameter[]{msgPointer, wnd, new UInt32(1024L), new UInt32(1024L), new UInt32(0L)});
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                _log.error((Object)"", (Throwable)e);
            }
            this._messageQueueIsReady.notifyEvent();
            _log.debug((Object)"MessageLoopThread.run(), messageQueueIsReady");
            result.setValue(1L);
            this._running = true;
            while (this._running && result.getValue() != 0L) {
                MessageLoopThread.this._processing = false;
                _getMessageFunction.invoke((Parameter)result, (Parameter)msgPointer, (Parameter)wnd, (Parameter)nullValue, (Parameter)nullValue);
                if (result.getValue() == -1L) break;
                boolean isProcessed = this.notifyListeners(msg);
                if (!isProcessed) {
                    _translateMessage.invoke(null, (Parameter)msgPointer);
                    _dispatchMessage.invoke(null, (Parameter)msgPointer);
                }
                MessageLoopThread.this._processing = true;
                while (!MessageLoopThread.this._actionsQueue.isEmpty()) {
                    ThreadAction action = (ThreadAction)MessageLoopThread.this._actionsQueue.remove(0);
                    if (action instanceof ThreadSynchronizedAction) {
                        ThreadSynchronizedAction synchronizedAction = (ThreadSynchronizedAction)action;
                        Object object = synchronizedAction._lock;
                        synchronized (object) {
                            try {
                                synchronizedAction.run();
                            }
                            finally {
                                ((boolean[])synchronizedAction._lock)[0] = true;
                                synchronizedAction._lock.notify();
                            }
                            continue;
                        }
                    }
                    try {
                        action.run();
                    }
                    catch (Exception e) {
                        _log.error((Object)"Failed to execute an asynchronous action in the MessageLoopThread.", (Throwable)e);
                    }
                }
            }
            this._messageQueueIsReady.close();
            MessageLoopThread.this.onStop();
        }
    }
}

