/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.IntBool;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.WinFunctionCache;
import com.jniwrapper.win32.process.Process;
import com.jniwrapper.win32.system.VersionInfo;
import java.io.File;

public class Kernel32
extends WinFunctionCache {
    private static final String FUNCTION_MultiByteToWideChar = "MultiByteToWideChar";
    private static final String FUNCTION_lstrlen = "lstrlen";
    private static final String FUNCTION_MulDiv = "MulDiv";
    private static final String FUNCTION_GetCurrentThreadId = "GetCurrentThreadId";
    private static final String FUNCTION_GetCurrentProcessId = "GetCurrentProcessId";
    private static final String FUNCTION_ProcessIdToSessionId = "ProcessIdToSessionId";
    private static final String FUNCTION_GetProcessId = "GetProcessId";
    private static final FunctionName FUNCTION_GetWindowsDirectory = new FunctionName("GetWindowsDirectory");
    private static final FunctionName FUNCTION_GetSystemDirectory = new FunctionName("GetSystemDirectory");
    private static final FunctionName FUNCTION_GlobalAddAtom = new FunctionName("GlobalAddAtom");
    private static final FunctionName FUNCTION_GET_CURRENT_DIRECTORY = new FunctionName("GetCurrentDirectory");
    private static final FunctionName FUNCTION_SET_CURRENT_DIRECTORY = new FunctionName("SetCurrentDirectory");
    private boolean _encodingSpecified;
    private static Kernel32 _instance;

    private Kernel32() {
        super("kernel32");
    }

    protected void setupEncoding() {
    }

    public boolean isUnicode() {
        if (!this._encodingSpecified) {
            VersionInfo verInfo = new VersionInfo();
            this.setUnicode(verInfo.isNT());
            this._encodingSpecified = true;
        }
        return super.isUnicode();
    }

    public void setUnicode(boolean unicode) {
        this._encodingSpecified = true;
        super.setUnicode(unicode);
    }

    public static Kernel32 getInstance() {
        if (_instance == null) {
            _instance = new Kernel32();
        }
        return _instance;
    }

    public static int multiByteToWideChar(int codePage, int dwFlags, Pointer.Void srcStr, int srcLen, Pointer.Void destStr, int destLen) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_MultiByteToWideChar);
        Int result = new Int();
        function.invoke((Parameter)result, new Parameter[]{new UInt((long)codePage), new UInt32((long)dwFlags), srcStr, new Int((long)srcLen), destStr, new Int((long)destLen)});
        return (int)result.getValue();
    }

    public static int lstrlen(Pointer.Void lpStr) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_lstrlen);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)lpStr);
        return (int)result.getValue();
    }

    public static int mulDiv(int number, int numerator, int denominator) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_MulDiv);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)new Int((long)number), (Parameter)new Int((long)numerator), (Parameter)new Int((long)denominator));
        return (int)result.getValue();
    }

    public static int getCurrentThreadId() {
        UInt32 result = new UInt32();
        Function getCurrentThreadID = Kernel32.getInstance().getFunction(FUNCTION_GetCurrentThreadId);
        getCurrentThreadID.invoke((Parameter)result);
        return (int)result.getValue();
    }

    public static int getCurrentProcessId() {
        UInt32 result = new UInt32();
        Function getCurrentProcessID = Kernel32.getInstance().getFunction(FUNCTION_GetCurrentProcessId);
        getCurrentProcessID.invoke((Parameter)result);
        return (int)result.getValue();
    }

    public static String getWindowsDirectory() {
        Str lpBuffer = new Str();
        UInt32 uSize = new UInt32((long)lpBuffer.getMaxLength());
        UInt32 res = new UInt32();
        Function getWindowsDirectory = Kernel32.getInstance().getFunction(FUNCTION_GetWindowsDirectory.toString());
        getWindowsDirectory.invoke((Parameter)res, (Parameter)new Pointer((Parameter)lpBuffer), (Parameter)uSize);
        if (res.getValue() != 0L && res.getValue() <= 256L) {
            return lpBuffer.getValue().endsWith("\\") ? lpBuffer.getValue() : lpBuffer.getValue() + "\\";
        }
        return null;
    }

    public static String getSystemDirectory() {
        Str lpBuffer = new Str();
        UInt32 uSize = new UInt32((long)lpBuffer.getMaxLength());
        UInt32 res = new UInt32();
        Function getWindowsDirectory = Kernel32.getInstance().getFunction(FUNCTION_GetSystemDirectory.toString());
        getWindowsDirectory.invoke((Parameter)res, (Parameter)new Pointer((Parameter)lpBuffer), (Parameter)uSize);
        if (res.getValue() != 0L && res.getValue() <= 256L) {
            return lpBuffer.getValue().endsWith("\\") ? lpBuffer.getValue() : lpBuffer.getValue() + "\\";
        }
        return null;
    }

    public static int globalAddAtom(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null.");
        }
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GlobalAddAtom.toString());
        UInt16 atom = new UInt16();
        long errorCode = function.invoke((Parameter)atom, (Parameter)new Str(value));
        if (atom.getValue() == 0L) {
            throw new LastErrorException(errorCode);
        }
        return (int)atom.getValue();
    }

    public static String getCurrentDirectory() {
        int MAX_PATH = 255;
        Function getCurrentDirectory = Kernel32.getInstance().getFunction(FUNCTION_GET_CURRENT_DIRECTORY.toString());
        Str currentDirectory = new Str(255);
        UInt32 res = new UInt32();
        getCurrentDirectory.invoke((Parameter)res, (Parameter)new UInt32((long)currentDirectory.getLength()), (Parameter)new Pointer((Parameter)currentDirectory));
        if (res.getValue() == 0L) {
            currentDirectory.setValue("");
        } else if (res.getValue() >= 255L) {
            currentDirectory = new Str((int)res.getValue());
            getCurrentDirectory.invoke((Parameter)res, (Parameter)new UInt32((long)currentDirectory.getLength()), (Parameter)new Pointer((Parameter)currentDirectory));
            if (res.getValue() == 0L) {
                currentDirectory.setValue("");
            }
        }
        return currentDirectory.getValue();
    }

    public static void setCurrentDirectory(String directory) {
        if (directory == null || !new File(directory).isDirectory()) {
            throw new IllegalArgumentException("The specified directory is invalid.");
        }
        Function setCurrentDirectory = Kernel32.getInstance().getFunction(FUNCTION_SET_CURRENT_DIRECTORY.toString());
        setCurrentDirectory.invoke((Parameter)new IntBool(), (Parameter)new Str(directory));
    }

    public static long getProcessId(Process process) {
        UInt32 processId = new UInt32();
        Function getProcessId = Kernel32.getInstance().getFunction(FUNCTION_GetProcessId);
        long errorCode = getProcessId.invoke((Parameter)processId, (Parameter)process);
        if (processId.getValue() == 0L) {
            throw new LastErrorException(errorCode);
        }
        return processId.getValue();
    }

    public static long processIdToSessionId(UInt32 processId) {
        Handle result = new Handle();
        UInt32 sessionId = new UInt32();
        Function processIdToSessionId = Kernel32.getInstance().getFunction(FUNCTION_ProcessIdToSessionId);
        long errorCode = processIdToSessionId.invoke((Parameter)result, (Parameter)processId, (Parameter)new Pointer((Parameter)sessionId));
        if (result.getValue() == 0L) {
            throw new LastErrorException(errorCode);
        }
        return sessionId.getValue();
    }
}

