/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.protocol.sunvideoplus.OPICapture;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;

public class SunVideoPlusAuto {
    private static String DEVICE_PREFIX = "/dev/o1k";
    private static String PROTOCOL = "sunvideoplus";
    private static String LOCATOR_PREFIX = PROTOCOL + "://";
    private static boolean DO_PAL = false;
    int currentID = -1;

    public SunVideoPlusAuto() {
        Vector vector = (Vector)CaptureDeviceManager.getDeviceList(null).clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CaptureDeviceInfo captureDeviceInfo = (CaptureDeviceInfo)enumeration.nextElement();
            String string = captureDeviceInfo.getLocator().getProtocol();
            if (!string.equals(PROTOCOL)) continue;
            CaptureDeviceManager.removeDevice(captureDeviceInfo);
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < 10) {
            File file = new File(DEVICE_PREFIX + n3);
            if (file.exists()) {
                if (DO_PAL) {
                    this.generalDevice(n3, "PAL");
                    System.gc();
                    this.generalDevice(n3, "NTSC");
                } else {
                    this.generalDevice(n3, null);
                }
                ++n2;
            }
            ++n3;
        }
        try {
            CaptureDeviceManager.commit();
            System.err.println("SunVideoPlusAuto: Committed ok");
        }
        catch (IOException iOException) {
            System.err.println("SunVideoPlusAuto: error committing cdm");
        }
    }

    protected void generalDevice(int n2, String string) {
        DataSource dataSource = null;
        String string2 = LOCATOR_PREFIX + n2;
        if (string != null) {
            string2 = string2 + "////" + string.toLowerCase();
        }
        try {
            dataSource = Manager.createDataSource(new MediaLocator(string2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dataSource != null && dataSource instanceof com.sun.media.protocol.sunvideoplus.DataSource) {
            CaptureDeviceInfo captureDeviceInfo = ((CaptureDevice)((Object)dataSource)).getCaptureDeviceInfo();
            if (captureDeviceInfo != null) {
                String string3 = captureDeviceInfo.getName();
                if (string == null) {
                    CaptureDeviceManager.addDevice(captureDeviceInfo);
                } else {
                    string3 = captureDeviceInfo.getName() + " (" + string + ")";
                    CaptureDeviceManager.addDevice(new CaptureDeviceInfo(string3, captureDeviceInfo.getLocator(), captureDeviceInfo.getFormats()));
                }
                System.err.println("CaptureDeviceInfo = " + string3 + " " + captureDeviceInfo.getLocator());
            }
            dataSource.disconnect();
        }
    }

    protected void doDevice(int n2) {
        this.currentID = n2;
        FormatSetup formatSetup = new FormatSetup(this.currentID);
        Vector vector = formatSetup.getDeviceInfo();
        if (vector != null && vector.size() > 0) {
            int n3 = 0;
            while (n3 < vector.size()) {
                CaptureDeviceInfo captureDeviceInfo = (CaptureDeviceInfo)vector.elementAt(n3);
                System.err.println("CaptureDeviceInfo = " + captureDeviceInfo.getName());
                ++n3;
            }
        }
    }

    public static void setPALSignal(boolean bl) {
        DO_PAL = bl;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            if (stringArray.length > 1) {
                System.err.println("Usage: java SunVideoPlusAuto [ ntsc | pal ]");
                System.exit(1);
            }
            if (stringArray[0].equalsIgnoreCase("ntsc")) {
                SunVideoPlusAuto.setPALSignal(false);
            } else if (stringArray[0].equalsIgnoreCase("pal")) {
                SunVideoPlusAuto.setPALSignal(true);
            } else {
                System.err.println("Usage: java SunVideoPlusAuto [ ntsc | pal ]");
                System.exit(1);
            }
        }
        SunVideoPlusAuto sunVideoPlusAuto = new SunVideoPlusAuto();
        System.exit(0);
    }

    class FormatSetup {
        int id;
        boolean fullVideo = false;
        boolean anyVideo = true;
        String sAnalog;
        String sPort;
        String sVideoFormat;
        String sSize;
        Hashtable videoFormats = new Hashtable();
        OPICapture opiVidCap = null;

        public FormatSetup(int n2) {
            this.id = n2;
            this.opiVidCap = new OPICapture(null);
            if (!this.opiVidCap.connect(n2)) {
                throw new Error("Unable to connect to device");
            }
        }

        private void addVideoFormat(Format format) {
            String string = this.sPort + "/" + this.sVideoFormat + "/" + this.sSize + "/" + this.sAnalog;
            System.err.println("New format " + string + " = " + format);
            this.videoFormats.put(string, format);
        }

        public void mydispose() {
            this.opiVidCap.disconnect();
            System.err.println("Disconnected driver");
        }

        public void doFormat() {
            if (this.anyVideo) {
                this.doVideoFormats();
            }
        }

        public void doVideoFormats() {
            if (!this.anyVideo) {
                this.videoFormats.put("off", new VideoFormat("rgb"));
            }
            this.sAnalog = "ntsc";
            if (DO_PAL) {
                this.sAnalog = "pal";
            }
            if (!this.opiVidCap.setSignal(this.sAnalog)) {
                System.err.println("Video analog signal not recognized");
                return;
            }
            int n2 = 1;
            if (!this.opiVidCap.setPort(n2)) {
                System.err.println("Video source not recognized on port");
                return;
            }
            this.sPort = "" + n2;
            this.opiVidCap.setScale(2);
            this.sSize = "cif";
            this.getVideoFormats();
        }

        private void getVideoFormats() {
            this.sVideoFormat = "h261";
            this.getH261Format();
            this.sVideoFormat = "h263";
            this.getH263Format();
            this.sVideoFormat = "jpeg";
            this.getJpegFormat();
            this.sVideoFormat = "rgb";
            this.getRGBFormat();
            this.sVideoFormat = "yuv";
            this.getYUVFormat();
        }

        private void getRGBFormat() {
            if (!this.opiVidCap.setCompress("RGB")) {
                return;
            }
            Dimension dimension = new Dimension(this.opiVidCap.getWidth(), this.opiVidCap.getHeight());
            this.addVideoFormat(new RGBFormat(dimension, -1, Format.byteArray, -1.0f, 16, 63488, 2016, 31, 2, -1, 0, -1));
        }

        private void getYUVFormat() {
            if (!this.opiVidCap.setCompress("YUV")) {
                return;
            }
            Dimension dimension = new Dimension(this.opiVidCap.getWidth(), this.opiVidCap.getHeight());
            this.addVideoFormat(new YUVFormat(dimension, -1, Format.byteArray, -1.0f, 32, -1, -1, 0, 3, 1));
        }

        private void getJpegFormat() {
            if (!this.opiVidCap.setCompress("Jpeg")) {
                return;
            }
            Dimension dimension = new Dimension(this.opiVidCap.getWidth(), this.opiVidCap.getHeight());
            this.addVideoFormat(new VideoFormat("jpeg", dimension, -1, Format.byteArray, -1.0f));
        }

        private void getH261Format() {
            if (!this.opiVidCap.setCompress("H261")) {
                return;
            }
            Dimension dimension = new Dimension(this.opiVidCap.getWidth(), this.opiVidCap.getHeight());
            this.addVideoFormat(new VideoFormat("h261", dimension, -1, Format.byteArray, -1.0f));
        }

        private void getH263Format() {
            if (!this.opiVidCap.setCompress("H263")) {
                return;
            }
            Dimension dimension = new Dimension(this.opiVidCap.getWidth(), this.opiVidCap.getHeight());
            this.addVideoFormat(new VideoFormat("h263", dimension, -1, Format.byteArray, -1.0f));
        }

        public void issueError(String string) {
            System.err.println(string);
            Toolkit.getDefaultToolkit().beep();
        }

        public Enumeration sortedFormats(Hashtable hashtable) {
            Vector<String> vector = new Vector<String>();
            Enumeration enumeration = hashtable.keys();
            block0: while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                int n2 = 0;
                while (n2 < vector.size()) {
                    if (string.compareTo((String)vector.elementAt(n2)) < 0) {
                        vector.insertElementAt(string, n2);
                        continue block0;
                    }
                    ++n2;
                }
                vector.addElement(string);
            }
            return vector.elements();
        }

        public Vector getDeviceInfo() {
            this.doFormat();
            this.mydispose();
            String string = LOCATOR_PREFIX + this.id;
            Vector<CaptureDeviceInfo> vector = new Vector<CaptureDeviceInfo>();
            if (this.anyVideo) {
                Enumeration enumeration = this.sortedFormats(this.videoFormats);
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    VideoFormat videoFormat = (VideoFormat)this.videoFormats.get(string2);
                    Format[] formatArray = null;
                    formatArray = new Format[]{videoFormat};
                    String string3 = string + "/" + string2;
                    CaptureDeviceInfo captureDeviceInfo = new CaptureDeviceInfo(string3, new MediaLocator(string3), formatArray);
                    CaptureDeviceManager.addDevice(captureDeviceInfo);
                    vector.addElement(captureDeviceInfo);
                }
            }
            return vector;
        }
    }
}

