/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.protocol.sunvideoplus.OPICapture;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class SunVideoPlusManual
extends Frame {
    private static String DEVICE_PREFIX = "/dev/o1k";
    CaptureDeviceInfo[] devices = null;
    int currentID = -1;

    public SunVideoPlusManual() {
        super("SunVideoPlus");
        Serializable serializable;
        Font font = new Font("Dialog", 3, 12);
        this.setLayout(new BorderLayout());
        BorderPanel borderPanel = new BorderPanel();
        borderPanel.setLayout(new BorderLayout(0, 0));
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0));
        Label label = new Label("Configure Capture Devices");
        label.setFont(font);
        panel.add(label);
        borderPanel.add("North", panel);
        panel = new Panel();
        panel.setLayout(new FlowLayout());
        int n2 = 0;
        int n3 = 0;
        while (n3 < 10) {
            serializable = new File(DEVICE_PREFIX + n3);
            if (((File)serializable).exists()) {
                Button button = new Button(DEVICE_PREFIX + n3);
                panel.add(button);
                button.addActionListener(new DBListener(n3));
                ++n2;
            }
            ++n3;
        }
        borderPanel.add("Center", panel);
        this.add("North", borderPanel);
        this.devices = new CaptureDeviceInfo[n2];
        panel = new Panel();
        panel.setLayout(new FlowLayout());
        serializable = new Button("Done");
        ((Button)serializable).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SunVideoPlusManual.this.currentID != -1) {
                    System.err.println("Need to close other window first");
                    return;
                }
                SunVideoPlusManual.this.dispose();
                System.exit(0);
            }
        });
        panel.add((Component)serializable);
        this.add("South", panel);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (SunVideoPlusManual.this.currentID != -1) {
                    System.err.println("Need to close other window first");
                    return;
                }
                SunVideoPlusManual.this.dispose();
                System.exit(0);
            }
        });
    }

    public void createDialog(int n2) {
        if (this.currentID == n2) {
            return;
        }
        this.currentID = n2;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                FormatsDialog formatsDialog = new FormatsDialog(SunVideoPlusManual.this.currentID);
                ((Component)formatsDialog).setVisible(true);
                Vector vector = formatsDialog.getDeviceInfo();
                if (vector != null && vector.size() > 0) {
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        CaptureDeviceInfo captureDeviceInfo = (CaptureDeviceInfo)vector.elementAt(n2);
                        System.err.println("CaptureDeviceInfo = " + captureDeviceInfo.getName());
                        ++n2;
                    }
                }
                SunVideoPlusManual.this.currentID = -1;
            }
        });
        thread.start();
    }

    public static void main(String[] stringArray) {
        SunVideoPlusManual sunVideoPlusManual = new SunVideoPlusManual();
        ((Component)sunVideoPlusManual).setVisible(true);
    }

    class BorderPanel
    extends Panel {
        int insets = 7;

        public BorderPanel() {
        }

        public BorderPanel(int n2) {
            this.insets = n2;
        }

        public Insets getInsets() {
            return new Insets(this.insets, this.insets, this.insets, this.insets);
        }

        public void paint(Graphics graphics) {
            if (this.insets != 0) {
                Color color = this.getBackground();
                super.paint(graphics);
                Dimension dimension = this.getSize();
                graphics.setColor(color.darker());
                graphics.drawLine(2, 2, dimension.width - 3, 2);
                graphics.drawLine(2, 2, 2, dimension.height - 3);
                graphics.setColor(color.brighter());
                graphics.drawLine(dimension.width - 3, 2, dimension.width - 3, dimension.height - 3);
                graphics.drawLine(2, dimension.height - 3, dimension.width - 3, dimension.height - 3);
            }
        }
    }

    class DBListener
    implements ActionListener {
        int id;

        public DBListener(int n2) {
            this.id = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SunVideoPlusManual.this.createDialog(this.id);
        }
    }

    class FormatsDialog
    extends Frame {
        int id;
        Button bFormat;
        Button bCancel;
        CheckboxGroup cAnalogGroup;
        Checkbox cNTSC;
        Checkbox cPAL;
        CheckboxGroup cPortGroup;
        Checkbox cPort1;
        Checkbox cPort2;
        Checkbox cSvhs;
        Checkbox cH261;
        Checkbox cH263;
        Checkbox cJpeg;
        Checkbox cRGB;
        Checkbox cYUV;
        Checkbox cFull;
        Checkbox cCif;
        Checkbox cQuarter;
        boolean fullVideo = false;
        boolean anyVideo = true;
        String sAnalog;
        String sPort;
        String sVideoFormat;
        String sSize;
        Hashtable videoFormats = new Hashtable();
        OPICapture opiVidCap = null;
        Integer lock = new Integer(1);
        boolean finished = false;
        boolean needFormat = false;

        public FormatsDialog(int n2) {
            super("sunvideoplus:" + DEVICE_PREFIX + n2);
            this.id = n2;
            this.setLayout(new BorderLayout());
            this.cAnalogGroup = new CheckboxGroup();
            this.cNTSC = new Checkbox("NTSC", true, this.cAnalogGroup);
            this.cPAL = new Checkbox("PAL", false, this.cAnalogGroup);
            this.cPortGroup = new CheckboxGroup();
            this.cPort1 = new Checkbox("1", true, this.cPortGroup);
            this.cPort2 = new Checkbox("2", false, this.cPortGroup);
            this.cSvhs = new Checkbox("S-VHS", false, this.cPortGroup);
            ItemListener itemListener = new ItemListener(this){
                private final /* synthetic */ FormatsDialog this$1;
                {
                    this.this$1 = formatsDialog;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    this.this$1.fullVideo = this.this$1.cRGB.getState() | this.this$1.cYUV.getState();
                    this.this$1.anyVideo = this.this$1.cH261.getState() | this.this$1.cH263.getState() | this.this$1.cJpeg.getState() | this.this$1.fullVideo;
                    this.this$1.cFull.setEnabled(this.this$1.fullVideo);
                    this.this$1.cCif.setEnabled(this.this$1.anyVideo);
                    this.this$1.cQuarter.setEnabled(this.this$1.anyVideo);
                }
            };
            this.cH261 = new Checkbox("h.261", false);
            this.cH261.addItemListener(itemListener);
            this.cH263 = new Checkbox("h.263", false);
            this.cH263.addItemListener(itemListener);
            this.cJpeg = new Checkbox("Jpeg", true);
            this.cJpeg.addItemListener(itemListener);
            this.cRGB = new Checkbox("RGB", false);
            this.cRGB.addItemListener(itemListener);
            this.cYUV = new Checkbox("YUV", false);
            this.cYUV.addItemListener(itemListener);
            this.cFull = new Checkbox("full cif", false);
            this.cFull.setEnabled(false);
            this.cCif = new Checkbox("cif", true);
            this.cQuarter = new Checkbox("quarter cif", false);
            this.bFormat = new Button("Add Formats");
            this.bCancel = new Button("Cancel");
            this.opiVidCap = new OPICapture(null);
            if (!this.opiVidCap.connect(n2)) {
                throw new Error("Unable to connect to device");
            }
            Font font = new Font("Dialog", 3, 12);
            BorderPanel borderPanel = new BorderPanel();
            borderPanel.setLayout(new BorderLayout(0, 0));
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout(0));
            Label label = new Label("Video Input Formats");
            label.setFont(font);
            panel.add(label);
            borderPanel.add("North", panel);
            Panel panel2 = new Panel();
            panel2.setLayout(new BorderLayout());
            panel = new Panel();
            panel.setLayout(new FlowLayout());
            panel.add(new Label("Analog"));
            panel.add(this.cNTSC);
            panel.add(this.cPAL);
            panel2.add("North", panel);
            panel = new Panel();
            panel.setLayout(new FlowLayout());
            panel.add(new Label("Port"));
            panel.add(this.cPort1);
            panel.add(this.cPort2);
            panel.add(this.cSvhs);
            panel2.add("South", panel);
            borderPanel.add("Center", panel2);
            panel2 = new Panel();
            panel2.setLayout(new BorderLayout());
            panel = new Panel();
            panel.setLayout(new FlowLayout());
            panel.add(new Label("Formats"));
            panel.add(this.cH261);
            panel.add(this.cH263);
            panel.add(this.cJpeg);
            panel.add(this.cRGB);
            panel.add(this.cYUV);
            panel2.add("Center", panel);
            panel = new Panel();
            panel.setLayout(new FlowLayout());
            panel.add(new Label("Sizes"));
            panel.add(this.cFull);
            panel.add(this.cCif);
            panel.add(this.cQuarter);
            panel2.add("South", panel);
            borderPanel.add("South", panel2);
            this.add("North", borderPanel);
            panel = new Panel();
            panel.setLayout(new FlowLayout());
            panel.add(this.bFormat);
            panel.add(this.bCancel);
            this.add("South", panel);
            this.pack();
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ FormatsDialog this$1;
                {
                    this.this$1 = formatsDialog;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    Integer n2 = this.this$1.lock;
                    synchronized (n2) {
                        this.this$1.finished = true;
                        this.this$1.lock.notify();
                    }
                }
            });
            this.bCancel.addActionListener(new ActionListener(this){
                private final /* synthetic */ FormatsDialog this$1;
                {
                    this.this$1 = formatsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Integer n2 = this.this$1.lock;
                    synchronized (n2) {
                        this.this$1.finished = true;
                        this.this$1.lock.notify();
                    }
                }
            });
            this.bFormat.addActionListener(new ActionListener(this){
                private final /* synthetic */ FormatsDialog this$1;
                {
                    this.this$1 = formatsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.needFormat = true;
                    Integer n2 = this.this$1.lock;
                    synchronized (n2) {
                        this.this$1.lock.notify();
                    }
                }
            });
        }

        private void addVideoFormat(Format format) {
            String string = this.sPort + "/" + this.sVideoFormat + "/" + this.sSize + "/" + this.sAnalog;
            System.err.println("New format " + string + " = " + format);
            this.videoFormats.put(string, format);
        }

        public void mydispose() {
            this.opiVidCap.disconnect();
            this.dispose();
            System.err.println("Disconnected driver");
        }

        public void doFormat() {
            if (!this.checkVideoFormats()) {
                return;
            }
            if (this.anyVideo) {
                this.doVideoFormats();
            }
            this.finished = true;
        }

        public boolean checkVideoFormats() {
            if (!this.anyVideo) {
                return true;
            }
            if (this.cCif.getState() | this.cQuarter.getState() | (this.cFull.getState() && this.cFull.isEnabled())) {
                return true;
            }
            this.issueError("Must specify at least one Video size");
            return false;
        }

        public void doVideoFormats() {
            if (!this.anyVideo) {
                this.videoFormats.put("off", new VideoFormat("rgb"));
            }
            Checkbox checkbox = this.cAnalogGroup.getSelectedCheckbox();
            this.sAnalog = "";
            if (checkbox == this.cNTSC) {
                this.sAnalog = "ntsc";
            } else if (checkbox == this.cPAL) {
                this.sAnalog = "pal";
            } else {
                System.err.println("No analog signal specified");
                return;
            }
            if (!this.opiVidCap.setSignal(this.sAnalog)) {
                System.err.println("Video analog signal not recognized");
                return;
            }
            Checkbox checkbox2 = this.cPortGroup.getSelectedCheckbox();
            int n2 = 1;
            if (checkbox2 == this.cPort1) {
                n2 = 1;
            } else if (checkbox2 == this.cPort2) {
                n2 = 2;
            } else if (checkbox2 == this.cSvhs) {
                n2 = 0;
            } else {
                System.err.println("No port specified");
                return;
            }
            if (!this.opiVidCap.setPort(n2)) {
                System.err.println("Video source not recognized on port");
                return;
            }
            this.sPort = "" + n2;
            if (this.cCif.getState()) {
                this.opiVidCap.setScale(2);
                this.sSize = "cif";
                this.getVideoFormats();
            }
            if (this.cQuarter.getState()) {
                this.opiVidCap.setScale(4);
                this.sSize = "qcif";
                this.getVideoFormats();
            }
            if (this.cFull.getState() && this.cFull.isEnabled()) {
                this.opiVidCap.setScale(1);
                this.sSize = "fcif";
                this.getVideoFormats();
            }
        }

        private void getVideoFormats() {
            if (this.cH261.getState() && !this.sSize.equals("fcif")) {
                this.sVideoFormat = "h261";
                this.getH261Format();
            }
            if (this.cH263.getState() && !this.sSize.equals("fcif")) {
                this.sVideoFormat = "h263";
                this.getH263Format();
            }
            if (this.cJpeg.getState() && !this.sSize.equals("fcif")) {
                this.sVideoFormat = "jpeg";
                this.getJpegFormat();
            }
            if (this.cRGB.getState()) {
                this.sVideoFormat = "rgb";
                this.getRGBFormat();
            }
            if (this.cYUV.getState()) {
                this.sVideoFormat = "yuv";
                this.getYUVFormat();
            }
        }

        private void getRGBFormat() {
            if (!this.opiVidCap.setCompress("RGB")) {
                return;
            }
            Dimension dimension = new Dimension(this.opiVidCap.getWidth(), this.opiVidCap.getHeight());
            this.addVideoFormat(new RGBFormat(dimension, -1, Format.byteArray, -1.0f, 16, 63488, 2016, 31, 2, -1, 0, -1));
        }

        private void getYUVFormat() {
            if (!this.opiVidCap.setCompress("YUV")) {
                return;
            }
            Dimension dimension = new Dimension(this.opiVidCap.getWidth(), this.opiVidCap.getHeight());
            this.addVideoFormat(new YUVFormat(dimension, -1, Format.byteArray, -1.0f, 32, -1, -1, 0, 3, 1));
        }

        private void getJpegFormat() {
            if (!this.opiVidCap.setCompress("Jpeg")) {
                return;
            }
            Dimension dimension = new Dimension(this.opiVidCap.getWidth(), this.opiVidCap.getHeight());
            this.addVideoFormat(new VideoFormat("jpeg", dimension, -1, Format.byteArray, -1.0f));
        }

        private void getH261Format() {
            if (!this.opiVidCap.setCompress("H261")) {
                return;
            }
            Dimension dimension = new Dimension(this.opiVidCap.getWidth(), this.opiVidCap.getHeight());
            this.addVideoFormat(new VideoFormat("h261", dimension, -1, Format.byteArray, -1.0f));
        }

        private void getH263Format() {
            if (!this.opiVidCap.setCompress("H263")) {
                return;
            }
            Dimension dimension = new Dimension(this.opiVidCap.getWidth(), this.opiVidCap.getHeight());
            this.addVideoFormat(new VideoFormat("h263", dimension, -1, Format.byteArray, -1.0f));
        }

        public void issueError(String string) {
            System.err.println(string);
            Toolkit.getDefaultToolkit().beep();
        }

        public Enumeration sortedFormats(Hashtable hashtable) {
            Vector<String> vector = new Vector<String>();
            Enumeration enumeration = hashtable.keys();
            block0: while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                int n2 = 0;
                while (n2 < vector.size()) {
                    if (string.compareTo((String)vector.elementAt(n2)) < 0) {
                        vector.insertElementAt(string, n2);
                        continue block0;
                    }
                    ++n2;
                }
                vector.addElement(string);
            }
            return vector.elements();
        }

        public Vector getDeviceInfo() {
            String string;
            Object object;
            Object object2;
            try {
                while (!this.finished) {
                    object2 = this.lock;
                    synchronized (object2) {
                        this.lock.wait();
                    }
                    if (!this.needFormat) continue;
                    this.needFormat = false;
                    this.doFormat();
                }
            }
            catch (InterruptedException interruptedException) {
                this.mydispose();
                return null;
            }
            object2 = "sunvideoplus://" + this.id;
            this.mydispose();
            Vector<CaptureDeviceInfo> vector = (Vector<CaptureDeviceInfo>)CaptureDeviceManager.getDeviceList(null).clone();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (CaptureDeviceInfo)enumeration.nextElement();
                string = ((CaptureDeviceInfo)object).getName();
                if (!string.startsWith((String)object2)) continue;
                CaptureDeviceManager.removeDevice((CaptureDeviceInfo)object);
            }
            vector = new Vector<CaptureDeviceInfo>();
            if (this.anyVideo) {
                object = this.sortedFormats(this.videoFormats);
                while (object.hasMoreElements()) {
                    string = (String)object.nextElement();
                    VideoFormat videoFormat = (VideoFormat)this.videoFormats.get(string);
                    Format[] formatArray = null;
                    formatArray = new Format[]{videoFormat};
                    String string2 = (String)object2 + "/" + string;
                    CaptureDeviceInfo captureDeviceInfo = new CaptureDeviceInfo(string2, new MediaLocator(string2), formatArray);
                    CaptureDeviceManager.addDevice(captureDeviceInfo);
                    vector.addElement(captureDeviceInfo);
                }
            }
            try {
                CaptureDeviceManager.commit();
                System.err.println("SunVideoPlusManual: Committed ok");
            }
            catch (IOException iOException) {
                System.err.println("SunVideoPlusManual: error committing cdm");
            }
            return vector;
        }
    }
}

