/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.gsm;

public class GsmDecoder {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1999.";
    private static final int OutputSize = 160;
    private static final int InputSize = 33;
    private static final int LpcOrder = 8;
    private static final int SubFrameSize = 40;
    private static final int NumOfSubframes = 4;
    private static final int NumOfParameters = 76;
    private static final int NumOfPulses = 13;
    private static final int NumOfLarInterp = 4;
    private static final int QuantResBase = 120;
    private static final int SidFrame = 2;
    private static final int SpeechFrame = 1;
    private static final int NullFrame = 0;
    private static final float[] QLB;
    private static final int[] larInterpStart;
    private static final float[][] InterpLarCoef;
    private static float[] xmaxTable;
    private static float[][] larTable;
    private static final int Parameter_SubFramesBase = 8;
    private static final int Parameter_SubFramesLength = 17;
    private static final int Parameter_LtpLag = 0;
    private static final int Parameter_LtpGain = 1;
    private static final int Parameter_RpeGridPosition = 2;
    private static final int Parameter_BlockAmplitude = 3;
    private static final int Parameter_RpePulsesBase = 4;
    private short[] outsig = new short[160];
    private byte[] inByteStream = new byte[33];
    private float[] prevLARpp = new float[9];
    private float[] rp = new float[9];
    private float[] u = new float[9];
    private int[] lastSID = new int[76];
    private int prevNc;
    private float prevOut;
    private float[] quantRes = new float[280];
    private int seed;
    private int[] parameters = new int[76];
    private float[] LARpp = new float[9];
    private static final int GSM_MAGIC = 13;

    private int GSMrand() {
        this.seed = this.seed * 1103515245 + 12345;
        return this.seed & Short.MAX_VALUE;
    }

    public void decoderInit() {
        this.prevNc = 40;
        this.prevOut = 0.0f;
        int n2 = 0;
        while (n2 < 9) {
            this.prevLARpp[n2] = 0.0f;
            this.rp[n2] = 0.0f;
            this.u[n2] = 0.0f;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.lastSID.length) {
            this.lastSID[n3] = 0;
            ++n3;
        }
        this.lastSID[0] = 2;
        this.lastSID[1] = 28;
        this.lastSID[2] = 18;
        this.lastSID[3] = 12;
        this.lastSID[4] = 7;
        this.lastSID[5] = 5;
        this.lastSID[6] = 3;
        this.lastSID[7] = 2;
        int n4 = 0;
        while (n4 < this.quantRes.length) {
            this.quantRes[n4] = 0.0f;
            ++n4;
        }
        this.seed = 1;
    }

    public boolean decodeFrame(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray = this.parameters;
        int[] nArray2 = this.lastSID;
        float[] fArray = this.LARpp;
        float[] fArray2 = this.u;
        float[] fArray3 = this.rp;
        float[] fArray4 = this.prevLARpp;
        float[] fArray5 = this.quantRes;
        System.arraycopy(fArray5, 160, fArray5, 0, 120);
        if (!this.UnpackBitStream(byArray, n2, nArray)) {
            return false;
        }
        int n8 = 0;
        int n9 = 0;
        while (n9 < 76) {
            if (0 != nArray[n9]) {
                n8 = 2;
                break;
            }
            ++n9;
        }
        if (n8 == 0) {
            System.arraycopy(nArray2, 0, nArray, 0, 76);
            n8 = 2;
        } else {
            n7 = 0;
            while (n7 < 4) {
                n6 = n7 * 17 + 8 + 4;
                n5 = 0;
                while (n5 < 13) {
                    if (nArray[n6 + n5] != 0) {
                        n8 = 1;
                        n7 = 4;
                        break;
                    }
                    ++n5;
                }
                ++n7;
            }
            if (n8 == 2) {
                System.arraycopy(nArray, 0, nArray2, 0, 76);
            }
        }
        if (n8 == 2) {
            n7 = 0;
            while (n7 < 4) {
                n4 = n7 * 17 + 8;
                n5 = 0;
                while (n5 < 13) {
                    nArray[n4 + 4 + n5] = this.GSMrand() / 5461 + 1;
                    ++n5;
                }
                nArray[n4 + 2] = this.GSMrand() / 10923;
                nArray[n4 + 1] = 0;
                nArray[n4 + 0] = n7 == 0 | n7 == 2 ? 40 : 120;
                ++n7;
            }
        }
        n9 = 0;
        while (n9 < 4) {
            n5 = n9 * 17 + 8;
            n6 = nArray[n5 + 0];
            if (n6 >= 40 && n6 <= 120) {
                this.prevNc = n6;
            }
            float f2 = QLB[nArray[n5 + 1]];
            n7 = nArray[n5 + 2];
            float f3 = xmaxTable[nArray[n5 + 3]];
            n8 = n9 * 40 + 120;
            int n10 = 0;
            while (n10 < 40) {
                fArray5[n8 + n10] = f2 * fArray5[n8 + n10 - this.prevNc];
                ++n10;
            }
            int n11 = 0;
            while (n11 < 13) {
                int n12 = n8 + n7 + 3 * n11;
                fArray5[n12] = (float)((double)fArray5[n12] + (0.25 * (double)nArray[n5 + 4 + n11] - 0.875) * (double)f3);
                ++n11;
            }
            ++n9;
        }
        n5 = 0;
        while (n5 < 8) {
            fArray[n5 + 1] = larTable[n5][nArray[n5]];
            ++n5;
        }
        float f4 = this.prevOut;
        n6 = 0;
        while (n6 < 4) {
            n4 = 1;
            while (n4 <= 8) {
                float f5 = fArray4[n4] * InterpLarCoef[n6][0] + fArray[n4] * InterpLarCoef[n6][1];
                fArray3[n4] = (double)Math.abs(f5) < 0.675 ? f5 : ((double)Math.abs(f5) < 1.225 ? (f5 > 0.0f ? 1.0f : -1.0f) * (0.5f * Math.abs(f5) + 0.3375f) : (f5 > 0.0f ? 1.0f : -1.0f) * (0.125f * Math.abs(f5) + 0.796875f));
                ++n4;
            }
            int n13 = larInterpStart[n6];
            while (n13 < larInterpStart[n6 + 1]) {
                float f6 = fArray5[120 + n13];
                fArray2[8] = fArray2[7] + fArray3[8] * (f6 -= fArray3[8] * fArray2[7]);
                fArray2[7] = fArray2[6] + fArray3[7] * (f6 -= fArray3[7] * fArray2[6]);
                fArray2[6] = fArray2[5] + fArray3[6] * (f6 -= fArray3[6] * fArray2[5]);
                fArray2[5] = fArray2[4] + fArray3[5] * (f6 -= fArray3[5] * fArray2[4]);
                fArray2[4] = fArray2[3] + fArray3[4] * (f6 -= fArray3[4] * fArray2[3]);
                fArray2[3] = fArray2[2] + fArray3[3] * (f6 -= fArray3[3] * fArray2[2]);
                fArray2[2] = fArray2[1] + fArray3[2] * (f6 -= fArray3[2] * fArray2[1]);
                fArray2[1] = fArray2[0] + fArray3[1] * (f6 -= fArray3[1] * fArray2[0]);
                f4 = f6 + f4 * 0.85998535f;
                fArray2[0] = f6;
                f6 = 65532.0f * f4;
                if (f6 > 32766.0f) {
                    f6 = 32766.0f;
                }
                if (f6 < -32766.0f) {
                    f6 = -32766.0f;
                }
                this.outsig[n13] = (short)f6;
                ++n13;
            }
            ++n6;
        }
        int n14 = 1;
        while (n14 <= 8) {
            fArray4[n14] = fArray[n14];
            ++n14;
        }
        this.prevOut = f4;
        int n15 = 0;
        int n16 = 0;
        while (n16 < 160) {
            n4 = this.outsig[n16];
            byArray2[n3 + n15++] = (byte)(n4 & 0xFF);
            byArray2[n3 + n15++] = (byte)(n4 >> 8);
            ++n16;
        }
        return true;
    }

    protected boolean UnpackBitStream(byte[] byArray, int n2, int[] nArray) {
        int n3 = 0;
        if ((byArray[n2] >> 4 & 0xF) != 13) {
            return false;
        }
        nArray[n3++] = (byArray[n2] & 0xF) << 2 | byArray[++n2] >> 6 & 3;
        nArray[n3++] = byArray[n2] & 0x3F;
        nArray[n3++] = byArray[++n2] >> 3 & 0x1F;
        nArray[n3++] = (byArray[n2] & 7) << 2 | byArray[++n2] >> 6 & 3;
        nArray[n3++] = byArray[n2] >> 2 & 0xF;
        nArray[n3++] = (byArray[n2] & 3) << 2 | byArray[++n2] >> 6 & 3;
        nArray[n3++] = byArray[n2] >> 3 & 7;
        nArray[n3++] = byArray[n2] & 7;
        ++n2;
        int n4 = 0;
        while (n4 < 4) {
            nArray[n3++] = byArray[n2] >> 1 & 0x7F;
            nArray[n3++] = (byArray[n2] & 1) << 1 | byArray[++n2] >> 7 & 1;
            nArray[n3++] = byArray[n2] >> 5 & 3;
            nArray[n3++] = (byArray[n2] & 0x1F) << 1 | byArray[++n2] >> 7 & 1;
            nArray[n3++] = byArray[n2] >> 4 & 7;
            nArray[n3++] = byArray[n2] >> 1 & 7;
            nArray[n3++] = (byArray[n2] & 1) << 2 | byArray[++n2] >> 6 & 3;
            nArray[n3++] = byArray[n2] >> 3 & 7;
            nArray[n3++] = byArray[n2] & 7;
            nArray[n3++] = byArray[++n2] >> 5 & 7;
            nArray[n3++] = byArray[n2] >> 2 & 7;
            nArray[n3++] = (byArray[n2] & 3) << 1 | byArray[++n2] >> 7 & 1;
            nArray[n3++] = byArray[n2] >> 4 & 7;
            nArray[n3++] = byArray[n2] >> 1 & 7;
            nArray[n3++] = (byArray[n2] & 1) << 2 | byArray[++n2] >> 6 & 3;
            nArray[n3++] = byArray[n2] >> 3 & 7;
            nArray[n3++] = byArray[n2] & 7;
            ++n2;
            ++n4;
        }
        return true;
    }

    static {
        int n2;
        int n3;
        QLB = new float[]{0.1f, 0.35f, 0.65f, 1.0f};
        larInterpStart = new int[]{0, 13, 27, 40, 160};
        InterpLarCoef = new float[][]{{0.75f, 0.25f}, {0.5f, 0.5f}, {0.25f, 0.75f}, {0.0f, 1.0f}};
        short[] sArray = new short[]{0, 0, 2048, -2560, 94, -1792, -341, -1144};
        short[] sArray2 = new short[]{-32, -32, -16, -16, -8, -8, -4, -4};
        short[] sArray3 = new short[]{13107, 13107, 13107, 13107, 19223, 17476, 31454, 29708};
        xmaxTable = new float[64];
        int n4 = 0;
        while (n4 < 64) {
            if (n4 < 16) {
                n3 = 31 + (n4 << 5);
            } else {
                n2 = n4 - 16 >> 3;
                n3 = (576 << n2) - 1 + (n4 - 16 - 8 * n2) * (64 << n2);
            }
            GsmDecoder.xmaxTable[n4] = (float)n3 / 32768.0f;
            ++n4;
        }
        larTable = new float[8][];
        n2 = 0;
        while (n2 < 8) {
            GsmDecoder.larTable[n2] = new float[-sArray2[n2] * 2];
            n3 = 0;
            while (n3 < -sArray2[n2] * 2) {
                short s = (short)((n3 + sArray2[n2] << 10) - sArray[n2] * 2);
                s = (short)((long)(s * sArray3[n2]) + 16384L >> 15);
                GsmDecoder.larTable[n2][n3] = (float)(s * 2) / 16384.0f;
                ++n3;
            }
            ++n2;
        }
    }
}

