/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicModule;
import com.sun.media.BasicMuxModule;
import com.sun.media.BasicPlugIn;
import com.sun.media.BasicRendererModule;
import com.sun.media.InputConnector;
import com.sun.media.Log;
import com.sun.media.Module;
import com.sun.media.OutputConnector;
import com.sun.media.PlaybackEngine;
import com.sun.media.controls.ProgressControl;
import com.sun.media.controls.StringControl;
import com.sun.media.util.JMFI18N;
import java.awt.Component;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Control;
import javax.media.Format;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.Renderer;
import javax.media.Track;
import javax.media.UnsupportedPlugInException;
import javax.media.control.FrameRateControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;

public class BasicTrackControl
implements TrackControl {
    static final String realizeErr = "Cannot get CodecControl before reaching the realized state.";
    static final String connectErr = "Cannot set a PlugIn before reaching the configured state.";
    PlaybackEngine engine;
    Track track;
    OutputConnector firstOC;
    OutputConnector lastOC;
    protected Vector modules = new Vector(7);
    protected BasicRendererModule rendererModule;
    protected BasicMuxModule muxModule = null;
    protected boolean prefetchFailed = false;
    protected boolean rendererFailed = false;
    float lastFrameRate = 0.0f;
    long lastStatsTime = 0L;

    public BasicTrackControl(PlaybackEngine playbackEngine, Track track, OutputConnector outputConnector) {
        this.engine = playbackEngine;
        this.track = track;
        this.firstOC = outputConnector;
        this.lastOC = outputConnector;
        this.setEnabled(track.isEnabled());
    }

    public Format getOriginalFormat() {
        return this.track.getFormat();
    }

    public Format getFormat() {
        return this.track.getFormat();
    }

    public Format[] getSupportedFormats() {
        return new Format[]{this.track.getFormat()};
    }

    public boolean buildTrack(int n2, int n3) {
        return false;
    }

    public Format setFormat(Format format) {
        if (format != null && format.matches(this.getFormat())) {
            return this.getFormat();
        }
        return null;
    }

    public void setCodecChain(Codec[] codecArray) throws NotConfiguredError, UnsupportedPlugInException {
        if (this.engine.getState() > 180) {
            throw new NotConfiguredError(connectErr);
        }
        if (codecArray.length < 1) {
            throw new UnsupportedPlugInException("No codec specified in the array.");
        }
    }

    public void setRenderer(Renderer renderer) throws NotConfiguredError {
        if (this.engine.getState() > 180) {
            throw new NotConfiguredError(connectErr);
        }
    }

    public boolean prefetchTrack() {
        int n2 = 0;
        while (n2 < this.modules.size()) {
            BasicModule basicModule = (BasicModule)this.modules.elementAt(n2);
            if (!basicModule.doPrefetch()) {
                this.setEnabled(false);
                this.prefetchFailed = true;
                if (basicModule instanceof BasicRendererModule) {
                    this.rendererFailed = true;
                }
                return false;
            }
            ++n2;
        }
        if (this.prefetchFailed) {
            this.setEnabled(true);
            this.prefetchFailed = false;
            this.rendererFailed = false;
        }
        return true;
    }

    public void startTrack() {
        int n2 = 0;
        while (n2 < this.modules.size()) {
            ((BasicModule)this.modules.elementAt(n2)).doStart();
            ++n2;
        }
    }

    public void stopTrack() {
        int n2 = 0;
        while (n2 < this.modules.size()) {
            ((BasicModule)this.modules.elementAt(n2)).doStop();
            ++n2;
        }
    }

    public boolean isCustomized() {
        return false;
    }

    public boolean isTimeBase() {
        return false;
    }

    public boolean isEnabled() {
        return this.track.isEnabled();
    }

    public void setEnabled(boolean bl) {
        this.track.setEnabled(bl);
    }

    protected ProgressControl progressControl() {
        return null;
    }

    protected FrameRateControl frameRateControl() {
        return null;
    }

    public void prError() {
        Log.error("  Unable to handle format: " + this.getOriginalFormat());
        Log.write("\n");
    }

    public Object[] getControls() throws NotRealizedError {
        int n2;
        InputConnector inputConnector;
        if (this.engine.getState() < 300) {
            throw new NotRealizedError(realizeErr);
        }
        OutputConnector outputConnector = this.firstOC;
        Object var4_2 = null;
        Vector<Object> vector = new Vector<Object>();
        while (outputConnector != null && (inputConnector = outputConnector.getInputConnector()) != null) {
            Module module = inputConnector.getModule();
            Object[] objectArray = module.getControls();
            if (objectArray != null) {
                n2 = 0;
                while (n2 < objectArray.length) {
                    vector.addElement(objectArray[n2]);
                    ++n2;
                }
            }
            outputConnector = module.getOutputConnector(null);
        }
        int n3 = vector.size();
        Object[] objectArray = new Control[n3];
        n2 = 0;
        while (n2 < n3) {
            objectArray[n2] = (Control)vector.elementAt(n2);
            ++n2;
        }
        return objectArray;
    }

    public Object getControl(String string) {
        Class clazz;
        try {
            clazz = BasicPlugIn.getClassForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        Object[] objectArray = this.getControls();
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (clazz.isInstance(objectArray[n2])) {
                return objectArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public Component getControlComponent() {
        return null;
    }

    public void updateFormat() {
        StringControl stringControl;
        Object object;
        if (!this.track.isEnabled()) {
            return;
        }
        ProgressControl progressControl = this.progressControl();
        if (progressControl == null) {
            return;
        }
        if (this.track.getFormat() instanceof AudioFormat) {
            object = "";
            AudioFormat audioFormat = (AudioFormat)this.track.getFormat();
            stringControl = progressControl.getAudioCodec();
            stringControl.setValue(audioFormat.getEncoding());
            stringControl = progressControl.getAudioProperties();
            object = audioFormat.getChannels() == 1 ? JMFI18N.getResource("mediaengine.mono") : JMFI18N.getResource("mediaengine.stereo");
            stringControl.setValue(audioFormat.getSampleRate() / 1000.0 + JMFI18N.getResource("mediaengine.khz") + ", " + audioFormat.getSampleSizeInBits() + JMFI18N.getResource("mediaengine.-bit") + ", " + (String)object);
        }
        if (this.track.getFormat() instanceof VideoFormat) {
            object = (VideoFormat)this.track.getFormat();
            stringControl = progressControl.getVideoCodec();
            stringControl.setValue(((Format)object).getEncoding());
            stringControl = progressControl.getVideoProperties();
            if (((VideoFormat)object).getSize() != null) {
                stringControl.setValue(((VideoFormat)object).getSize().width + " X " + ((VideoFormat)object).getSize().height);
            }
        }
    }

    public void updateRates(long l2) {
        float f2;
        FrameRateControl frameRateControl = this.frameRateControl();
        if (frameRateControl == null) {
            return;
        }
        if (!this.track.isEnabled() || !(this.track.getFormat() instanceof VideoFormat) || this.rendererModule == null && this.muxModule == null) {
            return;
        }
        if (l2 == this.lastStatsTime) {
            f2 = this.lastFrameRate;
        } else {
            int n2 = this.rendererModule != null ? this.rendererModule.getFramesPlayed() : this.muxModule.getFramesPlayed();
            f2 = (float)n2 / (float)(l2 - this.lastStatsTime) * 1000.0f;
        }
        float f3 = (float)((int)((this.lastFrameRate + f2) / 2.0f * 10.0f)) / 10.0f;
        frameRateControl.setFrameRate(f3);
        this.lastFrameRate = f2;
        this.lastStatsTime = l2;
        if (this.rendererModule != null) {
            this.rendererModule.resetFramesPlayed();
        } else {
            this.muxModule.resetFramesPlayed();
        }
    }
}

