/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.datasink.rtp;

import com.sun.media.datasink.BasicDataSink;
import com.sun.media.rtp.RTPMediaLocator;
import java.awt.Component;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import javax.media.IncompatibleSourceException;
import javax.media.MediaLocator;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.RTPManager;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionAddress;

public class Handler
extends BasicDataSink {
    private RTPMediaLocator rtpmrl = null;
    RTPManager rtpmanager = null;
    PushBufferDataSource source = null;
    SendStream rtpsendstream = null;

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Component getControlComponent() {
        return null;
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (!(dataSource instanceof PushBufferDataSource)) {
            throw new IncompatibleSourceException("Only supports PushBufferDataSource");
        }
        this.source = (PushBufferDataSource)dataSource;
        PushBufferStream[] pushBufferStreamArray = this.source.getStreams();
        int n2 = pushBufferStreamArray.length;
        System.out.println("streams is " + pushBufferStreamArray + " : " + n2);
        if (pushBufferStreamArray == null || n2 <= 0) {
            throw new IOException("source " + dataSource + " doesn't have any streams");
        }
    }

    public void setOutputLocator(MediaLocator mediaLocator) {
        if (this.rtpmrl == null) {
            System.out.println("sink: setOutputLocator " + mediaLocator);
            try {
                this.rtpmrl = new RTPMediaLocator(mediaLocator.toString());
            }
            catch (MalformedURLException malformedURLException) {
                this.rtpmrl = null;
            }
        } else {
            throw new Error("setOutputLocator cannot be called more than once");
        }
    }

    public MediaLocator getOutputLocator() {
        return this.rtpmrl;
    }

    public void start() throws IOException {
        this.rtpsendstream.start();
    }

    public void stop() throws IOException {
        this.rtpsendstream.stop();
    }

    public void open() throws IOException, SecurityException {
        if (this.rtpmrl == null) {
            throw new IOException("No Valid RTP MediaLocator");
        }
        try {
            String string = this.rtpmrl.getSessionAddress();
            int n2 = this.rtpmrl.getSessionPort();
            int n3 = this.rtpmrl.getTTL();
            this.rtpmanager = RTPManager.newInstance();
            SessionAddress sessionAddress = new SessionAddress();
            InetAddress inetAddress = InetAddress.getByName(string);
            SessionAddress sessionAddress2 = new SessionAddress(inetAddress, n2, n3);
            this.rtpmanager.initialize(sessionAddress);
            this.rtpmanager.addTarget(sessionAddress2);
            this.rtpsendstream = this.rtpmanager.createSendStream(this.source, 0);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public void close() {
        if (this.rtpmanager != null) {
            this.rtpmanager.removeTargets("DataSink closed");
            this.rtpmanager.dispose();
        }
    }

    public String getContentType() {
        return "RTP";
    }
}

