/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.sunvideo;

import com.sun.media.JMFSecurityManager;
import com.sun.media.renderer.video.XILRenderer;
import java.io.IOException;
import javax.media.protocol.SourceStream;

public class XILCapture {
    private static boolean available = false;
    private long peer;
    private SourceStream stream;

    public static boolean isAvailable() {
        return available;
    }

    public XILCapture(SourceStream sourceStream) {
        this.stream = sourceStream;
    }

    public boolean connect(int n2) {
        return this.connect(n2, 1);
    }

    public boolean connect(int n2, int n3) {
        if (available) {
            Integer n4 = XILRenderer.XILLock;
            synchronized (n4) {
                boolean bl = this.xilConnect(n2, n3);
                return bl;
            }
        }
        return false;
    }

    public boolean setPort(int n2) {
        if (available) {
            Integer n3 = XILRenderer.XILLock;
            synchronized (n3) {
                boolean bl = this.xilSetPort(n2);
                return bl;
            }
        }
        return false;
    }

    public boolean setScale(int n2) {
        if (available) {
            Integer n3 = XILRenderer.XILLock;
            synchronized (n3) {
                boolean bl = this.xilSetScale(n2);
                return bl;
            }
        }
        return false;
    }

    public boolean setSkip(int n2) {
        if (available) {
            Integer n3 = XILRenderer.XILLock;
            synchronized (n3) {
                boolean bl = this.xilSetSkip(n2);
                return bl;
            }
        }
        return false;
    }

    public boolean setQuality(int n2) {
        if (available) {
            Integer n3 = XILRenderer.XILLock;
            synchronized (n3) {
                boolean bl = this.xilSetQuality(n2);
                return bl;
            }
        }
        return false;
    }

    public boolean setCompress(String string) {
        if (available) {
            Integer n2 = XILRenderer.XILLock;
            synchronized (n2) {
                boolean bl = this.xilSetCompress(string);
                return bl;
            }
        }
        return false;
    }

    public boolean start() {
        if (available) {
            Integer n2 = XILRenderer.XILLock;
            synchronized (n2) {
                boolean bl = this.xilStart();
                return bl;
            }
        }
        return false;
    }

    public int read(byte[] byArray, int n2) throws IOException {
        int n3 = 0;
        if (available) {
            Integer n4 = XILRenderer.XILLock;
            synchronized (n4) {
                n3 = this.xilRead(byArray, n2);
            }
            if (n3 < 0) {
                throw new IOException("XILCapture read() failed");
            }
        } else {
            throw new IOException("XILCapture shared library not available");
        }
        return n3;
    }

    public int getWidth() {
        if (available) {
            Integer n2 = XILRenderer.XILLock;
            synchronized (n2) {
                int n3 = this.xilGetWidth();
                return n3;
            }
        }
        return 0;
    }

    public int getHeight() {
        if (available) {
            Integer n2 = XILRenderer.XILLock;
            synchronized (n2) {
                int n3 = this.xilGetHeight();
                return n3;
            }
        }
        return 0;
    }

    public int getLineStride() {
        if (available) {
            Integer n2 = XILRenderer.XILLock;
            synchronized (n2) {
                int n3 = this.xilGetLineStride();
                return n3;
            }
        }
        return 0;
    }

    public boolean stop() {
        if (available) {
            Integer n2 = XILRenderer.XILLock;
            synchronized (n2) {
                boolean bl = this.xilStop();
                return bl;
            }
        }
        return false;
    }

    public boolean disconnect() {
        if (available) {
            Integer n2 = XILRenderer.XILLock;
            synchronized (n2) {
                boolean bl = this.xilDisconnect();
                return bl;
            }
        }
        return false;
    }

    public void finalize() {
        if (available) {
            Integer n2 = XILRenderer.XILLock;
            synchronized (n2) {
                this.xilDisconnect();
            }
        }
    }

    private static native boolean cacheFieldIDs();

    private static native boolean xilInitialize();

    private native boolean xilLittleEndian();

    private native boolean xilConnect(int var1, int var2);

    private native boolean xilSetPort(int var1);

    private native boolean xilSetScale(int var1);

    private native boolean xilSetSkip(int var1);

    private native boolean xilSetQuality(int var1);

    private native boolean xilSetCompress(String var1);

    private native boolean xilStart();

    private native int xilRead(byte[] var1, int var2);

    private native int xilGetWidth();

    private native int xilGetHeight();

    private native int xilGetLineStride();

    private native boolean xilStop();

    private native boolean xilDisconnect();

    static {
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmxil");
            if (XILCapture.xilInitialize() && XILCapture.cacheFieldIDs()) {
                available = true;
            } else {
                System.err.println("XILCapture initialize failed");
            }
        }
        catch (Exception exception) {
            System.err.println("XILCapture initialize failed: " + exception);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("XILCapture initialize failed: " + unsatisfiedLinkError);
        }
    }
}

