/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.sunvideoplus;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.controls.AtomicControlAdapter;
import com.sun.media.controls.BitRateAdapter;
import com.sun.media.controls.ControlChangeEvent;
import com.sun.media.controls.ControlChangeListener;
import com.sun.media.controls.FrameRateAdapter;
import com.sun.media.controls.QualityAdapter;
import com.sun.media.protocol.BasicSourceStream;
import com.sun.media.protocol.sunvideoplus.DataSource;
import com.sun.media.protocol.sunvideoplus.OPICapture;
import com.sun.media.protocol.sunvideoplus.PushThread;
import com.sun.media.ui.VideoFormatChooser;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadAction;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.Owned;
import javax.media.SystemTimeBase;
import javax.media.control.FormatControl;
import javax.media.control.PortControl;
import javax.media.format.JPEGFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;

public class OPISourceStream
extends BasicSourceStream
implements PushBufferStream,
Owned {
    private DataSource dataSource = null;
    private MediaLocator locator = null;
    int maxDataSize = 230400;
    BufferTransferHandler transferHandler = null;
    private byte[] data = null;
    private int length = 0;
    private long nextSequence = 1L;
    long timeStamp = 0L;
    OPICapture opiCap = null;
    private VideoFormat capFormat = null;
    private Format[] supported = null;
    SystemTimeBase systemTimeBase = new SystemTimeBase();
    private static Format[] supportedNTSC;
    private static Format[] supportedPAL;
    private static Format[] supportedCommon;
    private static final boolean CONTROL_PANEL_HACK = false;
    private Frame controlFrame = null;
    private static Integer OPILock;
    Integer readLock = new Integer(1);
    private boolean started = false;
    private boolean connected = false;
    private boolean connectedOK = false;
    private boolean inUse = false;
    private int cardNo = 0;
    private static String[] VALID_PORTS;
    private static final int DEFAULT_PORT = 1;
    private int portNo = 1;
    private static String[] VALID_COMPRESS;
    private static String[] VIDEO_COMPRESS;
    private static final int DEFAULT_COMPRESS = 0;
    private static final int H261_COMPRESS = 0;
    private static final int H263_COMPRESS = 1;
    private static final int RGB_COMPRESS = 2;
    private static final int YUV_COMPRESS = 3;
    private int compressNo = 0;
    private static String[] VALID_SIGNAL;
    private static final int DEFAULT_SIGNAL = 0;
    private static final int PAL_SIGNAL = 1;
    private int signalNo = 0;
    private static String[] VALID_SIZES;
    private static float[] VALID_SIZES_FLOAT;
    private static int[] VALID_SCALE;
    private static final int DEFAULT_SIZE = 1;
    private static float SIZE_GRANULARITY;
    private int sizeNo = 1;
    private static final int DEFAULT_RATE = 30;
    private int rateNo = 30;
    private static final int DEFAULT_QUALITY = 50;
    private int qualityNo = 50;
    private static final int LO_BITRATE = 100;
    private static final int HI_BITRATE = 2500;
    private static final int DEFAULT_BITRATE = 2000;
    private int bitrateNo = 2000;
    private static final int H263_LO_BITRATE = 1;
    private static final int H263_HI_BITRATE = 200;
    private static final int H263_DEFAULT_BITRATE = 60;
    private LocalPortControl portControl = null;
    private SignalControl signalControl = null;
    private RateControl rateControl = null;
    private LocalQualityControl qualityControl = null;
    private BitRateControl bitrateControl = null;
    private LocalFormatControl formatControl = null;
    private float preferredFrameRate = 30.0f;
    private PushThread pt = null;
    private static JMFSecurity jmfSecurity;
    private static boolean securityPrivelege;
    private Method[] mSecurity = new Method[1];
    private Class[] clSecurity = new Class[1];
    private Object[][] argsSecurity = new Object[1][0];
    static /* synthetic */ Class class$com$sun$media$protocol$sunvideoplus$PushThread;

    public OPISourceStream(DataSource dataSource) {
        super(new ContentDescriptor("raw"), -1L);
        this.dataSource = dataSource;
        this.locator = dataSource.getLocator();
        this.cardNo = 0;
        String string = this.locator.getRemainder();
        if (string != null && string.length() > 0) {
            String string2;
            while (string.length() > 1 && string.charAt(0) == '/') {
                string = string.substring(1);
            }
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            int n2 = string.indexOf(47);
            if (n2 == -1) {
                string2 = string;
            } else {
                string2 = string.substring(0, n2);
                if ((n2 = (string = string.substring(n2 + 1)).indexOf(47)) == -1) {
                    string3 = string;
                } else {
                    string3 = string.substring(0, n2);
                    if ((n2 = (string = string.substring(n2 + 1)).indexOf(47)) == -1) {
                        string4 = string;
                    } else {
                        string4 = string.substring(0, n2);
                        if ((n2 = (string = string.substring(n2 + 1)).indexOf(47)) == -1) {
                            string6 = string;
                        } else {
                            string6 = string.substring(0, n2);
                            string5 = string.substring(n2 + 1);
                        }
                    }
                }
            }
            try {
                Integer n3 = Integer.valueOf(string2);
                if (n3 != null) {
                    this.cardNo = n3;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (string3 != null && string3.length() > 0) {
                int n4 = 0;
                while (n4 < VALID_PORTS.length) {
                    if (VALID_PORTS[n4].equalsIgnoreCase(string3)) {
                        this.portNo = n4;
                    }
                    ++n4;
                }
            }
            if (string4 != null && string4.length() > 0) {
                int n5 = 0;
                while (n5 < VALID_COMPRESS.length) {
                    if (VALID_COMPRESS[n5].equalsIgnoreCase(string4)) {
                        this.compressNo = n5;
                    }
                    ++n5;
                }
            }
            if (string5 != null && string5.length() > 0) {
                int n6 = 0;
                while (n6 < VALID_SIGNAL.length) {
                    if (VALID_SIGNAL[n6].equalsIgnoreCase(string5)) {
                        this.signalNo = n6;
                    }
                    ++n6;
                }
                this.signalToFormat(this.signalNo);
            } else {
                this.signalToFormat(-1);
            }
            if (string6 != null && string6.length() > 0) {
                int n7 = 0;
                while (n7 < VALID_SIZES.length) {
                    if (VALID_SIZES[n7].equalsIgnoreCase(string6)) {
                        this.sizeNo = n7;
                    }
                    ++n7;
                }
            }
        }
        this.capFormat = new VideoFormat(VIDEO_COMPRESS[this.compressNo], this.getSizeDimension(), -1, Format.byteArray, this.getRate());
        this.opiCap = new OPICapture(this);
        this.portControl = new LocalPortControl(this, VALID_PORTS, this.portNo);
        this.signalControl = new SignalControl(this, VALID_SIGNAL, this.signalNo);
        this.rateControl = new RateControl(this, 30.0f, 1.0f, 30.0f);
        this.qualityControl = new LocalQualityControl(this, 0.5f, 0.0f, 1.0f);
        this.bitrateControl = new BitRateControl(this, 2000, 100, 2500);
        this.formatControl = new LocalFormatControl(this);
        this.controls = new Object[5];
        this.controls[0] = this.portControl;
        this.controls[1] = this.rateControl;
        this.controls[2] = this.qualityControl;
        this.controls[3] = this.bitrateControl;
        this.controls[4] = this.formatControl;
    }

    public Object getDataType() {
        return Format.byteArray;
    }

    public void setTransferHandler(BufferTransferHandler bufferTransferHandler) {
        this.transferHandler = bufferTransferHandler;
    }

    public void connect() throws IOException {
        Integer n2 = OPILock;
        synchronized (n2) {
            if (this.inUse) {
                throw new IOException("Capture device in use");
            }
            this.inUse = true;
            this.connected = false;
            if (!this.doConnect()) {
                this.inUse = false;
                throw new IOException("Could not connect to capture device");
            }
            this.connected = true;
        }
    }

    private boolean doConnect() {
        if (!this.opiCap.connect(this.cardNo, this.portNo)) {
            return false;
        }
        this.setSize(this.sizeNo);
        this.setSignal(this.signalNo);
        this.setCompress(this.compressNo);
        this.data = new byte[this.maxDataSize];
        this.nextSequence = 1L;
        return true;
    }

    synchronized void disconnect() {
        if (this.started) {
            try {
                this.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Integer n2 = OPILock;
        synchronized (n2) {
            this.connected = false;
            this.opiCap.disconnect();
            if (this.pt != null) {
                this.pt.timeToQuit();
            }
            this.pt = null;
            this.inUse = false;
        }
    }

    void start() throws IOException {
        if (this.started) {
            return;
        }
        if (!this.opiCap.start()) {
            throw new IOException("OPIStart failed");
        }
        OPISourceStream oPISourceStream = this;
        synchronized (oPISourceStream) {
            this.started = true;
            if (this.pt == null) {
                Object object;
                if (jmfSecurity != null) {
                    object = null;
                    try {
                        if (jmfSecurity.getName().startsWith("jmf-security")) {
                            object = "thread";
                            jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 16);
                            this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                            object = "thread group";
                            jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 32);
                            this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                        } else if (jmfSecurity.getName().startsWith("internet")) {
                            PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                            PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                        }
                    }
                    catch (Throwable throwable) {
                        securityPrivelege = false;
                    }
                }
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    try {
                        object = jdk12CreateThreadAction.cons;
                        this.pt = (PushThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$protocol$sunvideoplus$PushThread == null ? (class$com$sun$media$protocol$sunvideoplus$PushThread = OPISourceStream.class$("com.sun.media.protocol.sunvideoplus.PushThread")) : class$com$sun$media$protocol$sunvideoplus$PushThread, this));
                    }
                    catch (Exception exception) {
                        System.err.println("OPISourceStream: exception when creating thread");
                    }
                } else {
                    this.pt = new PushThread(this);
                }
                if (this.pt != null) {
                    this.pt.start();
                }
            }
            if (this.signalControl != null) {
                this.signalControl.setEnabled(false);
            }
            if (this.formatControl != null) {
                this.formatControl.getControlComponent().setEnabled(false);
            }
        }
    }

    void stop() throws IOException {
        this.started = false;
        this.opiCap.stop();
        if (this.signalControl != null) {
            this.signalControl.setEnabled(true);
        }
        if (this.formatControl != null) {
            this.formatControl.getControlComponent().setEnabled(true);
        }
    }

    public void finalize() {
        if (this.connected) {
            this.disconnect();
        }
    }

    boolean getStarted() {
        return this.started;
    }

    boolean getConnected() {
        return this.connected;
    }

    public Format getFormat() {
        return this.capFormat;
    }

    public Format[] getSupportedFormats() {
        return this.supported;
    }

    byte[] getData() {
        return this.data;
    }

    void setData(byte[] byArray) {
        this.data = byArray;
    }

    void pushData(int n2) {
        this.length = n2;
        if (this.transferHandler != null) {
            this.transferHandler.transferData(this);
        }
    }

    public boolean willReadBlock() {
        return true;
    }

    public void read(Buffer buffer) {
        if (!this.started) {
            buffer.setDiscard(true);
            this.length = 0;
            return;
        }
        Integer n2 = this.readLock;
        synchronized (n2) {
            int n3 = this.length;
            if (this.length > 0) {
                byte[] byArray = this.data;
                Object object = buffer.getData();
                this.data = object instanceof byte[] && ((byte[])object).length >= this.maxDataSize ? (byte[])object : new byte[this.maxDataSize];
                buffer.setOffset(0);
                buffer.setData(byArray);
                buffer.setLength(this.length);
                buffer.setSequenceNumber(this.nextSequence++);
                buffer.setDiscard(false);
                buffer.setTimeStamp(this.timeStamp);
                buffer.setFlags(buffer.getFlags() | 0x80 | 0x10 | 0x8000);
                buffer.setFormat(this.capFormat);
            } else {
                buffer.setDiscard(true);
            }
            this.length = 0;
            return;
        }
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        return new CaptureDeviceInfo("SunVideoPlus device " + this.cardNo, this.locator, this.supported);
    }

    private void setSizes(int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        while (n7 < VALID_SCALE.length) {
            if (n6 == VALID_SCALE[n7]) {
                if (this.sizeNo == n7) break;
                this.setSize(n7);
                break;
            }
            ++n7;
        }
    }

    public void setRGBFormat(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n2 <= 0) {
            n2 = 640;
        }
        if (n3 <= 0) {
            n3 = 480;
        }
        if (n4 <= 0) {
            n4 = n2 / VALID_SCALE[this.sizeNo];
        }
        if (n5 <= 0) {
            n5 = n3 / VALID_SCALE[this.sizeNo];
        }
        Dimension dimension = new Dimension(n4, n5);
        if (n6 == -1) {
            n6 = 2 * n4;
        }
        this.maxDataSize = n6 * n5;
        this.capFormat = new RGBFormat(new Dimension(n4, n5), this.maxDataSize, Format.byteArray, this.getRate(), 16, 63488, 2016, 31, 2, n6, 0, -1);
        this.setSizes(n2, n3, n4, n5, n7);
        if (this.formatControl != null) {
            this.formatControl.setCurrentFormat(this.capFormat);
        }
    }

    public void setYUVFormat(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n2 <= 0) {
            n2 = 640;
        }
        if (n3 <= 0) {
            n3 = 480;
        }
        if (n4 <= 0) {
            n4 = n2 / VALID_SCALE[this.sizeNo];
        }
        if (n5 <= 0) {
            n5 = n3 / VALID_SCALE[this.sizeNo];
        }
        n6 = 2 * n4;
        this.maxDataSize = n6 * n5;
        this.capFormat = new YUVFormat(new Dimension(n4, n5), this.maxDataSize, Format.byteArray, this.getRate(), 32, n6, n6, 0, 3, 1);
        this.setSizes(n2, n3, n4, n5, n7);
        if (this.formatControl != null) {
            this.formatControl.setCurrentFormat(this.capFormat);
        }
    }

    public void setH261Format(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.setVideoFormat("h261", n2, n3, n4, n5, n6, n7);
    }

    public void setH263Format(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.setVideoFormat("h263", n2, n3, n4, n5, n6, n7);
    }

    public void setJpegFormat(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n2 <= 0) {
            n2 = 640;
        }
        if (n3 <= 0) {
            n3 = 480;
        }
        if (n4 <= 0) {
            n4 = n2 / VALID_SCALE[this.sizeNo];
        }
        if (n5 <= 0) {
            n5 = n3 / VALID_SCALE[this.sizeNo];
        }
        this.maxDataSize = n6 > 60 ? 3 * n4 * n5 : 2 * n4 * n5;
        this.capFormat = new JPEGFormat(new Dimension(n4, n5), this.maxDataSize, Format.byteArray, this.getRate(), this.qualityNo / 3, -1);
        this.setSizes(n2, n3, n4, n5, n7);
        if (this.formatControl != null) {
            this.formatControl.setCurrentFormat(this.capFormat);
        }
    }

    public void setVideoFormat(String string, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n2 <= 0) {
            n2 = 640;
        }
        if (n3 <= 0) {
            n3 = 480;
        }
        if (n4 <= 0) {
            n4 = n2 / VALID_SCALE[this.sizeNo];
        }
        if (n5 <= 0) {
            n5 = n3 / VALID_SCALE[this.sizeNo];
        }
        this.maxDataSize = n6 > 60 ? 3 * n4 * n5 : 2 * n4 * n5;
        this.capFormat = new VideoFormat(string, new Dimension(n4, n5), this.maxDataSize, Format.byteArray, this.getRate());
        this.setSizes(n2, n3, n4, n5, n7);
        if (this.formatControl != null) {
            this.formatControl.setCurrentFormat(this.capFormat);
        }
    }

    public void setMpegFormat(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n2 <= 0) {
            n2 = 640;
        }
        if (n3 <= 0) {
            n3 = 480;
        }
        if (n4 <= 0) {
            n4 = n2 / VALID_SCALE[this.sizeNo];
        }
        if (n5 <= 0) {
            n5 = n3 / VALID_SCALE[this.sizeNo];
        }
        this.maxDataSize = n6 > 60 ? 3 * n4 * n5 : 2 * n4 * n5;
        this.capFormat = new VideoFormat("mpeg", new Dimension(n4, n5), this.maxDataSize, Format.byteArray, this.getRate());
        this.setSizes(n2, n3, n4, n5, n7);
        if (this.formatControl != null) {
            this.formatControl.setCurrentFormat(this.capFormat);
        }
    }

    private void setPort(int n2) {
        this.portNo = n2;
        this.opiCap.setPort(this.portNo);
    }

    private void setSignal(int n2) {
        this.signalNo = n2;
        this.opiCap.setSignal(VALID_SIGNAL[this.signalNo]);
        this.signalToFormat(this.signalNo);
    }

    private void signalToFormat(int n2) {
        if (n2 == -1) {
            this.supported = new Format[supportedCommon.length + supportedNTSC.length + supportedPAL.length];
            System.arraycopy(supportedCommon, 0, this.supported, 0, supportedCommon.length);
            System.arraycopy(supportedNTSC, 0, this.supported, supportedCommon.length, supportedNTSC.length);
            System.arraycopy(supportedNTSC, 0, this.supported, supportedCommon.length + supportedNTSC.length, supportedPAL.length);
        } else if (this.signalNo == 1) {
            this.supported = new Format[supportedCommon.length + supportedPAL.length];
            System.arraycopy(supportedCommon, 0, this.supported, 0, supportedCommon.length);
            System.arraycopy(supportedPAL, 0, this.supported, supportedCommon.length, supportedNTSC.length);
        } else {
            this.supported = new Format[supportedCommon.length + supportedNTSC.length];
            System.arraycopy(supportedCommon, 0, this.supported, 0, supportedCommon.length);
            System.arraycopy(supportedNTSC, 0, this.supported, supportedCommon.length, supportedNTSC.length);
        }
        if (this.formatControl != null) {
            this.formatControl.setSupportedFormats(this.supported);
        }
    }

    private void setCompress(String string) {
        if (string != null && string.length() > 0) {
            int n2 = 0;
            while (n2 < VALID_COMPRESS.length) {
                if (VALID_COMPRESS[n2].equalsIgnoreCase(string)) {
                    this.compressNo = n2;
                    if (this.connected) {
                        this.setCompress(this.compressNo);
                    }
                }
                ++n2;
            }
        }
    }

    private void setCompress(int n2) {
        this.compressNo = n2;
        this.opiCap.setCompress(VALID_COMPRESS[this.compressNo]);
        if (n2 == 1) {
            this.bitrateControl.setRange(60, 1, 200);
            this.setBitRate(60);
        } else {
            this.bitrateControl.setRange(2000, 100, 2500);
            this.setBitRate(2000);
        }
        if (n2 == 2 || n2 == 3) {
            this.qualityControl.setEnabled(false);
            this.bitrateControl.setEnabled(false);
        } else {
            this.qualityControl.setEnabled(true);
            this.bitrateControl.setEnabled(true);
        }
    }

    int getSize() {
        return this.sizeNo;
    }

    Dimension getSizeDimension() {
        int n2 = VALID_SCALE[this.sizeNo];
        int n3 = 640;
        int n4 = 480;
        if (this.signalNo == 1) {
            n3 = 768;
            n4 = 576;
        }
        if (this.compressNo == 1 || this.compressNo == 0) {
            n3 = 704;
            n4 = 576;
        }
        return new Dimension(n3 / n2, n4 / n2);
    }

    void setSize(Dimension dimension) {
        int n2 = 1;
        n2 = dimension.width > 384 ? 1 : (dimension.width >= 320 ? 2 : 4);
        int n3 = 0;
        while (n3 < VALID_SIZES.length) {
            if (VALID_SCALE[n3] == n2) {
                this.sizeNo = n3;
                if (this.connected) {
                    this.setSize(this.sizeNo);
                }
            }
            ++n3;
        }
    }

    void setSize(int n2) {
        int n3 = this.sizeNo;
        this.sizeNo = n2;
        if (!this.opiCap.setScale(VALID_SCALE[this.sizeNo])) {
            this.sizeNo = n3;
        }
    }

    float getSizeFloat() {
        return VALID_SIZES_FLOAT[this.sizeNo];
    }

    float[] getSizesFloat() {
        return VALID_SIZES_FLOAT;
    }

    void setSize(float f2) {
        if (f2 > VALID_SIZES_FLOAT[0]) {
            this.sizeNo = 0;
        } else {
            int n2 = 1;
            while (n2 < VALID_SIZES_FLOAT.length) {
                this.sizeNo = n2;
                if (f2 > VALID_SIZES_FLOAT[n2]) {
                    if (!(VALID_SIZES_FLOAT[n2 - 1] - f2 < f2 - VALID_SIZES_FLOAT[n2])) break;
                    this.sizeNo = n2 - 1;
                    break;
                }
                ++n2;
            }
        }
        this.opiCap.setScale(VALID_SCALE[this.sizeNo]);
    }

    float getQuality() {
        return (float)this.qualityNo / 100.0f;
    }

    void setQuality(float f2) {
        this.qualityNo = (int)(f2 * 100.0f + 0.5f);
        this.opiCap.setQuality(this.qualityNo);
        if (this.capFormat != null && this.capFormat instanceof JPEGFormat) {
            this.capFormat = new JPEGFormat(this.capFormat == null ? null : this.capFormat.getSize(), this.maxDataSize, Format.byteArray, this.getRate(), this.qualityNo / 3, -1);
            if (this.formatControl != null) {
                this.formatControl.setCurrentFormat(this.capFormat);
            }
        }
    }

    int getBitRate() {
        return this.bitrateNo;
    }

    void setBitRate(int n2) {
        this.bitrateNo = n2;
        this.opiCap.setBitRate(this.bitrateNo);
    }

    float getRate() {
        if (this.rateNo == 30) {
            return 29.97f;
        }
        return this.rateNo;
    }

    void setRate(float f2) {
        this.rateNo = (int)((double)f2 + 0.5);
        if (this.rateNo <= 0) {
            this.rateNo = 1;
        }
        this.opiCap.setFrameRate(this.rateNo);
        if (this.capFormat != null) {
            if ("jpeg".equals(this.capFormat.getEncoding())) {
                this.capFormat = new JPEGFormat(this.capFormat.getSize(), this.maxDataSize, Format.byteArray, this.getRate(), this.qualityNo / 3, -1);
            } else if ("h261".equals(this.capFormat.getEncoding()) || "h263".equals(this.capFormat.getEncoding()) || "mpeg".equals(this.capFormat.getEncoding())) {
                this.capFormat = new VideoFormat(this.capFormat.getEncoding(), this.capFormat.getSize(), this.maxDataSize, Format.byteArray, this.getRate());
            } else if ("yuv".equals(this.capFormat.getEncoding())) {
                this.capFormat = new YUVFormat(this.capFormat.getSize(), this.maxDataSize, Format.byteArray, this.getRate(), 32, ((YUVFormat)this.capFormat).getStrideY(), ((YUVFormat)this.capFormat).getStrideUV(), 0, 3, 1);
            } else if ("rgb".equals(this.capFormat.getEncoding())) {
                this.capFormat = new RGBFormat(this.capFormat.getSize(), this.maxDataSize, Format.byteArray, this.getRate(), 16, 63488, 2016, 31, 2, ((RGBFormat)this.capFormat).getLineStride(), 0, -1);
            }
            this.formatControl.setCurrentFormat(this.capFormat);
        }
    }

    public Format setFormat(Format format) {
        Format format2 = null;
        int n2 = 0;
        while (n2 < this.supported.length) {
            if (format.matches(this.supported[n2]) && (format2 = format.intersects(this.supported[n2])) != null) break;
            ++n2;
        }
        if (format2 != null) {
            VideoFormat videoFormat = (VideoFormat)format2;
            if (videoFormat.getEncoding().equals("h261")) {
                this.setCompress("H261");
            } else if (videoFormat.getEncoding().equals("h263")) {
                this.setCompress("H263");
            } else if (videoFormat.getEncoding().equals("jpeg")) {
                this.setCompress("Jpeg");
            } else if (videoFormat.getEncoding().equals("yuv")) {
                this.setCompress("YUV");
            } else {
                this.setCompress("RGB");
            }
            if (videoFormat.getFrameRate() != -1.0f) {
                this.rateControl.setFrameRate(videoFormat.getFrameRate());
            }
            this.setSize(videoFormat.getSize());
            if (!this.connected) {
                this.capFormat = videoFormat;
            }
        }
        return this.capFormat;
    }

    private void doControlPanelHack() {
        if (this.controlFrame != null) {
            ((Component)this.controlFrame).setVisible(true);
            return;
        }
        this.controlFrame = new Frame("OPI Controls");
        this.controlFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)OPISourceStream.this.controlFrame).setVisible(false);
            }
        });
        this.controlFrame.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 1, 1));
        panel.add(this.portControl.getControlComponent());
        panel.add(this.formatControl.getControlComponent());
        this.controlFrame.add((Component)panel, "North");
        panel = new Panel();
        panel.setLayout(new FlowLayout(0, 1, 1));
        panel.add(this.rateControl.getControlComponent());
        panel.add(this.qualityControl.getControlComponent());
        panel.add(this.bitrateControl.getControlComponent());
        this.controlFrame.add((Component)panel, "South");
        this.controlFrame.pack();
        ((Component)this.controlFrame).setVisible(true);
    }

    public Object getOwner() {
        return this.dataSource;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        OPILock = new Integer(0);
        VALID_PORTS = new String[]{"S-VHS", "1", "2"};
        VALID_COMPRESS = new String[]{"H261", "H263", "RGB", "YUV", "JPEG"};
        VIDEO_COMPRESS = new String[]{"h261", "h263", "rgb", "yuv", "jpeg"};
        VALID_SIGNAL = new String[]{"NTSC", "PAL"};
        VALID_SIZES = new String[]{"FCIF", "CIF", "QCIF"};
        VALID_SIZES_FLOAT = new float[]{1.0f, 0.5f, 0.25f};
        VALID_SCALE = new int[]{1, 2, 4};
        SIZE_GRANULARITY = 0.25f;
        jmfSecurity = null;
        securityPrivelege = false;
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        supportedCommon = new Format[]{new VideoFormat("h261", new Dimension(352, 288), -1, Format.byteArray, -1.0f), new VideoFormat("h261", new Dimension(176, 144), -1, Format.byteArray, -1.0f), new VideoFormat("h263", new Dimension(352, 288), -1, Format.byteArray, -1.0f), new VideoFormat("h263", new Dimension(176, 144), -1, Format.byteArray, -1.0f)};
        supportedNTSC = new Format[]{new VideoFormat("jpeg", new Dimension(320, 240), -1, Format.byteArray, -1.0f), new VideoFormat("jpeg", new Dimension(160, 120), -1, Format.byteArray, -1.0f), new VideoFormat("rgb", new Dimension(640, 480), -1, Format.byteArray, -1.0f), new VideoFormat("rgb", new Dimension(320, 240), -1, Format.byteArray, -1.0f), new VideoFormat("rgb", new Dimension(160, 120), -1, Format.byteArray, -1.0f), new VideoFormat("yuv", new Dimension(640, 480), -1, Format.byteArray, -1.0f), new VideoFormat("yuv", new Dimension(320, 240), -1, Format.byteArray, -1.0f), new VideoFormat("yuv", new Dimension(160, 120), -1, Format.byteArray, -1.0f)};
        supportedPAL = new Format[]{new VideoFormat("jpeg", new Dimension(384, 288), -1, Format.byteArray, -1.0f), new VideoFormat("jpeg", new Dimension(192, 144), -1, Format.byteArray, -1.0f), new VideoFormat("rgb", new Dimension(768, 576), -1, Format.byteArray, -1.0f), new VideoFormat("rgb", new Dimension(384, 288), -1, Format.byteArray, -1.0f), new VideoFormat("rgb", new Dimension(192, 144), -1, Format.byteArray, -1.0f), new VideoFormat("yuv", new Dimension(768, 576), -1, Format.byteArray, -1.0f), new VideoFormat("yuv", new Dimension(384, 288), -1, Format.byteArray, -1.0f), new VideoFormat("yuv", new Dimension(192, 144), -1, Format.byteArray, -1.0f)};
    }

    class FormatPanel
    extends Panel {
        private VideoFormatChooser vfc = null;

        FormatPanel(VideoFormatChooser videoFormatChooser) {
            this.vfc = videoFormatChooser;
            this.setLayout(new BorderLayout());
            this.add(OPISourceStream.this.signalControl.getControlComponent(), "North");
            this.add((Component)videoFormatChooser, "Center");
        }

        public void setEnabled(boolean bl) {
            this.vfc.setEnabled(bl);
            OPISourceStream.this.signalControl.getControlComponent().setEnabled(bl);
        }
    }

    class LocalFormatControl
    implements FormatControl,
    Owned {
        OPISourceStream stream;
        private VideoFormatChooser vfc = null;
        private Panel fPanel = null;

        public LocalFormatControl(OPISourceStream oPISourceStream2) {
            this.stream = oPISourceStream2;
        }

        public void setCurrentFormat(VideoFormat videoFormat) {
            if (this.vfc != null) {
                this.vfc.setCurrentFormat(videoFormat);
            }
        }

        public void setSupportedFormats(Format[] formatArray) {
            if (this.vfc != null) {
                Vector<Format> vector = new Vector<Format>();
                int n2 = 0;
                while (n2 < formatArray.length) {
                    if (formatArray[n2] instanceof VideoFormat) {
                        vector.addElement(formatArray[n2]);
                    }
                    ++n2;
                }
                this.vfc.setSupportedFormats(vector);
            }
        }

        public Object getOwner() {
            return this.stream.getOwner();
        }

        public Format getFormat() {
            return this.stream.getFormat();
        }

        public Format setFormat(Format format) {
            return this.stream.setFormat(format);
        }

        public Format[] getSupportedFormats() {
            return this.stream.getSupportedFormats();
        }

        public boolean isEnabled() {
            return OPICapture.isAvailable();
        }

        public void setEnabled(boolean bl) {
        }

        public Component getControlComponent() {
            if (this.vfc == null) {
                this.vfc = new VideoFormatChooser(this.stream.getSupportedFormats(), (VideoFormat)this.stream.getFormat());
                if (OPISourceStream.this.started || !OPICapture.isAvailable()) {
                    this.vfc.setEnabled(false);
                }
                this.fPanel = new FormatPanel(this.vfc);
            }
            return this.fPanel;
        }
    }

    class BitRateControl
    extends BitRateAdapter
    implements Owned {
        OPISourceStream stream;

        public BitRateControl(OPISourceStream oPISourceStream2, int n2, int n3, int n4) {
            super(n2, n3, n4, true);
            this.stream = oPISourceStream2;
        }

        public void setRange(int n2, int n3, int n4) {
            this.min = n3;
            this.max = n4;
            super.setBitRate(n2);
        }

        public void setEnabled(boolean bl) {
        }

        public Object getOwner() {
            return this.stream.getOwner();
        }

        public int getBitRate() {
            return this.stream.getBitRate();
        }

        public int setBitRate(int n2) {
            if (n2 < this.min) {
                n2 = this.min;
            }
            if (n2 > this.max) {
                n2 = this.max;
            }
            this.stream.setBitRate(n2);
            return super.setBitRate(this.stream.getBitRate());
        }

        protected String getName() {
            return "Bit Rate (KB)";
        }
    }

    class LocalQualityControl
    extends QualityAdapter
    implements Owned {
        OPISourceStream stream;

        public LocalQualityControl(OPISourceStream oPISourceStream2, float f2, float f3, float f4) {
            super(f2, f3, f4, true);
            this.stream = oPISourceStream2;
        }

        public void setEnabled(boolean bl) {
        }

        public Object getOwner() {
            return this.stream.getOwner();
        }

        public float getQuality() {
            return this.stream.getQuality();
        }

        public float setQuality(float f2) {
            if (f2 > this.maxValue) {
                f2 = this.maxValue;
            }
            if (f2 < this.minValue) {
                f2 = this.minValue;
            }
            this.stream.setQuality(f2);
            return super.setQuality(this.stream.getQuality());
        }

        public boolean isTemporalSpatialTradeoffSupported() {
            return false;
        }
    }

    class RateControl
    extends FrameRateAdapter
    implements Owned {
        OPISourceStream stream;

        public RateControl(OPISourceStream oPISourceStream2, float f2, float f3, float f4) {
            super(f2, f3, f4, true);
            this.stream = oPISourceStream2;
        }

        public Object getOwner() {
            return this.stream.getOwner();
        }

        public float getFrameRate() {
            return this.stream.getRate();
        }

        public float setFrameRate(float f2) {
            if (f2 < this.min) {
                f2 = this.min;
            }
            if (f2 > this.max) {
                f2 = this.max;
            }
            this.stream.setRate(f2);
            return super.setFrameRate(this.stream.getRate());
        }
    }

    class SignalControl
    extends AtomicControlAdapter
    implements Owned,
    ItemListener {
        OPISourceStream stream;
        String[] validSignals = null;
        int currentSignal;
        Panel panel = null;
        Label labelSignal = null;
        Choice comboSignal = null;

        public SignalControl(OPISourceStream oPISourceStream2, String[] stringArray, int n2) {
            super(new Choice(), false, null);
            this.stream = oPISourceStream2;
            this.validSignals = stringArray;
            this.currentSignal = n2;
        }

        public String getSignal() {
            return this.validSignals[this.currentSignal];
        }

        public String[] getValidSignals() {
            return this.validSignals;
        }

        public void setSignal(String string) {
            int n2 = 0;
            while (n2 < this.validSignals.length) {
                if (this.validSignals[n2].equalsIgnoreCase(string)) {
                    this.currentSignal = n2;
                    this.stream.setSignal(this.currentSignal);
                    this.informListeners();
                    return;
                }
                ++n2;
            }
            System.err.println("OPISourceStream.setSignal() invalid Signal: " + string);
        }

        public Component getControlComponent() {
            if (this.panel == null) {
                this.panel = new Panel(new BorderLayout(6, 6));
                this.labelSignal = new Label("Signal:", 2);
                this.panel.add((Component)this.labelSignal, "West");
                this.comboSignal = (Choice)super.getControlComponent();
                this.comboSignal.addItemListener(this);
                this.panel.add((Component)this.comboSignal, "Center");
                int n2 = 0;
                while (n2 < this.validSignals.length) {
                    this.comboSignal.add(this.validSignals[n2]);
                    ++n2;
                }
                this.comboSignal.select(this.validSignals[this.currentSignal]);
                this.comboSignal.addItemListener(this);
            }
            return this.panel;
        }

        public Object getOwner() {
            return this.stream.getOwner();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                String string = this.comboSignal.getSelectedItem();
                this.setSignal(string);
            }
        }
    }

    class LocalPortControl
    extends AtomicControlAdapter
    implements Owned,
    PortControl,
    ControlChangeListener,
    ItemListener {
        OPISourceStream stream;
        String[] validPorts = null;
        int currentPort = 0;
        Panel panel = null;
        Label labelPort = null;
        Choice comboPort = null;
        int[] PC_PORTS = new int[]{64, 128, 512};

        public LocalPortControl(OPISourceStream oPISourceStream2, String[] stringArray, int n2) {
            super(new Choice(), false, null);
            this.stream = oPISourceStream2;
            this.validPorts = stringArray;
            this.currentPort = n2;
            this.addControlChangeListener(this);
        }

        public synchronized CaptureDeviceInfo getCaptureDeviceInfo() {
            return this.stream.getCaptureDeviceInfo();
        }

        public String getPort() {
            return this.validPorts[this.currentPort];
        }

        public void setPort(String string) {
            int n2 = 0;
            while (n2 < this.validPorts.length) {
                if (this.validPorts[n2].equalsIgnoreCase(string)) {
                    this.currentPort = n2;
                    this.stream.setPort(this.currentPort);
                    this.informListeners();
                    return;
                }
                ++n2;
            }
            System.err.println("OPISourceStream.setPort() invalid port: " + string);
        }

        public Component getControlComponent() {
            if (this.panel == null) {
                this.panel = new Panel(new BorderLayout(6, 6));
                this.labelPort = new Label("Port:", 2);
                this.panel.add((Component)this.labelPort, "West");
                this.comboPort = (Choice)super.getControlComponent();
                this.comboPort.addItemListener(this);
                this.panel.add((Component)this.comboPort, "Center");
                int n2 = 0;
                while (n2 < this.validPorts.length) {
                    this.comboPort.add(this.validPorts[n2]);
                    ++n2;
                }
                this.comboPort.select(this.validPorts[this.currentPort]);
                this.comboPort.addItemListener(this);
            }
            return this.panel;
        }

        public Object getOwner() {
            return this.stream.getOwner();
        }

        public int getPorts() {
            return this.PC_PORTS[this.currentPort];
        }

        public int getSupportedPorts() {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.PC_PORTS.length) {
                n2 |= this.PC_PORTS[n3];
                ++n3;
            }
            return n2;
        }

        public int setPorts(int n2) {
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.PC_PORTS.length) {
                if (n2 == this.PC_PORTS[n4]) {
                    this.currentPort = n4;
                    this.stream.setPort(this.currentPort);
                    this.informListeners();
                    break;
                }
                ++n4;
            }
            return this.PC_PORTS[this.currentPort];
        }

        public void controlChanged(ControlChangeEvent controlChangeEvent) {
            if (this.comboPort != null) {
                this.comboPort.select(this.validPorts[this.currentPort]);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                String string = this.comboPort.getSelectedItem();
                this.setPort(string);
            }
        }
    }
}

