/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.video;

import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.renderer.video.BasicVideoRenderer;
import com.sun.media.util.DynamicPlugIn;
import com.sun.media.util.MediaThread;
import com.sun.media.util.WindowUtil;
import java.io.File;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class SunRayRenderer
extends BasicVideoRenderer
implements DynamicPlugIn {
    private static boolean available = false;
    private static int jawtAvail = WindowUtil.getJAWTAvail();
    private static boolean debug = false;
    private int blitter = 0;
    protected Object data = null;
    private int offsetX = 0;
    private int offsetY = 0;
    private int yuvType;
    private int yOff;
    private int uOff;
    private int vOff;
    private int yStride;
    private int uvStride;
    private int lastOutWidth = -1;
    private int lastOutHeight = -1;
    private boolean firstTime = true;
    private EventThread xeventThread = null;

    private native void srSetJAWT(int var1);

    private synchronized native boolean srInitialize();

    private synchronized native boolean srDisplayIsSunRay();

    private synchronized native boolean srSetComponent(Object var1);

    private synchronized native boolean srSetInputFormat(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private synchronized native boolean srSetOutputSize(int var1, int var2);

    private synchronized native boolean srDraw(Object var1);

    private synchronized native boolean srFree();

    private synchronized native boolean srEventCheck();

    public SunRayRenderer() {
        super("SunRay Renderer");
        if (debug) {
            System.err.println("SunRayRenderer <init>() entered");
        }
        this.supportedFormats = new VideoFormat[]{new YUVFormat(1), new YUVFormat(2), new YUVFormat(4), new YUVFormat(8)};
        if (!available) {
            return;
        }
        this.srSetJAWT(jawtAvail);
        if (!this.srDisplayIsSunRay()) {
            if (debug) {
                System.err.println("SunRayRenderer display is not a Sun Ray ");
            }
            available = false;
            return;
        }
        if (!this.srInitialize()) {
            available = false;
        }
        if (debug) {
            System.err.println("SunRayRenderer <init>() completed");
        }
    }

    public void open() throws ResourceUnavailableException {
        if (debug) {
            System.err.println("SunRayRenderer open() entered");
        }
        if (!available) {
            if (debug) {
                System.err.println("SunRayRenderer Sun Ray not available");
            }
            throw new ResourceUnavailableException("Sun Ray not available");
        }
    }

    public void reset() {
    }

    public synchronized void close() {
        if (debug) {
            System.err.println("SunRayRenderer close() entered");
        }
        if (this.xeventThread != null) {
            this.xeventThread.stopChecking();
            this.xeventThread.interrupt();
            while (this.xeventThread.isAlive()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.xeventThread = null;
        }
        if (available && this.blitter != 0) {
            this.srFree();
        }
        if (debug) {
            System.err.println("SunRayRenderer close() complete");
        }
    }

    public Format setInputFormat(Format format) {
        if (debug) {
            System.err.println("SunRayRenderer setInputFormat() entered");
        }
        if (!available) {
            if (debug) {
                System.err.println("SunRayRenderer setInputFormat !available");
            }
            return null;
        }
        if (!(format instanceof YUVFormat)) {
            return null;
        }
        if (super.setInputFormat(format) != null) {
            if (!(this.inputFormat instanceof YUVFormat)) {
                return null;
            }
            YUVFormat yUVFormat = (YUVFormat)this.inputFormat;
            this.yuvType = yUVFormat.getYuvType();
            this.yOff = yUVFormat.getOffsetY();
            this.uOff = yUVFormat.getOffsetU();
            this.vOff = yUVFormat.getOffsetV();
            this.yStride = yUVFormat.getStrideY();
            this.uvStride = yUVFormat.getStrideUV();
            int n2 = 4;
            int n3 = 4;
            if (this.yuvType == 4) {
                n2 = 2;
                n3 = 2;
            } else if (this.yuvType == 8) {
                n2 = 1;
                n3 = 1;
            } else if (this.yuvType == 2) {
                n2 = 2;
                n3 = 2;
            }
            this.srSetInputFormat(this.inWidth, this.inHeight, this.yOff, this.uOff, this.vOff, this.yStride, this.uvStride, n2, n3);
            if (this.outWidth == -1 || this.outHeight == -1) {
                this.outWidth = this.inWidth;
                this.outHeight = this.inHeight;
            }
            if (this.component != null) {
                this.component.setSize(this.outWidth, this.outHeight);
            }
            if (debug) {
                System.err.println("SunRayRenderer setInputFormat() returned " + format);
            }
            return format;
        }
        return null;
    }

    protected void setAvailable(boolean bl) {
        if (debug) {
            System.err.println("SunRayRenderer setAvailable() entered");
        }
        Thread thread = null;
        super.setAvailable(bl);
        SunRayRenderer sunRayRenderer = this;
        synchronized (sunRayRenderer) {
            if (bl) {
                if (this.xeventThread == null) {
                    this.xeventThread = new EventThread(this);
                    this.xeventThread.start();
                }
            } else if (this.xeventThread != null) {
                this.xeventThread.stopChecking();
                this.xeventThread.interrupt();
                thread = this.xeventThread;
                this.xeventThread = null;
                this.data = null;
            }
        }
        if (thread != null) {
            while (thread.isAlive()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected synchronized void removingComponent() {
        if (debug) {
            System.err.println("SunRayRenderer removingComponent() entered");
        }
        if (this.blitter != 0) {
            this.srFree();
        }
    }

    protected int doProcess(Buffer buffer) {
        return this.doProcess(buffer, false);
    }

    protected int doProcess(Buffer buffer, boolean bl) {
        if (!available || this.component == null) {
            return 0;
        }
        SunRayRenderer sunRayRenderer = this;
        synchronized (sunRayRenderer) {
            int n2;
            if (!this.componentAvailable) {
                int n3 = 0;
                return n3;
            }
            if (this.blitter == 0 || this.firstTime) {
                this.firstTime = false;
                if (this.blitter == 0) {
                    this.srInitialize();
                }
                if ((n2 = WindowUtil.getWindowHandle(this.component)) != 0) {
                    this.srSetComponent(this.component);
                    this.inputFormat = new VideoFormat(null);
                }
                if (this.blitter == 0) {
                    if (debug) {
                        System.err.println("Could not create blitter");
                    }
                    int n4 = 1;
                    return n4;
                }
            }
            if (!bl) {
                if (!buffer.getFormat().equals(this.inputFormat) && this.setInputFormat(buffer.getFormat()) == null) {
                    n2 = 1;
                    return n2;
                }
                this.data = buffer.getData();
            } else if (this.data == null) {
                n2 = 1;
                return n2;
            }
            if (this.outWidth > 0 && this.outHeight > 0) {
                if (this.outWidth != this.lastOutWidth || this.outHeight != this.lastOutHeight) {
                    this.outWidth &= 0xFFFFFFFE;
                    this.lastOutWidth = this.outWidth;
                    this.lastOutHeight = this.outHeight;
                    this.srSetOutputSize(this.outWidth, this.outHeight);
                    if (debug) {
                        System.err.println("SunRayRenderer srSetOutputSize() " + this.outWidth + "x" + this.outHeight);
                    }
                }
                int n5 = this.srDraw(this.data) ? 0 : 1;
                return n5;
            }
            int n6 = 1;
            return n6;
        }
    }

    public Format[] getBaseInputFormats() {
        if (debug) {
            System.err.println("SunRayRenderer getBaseInputFormats() entered");
        }
        Format[] formatArray = new Format[]{new YUVFormat()};
        return formatArray;
    }

    public Format[] getBaseOutputFormats() {
        if (debug) {
            System.err.println("SunRayRenderer getBaseOutputFormats() entered");
        }
        Format[] formatArray = new Format[]{};
        return formatArray;
    }

    protected synchronized void repaint() {
        if (debug) {
            System.err.println("SunRayRenderer repaint() entered");
        }
        if (!this.isStarted() && this.data != null) {
            this.doProcess(null, true);
        }
    }

    static {
        if (debug) {
            System.err.println("SunRayRenderer static entered");
        }
        try {
            JMFSecurity jMFSecurity = JMFSecurityManager.getJMFSecurity();
            if (jMFSecurity != null && jMFSecurity.getClass().getName().equals("com.sun.media.NetscapeSecurity")) {
                if (debug) {
                    System.err.println("SunRayRenderer under Netscape");
                }
                available = false;
            } else {
                File file = new File("/opt/SUNWut/lib/libutmedia.so");
                if (file.exists()) {
                    JMFSecurityManager.loadLibrary("jmutil");
                    JMFSecurityManager.loadLibrary("jmsunray");
                    available = true;
                } else {
                    if (debug) {
                        System.err.println("SunRayRenderer no libutmedia");
                    }
                    available = false;
                }
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (debug) {
                System.err.println("SunRayRenderer load libjmsunray failed");
            }
            available = false;
        }
        catch (SecurityException securityException) {
            if (debug) {
                System.err.println("SunRayRenderer security exception");
            }
            available = false;
        }
        catch (NullPointerException nullPointerException) {
            if (debug) {
                System.err.println("SunRayRenderer null pointer exception");
            }
            available = false;
        }
        catch (Exception exception) {
            System.err.println("SunRayRenderer exception: " + exception);
            exception.printStackTrace();
            available = false;
        }
    }

    class EventThread
    extends MediaThread {
        SunRayRenderer renderer;
        private boolean checkEvents = true;

        public EventThread(SunRayRenderer sunRayRenderer2) {
            super("SunRayRenderer Event Thread");
            this.renderer = sunRayRenderer2;
            this.useVideoPriority();
        }

        public void stopChecking() {
            this.checkEvents = false;
        }

        public void run() {
            while (this.checkEvents) {
                if (this.renderer.srEventCheck()) {
                    this.renderer.repaint();
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.renderer = null;
        }
    }
}

