/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.util.LinkedList;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.impl.util.Cache;
import net.jxta.impl.util.CacheEntry;
import net.jxta.impl.util.CacheEntryListener;
import net.jxta.impl.util.ResourceAccount;
import net.jxta.impl.util.ResourceDispatcher;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class EndpointDemuxListener
implements EndpointListener {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$EndpointDemuxListener == null ? (class$net$jxta$impl$endpoint$EndpointDemuxListener = EndpointDemuxListener.class$("net.jxta.impl.endpoint.EndpointDemuxListener")) : class$net$jxta$impl$endpoint$EndpointDemuxListener).getName());
    private static ResourceDispatcher threadDispatcher = new ResourceDispatcher(100L, 1L, 3L, 100L, 50L, true);
    private static ResourceDispatcher messageDispatcher = new ResourceDispatcher(200L, 10240L, 51200L, 4096000L, 1024000L, false);
    private static Cache allSources = new Cache(100L, new MyCacheListener());
    private LinkedList messageQueue = new LinkedList();
    private boolean keepGoing = true;
    private EndpointListener listener = null;
    private int nbOfQueuedMessages = 0;
    private int nbOfDeQueuedMessages = 0;
    private String name = null;
    private ResourceAccount myAccount = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$EndpointDemuxListener;

    private void enQueue(MessageFromSource m) {
        this.messageQueue.addLast(m);
        ++this.nbOfQueuedMessages;
    }

    private MessageFromSource deQueue() {
        if (!this.keepGoing || this.messageQueue.size() == 0) {
            return null;
        }
        Object o = this.messageQueue.removeFirst();
        ++this.nbOfDeQueuedMessages;
        return (MessageFromSource)o;
    }

    public EndpointListener getListener() {
        return this.listener;
    }

    public EndpointDemuxListener(EndpointListener listener) {
        this("Unknown", listener);
    }

    public EndpointDemuxListener(String name, EndpointListener listener) {
        this.listener = listener;
        this.name = name;
        ResourceDispatcher resourceDispatcher = threadDispatcher;
        synchronized (resourceDispatcher) {
            this.myAccount = threadDispatcher.newAccount(1L, -1L, this);
            threadDispatcher.notify();
        }
        Thread.yield();
    }

    public void unregistered() {
        LinkedList oldQueue;
        ResourceDispatcher resourceDispatcher = threadDispatcher;
        synchronized (resourceDispatcher) {
            this.keepGoing = false;
            oldQueue = this.messageQueue;
            this.messageQueue = new LinkedList();
            threadDispatcher.notify();
        }
        Thread.yield();
        ResourceDispatcher resourceDispatcher2 = messageDispatcher;
        synchronized (resourceDispatcher2) {
            int sz = oldQueue.size();
            while (sz-- > 0) {
                MessageFromSource mfs = (MessageFromSource)oldQueue.removeFirst();
                mfs.src.inNeed(false);
                mfs.src.releaseQuantity(mfs.msg.getRawSize());
                if (!mfs.src.isIdle()) continue;
                allSources.stickyCacheEntry((CacheEntry)mfs.src.getUserObject(), false);
            }
            messageDispatcher.notify();
        }
    }

    public EndpointDemuxListener doOne() {
        ResourceAccount next;
        ResourceDispatcher resourceDispatcher;
        block15: {
            MessageFromSource mfs;
            ResourceDispatcher resourceDispatcher2 = threadDispatcher;
            synchronized (resourceDispatcher2) {
                mfs = this.deQueue();
                this.myAccount.inNeed(this.messageQueue.size() != 0);
                threadDispatcher.notify();
            }
            if (mfs != null) {
                Message message;
                resourceDispatcher = messageDispatcher;
                synchronized (resourceDispatcher) {
                    mfs.src.inNeed(false);
                    mfs.src.releaseQuantity(mfs.msg.getRawSize());
                    if (mfs.src.isIdle()) {
                        allSources.stickyCacheEntry((CacheEntry)mfs.src.getUserObject(), false);
                    }
                    message = mfs.msg;
                    messageDispatcher.notify();
                }
                try {
                    EndpointAddress srcAddr = message.getSourceAddress();
                    EndpointAddress dstAddr = message.getDestinationAddress();
                    this.listener.processIncomingMessage(message, srcAddr, dstAddr);
                }
                catch (Throwable ignored) {
                    if (!LOG.isEnabledFor(Priority.FATAL)) break block15;
                    LOG.fatal((Object)("Uncaught Throwable in thread : " + Thread.currentThread().getName()), ignored);
                }
            }
        }
        resourceDispatcher = threadDispatcher;
        synchronized (resourceDispatcher) {
            this.myAccount.inNeed(this.messageQueue.size() > 0);
            next = this.myAccount.releaseItem();
            if (!this.keepGoing && this.myAccount.isIdle()) {
                this.myAccount.close();
            }
            threadDispatcher.notify();
        }
        if (next == null) {
            return null;
        }
        return (EndpointDemuxListener)next.getUserObject();
    }

    public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        boolean obtained;
        ResourceAccount msgSrcAccount;
        if (!this.keepGoing) {
            return;
        }
        String srcAddrStr = srcAddr.toString();
        ResourceDispatcher resourceDispatcher = messageDispatcher;
        synchronized (resourceDispatcher) {
            CacheEntry ce = allSources.getCacheEntry(srcAddrStr);
            if (ce == null) {
                msgSrcAccount = messageDispatcher.newAccount(1L, -1L, null);
                if (msgSrcAccount.getNbReserved() < 1L) {
                    msgSrcAccount.close();
                    allSources.purge(10);
                    msgSrcAccount = messageDispatcher.newAccount(1L, -1L, null);
                }
                allSources.put(srcAddrStr, msgSrcAccount);
                ce = allSources.getCacheEntry(srcAddrStr);
                msgSrcAccount.setUserObject(ce);
            } else {
                msgSrcAccount = (ResourceAccount)ce.getValue();
            }
            if (!msgSrcAccount.obtainQuantity(message.getRawSize())) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"Peer exceeds queuing limits; msg discarded.");
                }
            } else {
                allSources.stickyCacheEntry(ce, true);
            }
            messageDispatcher.notify();
        }
        message.setSourceAddress(srcAddr);
        message.setDestinationAddress(dstAddr);
        ResourceDispatcher resourceDispatcher2 = threadDispatcher;
        synchronized (resourceDispatcher2) {
            this.enQueue(new MessageFromSource(message, msgSrcAccount));
            obtained = this.myAccount.obtainItem();
            threadDispatcher.notify();
        }
        Thread.yield();
        if (obtained) {
            new ListenerThread(this);
        } else if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"Listener exceeds threads limits; msg waits.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ListenerThread
    implements Runnable {
        EndpointDemuxListener current;

        ListenerThread(EndpointDemuxListener current) {
            this.current = current;
            new Thread(this).start();
        }

        public void run() {
            while (this.current != null) {
                this.current = this.current.doOne();
            }
        }
    }

    class MessageFromSource {
        Message msg;
        ResourceAccount src;

        MessageFromSource(Message msg, ResourceAccount src) {
            this.msg = msg;
            this.src = src;
        }
    }

    static class MyCacheListener
    implements CacheEntryListener {
        MyCacheListener() {
        }

        public void purged(CacheEntry entry) {
            ((ResourceAccount)entry.getValue()).close();
        }
    }
}

