/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointProtocol;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.exception.DiscardQueryException;
import net.jxta.exception.NoResponseException;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ResendQueryException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.Address;
import net.jxta.impl.endpoint.EndpointRouterMessage;
import net.jxta.impl.endpoint.LoopbackMessenger;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.EndpointAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class EndpointRouter
implements EndpointProtocol,
QueryHandler,
EndpointListener,
Module {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$EndpointRouter == null ? (class$net$jxta$impl$endpoint$EndpointRouter = EndpointRouter.class$("net.jxta.impl.endpoint.EndpointRouter")) : class$net$jxta$impl$endpoint$EndpointRouter).getName());
    private Hashtable routedRoutes = null;
    private Hashtable directRoutes = null;
    protected String localPeerAddr = null;
    protected ID localPeerId = null;
    private EndpointService endpoint = null;
    private DiscoveryService discovery = null;
    private PeerGroup group = null;
    private static final String TypeTag = "Type";
    private static final String RoutingPeerIdTag = "RoutingPeer";
    private static final String RoutingPeerAdvTag = "RoutingPeerAdv";
    private static final String DestPeerIdTag = "DestPeer";
    private static final String NbOfHopsTag = "NbOfHops";
    public static final String GatewayForwardTag = "GatewayForward";
    public static final String GatewayReverseTag = "GatewayReverse";
    private static final String VersionTag = "Version";
    private static final String RouteQuery = "RouteQuery";
    private static final String RouteResponse = "RouteResponse";
    private static final String PingQuery = "PingQuery";
    private static final String PingResponse = "PingResponse";
    private static final String NACK = "NACK";
    private static final int acceptableVersion = 3;
    private static final int currentVersion = 3;
    private ResolverService resolver = null;
    private boolean servicesInitialized = false;
    private int qid = 0;
    private static final String routerSName = "EndpointRouter";
    private static String routerSParam = null;
    private EndpointAdvertisement myAdv = null;
    private String localPeerAdv = null;
    protected Vector localGateway = new Vector(1);
    private static String routerPName = "jxta";
    private Vector pendingQueries = new Vector();
    private Hashtable triedAndFailed = new Hashtable();
    static /* synthetic */ Class class$net$jxta$impl$endpoint$EndpointRouter;

    public boolean allowOverLoad() {
        return true;
    }

    public int startApp(String[] arg) {
        this.discovery = this.group.getDiscoveryService();
        this.resolver = this.group.getResolverService();
        if (null == this.discovery && LOG.isEnabledFor(Priority.WARN)) {
            LOG.warn((Object)"discovery service is not available!");
        }
        if (null == this.resolver && LOG.isEnabledFor(Priority.WARN)) {
            LOG.warn((Object)"resolver service is not available!");
        }
        this.resolver.registerHandler(routerSName, this);
        return 0;
    }

    public void stopApp() {
        if (this.resolver != null) {
            this.resolver.unregisterHandler(routerSName);
        }
        if (this.endpoint != null) {
            this.endpoint.removeListener(routerSName + routerSParam, this);
            this.endpoint.removeEndpointProtocol(this);
        }
    }

    public void init(PeerGroup g, ID assignedID, Advertisement impl) throws PeerGroupException {
        block3: {
            this.group = g;
            this.endpoint = g.getEndpointService();
            this.localPeerAdv = this.advToString(g.getPeerAdvertisement());
            this.localPeerId = g.getPeerID();
            this.localPeerAddr = routerPName + "://" + this.group.getPeerID().getUniqueValue().toString();
            routerSParam = g.getPeerGroupID().getUniqueValue().toString();
            try {
                this.localGateway.add(0, this.localPeerAddr);
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block3;
                LOG.warn((Object)"Cannot set myself as a gateway");
            }
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("localPeerId = " + this.localPeerId));
        }
        this.directRoutes = new Hashtable();
        this.routedRoutes = new Hashtable();
        this.endpoint.addListener(routerSName + routerSParam, this);
        this.endpoint.addEndpointProtocol(this);
    }

    public boolean isConnectionOriented() {
        return false;
    }

    public boolean allowRouting() {
        return false;
    }

    public EndpointAddress getPublicAddress() {
        return this.endpoint.newEndpointAddress(this.localPeerAddr);
    }

    public String getProtocolName() {
        return routerPName;
    }

    public void propagate(Message srcMsg, String pName, String pParam, String prunePeer) throws IOException {
    }

    public void close() {
        this.endpoint.removeListener(routerSName + routerSParam, this);
    }

    private String advToString(Advertisement adv) {
        StringWriter out = new StringWriter();
        MimeMediaType displayAs = new MimeMediaType("text/xml");
        try {
            StructuredTextDocument doc = (StructuredTextDocument)adv.getDocument(displayAs);
            doc.sendToWriter(out);
            return out.toString();
        }
        catch (Exception all) {
            return null;
        }
    }

    public Enumeration getPeerAdv(String pId) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("getPeerAdv for : " + pId));
        }
        if (this.discovery == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"  no discovery");
            }
            return null;
        }
        try {
            EndpointAddress asAddress = this.endpoint.newEndpointAddress(pId);
            URL asUrl = IDFactory.jxtaURL("urn", "", "jxta:" + asAddress.getProtocolAddress());
            String realPeerID = asUrl.toString();
            return this.discovery.getLocalAdvertisements(0, "PID", realPeerID);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("  failed with " + e));
            }
            return null;
        }
    }

    private synchronized void waitABit() {
        block2: {
            try {
                this.wait(500L);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block2;
                LOG.debug((Object)("getAddress got an exception " + e + " while waiting"), (Throwable)e);
            }
        }
    }

    public EndpointAddress getAddress(String pId) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"getAddress for ");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("      peer= " + pId));
        }
        Route route = null;
        int count = 0;
        while (true) {
            this.learnLocalRoute(pId);
            if (this.isLocalRoute(pId)) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Found local address: " + pId + " -> " + this.getLocalRoute(pId).toString()));
                }
                return this.getLocalRoute(pId);
            }
            route = this.getRoute(pId);
            EndpointAddress addr = null;
            if (route != null) {
                try {
                    addr = this.getLocalRoute(route.router);
                    if (addr != null) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("Found remote address: " + pId + " -> " + addr.toString()));
                        }
                    } else if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Found no reachable route to " + pId));
                    }
                    return addr;
                }
                catch (Exception e) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("getAddress for " + pId + "\n     failed with "), (Throwable)e);
                    }
                    return null;
                }
            }
            if (count == 0) {
                this.findRoute(pId);
            }
            if (++count > 120) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break;
                LOG.debug((Object)("getAddress is giving up for " + pId));
                break;
            }
            this.waitABit();
        }
        return null;
    }

    public EndpointAddress getBestLocalRoute(Enumeration addrs) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"getBestLocalRoute:");
        }
        EndpointProtocol proto = null;
        EndpointAddress addr = null;
        EndpointAddress bestAddr = null;
        String protoName = null;
        boolean direct = false;
        boolean fast = false;
        while (addrs.hasMoreElements()) {
            try {
                addr = (EndpointAddress)addrs.nextElement();
                protoName = addr.getProtocolName();
                if (protoName.equals(this.getProtocolName())) continue;
                proto = this.endpoint.getEndpointProtocolByName(protoName);
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("getBestLocalRoute trying: " + addr.toString() + " on protocol " + proto.getProtocolName()));
                }
                if (proto == null || !proto.allowRouting() || !proto.ping(addr)) continue;
                if (bestAddr == null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Found: " + addr.toString()));
                    }
                    bestAddr = addr;
                }
                if (proto.isConnectionOriented()) {
                    if (direct) {
                        if (!this.isFast(proto)) continue;
                        return addr;
                    }
                    direct = true;
                    if (this.isFast(proto)) {
                        return addr;
                    }
                    bestAddr = addr;
                    continue;
                }
                if (direct) continue;
                bestAddr = addr;
            }
            catch (Exception e) {
                this.triedAndFailed.put(addr, new Long(System.currentTimeMillis()));
            }
        }
        return bestAddr;
    }

    boolean isFast(EndpointProtocol p) {
        String name = p.getProtocolName();
        return name.equals("tcp") || name.equals("beep");
    }

    public boolean ping(EndpointAddress addr) {
        try {
            return this.getAddress(addr.getProtocolName() + "://" + addr.getProtocolAddress()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized boolean isLocalRoute(String pId) {
        return this.directRoutes.containsKey(pId);
    }

    public synchronized EndpointAddress getLocalRoute(String pId) {
        return (EndpointAddress)this.directRoutes.get(pId);
    }

    private synchronized void learnLocalRouteSync(String pId, EndpointAddress addr) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"learnLocalRoute:");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("   peerId = " + pId));
        }
        try {
            this.directRoutes.put(pId, addr.clone());
        }
        catch (Exception e) {
            return;
        }
        try {
            this.routedRoutes.remove(pId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyAll();
    }

    public void learnLocalRoute(String pId) {
        if (this.directRoutes.containsKey(pId)) {
            return;
        }
        EndpointAddress addr = this.checkPeer(pId);
        if (addr == null) {
            return;
        }
        this.learnLocalRouteSync(pId, addr);
    }

    public synchronized void removeLocalRoute(String pId) {
        try {
            this.directRoutes.remove(pId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void brokenRoute(String peer) {
        if (this.isLocalRoute(peer)) {
            this.removeLocalRoute(peer);
            return;
        }
        Route route = this.getRoute(peer);
        if (route != null) {
            this.removeLocalRoute(route.router);
            this.removeRoute(peer);
        }
    }

    public synchronized boolean isRoute(String pId) {
        return this.routedRoutes.get(pId) != null;
    }

    public synchronized Route getRoute(String pId) {
        return (Route)this.routedRoutes.get(pId);
    }

    private boolean checkRoute(Route r) {
        if (r == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"route is null");
            }
            return false;
        }
        if (r.gateways == null || r.gateways.size() == 0) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"route is empty");
            }
            return false;
        }
        if (r.gateways.contains(this.localPeerAddr)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"route contains this peer - loopback");
            }
            return false;
        }
        Vector peers = new Vector();
        int i = 0;
        while (i < r.gateways.size()) {
            try {
                if (peers.contains((String)r.gateways.elementAt(i))) {
                    return false;
                }
                peers.add(r.gateways.elementAt(i));
            }
            catch (Exception ez1) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("Exception while processing route checking: " + ez1));
                }
                return false;
            }
            ++i;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"route is ok");
        }
        return true;
    }

    private synchronized boolean setRoute(Route r) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"setRoute:");
        }
        if (r == null) {
            return false;
        }
        r.display();
        if (this.directRoutes.containsKey(r.dest)) {
            return false;
        }
        if (!this.checkRoute(r)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Route is invalid");
            }
            return false;
        }
        if (!this.directRoutes.containsKey(r.router)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Unreachable route - ignore");
            }
            return false;
        }
        try {
            String lastInVector = (String)r.gateways.elementAt(0);
            if (lastInVector != null && !lastInVector.equals(r.router)) {
                r.gateways.add(0, r.router);
            }
        }
        catch (Exception ez1) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"Got an empty route - discard");
            }
            return false;
        }
        try {
            this.routedRoutes.put(r.dest, r);
            this.notifyAll();
            return true;
        }
        catch (Exception e2) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("   failed with " + e2));
            }
            return false;
        }
    }

    public synchronized void removeRoute(String pId) {
        try {
            this.routedRoutes.remove(pId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        block44: {
            EndpointRouterMessage routerMsg;
            int nbOfHops;
            EndpointAddress origDstAddr;
            EndpointAddress origSrcAddr;
            String lastHop;
            String destPeer;
            String srcPeer;
            block43: {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"processIncomingMessage starts");
                }
                InputStream ip = null;
                srcPeer = null;
                destPeer = null;
                lastHop = null;
                origSrcAddr = null;
                origDstAddr = null;
                nbOfHops = 0;
                routerMsg = null;
                MessageElement routerElement = msg.getElement("JxtaEndpointRouter");
                try {
                    int i;
                    Vector g;
                    if (routerElement == null) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"processIncomingMessage: no routing info");
                        }
                        this.endpoint.demux(msg);
                        return;
                    }
                    ip = routerElement.getStream();
                    if (ip == null) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"processIncomingMessage: invalid routing info");
                        }
                        this.endpoint.demux(msg);
                        return;
                    }
                    routerMsg = new EndpointRouterMessage(ip);
                    try {
                        nbOfHops = Integer.parseInt(routerMsg.getNbOfHops());
                    }
                    catch (Exception ez1) {
                        nbOfHops = 0;
                    }
                    origSrcAddr = this.endpoint.newEndpointAddress(routerMsg.getSrcAddress());
                    origDstAddr = this.endpoint.newEndpointAddress(routerMsg.getDestAddress());
                    srcPeer = origSrcAddr.getProtocolName() + "://" + origSrcAddr.getProtocolAddress();
                    destPeer = origDstAddr.getProtocolName() + "://" + origDstAddr.getProtocolAddress();
                    lastHop = routerMsg.getLastHop();
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Process Incoming : \n\tsrcPeer= " + srcPeer + "\n\tdestPeer= " + destPeer + "\n\tlastHop= " + (null != lastHop ? lastHop : "null")));
                    }
                    if ((g = routerMsg.getForwardGateways()) != null) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"    Forward Gateways:");
                        }
                        i = 0;
                        while (i < g.size()) {
                            block41: {
                                try {
                                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block41;
                                    LOG.debug((Object)("   [" + i + "] " + (String)g.elementAt(i)));
                                }
                                catch (Exception ez1) {
                                    break;
                                }
                            }
                            ++i;
                        }
                    }
                    if ((g = routerMsg.getReverseGateways()) != null) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"    Reverse Gateways:");
                        }
                        i = 0;
                        while (i < g.size()) {
                            block42: {
                                try {
                                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block42;
                                    LOG.debug((Object)("   [" + i + "] " + (String)g.elementAt(i)));
                                }
                                catch (Exception ez1) {
                                    break block43;
                                }
                            }
                            ++i;
                        }
                        break block43;
                    }
                    if (nbOfHops >= 1 && lastHop != null) {
                        Vector<String> tmp = new Vector<String>(1);
                        tmp.add(lastHop);
                        routerMsg.setReverseGateways(tmp);
                    }
                }
                catch (Exception badHdr) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"Bad routing header or bad message. Message dropped.");
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("exception: " + badHdr));
                    }
                    return;
                }
            }
            if (srcPeer != null && srcPeer.equals(this.localPeerAddr)) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"processIncomingMessage: dropped loopback");
                }
                return;
            }
            try {
                if (lastHop != null) {
                    this.triedAndFailed.remove(lastHop);
                    this.learnLocalRoute(lastHop);
                }
            }
            catch (Exception whatever) {
                whatever.printStackTrace();
            }
            try {
                Route reverseRoute;
                if (destPeer.equals(this.localPeerAddr)) {
                    if (nbOfHops != 0) {
                        this.setRoute(new Route(srcPeer, lastHop, nbOfHops, routerMsg.getReverseGateways()));
                    }
                    routerMsg.setForwardGateways(null);
                    msg.removeElement("JxtaEndpointRouter");
                    msg.addElement(msg.newMessageElement("JxtaEndpointRouter", null, routerMsg.getInputStream()));
                    msg.setSourceAddress(origSrcAddr);
                    msg.setDestinationAddress(origDstAddr);
                    this.endpoint.demux(msg);
                    return;
                }
                boolean headerIsChanged = false;
                String nextHop = null;
                if (routerMsg.getForwardGateways() != null) {
                    nextHop = this.getNextHop(routerMsg.getForwardGateways());
                }
                if (nextHop == null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"No next hop in forward gateways - Try to use destination as next hop");
                    }
                    nextHop = destPeer;
                    routerMsg.setForwardGateways(null);
                    reverseRoute = this.getRoute(destPeer);
                    if (reverseRoute != null) {
                        routerMsg.setReverseGateways(reverseRoute.gateways);
                    }
                    headerIsChanged = true;
                }
                if (this.isLocalRoute(destPeer) && !nextHop.equals(destPeer)) {
                    reverseRoute = this.getRoute(destPeer);
                    if (reverseRoute != null) {
                        routerMsg.setReverseGateways(reverseRoute.gateways);
                    }
                    headerIsChanged = true;
                    nextHop = destPeer;
                }
                if (headerIsChanged) {
                    msg.removeElement("JxtaEndpointRouter");
                    msg.addElement(msg.newMessageElement("JxtaEndpointRouter", null, routerMsg.getInputStream()));
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("forwarding to " + nextHop));
                }
                EndpointMessenger messenger = this.getTransportMessenger(nextHop, true);
                RouterMessenger routerMessenger = new RouterMessenger(messenger, origDstAddr, this.endpoint, this, false);
                routerMessenger.sendMessage(msg);
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Message has been forwarded to the next hop");
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block44;
                LOG.debug((Object)("failed to deliver or forward: " + e));
            }
        }
    }

    private String getNextHop(Vector v) {
        if (v == null || v.size() == 0) {
            return null;
        }
        String nextHop = null;
        int i = v.indexOf(this.localPeerAddr);
        if (i == -1) {
            try {
                nextHop = (String)v.elementAt(0);
            }
            catch (Exception ez1) {
                return null;
            }
            return nextHop;
        }
        try {
            nextHop = (String)v.elementAt(i + 1);
        }
        catch (Exception ez1) {
            return null;
        }
        return nextHop;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EndpointAddress checkPeer(String peer) {
        Long lastTry;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("checkPeer peer= " + peer));
        }
        if ((lastTry = (Long)this.triedAndFailed.get(peer)) != null) {
            long diff = System.currentTimeMillis() - lastTry;
            if (diff > 0L && diff < 300000L) {
                return null;
            }
            this.triedAndFailed.remove(peer);
        }
        Enumeration advs = null;
        PeerAdvertisement adv = null;
        try {
            advs = this.getPeerAdv(peer);
            if (advs == null || !advs.hasMoreElements()) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   no advertisement");
                }
                return null;
            }
            block4: while (advs.hasMoreElements()) {
                adv = (PeerAdvertisement)advs.nextElement();
                TextElement endpParam = (TextElement)((Object)adv.getServiceParam(PeerGroup.endpointClassID));
                if (endpParam == null) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                    LOG.debug((Object)"checkPeer: no Endpoint Params");
                    continue;
                }
                Enumeration endps = endpParam.getChildren("Addr");
                if (!endps.hasMoreElements()) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                    LOG.debug((Object)"checkPeer: no Addresses in adv");
                    continue;
                }
                Vector<EndpointAddress> addrs = new Vector<EndpointAddress>();
                while (true) {
                    if (!endps.hasMoreElements()) {
                        if (addrs.size() <= 0) continue block4;
                        EndpointAddress bestAddr = null;
                        bestAddr = this.getBestLocalRoute(addrs.elements());
                        if (bestAddr == null) continue block4;
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"found direct route");
                        }
                        return bestAddr;
                    }
                    String saddr = "";
                    try {
                        saddr = ((TextElement)endps.nextElement()).getTextValue();
                        addrs.addElement(this.endpoint.newEndpointAddress(saddr));
                    }
                    catch (Exception e) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                        LOG.debug((Object)"bad address");
                    }
                }
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("    failed with " + e));
            }
            this.triedAndFailed.put(peer, new Long(System.currentTimeMillis()));
            return null;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"   did not find a good route");
        }
        this.triedAndFailed.put(peer, new Long(System.currentTimeMillis()));
        return null;
    }

    private void findRoute(String peer) {
        block8: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"findRoute starts");
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("      peer= " + peer));
            }
            if (this.pendingQueries.contains(peer)) {
                return;
            }
            this.pendingQueries.addElement(peer);
            try {
                StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), "jxta:EndpointRouter");
                TextElement e = null;
                e = doc.createElement(TypeTag, RouteQuery);
                doc.appendChild((Element)e);
                e = doc.createElement(DestPeerIdTag, peer);
                doc.appendChild((Element)e);
                e = doc.createElement(RoutingPeerAdvTag, this.localPeerAdv);
                doc.appendChild((Element)e);
                StringWriter dumped = new StringWriter();
                doc.sendToWriter(dumped);
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"findRoute sends query EndpointRouter");
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("findRoute sends query for peer : " + peer));
                }
                ResolverQuery query = new ResolverQuery(routerSName, null, this.localPeerId.toString(), dumped.toString(), this.qid++);
                this.resolver.sendQuery(null, query);
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"getAddress() query sent");
                }
            }
            catch (Exception ee) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block8;
                LOG.debug((Object)"Exception in findRoute", (Throwable)ee);
            }
        }
        this.pendingQueries.remove(peer);
    }

    public void processResponse(ResolverResponseMsg response) {
        int nbOfHops;
        Vector<String> gatewaysForward;
        String destPeer;
        String routingPeer;
        block30: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processResponse got a response");
            }
            Enumeration enumeration = null;
            routingPeer = null;
            String routingPeerAdv = null;
            destPeer = null;
            MimeMediaType mediaType = null;
            Object ipId = null;
            mediaType = new MimeMediaType("text/xml");
            ByteArrayInputStream ip = new ByteArrayInputStream(response.getResponse().getBytes());
            StructuredDocument doc = null;
            try {
                doc = StructuredDocumentFactory.newStructuredDocument(mediaType, ip);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"processResponse: malformed response - discard");
                }
                return;
            }
            gatewaysForward = new Vector<String>();
            nbOfHops = 0;
            int version = 0;
            String type = null;
            enumeration = doc.getChildren();
            while (enumeration.hasMoreElements()) {
                TextElement elem = (TextElement)enumeration.nextElement();
                if (elem.getName().equals(DestPeerIdTag)) {
                    destPeer = (String)elem.getValue();
                    continue;
                }
                if (elem.getName().equals(RoutingPeerIdTag)) {
                    routingPeer = (String)elem.getValue();
                    continue;
                }
                if (elem.getName().equals(RoutingPeerAdvTag)) {
                    routingPeerAdv = (String)elem.getValue();
                    continue;
                }
                if (elem.getName().equals(NbOfHopsTag)) {
                    try {
                        nbOfHops = Integer.parseInt((String)elem.getValue());
                    }
                    catch (NumberFormatException ez1) {
                        if (!LOG.isEnabledFor(Priority.WARN)) continue;
                        LOG.warn((Object)"Cannot parse nbOfHops");
                    }
                    continue;
                }
                if (elem.getName().equals(VersionTag)) {
                    try {
                        version = Integer.parseInt((String)elem.getValue());
                    }
                    catch (Exception e) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                        LOG.debug((Object)"cannot decode version");
                    }
                    continue;
                }
                if (elem.getName().equals(TypeTag)) {
                    type = (String)elem.getValue();
                    continue;
                }
                if (!elem.getName().equals(GatewayForwardTag)) continue;
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Gateway forward adding " + (String)elem.getValue()));
                }
                gatewaysForward.addElement((String)elem.getValue());
            }
            if (version < 3) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("reject answer. Wrong version " + version));
                }
                return;
            }
            if (type == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"No type: invalid.");
                }
                return;
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("processResponse got message of type " + type));
            }
            if (!type.equals(RouteResponse)) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("unimplemented: " + type));
                }
                return;
            }
            if (routingPeer == null || destPeer == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"processResponse: malformed response - discard.");
                }
                return;
            }
            if (routingPeerAdv != null) {
                Advertisement adv = null;
                try {
                    adv = AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), new ByteArrayInputStream(routingPeerAdv.getBytes()));
                    this.discovery.publish(adv, 0, 0x6DDD00L, 0x6DDD00L);
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block30;
                    LOG.debug((Object)("   no advertisement " + e));
                }
            }
        }
        this.triedAndFailed.remove(routingPeer);
        if (destPeer.equals(routingPeer)) {
            this.learnLocalRoute(routingPeer);
        } else {
            this.learnLocalRoute(routingPeer);
            this.setRoute(new Route(destPeer, routingPeer, nbOfHops, gatewaysForward));
        }
    }

    public ResolverResponseMsg processQuery(ResolverQueryMsg query) throws NoResponseException, IOException, ResendQueryException, DiscardQueryException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processQuery starts");
        }
        MimeMediaType mediaType = null;
        try {
            mediaType = new MimeMediaType("text/xml");
        }
        catch (RuntimeException e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Malformed query [1] " + e));
            }
            throw new IOException();
        }
        ByteArrayInputStream ip = new ByteArrayInputStream(query.getQuery().getBytes());
        StructuredTextDocument doc = null;
        try {
            doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mediaType, ip);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("processQuery: malformed request [2] " + e));
            }
            throw new IOException();
        }
        String pId = null;
        String type = null;
        Enumeration enumeration = doc.getChildren();
        while (enumeration.hasMoreElements()) {
            TextElement elem = (TextElement)enumeration.nextElement();
            if (elem.getName().equals(DestPeerIdTag)) {
                pId = (String)elem.getValue();
                continue;
            }
            if (elem.getName().equals(TypeTag)) {
                type = (String)elem.getValue();
                continue;
            }
            if (!elem.getName().equals(RoutingPeerAdvTag)) continue;
            String remoteAdv = (String)elem.getValue();
            PeerAdvertisement padv = null;
            try {
                padv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), new ByteArrayInputStream(remoteAdv.getBytes()));
                if (padv.getPeerID().equals(this.localPeerId)) continue;
                this.discovery.publish(padv, 0, 0x6DDD00L, 0x6DDD00L);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                LOG.debug((Object)e);
            }
        }
        if (type == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"No type: invalid.");
            }
            throw new DiscardQueryException();
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("  type=  " + type));
        }
        if (!type.equals(RouteQuery)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("unimplemented: " + type));
            }
            throw new DiscardQueryException();
        }
        if (pId == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: malformed request, no PeerId.");
            }
            throw new IOException();
        }
        int queryId = query.getQueryId();
        String qReqAddr = pId;
        Route route = null;
        boolean found = false;
        if (qReqAddr.equals(this.localPeerAddr)) {
            found = true;
        } else if (this.group.isRendezvous()) {
            if (this.isLocalRoute(qReqAddr)) {
                found = true;
            } else {
                route = this.getRoute(qReqAddr);
                if (route != null) {
                    found = true;
                }
            }
        }
        if (!found) {
            if (!this.group.isRendezvous()) {
                throw new DiscardQueryException();
            }
            throw new NoResponseException();
        }
        try {
            doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), "jxta:EndpointRouter");
            TextElement e = null;
            e = doc.createElement(VersionTag, Integer.toString(3));
            doc.appendChild((Element)e);
            e = doc.createElement(TypeTag, RouteResponse);
            doc.appendChild((Element)e);
            e = doc.createElement(DestPeerIdTag, qReqAddr);
            doc.appendChild((Element)e);
            e = doc.createElement(RoutingPeerIdTag, this.localPeerAddr);
            doc.appendChild((Element)e);
            e = route != null ? doc.createElement(NbOfHopsTag, String.valueOf(route.nbOfHops + 1)) : doc.createElement(NbOfHopsTag, String.valueOf(1));
            doc.appendChild((Element)e);
            if (this.localPeerAdv != null) {
                e = doc.createElement(RoutingPeerAdvTag, this.localPeerAdv);
                doc.appendChild((Element)e);
            }
            e = doc.createElement(GatewayForwardTag, this.localPeerAddr);
            doc.appendChild((Element)e);
            if (route != null) {
                Vector gateways = route.gateways;
                String gateway = null;
                if (gateways != null && gateways.size() > 0) {
                    int i = 0;
                    while (i < gateways.size()) {
                        try {
                            gateway = (String)gateways.elementAt(i);
                            e = doc.createElement(GatewayForwardTag, gateway);
                            doc.appendChild((Element)e);
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
            }
            StringWriter dumped = new StringWriter();
            doc.sendToWriter(dumped);
            ResolverResponse res = new ResolverResponse(routerSName, null, queryId, dumped.toString());
            return res;
        }
        catch (Exception ee) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: error while processing query: ", (Throwable)ee);
            }
            throw new IOException();
        }
    }

    public EndpointMessenger getMessenger(EndpointAddress addr) throws IOException {
        String dstPAddr = addr.getProtocolName() + "://" + addr.getProtocolAddress();
        if (dstPAddr.equals(this.localPeerAddr)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"getMessenger: return LoopbackMessenger");
            }
            return new LoopbackMessenger(this.endpoint, this.endpoint.newEndpointAddress(this.localPeerAddr), addr);
        }
        EndpointMessenger m = this.getTransportMessenger(dstPAddr, false);
        return new RouterMessenger(m, addr, this.endpoint, this, true);
    }

    private EndpointMessenger getTransportMessenger(String dstPAddr, boolean local) throws IOException {
        EndpointMessenger messenger = null;
        int triesLeft = 2;
        while (triesLeft-- > 0) {
            Address naddr = null;
            naddr = local ? (Address)this.getLocalRoute(dstPAddr) : (Address)this.getAddress(dstPAddr);
            if (naddr == null) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("getTransportMessenger: no xport address for " + dstPAddr));
                }
                throw new IOException("getTransportMessenger: no address");
            }
            naddr = (Address)naddr.clone();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("getMessenger(). dest peer= " + dstPAddr + "using = " + naddr.toString()));
            }
            naddr.setServiceName(routerSName);
            naddr.setServiceParameter(routerSParam);
            try {
                messenger = this.endpoint.getMessenger(naddr);
                if (messenger != null) break;
                throw new IOException("getTransportMessenger: no messenger");
            }
            catch (IOException noCheese) {
                this.brokenRoute(dstPAddr);
            }
        }
        if (messenger == null) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("getMessenger: no messenger to " + dstPAddr));
            }
            throw new IOException("getTransportMessenger: no messenger");
        }
        return messenger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class RouterMessenger
    implements EndpointMessenger {
        protected EndpointMessenger messenger = null;
        protected EndpointAddress destAddress = null;
        protected EndpointRouter router = null;
        protected boolean persistent = false;
        protected String dstPAddr = null;

        public RouterMessenger(EndpointMessenger m, EndpointAddress destAddress, EndpointService e, EndpointRouter r) {
            if (m == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"null messenger!");
                }
                throw new IllegalArgumentException("null messenger!");
            }
            this.messenger = m;
            this.destAddress = destAddress;
            this.router = r;
        }

        public RouterMessenger(EndpointMessenger m, EndpointAddress destAddress, EndpointService e, EndpointRouter r, boolean persistent) {
            this.messenger = m;
            this.destAddress = destAddress;
            this.router = r;
            this.persistent = persistent;
            if (persistent) {
                this.dstPAddr = destAddress.getProtocolName() + "://" + destAddress.getProtocolAddress();
            }
        }

        public void sendMessage(Message message) throws IOException {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"EndpointRouterMessenger.sendMessage starts");
            }
            int triesLeft = 2;
            while (triesLeft-- > 0) {
                block37: {
                    EndpointRouterMessage routerMsg;
                    block34: {
                        block35: {
                            String inMsgDest;
                            if (this.messenger == null) {
                                this.messenger = EndpointRouter.this.getTransportMessenger(this.dstPAddr, false);
                            }
                            InputStream ip = null;
                            routerMsg = null;
                            MessageElement elem = message.getElement("JxtaEndpointRouter");
                            if (elem != null && (ip = elem.getStream()) != null) {
                                try {
                                    routerMsg = new EndpointRouterMessage(ip);
                                }
                                catch (Exception ez1) {
                                    routerMsg = null;
                                }
                            }
                            if (routerMsg == null) {
                                if (LOG.isEnabledFor(Priority.DEBUG)) {
                                    LOG.debug((Object)"Create a new EndpointRouterMessage");
                                }
                                routerMsg = new EndpointRouterMessage();
                                routerMsg.setSrcAddress(this.router.localPeerAddr);
                                routerMsg.setNbOfHops("1");
                                try {
                                    Route route = this.router.getRoute(this.destAddress.getProtocolName() + "://" + this.destAddress.getProtocolAddress());
                                    if (route != null && route.gateways != null) {
                                        routerMsg.setForwardGateways(route.gateways);
                                    }
                                    break block34;
                                }
                                catch (Exception ez1) {
                                    if (LOG.isEnabledFor(Priority.WARN)) {
                                        LOG.warn((Object)"Cannot set forward gateways");
                                    }
                                    break block34;
                                }
                            }
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)"Using EndpointRouterMessage");
                            }
                            if ((inMsgDest = routerMsg.getDestAddress()) != null && !inMsgDest.equals(this.destAddress.toString())) {
                                routerMsg.setForwardGateways(null);
                                try {
                                    Route route = this.router.getRoute(this.destAddress.toString());
                                    if (route != null && route.gateways != null) {
                                        routerMsg.setForwardGateways(route.gateways);
                                        int nbOfHops = route.gateways.size() + 1;
                                        routerMsg.setNbOfHops(String.valueOf(nbOfHops));
                                    }
                                }
                                catch (Exception ez1) {
                                    if (!LOG.isEnabledFor(Priority.WARN)) break block35;
                                    LOG.warn((Object)"Cannot set forward gateways");
                                }
                            }
                        }
                        boolean reverse = false;
                        if (routerMsg.getReverseGateways() != null && !(reverse = EndpointRouter.this.isLocalRoute(routerMsg.getLastHop()))) {
                            routerMsg.setReverseGateways(null);
                        }
                        if (!reverse) {
                            reverse = EndpointRouter.this.getRoute(routerMsg.getSrcAddress()) != null ? true : EndpointRouter.this.isLocalRoute(routerMsg.getSrcAddress());
                        }
                        if (reverse) {
                            Vector<String> v;
                            block36: {
                                if (LOG.isEnabledFor(Priority.DEBUG)) {
                                    LOG.debug((Object)"    setting reverse remote route");
                                }
                                if ((v = routerMsg.getReverseGateways()) == null) {
                                    v = new Vector<String>(1);
                                }
                                try {
                                    v.add(0, EndpointRouter.this.localPeerAddr);
                                }
                                catch (Exception ez1) {
                                    if (!LOG.isEnabledFor(Priority.WARN)) break block36;
                                    LOG.warn((Object)"Cannot insert local peer id in the reverse route");
                                }
                            }
                            try {
                                routerMsg.setNbOfHops(String.valueOf(Integer.parseInt(routerMsg.getNbOfHops()) + 1));
                            }
                            catch (Exception ez1) {
                                if (LOG.isEnabledFor(Priority.WARN)) {
                                    LOG.warn((Object)("Got exception while trying to set the nbofHops " + ez1));
                                }
                                routerMsg.setNbOfHops("0");
                            }
                            routerMsg.setReverseGateways(v);
                        } else {
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)"     no reverse route");
                            }
                            routerMsg.setNbOfHops("0");
                            routerMsg.setReverseGateways(null);
                        }
                    }
                    routerMsg.setDestAddress(this.destAddress.toString());
                    routerMsg.setLastHop(this.router.localPeerAddr);
                    try {
                        message.addElement(message.newMessageElement("JxtaEndpointRouter", null, routerMsg.getInputStream()));
                    }
                    catch (Exception e) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) break block37;
                        LOG.debug((Object)"Can't push header");
                    }
                }
                try {
                    this.messenger.sendMessage(message);
                    return;
                }
                catch (IOException ee) {
                    if (!this.persistent) {
                        throw ee;
                    }
                    message.removeElement("JxtaEndpointRouter");
                    this.messenger = null;
                    EndpointRouter.this.brokenRoute(this.dstPAddr);
                }
            }
            throw new IOException("RouterMessenger: Could not find a working transport for destination.");
        }

        public void close() {
        }
    }

    protected class Route {
        public String dest = null;
        public String router = null;
        public int nbOfHops = 0;
        public Vector gateways = null;

        public Route(String dest, String router, int nbOfHops, Vector gateways) {
            this.dest = dest;
            this.router = router;
            this.nbOfHops = nbOfHops;
            this.gateways = gateways;
        }

        public void display() {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Route to    = " + this.dest));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("    nextHop = " + this.router));
            }
            if (this.gateways == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"    no gateways");
                }
            } else {
                int i = 0;
                while (i < this.gateways.size()) {
                    try {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("   [" + i + "] " + (String)this.gateways.elementAt(i)));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
    }
}

