/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageElementEnumeration;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.impl.endpoint.MessageWireFormat;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class MessageWireFormatBinary
extends MessageWireFormat {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$MessageWireFormatBinary == null ? (class$net$jxta$impl$endpoint$MessageWireFormatBinary = MessageWireFormatBinary.class$("net.jxta.impl.endpoint.MessageWireFormatBinary")) : class$net$jxta$impl$endpoint$MessageWireFormatBinary).getName());
    protected static final int HAS_TYPE = 1;
    protected static final int MESSAGE_VERSION = 0;
    protected static final MimeMediaType outputMimeType = new MimeMediaType("application/x-jxta-msg");
    MimeMediaType type;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$MessageWireFormatBinary;

    public static MimeMediaType getOutputMimeType() {
        return (MimeMediaType)outputMimeType.clone();
    }

    public MessageWireFormatBinary(MimeMediaType type) {
        this.type = type;
    }

    public void writeMessage(OutputStream os, Message m) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeBytes("jxmg");
        dos.writeByte(0);
        Hashtable namespace2id = new Hashtable();
        Vector namespaceTable = new Vector();
        this.assignNamespaceIds(m, namespace2id, namespaceTable);
        this.writeStringVector(dos, namespaceTable);
        int elementCount = 0;
        MessageElementEnumeration els = m.getElements();
        while (els.hasMoreElements()) {
            els.nextElement();
            elementCount = (short)(elementCount + 1);
        }
        dos.writeShort(elementCount);
        els = ((MessageImpl)m).getElementsInFifoOrder();
        while (els.hasMoreElements()) {
            MessageElement el = (MessageElement)els.nextElement();
            this.writeMessageElement(dos, namespace2id, m, el);
        }
    }

    public void readMessage(InputStream is, Message msg) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        if (dis.readByte() != 106 || dis.readByte() != 120 || dis.readByte() != 109 || dis.readByte() != 103) {
            throw new IOException("Not a message");
        }
        if (dis.readByte() != 0) {
            throw new IOException("Message not version 0");
        }
        int namespaceCnt = dis.readShort();
        Hashtable<Integer, String> id2namespace = new Hashtable<Integer, String>();
        id2namespace.put(new Integer(0), "");
        id2namespace.put(new Integer(1), "jxta");
        int id = 2;
        int i = 0;
        while (i < namespaceCnt) {
            try {
                String namespace = this.readString(dis);
                id2namespace.put(new Integer(id++), namespace);
            }
            catch (IOException caught) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Error Processing namespace", (Throwable)caught);
                }
                throw caught;
            }
            ++i;
        }
        int elementCnt = dis.readShort();
        if (elementCnt < 0) {
            throw new IOException("Negative element count");
        }
        int i2 = 0;
        while (i2 < elementCnt) {
            try {
                this.readMessageElement(dis, id2namespace, msg);
            }
            catch (IOException caught) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("Error Processing message element #" + i2 + " of " + elementCnt + "."), (Throwable)caught);
                }
                throw caught;
            }
            ++i2;
        }
    }

    private void assignNamespaceIds(Message m, Hashtable namespace2id, Vector namespaceTable) {
        int id = 0;
        Enumeration namespaces = m.getNamespaces();
        namespace2id.clear();
        namespaceTable.clear();
        namespace2id.put("", new Integer(id++));
        namespace2id.put("jxta", new Integer(id++));
        while (namespaces.hasMoreElements()) {
            String namespace = (String)namespaces.nextElement();
            if (namespace2id.get(namespace) != null) continue;
            namespace2id.put(namespace, new Integer(id++));
            namespaceTable.addElement(namespace);
        }
    }

    private void readMessageElement(DataInputStream dis, Hashtable id2namespace, Message m) throws IOException {
        if (dis.readByte() != 106 || dis.readByte() != 120 || dis.readByte() != 101 || dis.readByte() != 108) {
            throw new IOException("Not a message element");
        }
        byte nsid = dis.readByte();
        String namespace = (String)id2namespace.get(new Integer(nsid));
        if (namespace == null) {
            throw new IOException("bad namespace id");
        }
        byte flags = dis.readByte();
        String name = this.readString(dis);
        MimeMediaType type = null;
        if ((flags & 1) != 0) {
            String typeString = this.readString(dis);
            type = new MimeMediaType(typeString);
        }
        int len = dis.readInt();
        byte[] value = new byte[len];
        dis.readFully(value);
        String qname = namespace.equals("") ? name : namespace + ":" + name;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Add Message Element ns='" + namespace + "' name='" + name + "' len=" + value.length));
        }
        MessageElement el = m.newMessageElement(qname, type, value);
        m.addElement(el);
    }

    private void writeMessageElement(DataOutputStream dos, Hashtable namespace2id, Message m, MessageElement el) throws IOException {
        MimeMediaType type;
        String[] names = MessageElement.parseName(el.getName());
        String namespace = names[0];
        String name = names[1];
        dos.writeByte(106);
        dos.writeByte(120);
        dos.writeByte(101);
        dos.writeByte(108);
        int nsid = 0;
        Integer idi = (Integer)namespace2id.get(namespace);
        if (idi != null) {
            nsid = idi;
        }
        dos.writeByte(nsid);
        int flags = 0;
        if (el.getType() != null) {
            flags = (byte)(flags | 1);
        }
        dos.writeByte(flags);
        if (name != null) {
            this.writeString(dos, name);
        }
        if ((type = el.getType()) != null) {
            this.writeString(dos, type.toString());
        }
        byte[] bytes = el.getBytesOffset();
        dos.writeInt(el.getLength());
        dos.write(bytes, el.getOffset(), el.getLength());
    }

    private void writeStringVector(DataOutputStream dos, Vector v) throws IOException {
        dos.writeShort(v.size());
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            this.writeString(dos, (String)e.nextElement());
        }
    }

    private String readString(DataInputStream dis) throws IOException {
        short len = dis.readShort();
        if (len < 0) {
            throw new IOException("Bad string length in message");
        }
        byte[] bytes = new byte[len];
        dis.readFully(bytes);
        return new String(bytes, "UTF8");
    }

    private void writeString(DataOutputStream dos, String s) throws IOException {
        dos.writeShort(s.length());
        dos.write(s.getBytes("UTF8"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Instantiator
    implements MessageWireFormatFactory.Instantiator {
        public MimeMediaType getOutputMimeType() {
            return MessageWireFormatBinary.getOutputMimeType();
        }

        public MessageWireFormat newInstance(MimeMediaType type) {
            return new MessageWireFormatBinary(type);
        }
    }
}

