/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import COM.claymoresystems.cert.WrappedObject;
import COM.claymoresystems.crypto.EAYEncryptedPrivateKey;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.util.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import jxta.security.exceptions.CryptoException;
import jxta.security.hash.Hash;
import jxta.security.impl.crypto.JxtaCryptoSuite;
import jxta.security.impl.random.JRandom;
import jxta.security.util.URLBase64;
import net.jxta.impl.endpoint.tls.JTlsUtil;
import org.apache.log4j.Category;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.X509V3CertificateGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PeerCerts {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tls$PeerCerts == null ? (class$net$jxta$impl$endpoint$tls$PeerCerts = PeerCerts.class$("net.jxta.impl.endpoint.tls.PeerCerts")) : class$net$jxta$impl$endpoint$tls$PeerCerts).getName());
    static final String testPw = "password";
    private static final int NUM_BYTES = 128;
    static final String[] dh = new String[]{"-----BEGIN DH PARAMETERS-----\n", "MIGHAoGBANmAnfkETuKHOCWaE+W+F3kM/e7z5A8hZb7OqwGMQrUOaBEAr4BWeZBn\n", "G/87hhwZgNP69/KUchm714qd/PpOspCaUJ20x6PcmKujpAgca/f19HGMBjRawQMk\n", "R9oaBwazuQT0l0rTTKmvpMEcrQQIcVWii3CZI56I56oqF8biGPD7AgEC\n", "-----END DH PARAMETERS-----\n"};
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$PeerCerts;

    public static IssuerInfo genPeerRootCert(String peerName, String password) throws IOException {
        String rootFile = JTlsUtil.getPCERootPath() + "peer-root.pem";
        SSLDebug.debug((int)128, (String)"Generating root cert ...");
        IssuerInfo info = PeerCerts.genCert(rootFile, peerName + "-CA", null);
        info.passwd = PeerCerts.genPassPhrase(password);
        PeerCerts.appendPrivateKey(info, rootFile);
        return info;
    }

    public static void genPeerServiceCert(String peerName, IssuerInfo info, String password) throws IOException {
        String keyFile = JTlsUtil.getPCEClientPath() + "peer-service.pem";
        SSLDebug.debug((int)128, (String)"\nGenerating client cert ...");
        IssuerInfo myinfo = PeerCerts.genCert(keyFile, peerName, info);
        myinfo.passwd = info.passwd;
        PeerCerts.appendPrivateKey(myinfo, keyFile);
    }

    private static void appendPrivateKey(IssuerInfo info, String keyFile) throws IOException {
        RSAPrivateCrtKey priKey = (RSAPrivateCrtKey)info.subjectPkey;
        FileWriter fw = new FileWriter(keyFile, true);
        BufferedWriter bw = new BufferedWriter(fw);
        EAYEncryptedPrivateKey.writePrivateKey((RSAPrivateCrtKey)priKey, (byte[])info.passwd, (BufferedWriter)bw);
        bw.flush();
        fw.close();
    }

    public static SecureRandom seedSRN() throws CryptoException {
        byte[] seed = new byte[128];
        JRandom jran = new JRandom();
        jran.nextBytes(seed);
        return new SecureRandom(seed);
    }

    private static byte[] genPassPhrase(String password) throws IOException {
        String PCEpath = JTlsUtil.getPCEClientPath();
        String phraseFile = PCEpath + "peer.phrase";
        byte[] buf = new byte[128];
        SecureRandom rng = null;
        try {
            rng = PeerCerts.seedSRN();
        }
        catch (CryptoException cex) {
            return null;
        }
        rng.nextBytes(buf);
        byte[] phrase = new byte[buf.length];
        System.arraycopy(buf, 0, phrase, 0, buf.length);
        byte[] str64 = null;
        try {
            byte profile = 4;
            JxtaCryptoSuite suite = new JxtaCryptoSuite(profile, null, 0, 0);
            Hash sha1 = suite.getJxtaHash((byte)1);
            byte[] digest = new byte[sha1.getDigestLength()];
            int len = 128;
            int i = 0;
            while (i < 127) {
                sha1.doFinal(buf, 0, len, digest, 0);
                System.arraycopy(digest, 0, buf, 0, digest.length);
                len = digest.length;
                ++i;
            }
            str64 = URLBase64.encode((byte[])digest);
            PeerCerts.writePassphrase(phraseFile, new String(str64), password);
        }
        catch (CryptoException cex) {
            throw new IOException("Could not generate passphrase");
        }
        return str64;
    }

    public static void writePassphrase(String phraseFile, String str64, String passwd) throws CryptoException, IOException {
        byte[] by64 = str64.getBytes();
        File tmp = File.createTempFile("yyj", null);
        FileWriter fw = new FileWriter(tmp);
        BufferedWriter bw = new BufferedWriter(fw);
        WrappedObject.writeHeader((String)"PASSPHRASE", (BufferedWriter)bw);
        WrappedObject.writeObject((byte[])by64, (String)"PASSPHRASE", (BufferedWriter)bw);
        fw.close();
        int size = (int)tmp.length();
        FileInputStream fr = new FileInputStream(tmp);
        byte[] ibuf = new byte[size];
        int n = fr.read(ibuf, 0, size);
        fr.close();
        tmp.delete();
        byte[] obuf = JTlsUtil.tlsCipher(ibuf, passwd, (byte)1);
        FileOutputStream fout = new FileOutputStream(phraseFile);
        fout.write(obuf, 0, size);
        fout.close();
    }

    public static IssuerInfo genCert(String fileName, String peerName, IssuerInfo issuer) throws IOException {
        try {
            SecureRandom rng = PeerCerts.seedSRN();
            Security.addProvider((Provider)new BouncyCastleProvider());
            KeyPairGenerator g = KeyPairGenerator.getInstance("RSA", "BC");
            g.initialize(1024, rng);
            KeyPair p = g.generateKeyPair();
            PrivateKey privKey = p.getPrivate();
            PublicKey pubKey = p.getPublic();
            Hashtable attrs = new Hashtable();
            attrs.put(X509Name.C, "US");
            attrs.put(X509Name.O, "www.jxta.org");
            attrs.put(X509Name.L, "SF");
            byte[] ou = new byte[10];
            rng.nextBytes(ou);
            String ouStr = jxta.security.util.Util.hexEncode((byte[])ou);
            attrs.put(X509Name.OU, ouStr);
            attrs.put(X509Name.CN, peerName);
            Date today = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(today);
            cal.add(1, 10);
            Date after = cal.getTime();
            Hashtable issuerAttrs = null;
            PrivateKey signer = null;
            String strx = null;
            if (issuer == null) {
                issuerAttrs = attrs;
                signer = privKey;
                strx = "\nRoot Cert:";
            } else {
                issuerAttrs = issuer.issuer;
                signer = issuer.rootKey;
                strx = "\nClient Cert:";
            }
            X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
            certGen.setSerialNumber(BigInteger.valueOf(1L));
            certGen.setIssuerDN((X509Name)new X509Principal(issuerAttrs));
            certGen.setNotBefore(today);
            certGen.setNotAfter(after);
            certGen.setSubjectDN((X509Name)new X509Principal(attrs));
            certGen.setPublicKey(pubKey);
            certGen.setSignatureAlgorithm("SHA1withRSA");
            X509Certificate cert = certGen.generateX509Certificate(signer);
            FileWriter fw = new FileWriter(fileName);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(cert.toString());
            bw.flush();
            byte[] buf = cert.getEncoded();
            WrappedObject.writeHeader((String)"CERTIFICATE", (BufferedWriter)bw);
            WrappedObject.writeObject((byte[])buf, (String)"CERTIFICATE", (BufferedWriter)bw);
            fw.close();
            if (SSLDebug.getDebug((int)128)) {
                Util.xdump((String)strx, (byte[])buf);
            }
            IssuerInfo info = new IssuerInfo();
            info.issuer = issuerAttrs;
            info.rootKey = signer;
            info.subjectPkey = privKey;
            return info;
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("genCert: " + e.getMessage());
        }
        catch (SignatureException e) {
            System.out.println("genCert: " + e.getMessage());
        }
        catch (CertificateEncodingException e) {
            System.out.println("genCert: " + e.getMessage());
        }
        catch (InvalidKeyException e) {
            System.out.println("genCert: " + e.getMessage());
        }
        catch (NoSuchProviderException e) {
            System.out.println("genCert: " + e.getMessage());
        }
        catch (CertificateException e) {
            System.out.println("genCert: " + e.getMessage());
        }
        catch (CryptoException e) {
            System.out.println("genCert: " + e.getMessage());
        }
        throw new IOException("Could not generate certificate");
    }

    public static void genDhfile() throws IOException {
        String PCEPath = JTlsUtil.getPCEPath();
        String dhfile = PCEPath + "dh1024.pem";
        FileWriter fw = new FileWriter(dhfile);
        BufferedWriter bw = new BufferedWriter(fw);
        int i = 0;
        while (i < dh.length) {
            bw.write(dh[i]);
            ++i;
        }
        bw.flush();
        fw.close();
    }

    public static void generateCerts(String peerName, String password, boolean wantDH) throws Exception {
        IssuerInfo info = PeerCerts.genPeerRootCert(peerName, password);
        PeerCerts.genPeerServiceCert(peerName, info, password);
        if (wantDH) {
            PeerCerts.genDhfile();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class IssuerInfo {
        PrivateKey rootKey;
        Hashtable issuer;
        PrivateKey subjectPkey;
        byte[] passwd;

        private IssuerInfo() {
        }
    }
}

