/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import java.io.IOException;
import java.util.Hashtable;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.exception.HandshakeInProgressException;
import net.jxta.impl.endpoint.tls.JTlsUtil;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.endpoint.tls.TlsTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TlsManager {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tls$TlsManager == null ? (class$net$jxta$impl$endpoint$tls$TlsManager = TlsManager.class$("net.jxta.impl.endpoint.tls.TlsManager")) : class$net$jxta$impl$endpoint$tls$TlsManager).getName());
    TlsTransport transport = null;
    Hashtable cons = new Hashtable();
    private static final int CONN_TIMEOUT = 3600000;
    private static final int STARTOFHS = 1;
    private static final int RETRSTARTOFHS = 2;
    private static final int NOTSTARTOFHS = 0;
    private static int count = 1;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$TlsManager;

    private synchronized boolean handshakeInprogress(TlsConnInfo cinfo) {
        return !cinfo.handshakeDone;
    }

    private synchronized TlsConnInfo setTlsConnTable(String paddr, TlsConn conn) {
        TlsConnInfo cinfo = null;
        if (this.cons.containsKey(paddr)) {
            cinfo = (TlsConnInfo)this.cons.get(paddr);
            if (cinfo.handshakeDone) {
                return cinfo;
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Handshake in progress for " + paddr));
            }
            return null;
        }
        cinfo = new TlsConnInfo(conn, System.currentTimeMillis());
        this.cons.put(paddr, cinfo);
        return cinfo;
    }

    public TlsManager(TlsTransport tp) {
        this.transport = tp;
    }

    public TlsConn getTlsConn(EndpointAddress dstAddr) throws HandshakeInProgressException, IOException {
        TlsConn conn = null;
        String paddr = dstAddr.getProtocolAddress();
        TlsConnInfo cinfo = (TlsConnInfo)this.cons.get(paddr);
        if (cinfo != null) {
            long maxIdleTime;
            if (this.handshakeInprogress(cinfo)) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Handshake in progress for " + paddr));
                }
                throw new HandshakeInProgressException("Handshake in progress");
            }
            conn = cinfo.connection;
            if (conn.getInputDead()) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Input died for " + paddr));
                }
                throw new IOException("Input died");
            }
            long ctime = System.currentTimeMillis();
            if (ctime > (maxIdleTime = cinfo.lastAccessed + 3600000L)) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    long idletime = (ctime - cinfo.lastAccessed) / 60000L;
                    LOG.info((Object)("getTlsConn, idle time expired:\n  Dest = " + paddr + "  minutes idle = " + idletime + "\n"));
                }
                cinfo = null;
                this.cons.remove(paddr);
            } else {
                cinfo.lastAccessed = ctime;
                this.cons.put(paddr, cinfo);
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"getTlsConn: Continuing cached Tls session");
                }
                return conn;
            }
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("getTlsConn, new TlsConn:\n  Addr = " + paddr));
        }
        try {
            conn = new TlsConn(this, this.transport, dstAddr, true, null);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.info((Object)("new tls connection = " + paddr));
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"TlsManager:", (Throwable)e);
            }
            return null;
        }
        cinfo = this.setTlsConnTable(paddr, conn);
        if (cinfo == null) {
            conn = null;
            throw new HandshakeInProgressException("Handshake in progress");
        }
        if (cinfo.handshakeDone) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"TlsManager: continuing connection");
            }
            return cinfo.connection;
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"TlsManager: initiating handshake");
        }
        conn.openTLSConnection();
        cinfo.handshakeDone = true;
        this.cons.put(paddr, cinfo);
        return conn;
    }

    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) throws IOException {
        TlsConn conn = null;
        String paddr = null;
        paddr = srcAddr.getProtocolAddress();
        ++count;
        TlsConnInfo cinfo = (TlsConnInfo)this.cons.get(paddr);
        boolean restart = false;
        if (cinfo != null) {
            int state;
            conn = cinfo.connection;
            if (conn.getInputDead()) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Input died for " + paddr));
                }
                throw new IOException("TLS Input died");
            }
            boolean hsdone = conn.getHandshakeDone();
            if (hsdone && (state = this.firstHandshakeMessage(msg)) == 1) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    int j = conn.jin.getSequenceNumber();
                    LOG.info((Object)("Restart handshake, Seq#s: received 1, expected " + j + "\n"));
                }
                this.cons.remove(paddr);
                cinfo = null;
                restart = true;
            }
        }
        if (cinfo == null) {
            int first;
            if (!restart && (first = this.firstHandshakeMessage(msg)) != 1 && first != 2) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("NO CONNECTION, STATE = " + first + ", Discard msg."));
                }
                msg = null;
                return;
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"New first contact server or handshake restart: ");
            }
            try {
                conn = new TlsConn(this, this.transport, srcAddr, false, msg);
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("New Server tls connection = " + srcAddr.toString()));
                }
                cinfo = new TlsConnInfo(conn, System.currentTimeMillis());
                this.cons.put(paddr, cinfo);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"TlsManager, cannot establish Server Connection:", (Throwable)e);
                }
                return;
            }
            try {
                conn.openTLSConnection();
                cinfo.handshakeDone = true;
                cinfo.lastAccessed = System.currentTimeMillis();
                this.cons.put(paddr, cinfo);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"TlsManger, Handshake failure for TLS connection:", (Throwable)e);
                }
                this.cons.remove(paddr);
                return;
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("TlsManger, NEW TLS Server, N = " + this.cons.size() + "]\n  New Server@" + paddr + "\n"));
            }
            return;
        }
        conn.jin.queueIncomingMessage(msg);
    }

    private int firstHandshakeMessage(Message msg) {
        MessageElement elt = null;
        MessageElement elt1 = null;
        int seqN = 0;
        boolean startOfHandshake = false;
        boolean retrans = false;
        while ((elt = JTlsUtil.getNextElement(msg, elt1)) != null) {
            String name = elt.getName();
            if (name.compareTo("jxtatls:MARKRetr") == 0) {
                retrans = true;
            }
            try {
                seqN = JTlsUtil.getSequenceNumber(elt);
            }
            catch (Exception e) {
                elt1 = elt;
                continue;
            }
            if (seqN == 1) {
                startOfHandshake = true;
            }
            elt1 = elt;
        }
        if (startOfHandshake) {
            if (retrans) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TlsConnInfo {
        TlsConn connection;
        boolean handshakeDone;
        long lastAccessed;

        public TlsConnInfo(TlsConn conn, long lastAccessed) {
            this.connection = conn;
            this.handshakeDone = false;
            this.lastAccessed = lastAccessed;
        }
    }
}

