/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import java.io.IOException;
import java.io.InputStream;
import net.jxta.document.Advertisement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointProtocol;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.exception.HandshakeInProgressException;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.LoopbackMessenger;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.endpoint.tls.TlsManager;
import net.jxta.impl.endpoint.tls.TlsMessage;
import net.jxta.impl.endpoint.tls.TlsMessenger;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TlsTransport
implements EndpointProtocol,
EndpointListener,
Module {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tls$TlsTransport == null ? (class$net$jxta$impl$endpoint$tls$TlsTransport = TlsTransport.class$("net.jxta.impl.endpoint.tls.TlsTransport")) : class$net$jxta$impl$endpoint$tls$TlsTransport).getName());
    protected String localPeerAddr = null;
    protected String localTlsPeerAddr = null;
    protected String localPeerId = null;
    protected String localPeerUID = null;
    private EndpointService endpoint = null;
    private PeerGroup group = null;
    private static final String tlsSName = "TlsTransport";
    private static String tlsSParam = null;
    private String localPeerAdv = null;
    private static String tlsPName = "jxtatls";
    private TlsManager manager = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$TlsTransport;

    public boolean allowOverLoad() {
        return true;
    }

    public int startApp(String[] args) {
        return 1;
    }

    public void stopApp() {
    }

    public void init(PeerGroup group, ID id, Advertisement impl) throws PeerGroupException {
        block5: {
            this.group = group;
            this.endpoint = group.getEndpointService();
            this.localPeerId = group.getPeerID().toString();
            this.localPeerUID = group.getPeerID().getUniqueValue().toString();
            this.localPeerAddr = "jxta://" + group.getPeerID().getUniqueValue().toString();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("localPeerId = " + this.localPeerId));
            }
            tlsSParam = group.getPeerGroupID().getUniqueValue().toString();
            this.localTlsPeerAddr = tlsPName + "://" + group.getPeerID().getUniqueValue().toString() + "/" + tlsSName + "/" + tlsSParam;
            try {
                this.endpoint.addListener(tlsSName + tlsSParam, this);
            }
            catch (Exception e2) {
                if (LOG.isEnabledFor(Priority.ERROR)) {
                    LOG.error((Object)"TLS could not register...as good as dead");
                }
                if (!LOG.isEnabledFor(Priority.ERROR)) break block5;
                LOG.error((Object)e2);
            }
        }
        this.manager = new TlsManager(this);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"TLS Transport is now initialized");
        }
        this.endpoint.addEndpointProtocol(this);
    }

    public boolean isConnectionOriented() {
        return false;
    }

    public boolean allowRouting() {
        return false;
    }

    public EndpointAddress getPublicAddress() {
        return this.endpoint.newEndpointAddress(this.localTlsPeerAddr);
    }

    public String getProtocolName() {
        return tlsPName;
    }

    public static String getSupportedProtocolName() {
        return "jxtatls";
    }

    public PeerGroup getPeerGroup() {
        return this.group;
    }

    public void propagate(Message srcMsg, String pName, String pParam, String prunePeer) throws IOException {
    }

    public void close() {
        this.endpoint.removeListener(tlsSName + tlsSParam, this);
    }

    public boolean ping(EndpointAddress addr) {
        return true;
    }

    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        block3: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processIncomingMessage starts");
            }
            try {
                this.manager.processIncomingMessage(msg, srcAddr, dstAddr);
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.ERROR)) break block3;
                LOG.debug((Object)"Error processing incoming message", (Throwable)e);
            }
        }
    }

    public EndpointMessenger getMessenger(EndpointAddress addr) throws IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("TlsTransport: getMessanger for " + addr.toString()));
        }
        String dstPeerID = addr.getProtocolAddress();
        String dstPAddr = "jxta://" + dstPeerID;
        if (dstPeerID.equals(this.localPeerUID)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"getMessenger: return LoopbackMessenger");
            }
            return new LoopbackMessenger(this.endpoint, this.endpoint.newEndpointAddress(this.localPeerAddr), addr);
        }
        TlsConn conn = null;
        try {
            conn = this.manager.getTlsConn(this.endpoint.newEndpointAddress(dstPAddr));
        }
        catch (HandshakeInProgressException e) {
            throw new IOException("Cannot get TlsConn: " + e.getMessage());
        }
        if (conn == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Cannot get a TLS connection");
            }
            throw new IOException();
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"TlsTransport: TlsMessanger with TlsConn DONE");
        }
        return new TlsMessenger(addr, conn, this);
    }

    public void sendToRemoteTls(EndpointAddress destAddr, Message msg) throws IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("TlsTransport: sendToRemoteTLS, dest peer= " + destAddr.toString()));
        }
        EndpointAddress realAddr = this.endpoint.newEndpointAddress(destAddr.toString());
        realAddr.setServiceName(tlsSName);
        realAddr.setServiceParameter(tlsSParam);
        EndpointMessenger messenger = this.endpoint.getMessenger(realAddr);
        if (messenger == null) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"getMessenger: no raw messenger");
            }
            throw new IOException("No raw messenger in getMessenger()");
        }
        messenger.sendMessage(msg);
    }

    public void processReceivedMessage(Message msg) {
        block13: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processReceivedMessage starts");
            }
            InputStream ip = null;
            String srcPeer = null;
            String destPeer = null;
            EndpointAddress origSrcAddr = null;
            EndpointAddress origDstAddr = null;
            TlsMessage tlsMsg = null;
            MessageElement tlsElement = msg.getElement("JxtaTls");
            try {
                if (tlsElement == null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"processReceivedMessage: no TLS header - discard message");
                    }
                    return;
                }
                ip = tlsElement.getStream();
                if (ip == null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"processReceivedMessage: invalid TLS header - discard message");
                    }
                    return;
                }
                tlsMsg = new TlsMessage(ip);
                origSrcAddr = this.endpoint.newEndpointAddress(tlsMsg.getSrcAddress());
                origDstAddr = this.endpoint.newEndpointAddress(tlsMsg.getDestAddress());
                srcPeer = origSrcAddr.getProtocolName() + "://" + origSrcAddr.getProtocolAddress();
                destPeer = origDstAddr.getProtocolName() + "://" + origDstAddr.getProtocolAddress();
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("     srcPeer= " + srcPeer));
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("    destPeer= " + destPeer));
                }
            }
            catch (Exception badHdr) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Bad TLS header or bad message. Message dropped.");
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("exception: " + badHdr));
                }
                return;
            }
            try {
                msg.setSourceAddress(origSrcAddr);
                msg.setDestinationAddress(origDstAddr);
                this.endpoint.demux(msg);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block13;
                LOG.debug((Object)"Error while demuxing an incoming message", (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

