/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import net.jxta.impl.peergroup.PanelGBL;

class BorderPanelGBL
extends PanelGBL {
    public static final int NONE = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    public static final int GROOVE = 3;
    public static final int BUMP = 4;
    int style = 3;
    String title;
    int ascent = 0;
    int descent = 0;
    int leading = 0;
    int titleWidth = 0;
    GridBagLayout lay = new GridBagLayout();

    public BorderPanelGBL(String title) {
        this.title = title;
    }

    public BorderPanelGBL(String title, String advice) {
        super(advice);
        this.title = title;
    }

    public BorderPanelGBL(String title, String advice, int s) {
        super(advice);
        this.title = title;
        if (s < 0 && s > 4) {
            return;
        }
        if (s == 1 || s == 2) {
            this.title = null;
        }
        this.style = s;
    }

    private void checkMetrics() {
        Font font = this.getFont();
        if (this.title == null || font == null) {
            this.ascent = 2;
        } else {
            FontMetrics fmetrics = this.getFontMetrics(font);
            this.ascent = fmetrics.getAscent();
            this.descent = fmetrics.getDescent();
            this.leading = fmetrics.getLeading();
            this.titleWidth = fmetrics.stringWidth(this.title);
        }
        this.insets = new Insets(this.descent + this.ascent + this.leading + 2, 7, 7, 7);
    }

    public Insets getInsets() {
        this.checkMetrics();
        return this.insets;
    }

    private void paintLowered(Graphics g) {
        this.checkMetrics();
        if (this.ascent == 0) {
            return;
        }
        Dimension d = this.getSize();
        g.setColor(Color.black);
        g.drawRect(1, this.ascent - 2, d.width - 4, d.height - this.ascent);
        g.setColor(Color.white);
        g.drawRect(2, this.ascent - 1, d.width - 4, d.height - this.ascent);
        g.setColor(this.getBackground());
        g.drawRect(2, this.ascent - 1, d.width - 5, d.height - this.ascent - 1);
    }

    private void paintRaised(Graphics g) {
        this.checkMetrics();
        if (this.ascent == 0) {
            return;
        }
        Dimension d = this.getSize();
        g.setColor(Color.white);
        g.drawRect(1, this.ascent - 2, d.width - 4, d.height - this.ascent);
        g.setColor(Color.black);
        g.drawRect(2, this.ascent - 1, d.width - 4, d.height - this.ascent);
        g.setColor(this.getBackground());
        g.drawRect(2, this.ascent - 1, d.width - 5, d.height - this.ascent - 1);
    }

    private void paintGroove(Graphics g) {
        this.checkMetrics();
        if (this.ascent == 0) {
            return;
        }
        Dimension d = this.getSize();
        g.setColor(Color.black);
        g.drawRect(1, this.ascent - 2, d.width - 4, d.height - this.ascent);
        g.setColor(Color.white);
        g.drawRect(2, this.ascent - 1, d.width - 4, d.height - this.ascent);
        g.setColor(Color.black);
        g.clearRect(10, 0, this.titleWidth + 6, this.descent + this.ascent + this.leading + 1);
        g.drawString(this.title, 12, this.ascent + 1);
        g.setColor(Color.white);
        g.drawString(this.title, 13, this.ascent + 2);
        g.clearRect(0, 0, d.width, 1);
    }

    private void paintBump(Graphics g) {
        this.checkMetrics();
        if (this.ascent == 0) {
            return;
        }
        Dimension d = this.getSize();
        g.setColor(Color.white);
        g.drawRect(1, this.ascent - 2, d.width - 4, d.height - this.ascent);
        g.setColor(Color.black);
        g.drawRect(2, this.ascent - 1, d.width - 4, d.height - this.ascent);
        g.setColor(Color.white);
        g.clearRect(10, 0, this.titleWidth + 6, this.descent + this.ascent + this.leading + 1);
        g.drawString(this.title, 12, this.ascent + 1);
        g.setColor(Color.black);
        g.drawString(this.title, 13, this.ascent + 2);
        g.clearRect(0, 0, d.width, 1);
    }

    public void paint(Graphics g) {
        switch (this.style) {
            case 3: {
                this.paintGroove(g);
                break;
            }
            case 4: {
                this.paintBump(g);
                break;
            }
            case 1: {
                this.paintRaised(g);
                break;
            }
            case 2: {
                this.paintLowered(g);
            }
        }
        super.paint(g);
    }
}

