/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.endpoint.EndpointReceiveQueue;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.pipe.WireHeader;
import net.jxta.impl.pipe.WireInputPipe;
import net.jxta.impl.pipe.WirePrivateOutputPipe;
import net.jxta.impl.pipe.WirePublicOutputPipe;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class WirePipe
implements EndpointListener {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$pipe$WirePipe == null ? (class$net$jxta$impl$pipe$WirePipe = WirePipe.class$("net.jxta.impl.pipe.WirePipe")) : class$net$jxta$impl$pipe$WirePipe).getName());
    private RefPeerGroup myGroup;
    private RendezVousService rendezvous;
    private String localPeerId;
    private Vector inputs;
    private Vector pipemsglisteners;
    private boolean valid;
    private String wireId;
    private PipeID pID;
    public static final String WireName = "jxta.service.wirepipe";
    public static final String WireKeywords = "WIRE";
    public static final String WirePrefix = "JxtaWire";
    public static final String WireVersion = "1.0";
    public static final String WireTagName = "JxtaWireHeader";
    public static final int DefaultTTL = 7;
    static /* synthetic */ Class class$net$jxta$impl$pipe$WirePipe;

    public WirePipe(PeerGroup g, PipeAdvertisement adv) throws IllegalArgumentException {
        block4: {
            this.myGroup = null;
            this.rendezvous = null;
            this.localPeerId = null;
            this.inputs = null;
            this.pipemsglisteners = null;
            this.valid = false;
            this.wireId = null;
            this.pID = null;
            if (!adv.getType().equals("JxtaPropagate")) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Wrong PipeService type");
                }
                throw new IllegalArgumentException();
            }
            this.myGroup = (RefPeerGroup)g;
            this.pID = (PipeID)adv.getPipeID().clone();
            this.wireId = adv.getPipeID().toString();
            this.rendezvous = this.myGroup.getRendezVousService();
            try {
                this.rendezvous.addPropagateListener(WireName + this.wireId, this);
            }
            catch (Exception e) {
                this.valid = false;
                if (!LOG.isEnabledFor(Priority.WARN)) break block4;
                LOG.warn((Object)"Cannot register EndpointService");
            }
        }
        this.inputs = new Vector();
        this.pipemsglisteners = new Vector();
        this.localPeerId = this.myGroup.getPeerID().toString();
        this.valid = true;
    }

    public InputPipe createInputPipe() throws IOException {
        if (!this.valid) {
            throw new IOException();
        }
        WireInputPipe ip = new WireInputPipe(this);
        return ip;
    }

    public InputPipe createInputPipe(PipeMsgListener listener) throws IOException {
        if (!this.valid) {
            throw new IOException();
        }
        WireInputPipe ip = new WireInputPipe(this, listener);
        return ip;
    }

    public synchronized void registerQueue(EndpointReceiveQueue queue) {
        this.inputs.addElement(queue);
    }

    public synchronized void forgetQueue(EndpointReceiveQueue queue) {
        this.inputs.removeElement(queue);
    }

    public synchronized void registerPipeMsgListener(PipeMsgListener listener) {
        this.pipemsglisteners.addElement(listener);
    }

    public synchronized void forgetPipeMsgListener(PipeMsgListener listener) {
        this.pipemsglisteners.removeElement(listener);
    }

    public OutputPipe createOutputPipe(long timeout) throws IOException {
        if (!this.valid) {
            throw new IOException();
        }
        WirePublicOutputPipe op = null;
        op = new WirePublicOutputPipe(this, this.wireId);
        return op;
    }

    public OutputPipe createOutputPipe(Enumeration peers, long timeout) throws IOException {
        if (!this.valid) {
            throw new IOException();
        }
        WirePrivateOutputPipe op = null;
        op = new WirePrivateOutputPipe(this, this.wireId, peers);
        return op;
    }

    public void sendMessage(Message msg, WireHeader header) throws IOException {
        msg = this.localDemux(msg);
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"propagating message");
        }
        this.propagate(msg, header);
    }

    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processIncominMessage starts");
        }
        WireHeader header = null;
        try {
            MessageElement elem = msg.getElement(WireTagName);
            InputStream ip = elem.getStream();
            if (ip != null) {
                header = new WireHeader(ip);
                ip.close();
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"No JxtaWireHeader tag. Message is discarded");
            }
            return;
        }
        if (this.isLoopback(header)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Loopback detected - discard");
            }
            return;
        }
        if (!this.isAlive(header)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Dead on arrival - discard");
            }
            return;
        }
        msg = this.localDemux(msg);
        if (!this.isToBePropagated(header)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Max TTL reached - discard");
            }
            return;
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"repropagating message");
        }
        this.propagate(msg, header);
    }

    private boolean isLoopback(WireHeader header) {
        Vector peers = header.getPeers();
        if (peers == null || peers.size() <= 0) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"isLoopback: No peers in header");
            }
            return true;
        }
        String peerId = null;
        int i = 0;
        while (i < peers.size()) {
            block8: {
                try {
                    peerId = (String)peers.elementAt(i);
                    if (peerId.equals(this.localPeerId)) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"isLoopback: local peer is in peers");
                        }
                        return true;
                    }
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block8;
                    LOG.warn((Object)("isLoopback failed with " + e));
                }
            }
            ++i;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"isLoopback: this message is not a loopback");
        }
        return false;
    }

    private boolean isAlive(WireHeader header) {
        return true;
    }

    private boolean isToBePropagated(WireHeader header) {
        header.setTTL(header.getTTL() - 1);
        return header.getTTL() >= 1;
    }

    private synchronized Message localDemux(Message msg) {
        Message tmpMsg = null;
        int i = 0;
        while (i < this.inputs.size()) {
            block8: {
                try {
                    EndpointReceiveQueue queue = (EndpointReceiveQueue)this.inputs.elementAt(i);
                    if (queue != null) {
                        tmpMsg = (Message)msg.clone();
                        queue.push(tmpMsg);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block8;
                    LOG.warn((Object)("localDemux failed with " + e));
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.pipemsglisteners.size()) {
            block9: {
                try {
                    PipeMsgListener listener = (PipeMsgListener)this.pipemsglisteners.elementAt(i2);
                    if (listener != null) {
                        tmpMsg = (Message)msg.clone();
                        PipeMsgEvent event = new PipeMsgEvent(this, tmpMsg, this.pID);
                        listener.pipeMsgEvent(event);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block9;
                    LOG.warn((Object)("localDemux failed with " + e));
                }
            }
            ++i2;
        }
        return msg;
    }

    private void addLocalPeer(WireHeader header) {
        Vector<String> peers = header.getPeers();
        if (peers == null) {
            peers = new Vector<String>();
        }
        String peerId = null;
        int i = 0;
        while (i < peers.size()) {
            block6: {
                try {
                    peerId = (String)peers.elementAt(i);
                    if (peerId.equals(this.localPeerId)) {
                        return;
                    }
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block6;
                    LOG.warn((Object)("addLocalPeer failed with " + e));
                }
            }
            ++i;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"Adding local peer id into the header");
        }
        peers.addElement(this.localPeerId);
        header.setPeers(peers);
    }

    private void propagate(Message msg, WireHeader header) {
        block3: {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"propagate starts");
            }
            this.addLocalPeer(header);
            try {
                msg.addElement(msg.newMessageElement(WireTagName, null, header.getInputStream()));
                this.rendezvous.propagateInGroup(msg, WireName, this.wireId, 7, null);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block3;
                LOG.warn((Object)("propagate failed with " + e));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

