/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.protocol.DiscoveryQueryMsg;

public class DiscoveryQuery
extends DiscoveryQueryMsg {
    private static final String typeTag = "Type";
    private static final String peerAdvTag = "PeerAdv";
    private static final String thresholdTag = "Threshold";
    private static final String queryAttrTag = "Attr";
    private static final String queryValueTag = "Value";

    public DiscoveryQuery(InputStream stream) throws IOException {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), stream);
        this.readIt(doc);
    }

    public DiscoveryQuery(TextElement doc) {
        if (!DiscoveryQueryMsg.getAdvertisementType().equals(doc.getName())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.readIt(doc);
    }

    public void readIt(TextElement doc) {
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            if (elem.getName().equals(typeTag)) {
                this.setDiscoveryType(Integer.parseInt(elem.getTextValue()));
                continue;
            }
            if (elem.getName().equals(thresholdTag)) {
                this.setThreshold(Integer.parseInt(elem.getTextValue()));
                continue;
            }
            if (elem.getName().equals(peerAdvTag)) {
                this.setPeerAdv(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals(queryAttrTag)) {
                this.setAttr(elem.getTextValue());
                continue;
            }
            if (!elem.getName().equals(queryValueTag)) continue;
            this.setValue(elem.getTextValue());
        }
    }

    public DiscoveryQuery(int type, String peeradv, String attr, String value, int threshold) {
        this.setDiscoveryType(type);
        this.setThreshold(threshold);
        this.setPeerAdv(peeradv);
        this.setAttr(attr);
        this.setValue(value);
    }

    public Document getDocument(MimeMediaType asMimeType) {
        String attr;
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(asMimeType, DiscoveryQueryMsg.getAdvertisementType());
        Element e = adv.createElement((Object)typeTag, (Object)Integer.toString(this.getDiscoveryType()));
        adv.appendChild(e);
        int threshold = this.getThreshold();
        if (threshold < 0) {
            throw new IllegalStateException("threshold must be >= 0");
        }
        e = adv.createElement((Object)thresholdTag, (Object)Integer.toString(threshold));
        adv.appendChild(e);
        String peerAdv = this.getPeerAdv();
        if (peerAdv != null && peerAdv.length() > 0) {
            e = adv.createElement((Object)peerAdvTag, (Object)this.getPeerAdv());
            adv.appendChild(e);
        }
        if (null != (attr = this.getAttr()) && attr.length() > 0) {
            e = adv.createElement((Object)queryAttrTag, (Object)attr);
            adv.appendChild(e);
            String value = this.getValue();
            if (null == value || 0 == value.length()) {
                throw new IllegalStateException("Query value not initialized");
            }
            e = adv.createElement((Object)queryValueTag, (Object)value);
            adv.appendChild(e);
        }
        return adv;
    }

    public String toString() {
        try {
            StringWriter out = new StringWriter();
            StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(new MimeMediaType("text/xml"));
            doc.sendToWriter(out);
            return out.toString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

