/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.protocol.PeerInfoResponseMessage;

public class PeerInfoResponseMsg
extends PeerInfoResponseMessage {
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public PeerInfoResponseMsg() {
    }

    public PeerInfoResponseMsg(ID spid, ID tpid, long uptime, long timestamp, long itime, long otime, Hashtable itraffic, Hashtable otraffic) {
        this.setSourcePid(spid);
        this.setTargetPid(tpid);
        this.setUptime(uptime);
        this.setTimestamp(timestamp);
        this.setLastIncomingMessageTime(itime);
        this.setLastOutgoingMessageTime(otime);
        Enumeration ik = itraffic.keys();
        while (ik.hasMoreElements()) {
            String k = (String)ik.nextElement();
            this.setIncomingTrafficElement(k, (Long)itraffic.get(k));
        }
        Enumeration ok = otraffic.keys();
        while (ok.hasMoreElements()) {
            String k = (String)ok.nextElement();
            this.setOutgoingTrafficElement(k, (Long)otraffic.get(k));
        }
    }

    public PeerInfoResponseMsg(Element root) {
        this.initialize(root);
    }

    public void initialize(Element root) {
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = PeerInfoResponseMsg.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        this.setSourcePid(null);
        this.setTargetPid(null);
        this.setUptime(0L);
        this.setTimestamp(0L);
        this.setLastIncomingMessageTime(0L);
        this.setLastOutgoingMessageTime(0L);
        TextElement doc = (TextElement)root;
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            URL peerid;
            TextElement element = (TextElement)elements.nextElement();
            String elementName = element.getName();
            if (elementName.equals("sourcePid")) {
                try {
                    peerid = IDFactory.jxtaURL(element.getTextValue());
                    this.setSourcePid(IDFactory.fromURL(peerid));
                    continue;
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad peerid ID in advertisement");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (elementName.equals("targetPid")) {
                try {
                    peerid = IDFactory.jxtaURL(element.getTextValue());
                    this.setTargetPid(IDFactory.fromURL(peerid));
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad peerid ID in advertisement");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (elementName.equals("uptime")) {
                this.setUptime(Long.parseLong(element.getTextValue()));
                continue;
            }
            if (elementName.equals("timestamp")) {
                this.setTimestamp(Long.parseLong(element.getTextValue()));
                continue;
            }
            if (elementName.equals("response")) {
                Enumeration elems = doc.getChildren();
                if (!elems.hasMoreElements()) continue;
                this.setResponse(StructuredDocumentUtils.copyAsDocument((Element)elems.nextElement()));
                continue;
            }
            if (!elementName.equals("traffic")) continue;
            Enumeration traffelems = doc.getChildren();
            while (traffelems.hasMoreElements()) {
                Attribute transportName;
                TextElement ch;
                Enumeration children;
                TextElement traffelem = (TextElement)traffelems.nextElement();
                String traffelemName = traffelem.getName();
                if (traffelemName.equals("lastIncomingMessageAt")) {
                    this.setLastIncomingMessageTime(Long.parseLong(traffelem.getTextValue()));
                    continue;
                }
                if (traffelemName.equals("lastOutgoingMessageAt")) {
                    this.setLastOutgoingMessageTime(Long.parseLong(traffelem.getTextValue()));
                    continue;
                }
                if (elementName.equals("in")) {
                    children = traffelem.getChildren("transport");
                    while (children.hasMoreElements()) {
                        ch = (TextElement)children.nextElement();
                        transportName = ((Attributable)((Object)ch)).getAttribute("name");
                        this.setIncomingTrafficElement(transportName.getValue(), Long.parseLong(ch.getTextValue()));
                    }
                    continue;
                }
                if (!elementName.equals("out")) continue;
                children = traffelem.getChildren("transport");
                while (children.hasMoreElements()) {
                    ch = (TextElement)children.nextElement();
                    transportName = ((Attributable)((Object)ch)).getAttribute("name");
                    this.setOutgoingTrafficElement(transportName.getValue(), Long.parseLong(ch.getTextValue()));
                }
            }
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, PeerInfoResponseMessage.getMessageType());
        TextElement e = null;
        e = doc.createElement("sourcePid", this.getSourcePid().toString());
        doc.appendChild(e);
        e = doc.createElement("targetPid", this.getTargetPid().toString());
        doc.appendChild(e);
        Element response = this.getResponse();
        if (null != response) {
            e = doc.createElement("response");
            doc.appendChild(e);
            StructuredDocumentUtils.copyElements(doc, e, response);
        }
        e = doc.createElement("uptime", String.valueOf(this.getUptime()));
        doc.appendChild(e);
        e = doc.createElement("timestamp", String.valueOf(this.getTimestamp()));
        doc.appendChild(e);
        TextElement traffic = doc.createElement("traffic");
        doc.appendChild((Element)traffic);
        TextElement itime = doc.createElement("lastIncomingMessageAt", String.valueOf(this.getLastIncomingMessageTime()));
        traffic.appendChild((Element)itime);
        TextElement otime = doc.createElement("lastOutgoingMessageAt", String.valueOf(this.getLastOutgoingMessageTime()));
        traffic.appendChild((Element)otime);
        TextElement itraffic = doc.createElement("in");
        traffic.appendChild((Element)itraffic);
        Enumeration ichannels = this.getIncomingTrafficChannels();
        while (ichannels.hasMoreElements()) {
            String ch = (String)ichannels.nextElement();
            long tr = this.getIncomingTrafficOnChannel(ch);
            e = doc.createElement("transport", Long.toString(tr));
            itraffic.appendChild((Element)e);
            ((Attributable)((Object)e)).addAttribute("name", ch);
        }
        TextElement otraffic = doc.createElement("out");
        traffic.appendChild((Element)otraffic);
        Enumeration ochannels = this.getOutgoingTrafficChannels();
        while (ochannels.hasMoreElements()) {
            String ch = (String)ochannels.nextElement();
            long tr = this.getOutgoingTrafficOnChannel(ch);
            e = doc.createElement("transport", Long.toString(tr));
            otraffic.appendChild((Element)e);
            ((Attributable)((Object)e)).addAttribute("name", ch);
        }
        return doc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

