/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.RdvAdvertisement;

public class RdvAdv
extends RdvAdvertisement {
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public ID getID() {
        return ID.nullID;
    }

    public RdvAdv() {
    }

    public RdvAdv(Element root) {
        this.initialize(root);
    }

    public void initialize(Element root) {
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = RdvAdv.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        if (!doc.getName().equals(RdvAdvertisement.getAdvertisementType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + " from doc containing a '" + doc.getName() + "'. Should be : " + RdvAdvertisement.getAdvertisementType());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            if (elem.getName().equals("RdvGroupId")) {
                try {
                    URL groupID = IDFactory.jxtaURL(elem.getTextValue());
                    this.setGroupID((PeerGroupID)IDFactory.fromURL(groupID));
                    continue;
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad group ID in advertisement");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (elem.getName().equals("RdvPeerId")) {
                try {
                    URL peerID = IDFactory.jxtaURL(elem.getTextValue());
                    this.setPeerID((PeerID)IDFactory.fromURL(peerID));
                    continue;
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad peer ID in advertisement");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (!elem.getName().equals("Name")) continue;
            this.setName(elem.getTextValue());
        }
    }

    public Document getDocument(MimeMediaType mediaType) {
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mediaType, RdvAdvertisement.getAdvertisementType());
        TextElement e = adv.createElement("RdvGroupId", this.getGroupID().toString());
        adv.appendChild(e);
        e = adv.createElement("RdvPeerId", this.getPeerID().toString());
        adv.appendChild(e);
        if (this.getName() != null) {
            e = adv.createElement("Name", this.getName());
            adv.appendChild(e);
        }
        return adv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return RdvAdvertisement.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new RdvAdv();
        }

        public Advertisement newInstance(Element root) {
            return new RdvAdv(root);
        }
    }
}

