/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.proxy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.jxta.discovery.DiscoveryEvent;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.proxy.Requestor;
import net.jxta.impl.util.Cache;
import net.jxta.impl.util.CacheEntry;
import net.jxta.impl.util.CacheEntryListener;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.OutputPipeEvent;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.service.Service;
import net.jxta.util.StringEnumeration;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class ProxyService
implements Service,
EndpointListener,
PipeMsgListener,
OutputPipeListener,
CacheEntryListener {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$proxy$ProxyService == null ? (class$net$jxta$impl$proxy$ProxyService = ProxyService.class$("net.jxta.impl.proxy.ProxyService")) : class$net$jxta$impl$proxy$ProxyService).getName());
    protected static final boolean LOG_MESSAGES = false;
    public static final int DEFAULT_THRESHOLD = 2;
    public static final int DEFAULT_LIFETIME = 1800000;
    private PeerGroup group = null;
    private String serviceName = null;
    private String serviceParameter = null;
    private EndpointService endpoint = null;
    private DiscoveryService discovery = null;
    private PipeService pipe = null;
    private Advertisement implAdv = null;
    private Map searchRequests;
    private Map pipeListeners;
    private Cache pendingPipes;
    private Cache resolvedPipes;
    public static final String REQUEST_TAG = "proxy:request";
    public static final String RESPONSE_TAG = "proxy:response";
    public static final String REQUESTID_TAG = "proxy:requestId";
    public static final String TYPE_TAG = "proxy:type";
    public static final String NAME_TAG = "proxy:name";
    public static final String ID_TAG = "proxy:id";
    public static final String ARG_TAG = "proxy:arg";
    public static final String ATTRIBUTE_TAG = "proxy:attr";
    public static final String VALUE_TAG = "proxy:value";
    public static final String ERROR_MESSAGE_TAG = "proxy:error";
    public static final String REQUEST_CREATE = "create";
    public static final String REQUEST_SEARCH = "search";
    public static final String REQUEST_LISTEN = "listen";
    public static final String REQUEST_CLOSE = "close";
    public static final String REQUEST_SEND = "send";
    public static final String RESPONSE_SUCCESS = "success";
    public static final String RESPONSE_ERROR = "error";
    public static final String RESPONSE_INFO = "info";
    public static final String RESPONSE_RESULT = "result";
    public static final String RESPONSE_MESSAGE = "data";
    public static final String TYPE_PEER = "PEER";
    public static final String TYPE_GROUP = "GROUP";
    public static final String TYPE_PIPE = "PIPE";
    static PeerGroup netPeerGroup = null;
    static /* synthetic */ Class class$net$jxta$impl$proxy$ProxyService;

    public Service getInterface() {
        return this;
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdv;
    }

    public void init(PeerGroup group, ID assignedID, Advertisement implAdv) throws PeerGroupException {
        this.group = group;
        this.serviceName = assignedID.toString();
        this.implAdv = implAdv;
        this.serviceParameter = group.getPeerGroupID().toString();
        this.searchRequests = new TreeMap();
        this.pipeListeners = new TreeMap();
        this.pendingPipes = new Cache(200L, null);
        this.resolvedPipes = new Cache(200L, this);
    }

    public int startApp(String[] args) {
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("addListener " + this.serviceName + this.serviceParameter));
        }
        this.endpoint = this.group.getEndpointService();
        this.discovery = this.group.getDiscoveryService();
        this.pipe = this.group.getPipeService();
        this.endpoint.addListener(this.serviceName + this.serviceParameter, this);
        return 0;
    }

    public void stopApp() {
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("removeListener " + this.serviceName + this.serviceParameter));
        }
        this.endpoint.removeListener(this.serviceName + this.serviceParameter, this);
    }

    public synchronized void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        Requestor requestor;
        block13: {
            requestor = null;
            try {
                requestor = Requestor.createRequestor(this.group, message);
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block13;
                LOG.warn((Object)"could not create requestor", (Throwable)e);
            }
        }
        String request = ProxyService.popString(REQUEST_TAG, message);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("request = " + request + " object " + this));
        }
        if (request != null && requestor != null) {
            if (REQUEST_CREATE.equals(request)) {
                this.handleCreateRequest(requestor, ProxyService.popString(TYPE_TAG, message), ProxyService.popString(NAME_TAG, message), ProxyService.popString(ID_TAG, message), ProxyService.popString(ARG_TAG, message));
            } else if (REQUEST_SEARCH.equals(request)) {
                this.handleSearchRequest(requestor, ProxyService.popString(TYPE_TAG, message), ProxyService.popString(ATTRIBUTE_TAG, message), ProxyService.popString(VALUE_TAG, message));
            } else if (REQUEST_LISTEN.equals(request)) {
                this.handleListenRequest(requestor, ProxyService.popString(NAME_TAG, message), ProxyService.popString(ID_TAG, message), ProxyService.popString(ARG_TAG, message));
            } else if (REQUEST_CLOSE.equals(request)) {
                this.handleCloseRequest(requestor, ProxyService.popString(ID_TAG, message));
            } else if (REQUEST_SEND.equals(request)) {
                this.handleSendRequest(requestor, ProxyService.popString(NAME_TAG, message), ProxyService.popString(ID_TAG, message), ProxyService.popString(ARG_TAG, message), message);
            }
        }
    }

    private void handleCreateRequest(Requestor requestor, String type, String name, String id, String arg) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("handleCreateRequest type=" + type + " name=" + name + " id=" + id + " arg=" + arg));
        }
        if (name == null) {
            name = "";
        }
        if (TYPE_PEER.equals(type)) {
            PeerAdvertisement adv = this.createPeerAdvertisement(name, id);
            if (adv != null) {
                block21: {
                    try {
                        this.discovery.publish(adv, 0);
                    }
                    catch (Exception e) {
                        if (!LOG.isEnabledFor(Priority.WARN)) break block21;
                        LOG.warn((Object)"Could not publish peer advertisement");
                    }
                }
                requestor.send(adv, RESPONSE_SUCCESS);
            } else {
                requestor.notifyError("could not create advertisement");
            }
        } else if (TYPE_GROUP.equals(type)) {
            PeerGroupAdvertisement adv = this.createGroupAdvertisement(name, id);
            if (adv != null) {
                block22: {
                    try {
                        this.discovery.publish(adv, 1);
                    }
                    catch (Exception e) {
                        if (!LOG.isEnabledFor(Priority.WARN)) break block22;
                        LOG.warn((Object)"Could not publish group advertisement");
                    }
                }
                requestor.send(adv, RESPONSE_SUCCESS);
            } else {
                requestor.notifyError("could not create advertisement");
            }
        } else if (TYPE_PIPE.equals(type)) {
            PipeAdvertisement adv;
            if (arg == null) {
                arg = "JxtaUnicast";
            }
            if ((adv = this.createPipeAdvertisement(name, id, arg)) != null) {
                block23: {
                    try {
                        this.discovery.publish(adv, 2);
                    }
                    catch (Exception e) {
                        if (!LOG.isEnabledFor(Priority.WARN)) break block23;
                        LOG.warn((Object)"Could not publish pipe advertisement");
                    }
                }
                requestor.send(adv, RESPONSE_SUCCESS);
            } else {
                requestor.notifyError("could not create advertisement");
            }
        } else {
            requestor.notifyError("unsupported type");
        }
    }

    private void handleSearchRequest(Requestor requestor, String type, String attribute, String value) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("handleSearchRequest type=" + type + " attribute=" + attribute + " value=" + value));
        }
        int discoveryType = TYPE_PEER.equals(type) ? 0 : (TYPE_GROUP.equals(type) ? 1 : 2);
        Enumeration enumeration = null;
        try {
            enumeration = this.discovery.getLocalAdvertisements(discoveryType, attribute, value);
        }
        catch (IOException e) {
            requestor.notifyError("could not search locally");
        }
        Advertisement adv = null;
        while (enumeration != null && enumeration.hasMoreElements()) {
            adv = (Advertisement)enumeration.nextElement();
            requestor.send(adv, RESPONSE_RESULT);
        }
        int queryId = this.discovery.getRemoteAdvertisements(null, discoveryType, attribute, value, 2);
    }

    private void handleListenRequest(Requestor requestor, String name, String id, String arg) {
        block14: {
            PipeListenerList list;
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("handleListenRequest name=" + name + " id=" + id + " arg=" + arg));
            }
            PipeAdvertisement pipeAdv = null;
            if (id != null && id.length() > 0) {
                pipeAdv = this.createPipeAdvertisement(name, id, arg);
            } else {
                pipeAdv = this.findPipeAdvertisement(name, id, arg);
                requestor.send(pipeAdv, RESPONSE_INFO);
            }
            if (pipeAdv == null) {
                requestor.notifyError("Could not find pipe");
                return;
            }
            String pipeId = pipeAdv.getPipeID().toString();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("listen to pipe name=" + pipeAdv.getName() + " id=" + pipeAdv.getPipeID().toString() + " arg=" + pipeAdv.getType()));
            }
            if ((list = (PipeListenerList)this.pipeListeners.get(pipeId)) == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"first listener, create input pipe");
                }
                try {
                    list = new PipeListenerList(this.pipe.createInputPipe(pipeAdv, this), this.pipeListeners, pipeId);
                }
                catch (IOException e) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"could not listen to pipe", (Throwable)e);
                    }
                    requestor.notifyError("could not listen to pipe");
                    return;
                }
                this.pipeListeners.put(pipeId, list);
            }
            list.add(requestor);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("add requestor=" + requestor + " id=" + pipeId + " list=" + list));
                LOG.debug((Object)"publish PipeAdvertisement");
            }
            try {
                this.discovery.publish(pipeAdv, 2, 1800000L, 1800000L);
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block14;
                LOG.warn((Object)"Could not publish pipe advertisement");
            }
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"done with listen request");
        }
        requestor.notifySuccess();
    }

    private void handleCloseRequest(Requestor requestor, String id) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("handleCloseRequest id=" + id));
        }
        PipeListenerList list = (PipeListenerList)this.pipeListeners.get(id);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("handleCloseRequest list = " + list));
        }
        if (list != null) {
            list.remove(requestor);
            if (list.size() == 0) {
                this.pipeListeners.remove(id);
            }
        }
        requestor.notifySuccess();
    }

    private void sendToPipe(Requestor req, Message mess, OutputPipe out) {
        try {
            out.send(mess);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"output pipe send end");
            }
            req.notifySuccess();
        }
        catch (IOException e) {
            req.notifyError("could not send to pipe");
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"could not send to pipe", (Throwable)e);
            }
            return;
        }
    }

    private void handleSendRequest(Requestor requestor, String name, String id, String arg, Message message) {
        OutputPipe out;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("handleSendRequest name=" + name + " id=" + id + " arg=" + arg));
        }
        PipeAdvertisement pipeAdv = null;
        if (id != null && id.length() > 0) {
            pipeAdv = this.createPipeAdvertisement(name, id, arg);
        } else {
            pipeAdv = this.findPipeAdvertisement(name, id, arg);
            requestor.send(pipeAdv, RESPONSE_INFO);
        }
        if (pipeAdv == null) {
            requestor.notifyError("Could not find pipe");
            return;
        }
        String pipeId = pipeAdv.getPipeID().toString();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("send to pipe name=" + pipeAdv.getName() + " id=" + pipeAdv.getPipeID().toString() + " arg=" + pipeAdv.getType()));
        }
        PipeListenerList list = (PipeListenerList)this.pipeListeners.get(pipeId);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("local listener list " + list));
        }
        if (list != null && "JxtaUnicast".equals(pipeAdv.getType())) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"start sending to each requestor");
            }
            list.send((Message)message.clone(), pipeId);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"end sending to each requestor");
            }
            requestor.notifySuccess();
            return;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"output pipe creation begin");
        }
        if ((out = (OutputPipe)this.resolvedPipes.get(pipeId)) != null) {
            this.sendToPipe(requestor, message, out);
            return;
        }
        PendingPipe p = (PendingPipe)this.pendingPipes.get(pipeId);
        if (p != null) {
            p.enqueue(requestor, message);
            return;
        }
        try {
            p = new PendingPipe();
            p.enqueue(requestor, message);
            this.pendingPipes.put(pipeId, p);
            this.pipe.createOutputPipe(pipeAdv, this);
        }
        catch (IOException e) {
            this.pendingPipes.remove(pipeId);
            requestor.notifyError("could not create output pipe");
            return;
        }
    }

    private PeerAdvertisement createPeerAdvertisement(String name, String id) {
        PeerAdvertisement adv;
        block11: {
            PeerID pid;
            block10: {
                adv = null;
                pid = null;
                if (id != null) {
                    try {
                        ID tempId = IDFactory.fromURL(IDFactory.jxtaURL(id));
                        if (tempId instanceof PeerID) {
                            pid = (PeerID)tempId;
                        }
                    }
                    catch (UnknownServiceException e) {
                        if (LOG.isEnabledFor(Priority.WARN)) {
                            LOG.warn((Object)"Invalid peerId", (Throwable)e);
                        }
                    }
                    catch (MalformedURLException e) {
                        if (!LOG.isEnabledFor(Priority.WARN)) break block10;
                        LOG.warn((Object)"Could not parse peerId from url", (Throwable)e);
                    }
                }
            }
            if (pid == null) {
                pid = IDFactory.newPeerID(this.group.getPeerGroupID());
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("newPeerAdvertisement name=" + name + " id=" + pid.toString()));
            }
            try {
                adv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(PeerAdvertisement.getAdvertisementType());
                adv.setName(name);
                adv.setPeerID(pid);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block11;
                LOG.warn((Object)"newPeerAdvertisement Exception", (Throwable)e);
            }
        }
        return adv;
    }

    private PeerGroupAdvertisement createGroupAdvertisement(String name, String id) {
        PeerGroupAdvertisement adv;
        block11: {
            PeerGroupID gid;
            block10: {
                adv = null;
                gid = null;
                if (id != null) {
                    try {
                        ID tempId = IDFactory.fromURL(IDFactory.jxtaURL(id));
                        if (tempId instanceof PeerGroupID) {
                            gid = (PeerGroupID)tempId;
                        }
                    }
                    catch (UnknownServiceException e) {
                        if (LOG.isEnabledFor(Priority.WARN)) {
                            LOG.warn((Object)"Invalid peergroupId", (Throwable)e);
                        }
                    }
                    catch (MalformedURLException e) {
                        if (!LOG.isEnabledFor(Priority.WARN)) break block10;
                        LOG.warn((Object)"Could not parse peergroupId from url", (Throwable)e);
                    }
                }
            }
            if (gid == null) {
                gid = IDFactory.newPeerGroupID();
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("newPeerGroupAdvertisement name=" + name + " id=" + gid.toString()));
            }
            try {
                adv = (PeerGroupAdvertisement)AdvertisementFactory.newAdvertisement(PeerGroupAdvertisement.getAdvertisementType());
                adv.setName(name);
                adv.setPeerGroupID(gid);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block11;
                LOG.warn((Object)"newPeerGroupAdvertisement Exception", (Throwable)e);
            }
        }
        return adv;
    }

    private PipeAdvertisement createPipeAdvertisement(String pipeName, String pipeId, String pipeType) {
        PipeAdvertisement adv;
        block4: {
            adv = null;
            LOG.debug((Object)("newPipeAdvertisement name=" + pipeName + " pipeId=" + pipeId + " pipeType=" + pipeType));
            if (pipeType == null || pipeType.length() == 0) {
                pipeType = "JxtaUnicast";
            }
            if (pipeId == null) {
                pipeId = IDFactory.newPipeID(this.group.getPeerGroupID()).toString();
            }
            try {
                adv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
                adv.setName(pipeName);
                adv.setPipeID(IDFactory.fromURL(IDFactory.jxtaURL(pipeId)));
                adv.setType(pipeType);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block4;
                LOG.warn((Object)"newPipeAdvertisement Exception", (Throwable)e);
            }
        }
        return adv;
    }

    private PipeAdvertisement findPipeAdvertisement(String name, String id, String arg) {
        String value;
        String attribute;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("findPipeAdvertisement name=" + name + " id=" + id + " arg=" + arg));
        }
        if (id != null) {
            attribute = "Id";
            value = id;
        } else if (name != null) {
            attribute = "Name";
            value = name;
        } else {
            return null;
        }
        if (arg == null) {
            arg = "JxtaUnicast";
        }
        Enumeration enumeration = null;
        try {
            enumeration = this.discovery.getLocalAdvertisements(2, attribute, value);
        }
        catch (IOException e) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"IOException in getLocalAdvertisements()", (Throwable)e);
            }
            return null;
        }
        PipeAdvertisement pipeAdv = null;
        Advertisement adv = null;
        while (enumeration != null && enumeration.hasMoreElements()) {
            adv = (Advertisement)enumeration.nextElement();
            if (!(adv instanceof PipeAdvertisement)) continue;
            pipeAdv = (PipeAdvertisement)adv;
            if (!LOG.isEnabledFor(Priority.DEBUG)) break;
            LOG.debug((Object)("found PipeAdvertisement = " + pipeAdv));
            break;
        }
        if (pipeAdv == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"create PipeAdvertisement");
            }
            pipeAdv = this.createPipeAdvertisement(name, id, arg);
        }
        return pipeAdv;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void discoveryEvent(DiscoveryEvent event) {
        if (ProxyService.LOG.isEnabledFor(Priority.DEBUG)) {
            ProxyService.LOG.debug((Object)("discoveryEvent " + event));
        }
        if ((requestor = (Requestor)this.searchRequests.get(new Integer(event.getQueryID()))) == null) {
            return;
        }
        response = event.getResponse();
        if (response == null) {
            return;
        }
        enum = response.getResponses();
        if (enum != null && enum.hasMoreElements()) ** GOTO lbl20
        return;
lbl-1000:
        // 1 sources

        {
            try {
                str = (String)enum.nextElement();
                adv = AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), new ByteArrayInputStream(str.getBytes()));
                requestor.send(adv, "result");
                continue;
            }
            catch (Exception e) {
                if (!ProxyService.LOG.isEnabledFor(Priority.WARN)) continue;
                ProxyService.LOG.warn((Object)"Bad result returned by DiscoveryService", (Throwable)e);
            }
lbl20:
            // 4 sources

            ** while (enum.hasMoreElements())
        }
lbl21:
        // 1 sources

    }

    public synchronized void pipeMsgEvent(PipeMsgEvent event) {
        String id;
        PipeListenerList list;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("pipeMsgEvent " + event.getPipeID()));
        }
        if ((list = (PipeListenerList)this.pipeListeners.get(id = event.getPipeID().toString())) != null) {
            Message message = event.getMessage();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"pipeMsgEvent: start sending to each requestor");
            }
            list.send((Message)message.clone(), id);
            LOG.debug((Object)"pipeMsgEvent: end sending to each requestor");
        } else {
            ((InputPipe)event.getSource()).close();
            LOG.debug((Object)("close pipe id=" + id));
        }
    }

    public synchronized void outputPipeEvent(OutputPipeEvent event) {
        PendingPipe p;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("outputPipeEvent " + event));
        }
        if ((p = (PendingPipe)this.pendingPipes.remove(event.getPipeID())) == null) {
            event.getOutputPipe().close();
            return;
        }
        this.resolvedPipes.put(event.getPipeID(), event.getOutputPipe());
        p.sendPending(event.getOutputPipe());
    }

    private static String popString(String name, Message message) {
        String value = message.getString(name);
        message.removeElement(name);
        return value;
    }

    protected static void logMessage(Message message, Category log) {
        String out = "\n**************** begin ****************\n";
        StringEnumeration names = message.getNames();
        while (names.hasMoreStrings()) {
            String name = names.nextString();
            String data = message.getString(name);
            out = out + "[" + name + "]=" + data + "\n";
        }
        log.debug((Object)(out + "****************  end  ****************\n"));
    }

    public static void main(String[] args) throws PeerGroupException {
        netPeerGroup = PeerGroupFactory.newNetPeerGroup();
        Category cat = Category.getInstance((String)"net.jxta.impl.proxy");
        cat.setPriority(Priority.DEBUG);
    }

    public void purged(CacheEntry ce) {
        ((OutputPipe)ce.getValue()).close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class PipeListenerList {
        LinkedList list = new LinkedList();
        InputPipe inputPipe = null;
        Map pipeListeners = null;
        String id = null;

        PipeListenerList(InputPipe inputPipe, Map pipeListeners, String id) {
            this.inputPipe = inputPipe;
            this.pipeListeners = pipeListeners;
            this.id = id;
            if (pipeListeners != null && LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("number of pipeListeners = " + pipeListeners.size()));
            }
        }

        void add(Requestor requestor) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("add " + requestor + " from " + this.toString()));
            }
            if (!this.list.contains(requestor)) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"requestor add");
                }
                this.list.add(requestor);
            } else if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"requestor exits already");
            }
        }

        void remove(Requestor requestor) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("remove " + requestor + " from " + this.toString()));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("removed = " + this.list.remove(requestor)));
            }
            if (this.list.size() == 0) {
                if (this.inputPipe != null) {
                    this.inputPipe.close();
                }
                if (this.id != null && this.pipeListeners != null) {
                    this.pipeListeners.remove(this.id);
                }
            }
        }

        int size() {
            int size = this.list.size();
            LOG.debug((Object)("size " + size));
            return size;
        }

        void send(Message message, String id) {
            LOG.debug((Object)("send list.size = " + this.list.size()));
            message.setString(ProxyService.RESPONSE_TAG, ProxyService.RESPONSE_MESSAGE);
            message.setString(ProxyService.ID_TAG, id);
            StringEnumeration names = message.getNames();
            while (names.hasMoreStrings()) {
                String name = names.nextString();
                if (name.startsWith("RendezVousPropagate")) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("removeElement " + name));
                    }
                    message.removeElement(name);
                    continue;
                }
                if (name.startsWith("JxtaWireHeader")) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("removeElement " + name));
                    }
                    message.removeElement(name);
                    continue;
                }
                if (name.startsWith("JxtaEndpointRouter")) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("removeElement " + name));
                    }
                    message.removeElement(name);
                    continue;
                }
                if (!name.startsWith("jxta:EndpointHeaderSrcPeer")) continue;
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("removeElement " + name));
                }
                message.removeElement(name);
            }
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                Requestor requestor = (Requestor)iterator.next();
                if (requestor.send((Message)message.clone())) continue;
                this.remove(requestor);
            }
        }

        public String toString() {
            String str = "PipeListenerList size=" + this.list.size();
            return str;
        }
    }

    class PendingPipe {
        private ClientMessage pending = null;

        public void sendPending(OutputPipe out) {
            this.pending.send(out);
            this.pending = null;
        }

        public void enqueue(Requestor req, Message mess) {
            if (this.pending != null) {
                return;
            }
            this.pending = new ClientMessage(req, mess);
        }
    }

    class ClientMessage {
        private Requestor requestor;
        private Message message;

        public ClientMessage(Requestor req, Message mess) {
            this.requestor = req;
            this.message = mess;
        }

        public void send(OutputPipe out) {
            ProxyService.this.sendToPipe(this.requestor, this.message, out);
        }
    }
}

