/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.relay;

import java.io.IOException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.servlethttp.MessageSender;
import net.jxta.impl.relay.RelayServer;
import net.jxta.impl.util.BoundedQueue;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class RelayClientMessageSender
implements MessageSender {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$relay$RelayClientMessageSender == null ? (class$net$jxta$impl$relay$RelayClientMessageSender = RelayClientMessageSender.class$("net.jxta.impl.relay.RelayClientMessageSender")) : class$net$jxta$impl$relay$RelayClientMessageSender).getName());
    RelayServer relayServer = null;
    private EndpointAddress localAddress = null;
    static /* synthetic */ Class class$net$jxta$impl$relay$RelayClientMessageSender;

    public RelayClientMessageSender(RelayServer relayServer, EndpointAddress localAddress) {
        this.relayServer = relayServer;
        this.localAddress = localAddress;
    }

    public EndpointMessenger getMessenger(EndpointAddress destAddr) throws IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Getting messenger for EndpointAddress: " + destAddr));
        }
        String clientPeerId = RelayClientMessageSender.getPeerIdFromEndpointAddress(destAddr);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Getting messenger for Peer: " + clientPeerId));
        }
        if (!this.relayServer.hasLease(clientPeerId)) {
            throw new IOException("Destination peer has no lease");
        }
        return new RelayClientMessenger(this.relayServer, this.localAddress, destAddr);
    }

    public void propagate(Message msg, String serviceName, String serviceParams, String prunePeer) throws IOException {
    }

    public void init(EndpointService p) {
    }

    public String getProtocolName() {
        return "http";
    }

    public boolean ping(EndpointAddress addr) {
        String peerId;
        boolean retval;
        block3: {
            retval = false;
            peerId = null;
            try {
                peerId = RelayClientMessageSender.getPeerIdFromEndpointAddress(addr);
                retval = this.relayServer.hasLease(peerId);
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block3;
                LOG.debug((Object)("EndpointAddress malformed: " + addr));
            }
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Ping for " + peerId + " is " + retval));
        }
        return retval;
    }

    private static String getPeerIdFromEndpointAddress(EndpointAddress addr) throws IOException {
        String peerId = addr.getProtocolAddress().substring("JxtaHttpClient".length());
        return peerId;
    }

    public boolean isConnectionOriented() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class RelayClientMessenger
    implements EndpointMessenger {
        RelayServer svr = null;
        EndpointAddress localAddress = null;
        EndpointAddress destAddress = null;
        String clientPeerId = null;
        BoundedQueue queue = null;

        public RelayClientMessenger(RelayServer svr, EndpointAddress localAddress, EndpointAddress destAddress) throws IOException {
            this.svr = svr;
            this.destAddress = destAddress;
            this.localAddress = localAddress;
            this.clientPeerId = RelayClientMessageSender.getPeerIdFromEndpointAddress(destAddress);
            this.queue = svr.getOutboundMessageQueueByPeerId(this.clientPeerId);
        }

        public void sendMessage(Message msg) throws IOException {
            block6: {
                if (this.svr.hasLease(this.clientPeerId)) {
                    try {
                        this.addressMessage(msg);
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"enqueing message");
                        }
                        this.queue.enqueue(msg, -2L);
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"done enqueueing message");
                        }
                        break block6;
                    }
                    catch (InterruptedException e) {
                        if (LOG.isEnabledFor(Priority.INFO)) {
                            LOG.info((Object)"Message send interrupted; message thrown away");
                        }
                        break block6;
                    }
                }
                throw new IOException("Client peer no longer has a lease");
            }
        }

        public void close() {
        }

        private void addressMessage(Message msg) {
            msg.setDestinationAddress(this.destAddress);
            msg.setSourceAddress(this.localAddress);
        }
    }
}

