/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.relay;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.endpoint.EndpointService;
import net.jxta.id.ID;
import net.jxta.impl.relay.RelayLease;
import net.jxta.impl.relay.RelayLeaseException;
import net.jxta.impl.util.Base64;
import net.jxta.impl.util.BoundedQueue;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class RelayServer {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$relay$RelayServer == null ? (class$net$jxta$impl$relay$RelayServer = RelayServer.class$("net.jxta.impl.relay.RelayServer")) : class$net$jxta$impl$relay$RelayServer).getName());
    private static Timer timer = new Timer();
    private static final String LEASE_LEN_KEY = "RelayServer.LeaseLength";
    private int leaseLength = 1800000;
    private SecureRandom random = null;
    private EndpointService endpoint = null;
    private HashMap leaseMap = new HashMap();
    private HashMap peerMap = new HashMap();
    static /* synthetic */ Class class$net$jxta$impl$relay$RelayServer;

    public ID getPeerID() {
        return this.endpoint.getGroup().getPeerID();
    }

    public RelayServer(EndpointService endpoint, Properties prop) {
        this.endpoint = endpoint;
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)"RelayServer does not have SHA1PRNG crypto algorithm");
            }
            throw new RuntimeException("RelayServer does not have SHA1PRNG crypto algorithm");
        }
        if (prop != null) {
            String leaseLenStr = prop.getProperty(LEASE_LEN_KEY);
            if (leaseLenStr != null) {
                try {
                    this.leaseLength = Integer.parseInt(leaseLenStr);
                }
                catch (NumberFormatException e) {
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)"Illegal value specified for RelayServer.LeaseLength");
                    }
                }
            } else if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"Using default value for lease length");
            }
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("lease length = " + this.leaseLength));
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"Generating initial lease key");
        }
        this.generateLeaseId();
    }

    public RelayLease issueNewLease(String clientPeerId) {
        RelayLease newLease = null;
        RelayLease oldLease = null;
        RelayServer relayServer = this;
        synchronized (relayServer) {
            oldLease = (RelayLease)this.peerMap.remove(clientPeerId);
            if (oldLease != null) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Peer " + clientPeerId + " already has a lease"));
                }
                this.leaseMap.remove(oldLease.getLeaseId());
            }
            String newLeaseId = this.generateLeaseId();
            newLease = new RelayLease(clientPeerId, newLeaseId, this.leaseLength);
            this.leaseMap.put(newLeaseId, newLease);
            this.peerMap.put(clientPeerId, newLease);
            newLease.setTimerTask(new LeaseExpirationTask(newLease));
            timer.schedule(newLease.getTimerTask(), this.leaseLength);
        }
        if (oldLease != null) {
            ((LeaseExpirationTask)oldLease.getTimerTask()).disable();
            oldLease.close();
        }
        return newLease;
    }

    public synchronized RelayLease renewLease(String leaseId) throws RelayLeaseException {
        RelayLease currLease;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("attempting to renew lease " + leaseId));
        }
        if ((currLease = (RelayLease)this.leaseMap.get(leaseId)) == null || !currLease.isValid()) {
            throw new RelayLeaseException("Existing lease is not valid");
        }
        currLease.refresh();
        return currLease;
    }

    private void leaseEvent(RelayLease lease) {
        RelayServer relayServer = this;
        synchronized (relayServer) {
            if (!this.leaseMap.containsKey(lease.getLeaseId())) {
                return;
            }
            if (lease.isValid()) {
                lease.setTimerTask(new LeaseExpirationTask(lease));
                timer.schedule(lease.getTimerTask(), lease.getTimeLeft());
                return;
            }
            this.peerMap.remove(lease.getPeerId());
            this.leaseMap.remove(lease.getLeaseId());
        }
        lease.close();
    }

    public synchronized boolean hasLease(String clientPeerId) {
        return this.peerMap.get(clientPeerId) != null;
    }

    public synchronized String getLeaseId(String clientPeerId) {
        RelayLease lease = (RelayLease)this.peerMap.get(clientPeerId);
        if (lease == null) {
            return null;
        }
        return lease.getLeaseId();
    }

    public synchronized BoundedQueue getOutboundMessageQueueByPeerId(String clientPeerId) {
        RelayLease lease = (RelayLease)this.peerMap.get(clientPeerId);
        if (lease == null) {
            return null;
        }
        return lease.getQueue();
    }

    public synchronized BoundedQueue getOutboundMessageQueueByLeaseId(String leaseId) {
        RelayLease lease = (RelayLease)this.leaseMap.get(leaseId);
        if (lease == null) {
            return null;
        }
        return lease.getQueue();
    }

    private String generateLeaseId() {
        byte[] buf = new byte[16];
        this.random.nextBytes(buf);
        return new String(Base64.encodeBase64(buf)).trim();
    }

    public void removeLease(String leaseId) {
        RelayLease lease = null;
        RelayServer relayServer = this;
        synchronized (relayServer) {
            lease = (RelayLease)this.leaseMap.remove(leaseId);
            if (lease == null) {
                return;
            }
            this.peerMap.remove(lease.getPeerId());
        }
        ((LeaseExpirationTask)lease.getTimerTask()).disable();
        lease.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class LeaseExpirationTask
    extends TimerTask {
        RelayLease lease = null;

        LeaseExpirationTask(RelayLease lease) {
            this.lease = lease;
        }

        public void run() {
            RelayLease tmp = this.lease;
            if (tmp != null) {
                RelayServer.this.leaseEvent(tmp);
            }
        }

        public void disable() {
            this.lease = null;
        }
    }
}

