/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointFilterListener;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.rendezvous.PeerConnection;
import net.jxta.impl.rendezvous.RdvManager;
import net.jxta.impl.rendezvous.RdvMonitor;
import net.jxta.impl.rendezvous.RendAddrCompactor;
import net.jxta.impl.rendezvous.RendezVousPropagateMessage;
import net.jxta.impl.rendezvous.RendezVousServiceInterface;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.rendezvous.RendezVousManager;
import net.jxta.rendezvous.RendezVousMonitor;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class RendezVousServiceImpl
implements RendezVousService,
EndpointListener {
    public static final int MaxTTL = 10;
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$rendezvous$RendezVousServiceImpl == null ? (class$net$jxta$impl$rendezvous$RendezVousServiceImpl = RendezVousServiceImpl.class$("net.jxta.impl.rendezvous.RendezVousServiceImpl")) : class$net$jxta$impl$rendezvous$RendezVousServiceImpl).getName());
    private static final long GCDelay = 60000L;
    private static final String ConnectRequest = "jxta:Connect";
    private static final String DisconnectRequest = "jxta:Disconnect";
    private static final String ConnectedPeerReply = "jxta:ConnectedPeer";
    private static final String ConnectedLeaseReply = "jxta:ConnectedLease";
    private static final String ConnectedRdvAdvReply = "jxta:RdvAdvReply";
    private static final String PingRequest = "jxta:PingRequest";
    private static final String PingReply = "jxta:PingReply";
    private static final String RdvAdvReply = "jxta:RdvAdv";
    private String pName = null;
    private EndpointService endpoint = null;
    private ID assignedID = null;
    private PeerGroup group = null;
    private String gId = null;
    private Vector rendezVous = null;
    private Vector removedRendezVous = new Vector();
    private Vector clients = null;
    private RendezVousManager manager = null;
    private RendezVousMonitor monitor = null;
    private boolean isRendezVous = false;
    private boolean configIsRendezvous = false;
    private boolean isClient = false;
    private boolean endpointCreated = false;
    private String pParam = null;
    private String headerName = null;
    private String localPeerId = null;
    private String localPeerAddr = null;
    private Advertisement localPeerAdv = null;
    private Timer GCTimer = new Timer();
    private ModuleImplAdvertisement implAdvertisement = null;
    private Hashtable listeners = new Hashtable();
    private EndpointFilterListener filterListener = null;
    private Vector applisteners = new Vector();
    private MimeMediaType textXml = new MimeMediaType("text/xml");
    private RendAddrCompactor compactor = null;
    private Vector initialCompactorParams = new Vector();
    private boolean stopping = false;
    private static final String PropSName = "JxtaPropagate";
    private String PropPName = null;
    private PropagateListener propagateListener = null;
    private static final int MaxNbOfStoredIds = 1000;
    private Vector msgIds = new Vector(1000);
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$RendezVousServiceImpl;

    public synchronized RendezVousMonitor setMonitor(RendezVousMonitor handler) {
        RendezVousMonitor old = this.monitor;
        this.monitor = handler;
        return old;
    }

    public Service getInterface() {
        return new RendezVousServiceInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public boolean isRendezVous() {
        return this.isRendezVous;
    }

    public synchronized Enumeration getConnectedPeers() {
        Vector<ID> result = new Vector<ID>();
        if (!this.isRendezVous) {
            return result.elements();
        }
        if (this.clients == null || this.clients.size() == 0) {
            return result.elements();
        }
        int i = 0;
        while (i < this.clients.size()) {
            try {
                PeerConnection pConn = (PeerConnection)this.clients.elementAt(i);
                String peerId = pConn.getPeer();
                ID id = IDFactory.fromURL(IDFactory.jxtaURL(peerId));
                result.addElement(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return result.elements();
    }

    public boolean isConnectedToRendezVous() {
        Enumeration enumeration = this.getConnectedRendezVous();
        if (enumeration == null) {
            return false;
        }
        return enumeration.hasMoreElements();
    }

    public int startApp(String[] arg) {
        block3: {
            if (this.configIsRendezvous) {
                this.startRendezVous();
            }
            this.compactor = new RendAddrCompactor(this.group, this.initialCompactorParams);
            this.propagateListener = new PropagateListener(this);
            try {
                this.endpoint.addListener(PropSName + this.PropPName, this.propagateListener);
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block3;
                LOG.warn((Object)"Cannot register the propagation listener", (Throwable)ez1);
            }
        }
        this.GCTimer.scheduleAtFixedRate((TimerTask)new GCTask(this), 60000L, 60000L);
        return 0;
    }

    public synchronized void stopApp() {
        this.stopping = true;
        this.compactor.shutdown();
        this.stopRendezVous();
        this.endpoint.removeListener(PropSName + this.PropPName, this.propagateListener);
        this.endpoint.removeFilterListener(this.headerName, this.filterListener, true);
    }

    public void init(PeerGroup g, ID assignedID, Advertisement impl) {
        PeerAdvertisement confAdv;
        block12: {
            this.implAdvertisement = (ModuleImplAdvertisement)impl;
            confAdv = (PeerAdvertisement)g.getConfigAdvertisement();
            this.group = g;
            this.gId = g.getPeerGroupID().toString();
            this.assignedID = assignedID;
            this.endpoint = g.getEndpointService();
            this.pParam = this.group.getPeerGroupID().toString();
            this.pName = assignedID.toString();
            this.PropPName = this.pParam;
            this.headerName = "RendezVousPropagate" + this.pParam;
            this.localPeerId = this.group.getPeerID().toString();
            this.localPeerAddr = "jxta://" + this.group.getPeerID().getUniqueValue().toString();
            this.localPeerAdv = this.group.getPeerAdvertisement();
            this.filterListener = new FilterListener();
            try {
                this.endpoint.addFilterListener(this.headerName, this.filterListener, true);
                this.endpoint.addFilterListener("RendezVousPropagate", this.filterListener, true);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("Cannot register the filter: " + e));
                }
                if (!LOG.isEnabledFor(Priority.WARN)) break block12;
                LOG.warn((Object)"This peer will not filter potentional loopbacks, expired or duplicate messages.");
            }
        }
        if (confAdv == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"RendezVousService is initialized");
            }
            return;
        }
        StructuredTextDocument params = (StructuredTextDocument)confAdv.getServiceParam(assignedID);
        if (params == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"RendezVousService is initialized");
            }
            return;
        }
        Enumeration param = params.getChildren("Rdv");
        this.configIsRendezvous = param.hasMoreElements() && "true".equals(((TextElement)param.nextElement()).getTextValue());
        param = params.getChildren("Addr");
        while (param.hasMoreElements()) {
            this.initialCompactorParams.addElement(((TextElement)param.nextElement()).getTextValue());
        }
        if (this.configIsRendezvous) {
            try {
                params = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(this.textXml, "Parm");
                TextElement e = params.createElement("Rdv", "true");
                params.appendChild((Element)e);
                ((PeerAdvertisement)this.localPeerAdv).putServiceParam(assignedID, params);
            }
            catch (Exception ohwell) {
                // empty catch block
            }
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"RendezVousService is initialized");
        }
    }

    private void publishInParentGroup(Advertisement adv) {
        block5: {
            RefPeerGroup parent = ((RefPeerGroup)this.group).getParentGroup();
            if (parent == null) {
                return;
            }
            DiscoveryService parentDiscovery = parent.getDiscoveryService();
            if (parentDiscovery == null) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Cannot access parent's DiscoveryService Service");
                }
                return;
            }
            try {
                parentDiscovery.publish(adv, 0, 0x6DDD00L, 0x6DDD00L);
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block5;
                LOG.warn((Object)"Cannot locally publish advertisementin parent group");
            }
        }
    }

    public void connectToRendezVous(PeerAdvertisement adv) throws IOException {
        String peerId;
        block7: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"connectToRendezVous with advertisement");
            }
            if (adv == null) {
                return;
            }
            peerId = adv.getPeerID().toString();
            if (peerId.equals(this.localPeerId)) {
                return;
            }
            try {
                this.group.getDiscoveryService().publish(adv, 0, 0x6DDD00L, 0x6DDD00L);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block7;
                LOG.debug((Object)("   publish failed with " + e));
            }
        }
        this.publishInParentGroup(adv);
        EndpointAddress endpointAddress = this.mkAddress(peerId);
        if (!this.endpoint.ping(endpointAddress)) {
            throw new IOException("Unable to ping address " + endpointAddress);
        }
        endpointAddress = this.mkAddress(peerId, this.pName, this.pParam);
        EndpointMessenger messenger = this.endpoint.getMessenger(endpointAddress);
        if (messenger == null) {
            throw new IOException("Unable to create endpoint messenger to " + endpointAddress);
        }
        this.connectToRendezVous(messenger);
    }

    public void connectToRendezVous(EndpointAddress addr) throws IOException {
        String proto;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"connectToRendezVous with EndpointAddress");
        }
        if (addr == null) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"bad endpoint address");
            }
            return;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            try {
                LOG.debug((Object)("    to = " + addr.getProtocolName() + "://" + addr.getProtocolAddress()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!(proto = addr.getProtocolName()).equals("jxta")) {
            if (!this.endpoint.ping(addr)) {
                throw new IOException("Cannot ping rendezvous at " + addr);
            }
        } else {
            String peerId = addr.getProtocolName() + "://" + addr.getProtocolAddress();
            if (peerId.equals(this.localPeerAddr)) {
                return;
            }
        }
        addr.setServiceName(this.pName);
        addr.setServiceParameter(this.pParam);
        try {
            EndpointMessenger messenger = this.endpoint.getMessenger(addr);
            if (messenger == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"no messenger");
                }
                throw new IOException("no messenger for address " + addr);
            }
            this.connectToRendezVous(messenger);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"connectToRendezVous failed", (Throwable)e);
            }
            throw new IOException("connectToRendezVous at " + addr + " failed");
        }
    }

    public void reconnectToRendezVous(String peer) {
        block6: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("reconnectToRendezVous to " + peer));
            }
            if (peer.equals(this.localPeerAddr)) {
                return;
            }
            try {
                EndpointAddress endpointAddress = this.mkAddress(peer, this.pName, this.pParam);
                EndpointMessenger messenger = this.endpoint.getMessenger(endpointAddress);
                if (messenger == null) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)("Could not get messenger for " + endpointAddress + "; aborting"));
                    }
                    throw new IOException("Could not get messenger for " + endpointAddress + "; aborting");
                }
                this.connectToRendezVous(messenger);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block6;
                LOG.debug((Object)"reconnecteRendezVous failed ", (Throwable)e);
            }
        }
    }

    public void disconnectFromRendezVous(PeerID rdv) {
        String peerId;
        block5: {
            if (!this.isClient || rdv == null) {
                return;
            }
            peerId = rdv.toString();
            try {
                EndpointMessenger messenger = this.endpoint.getMessenger(this.mkAddress(peerId, this.pName, this.pParam));
                if (messenger != null) {
                    this.disconnectFromRendezVous(messenger);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block5;
                LOG.debug((Object)("Error getting messenger to disconnect from rdv " + peerId), (Throwable)e);
            }
        }
        this.removeRdv(peerId);
        if (this.rendezVous.size() == 0) {
            this.rendezVous = null;
            this.isClient = false;
        }
    }

    public synchronized Enumeration getConnectedRendezVous() {
        Vector<ID> result = new Vector<ID>();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"getConnectedRendezVous");
        }
        if (!this.isClient) {
            return result.elements();
        }
        if (this.rendezVous == null || this.rendezVous.size() == 0) {
            return result.elements();
        }
        int i = 0;
        while (i < this.rendezVous.size()) {
            block6: {
                try {
                    PeerConnection pConn = (PeerConnection)this.rendezVous.elementAt(i);
                    String peerId = pConn.getPeer();
                    ID id = IDFactory.fromURL(IDFactory.jxtaURL(peerId));
                    result.addElement(id);
                }
                catch (Exception ignored) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block6;
                    LOG.debug((Object)"getConnectedRendezVous failed to construct peerid ", (Throwable)ignored);
                }
            }
            ++i;
        }
        return result.elements();
    }

    public synchronized Enumeration getDisconnectedRendezVous() {
        Vector<ID> result = new Vector<ID>();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"getDisconnectedRendezVous");
        }
        if (!this.isClient) {
            return result.elements();
        }
        if (this.removedRendezVous.size() == 0) {
            return result.elements();
        }
        int i = 0;
        while (i < this.removedRendezVous.size()) {
            try {
                PeerConnection pConn = (PeerConnection)this.removedRendezVous.elementAt(i);
                String peerId = pConn.getPeer();
                ID id = IDFactory.fromURL(IDFactory.jxtaURL(peerId));
                result.addElement(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return result.elements();
    }

    public void sendRendezVousAdv(PeerAdvertisement destPeer, PeerAdvertisement rdv) {
        block7: {
            block6: {
                try {
                    this.group.getDiscoveryService().publish(destPeer, 0, 0x6DDD00L, 0x6DDD00L);
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block6;
                    LOG.debug((Object)"publish failed with ", (Throwable)e);
                }
            }
            this.publishInParentGroup(destPeer);
            String peer = destPeer.getPeerID().toString();
            if (!this.endpoint.ping(this.endpoint.newEndpointAddress(peer))) {
                return;
            }
            try {
                EndpointMessenger messenger = this.endpoint.getMessenger(this.mkAddress(peer, this.pName, this.pParam));
                if (messenger == null) {
                    return;
                }
                Message msg = this.endpoint.newMessage();
                msg.addElement(msg.newMessageElement(RdvAdvReply, this.textXml, rdv.getDocument(this.textXml).getStream()));
                messenger.sendMessage(msg);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block7;
                LOG.debug((Object)"Error during send to rdv ", (Throwable)e);
            }
        }
    }

    public synchronized void startRendezVous(RendezVousManager handler) throws IOException {
        if (this.isRendezVous || handler == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"startRendezvous: already a rendezvous");
            }
            throw new IOException("I'm already a rendezvous.");
        }
        this.manager = handler;
        this.clients = new Vector();
        this.createLocalEndpoint();
        this.isRendezVous = true;
        try {
            StructuredTextDocument params = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(this.textXml, "Parm");
            TextElement e = params.createElement("Rdv", "true");
            params.appendChild((Element)e);
            ((PeerAdvertisement)this.localPeerAdv).putServiceParam(this.assignedID, params);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((RdvMonitor)this.monitor).startRdv();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"RendezVousService is started");
        }
    }

    public synchronized void startRendezVous() {
        if (this.isRendezVous) {
            return;
        }
        try {
            this.startRendezVous(new RdvManager(this.group));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void stopRendezVous() {
        if (!this.isRendezVous) {
            return;
        }
        ((PeerAdvertisement)this.localPeerAdv).removeServiceParam(this.assignedID);
        this.isRendezVous = false;
        this.deleteLocalEndpoint();
        this.clients = null;
    }

    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"demux");
        }
        if (msg.hasElement(ConnectRequest)) {
            this.processConnectRequest(msg);
        }
        if (msg.hasElement(DisconnectRequest)) {
            this.processDisconnectRequest(msg);
        }
        if (msg.hasElement(RdvAdvReply)) {
            this.processRdvAdvReply(msg);
        }
        if (msg.hasElement(ConnectedPeerReply)) {
            this.processConnectedReply(msg);
        }
        if (msg.hasElement(PingRequest)) {
            this.processPingRequest(msg);
        }
        if (msg.hasElement(PingReply)) {
            this.processPingReply(msg);
        }
    }

    protected void processReceivedMessage(Message message, String msgId, String sName, String sParam, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        EndpointListener listener;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processReceivedMessage starts");
        }
        if ((listener = (EndpointListener)this.listeners.get(sName + sParam)) != null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Local listener is called");
            }
            EndpointAddress realDst = this.endpoint.newEndpointAddress(dstAddr.toString());
            realDst.setServiceName(sName);
            realDst.setServiceParameter(sParam);
            if (this.isMsgIdRecorded(msgId)) {
                return;
            }
            this.addMsgId(msgId);
            listener.processIncomingMessage(message, srcAddr, realDst);
        } else {
            this.addMsgId(msgId);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"No local listener - repropagate");
            }
            this.rePropagateInGroup(message);
        }
    }

    public synchronized void addPropagateListener(String name, EndpointListener listener) throws IOException {
        block2: {
            this.listeners.put(name, listener);
            try {
                this.endpoint.addListener(name, listener);
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block2;
                LOG.warn((Object)("Cannot connect listener " + name), (Throwable)ez1);
            }
        }
    }

    public synchronized void removePropagateListener(String name, EndpointListener listener) throws IOException {
        EndpointListener myListener = (EndpointListener)this.listeners.get(name);
        if (myListener == null) {
            throw new IOException("No propagate listener named \"" + name + "\"");
        }
        this.listeners.remove(name);
    }

    public void addListener(RendezvousListener listener) {
        this.applisteners.addElement(listener);
    }

    public boolean removeListener(RendezvousListener listener) {
        return this.applisteners.removeElement(listener);
    }

    public void propagate(Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        if (defaultTTL == 1) {
            this.propagateToNeighbors(msg, serviceName, serviceParam, defaultTTL, null);
        } else {
            this.propagateInGroup(msg, serviceName, serviceParam, defaultTTL, null);
        }
    }

    public void propagateToNeighbors(Message msg, String serviceName, String serviceParam, int defaultTTL, String prunePeer) throws IOException {
        Message dupMsg = (Message)msg.clone();
        if (this.updatePropHeader(dupMsg, defaultTTL, serviceName, serviceParam)) {
            this.sendToNetwork(dupMsg, PropSName, this.PropPName);
        }
    }

    public void propagateInGroup(Message msg, String serviceName, String serviceParam, int defaultTTL, String prunePeer) throws IOException {
        Message dupMsg = (Message)msg.clone();
        if (this.updatePropHeader(dupMsg, defaultTTL, serviceName, serviceParam)) {
            this.sendToNetwork(dupMsg, PropSName, this.PropPName);
            this.sendToEachRendezVous(dupMsg, PropSName, this.PropPName);
            this.sendToEachClient(dupMsg, PropSName, this.PropPName);
        }
    }

    protected void rePropagateInGroup(Message msg) {
        block3: {
            try {
                Message dupMsg = (Message)msg.clone();
                if (this.updatePropHeader(dupMsg, 10, null, null)) {
                    this.sendToNetwork(dupMsg, PropSName, this.PropPName);
                    this.sendToEachRendezVous(dupMsg, PropSName, this.PropPName);
                    this.sendToEachClient(dupMsg, PropSName, this.PropPName);
                }
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block3;
                LOG.debug((Object)"Cannot repropagate the message ", (Throwable)ez1);
            }
        }
    }

    private boolean isPeerInPropHeader(Message msg, String peer) {
        MessageElement elem = msg.getElement(this.headerName);
        if (elem == null && (elem = msg.getElement("RendezVousPropagate")) == null) {
            return false;
        }
        try {
            InputStream ip = elem.getStream();
            if (ip == null) {
                return false;
            }
            RendezVousPropagateMessage propHdr = null;
            propHdr = new RendezVousPropagateMessage(ip);
            return propHdr.hasInPath(peer);
        }
        catch (Exception ez1) {
            return false;
        }
    }

    private EndpointAddress mkAddress(String destPeer) {
        try {
            PeerID asID = (PeerID)IDFactory.fromURL(IDFactory.jxtaURL(destPeer));
            String asString = "jxta://" + asID.getUniqueValue().toString();
            EndpointAddress addr = this.endpoint.newEndpointAddress(asString);
            return addr;
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("Invalid peerID string : " + destPeer), (Throwable)e);
            }
            return null;
        }
    }

    private EndpointAddress mkAddress(String destPeer, String serv, String parm) {
        EndpointAddress addr = this.mkAddress(destPeer);
        addr.setServiceName(serv);
        addr.setServiceParameter(parm);
        return addr;
    }

    private synchronized void addRdv(String peer, long lease) {
        PeerConnection tmp;
        if (peer == null) {
            return;
        }
        if (!this.isClient) {
            this.rendezVous = new Vector();
            this.isClient = true;
        }
        if (this.rendezVous.contains(tmp = new PeerConnection(this.group, peer, lease))) {
            block13: {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   already registered");
                }
                try {
                    int index = this.rendezVous.indexOf(tmp);
                    if (index == -1) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("addRdv: cannot access PeerConnection for " + peer));
                        }
                    } else {
                        tmp = (PeerConnection)this.rendezVous.elementAt(index);
                        long time = System.currentTimeMillis();
                        if (lease < 0L) {
                            tmp.setLease(lease);
                        } else {
                            tmp.setLease(time + lease);
                        }
                        tmp.connect();
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("Got renewed leased for " + peer));
                        }
                    }
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block13;
                    LOG.debug((Object)"addRdv has failed [1] ", (Throwable)e);
                }
            }
            return;
        }
        tmp.connect();
        this.rendezVous.addElement(tmp);
        this.generateEvent(0, peer);
        if (this.removedRendezVous.contains(tmp)) {
            this.removedRendezVous.remove(tmp);
        }
    }

    private synchronized void removeRdv(String peer) {
        if (peer == null) {
            return;
        }
        PeerConnection tmp = new PeerConnection(this.group, peer, 0L);
        if (!this.rendezVous.contains(tmp)) {
            return;
        }
        tmp.close();
        this.rendezVous.removeElement(tmp);
        this.removedRendezVous.addElement(tmp);
        this.generateEvent(4, peer);
    }

    private synchronized void addClient(String peer, long lease) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"addClient starts");
        }
        if (peer == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"no peer");
            }
            return;
        }
        if (!this.isRendezVous) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"is not a rendezvous");
            }
            return;
        }
        PeerConnection tmp = new PeerConnection(this.group, peer, lease);
        if (this.clients.contains(tmp)) {
            block16: {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   already registered");
                }
                try {
                    int index = this.clients.indexOf(tmp);
                    if (index == -1) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("addClient: cannot access PeerConnection for " + peer));
                        }
                    } else {
                        tmp = (PeerConnection)this.clients.elementAt(index);
                        long time = System.currentTimeMillis();
                        if (lease < 0L) {
                            tmp.setLease(lease);
                        } else {
                            tmp.setLease(time + lease);
                        }
                        tmp.connect();
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("Renewed leased for " + peer));
                        }
                    }
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block16;
                    LOG.debug((Object)"addClient has failed [1] ", (Throwable)e);
                }
            }
            return;
        }
        tmp.connect();
        this.clients.addElement(tmp);
        this.generateEvent(2, peer);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"   done");
        }
    }

    private synchronized void removeClient(String peer) {
        if (peer == null) {
            return;
        }
        PeerConnection tmp = new PeerConnection(this.group, peer, 0L);
        if (!this.clients.contains(tmp)) {
            return;
        }
        tmp.close();
        this.clients.removeElement(tmp);
        this.generateEvent(6, peer);
    }

    private void createLocalEndpoint() throws IOException {
        if (this.endpointCreated) {
            return;
        }
        try {
            this.endpoint.addListener(this.pName + this.pParam, this);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        this.endpointCreated = true;
    }

    private void deleteLocalEndpoint() {
        if (!this.endpointCreated) {
            return;
        }
        this.endpoint.removeListener(this.pName + this.pParam, this);
        this.endpointCreated = false;
    }

    private void connectToRendezVous(EndpointMessenger messenger) throws IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"connectToRendezVous begins");
        }
        if (messenger == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   messenger is null");
            }
            throw new IOException("   messenger is null");
        }
        this.createLocalEndpoint();
        Message msg = this.endpoint.newMessage();
        try {
            InputStream ip = null;
            Document doc = null;
            doc = this.localPeerAdv.getDocument(this.textXml);
            ip = doc.getStream();
            msg.addElement(msg.newMessageElement(ConnectRequest, this.textXml, ip));
            messenger.sendMessage(msg);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"connectToRendezVous failed", (Throwable)e);
            }
            throw new IOException("connectToRendezVous failed : " + e.getMessage());
        }
    }

    private void disconnectFromRendezVous(EndpointMessenger messenger) throws IOException {
        if (messenger == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   messenger is null");
            }
            throw new IOException("   messenger is null");
        }
        Message msg = this.endpoint.newMessage();
        try {
            InputStream ip = null;
            Document doc = null;
            doc = this.localPeerAdv.getDocument(this.textXml);
            ip = doc.getStream();
            msg.addElement(msg.newMessageElement(DisconnectRequest, this.textXml, ip));
            messenger.sendMessage(msg);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"disconnectFromRendezVous failed", (Throwable)e);
            }
            throw new IOException("disconnectFromRendezVous failed :" + e.getMessage());
        }
    }

    private void processConnectRequest(Message msg) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processConnectRequest");
        }
        if (!this.isRendezVous || this.manager == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   not a rendezvous");
            }
            return;
        }
        PeerAdvertisement adv = null;
        try {
            MessageElement elem = msg.getElement(ConnectRequest);
            msg.removeElement(ConnectRequest);
            adv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(this.textXml, elem.getStream());
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   cannot retrieve advertisment from request");
            }
            return;
        }
        if (adv == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   advertisement is null");
            }
            return;
        }
        long lease = this.manager.requestConnection(adv);
        if (!this.sendReply(adv.getPeerID().toString(), adv, lease)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("processConnectRequest. Cannot reach client " + adv.getPeerID()));
            }
            return;
        }
        if (lease != 0L) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"  addClient");
            }
            this.addClient(adv.getPeerID().toString(), lease);
        }
    }

    private void processDisconnectRequest(Message msg) {
        if (!this.isRendezVous || this.manager == null) {
            return;
        }
        PeerAdvertisement adv = null;
        try {
            adv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(this.textXml, msg.getElement(DisconnectRequest).getStream());
        }
        catch (Exception e) {
            return;
        }
        if (adv == null) {
            return;
        }
        this.removeClient(adv.getPeerID().toString());
    }

    private void processConnectedReply(Message msg) {
        block28: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processConnectedReply");
            }
            boolean size = false;
            InputStream is = msg.getElement(ConnectedRdvAdvReply).getStream();
            Advertisement adv = null;
            if (is != null) {
                try {
                    adv = AdvertisementFactory.newAdvertisement(this.textXml, is);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (adv == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   no advertisement");
                }
            } else {
                this.publishInParentGroup(adv);
                try {
                    this.group.getDiscoveryService().publish(adv, 0, 0x6DDD00L, 0x6DDD00L);
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block28;
                    LOG.debug((Object)("   publish failed with " + e));
                }
            }
        }
        long lease = 0L;
        try {
            MessageElement el = msg.getElement(ConnectedLeaseReply);
            if (el == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"missing lease");
                }
                return;
            }
            byte[] buffer = el.getBytesOffset();
            int offset = el.getOffset();
            int len = el.getLength();
            lease = Long.parseLong(new String(buffer, offset, len));
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("lease=" + lease));
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)(" leased failed with " + e));
            }
            return;
        }
        String peer = null;
        try {
            MessageElement el = msg.getElement(ConnectedPeerReply);
            if (el == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"missing rdv peer");
                }
                return;
            }
            byte[] buffer = el.getBytesOffset();
            peer = new String(el.getBytesOffset(), el.getOffset(), el.getLength());
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("peer=" + peer));
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("  getting peer failed with " + e));
            }
            return;
        }
        PeerID pId = null;
        try {
            pId = (PeerID)IDFactory.fromURL(IDFactory.jxtaURL(peer));
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("   getting peer advertisement failed with " + e));
            }
            return;
        }
        if (lease == 0L) {
            if (this.monitor != null) {
                this.monitor.disconnected(pId);
            }
        } else {
            this.addRdv(peer, lease);
            if (this.monitor != null) {
                this.monitor.connected(pId, lease);
            }
        }
    }

    private void processRdvAdvReply(Message msg) {
        if (this.monitor == null) {
            return;
        }
        Advertisement adv = null;
        try {
            adv = AdvertisementFactory.newAdvertisement(this.textXml, msg.getElement(RdvAdvReply).getStream());
        }
        catch (Exception e) {
            return;
        }
        if (adv == null) {
            return;
        }
        this.monitor.discovered(adv);
    }

    private boolean sendReply(String peer, Advertisement adv, long lease) {
        EndpointAddress addr;
        block17: {
            this.localPeerAdv = this.group.getPeerAdvertisement();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"sendReply");
            }
            try {
                this.group.getDiscoveryService().publish(adv, 0, 0x6DDD00L, 0x6DDD00L);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block17;
                LOG.debug((Object)("   publish failed with " + e));
            }
        }
        this.publishInParentGroup(adv);
        try {
            addr = this.mkAddress(peer, this.pName, this.pParam);
        }
        catch (Exception caught) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)(" malformed peer id " + peer));
            }
            return false;
        }
        if (!this.endpoint.ping(addr)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("   cannot get route to peer " + addr));
            }
            return false;
        }
        EndpointMessenger messenger = null;
        try {
            messenger = this.endpoint.getMessenger(addr);
            if (messenger == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"    no messenger");
                }
                return false;
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   getting messenger failed with ", (Throwable)e);
            }
            return false;
        }
        Message msg = this.endpoint.newMessage();
        ByteArrayInputStream ipPeer = new ByteArrayInputStream(this.localPeerId.getBytes());
        ByteArrayInputStream ipLease = new ByteArrayInputStream(Long.toString(lease).getBytes());
        try {
            InputStream ip = null;
            Document doc = null;
            doc = this.localPeerAdv.getDocument(this.textXml);
            ip = doc.getStream();
            msg.addElement(msg.newMessageElement(ConnectedRdvAdvReply, this.textXml, ip));
            msg.setString(ConnectedPeerReply, this.localPeerId);
            msg.setString(ConnectedLeaseReply, Long.toString(lease));
            messenger.sendMessage(msg);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   message sent");
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"  failed with ", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private void sendToNetwork(Message msg, String serviceName, String queueName) {
        block2: {
            try {
                this.endpoint.propagate(msg, serviceName, queueName);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block2;
                LOG.debug((Object)e.toString());
            }
        }
    }

    private void sendToEachClient(Message msg, String serviceName, String serviceParam) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"sendToEachClient");
        }
        if (!this.isRendezVous || this.clients == null || this.clients.size() == 0) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"  no clients");
            }
            return;
        }
        int i = this.clients.size() - 1;
        while (i >= 0) {
            block10: {
                PeerConnection pConn = null;
                try {
                    pConn = (PeerConnection)this.clients.elementAt(i);
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("to: " + pConn.getPeer()));
                    }
                    if (!this.isPeerInPropHeader(msg, pConn.getPeer())) {
                        Message tmpMsg = (Message)msg.clone();
                        pConn.sendMessage(tmpMsg, serviceName, serviceParam);
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("   sent to " + pConn.getPeer()));
                        }
                    }
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block10;
                    LOG.debug((Object)("   failed sent to " + pConn.getPeer()), (Throwable)e);
                }
            }
            --i;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"   done");
        }
    }

    private void sendToEachRendezVous(Message msg, String serviceName, String serviceParam) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"sendToEachRendezVous");
        }
        if (!this.isClient || this.rendezVous == null || this.rendezVous.size() == 0) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"  no rendezvous");
            }
            return;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"    Sending to all rendezvous");
        }
        int i = this.rendezVous.size() - 1;
        while (i >= 0) {
            block9: {
                try {
                    PeerConnection pConn = (PeerConnection)this.rendezVous.elementAt(i);
                    if (!this.isPeerInPropHeader(msg, pConn.getPeer())) {
                        Message tmpMsg = (Message)msg.clone();
                        pConn.sendMessage(tmpMsg, serviceName, serviceParam);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block9;
                    LOG.debug((Object)("   failed with " + e));
                }
            }
            --i;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"     done");
        }
    }

    private void ping(String peer) {
        block9: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("ping " + peer));
            }
            EndpointMessenger messenger = null;
            try {
                messenger = this.endpoint.getMessenger(this.mkAddress(peer, this.pName, this.pParam));
                if (messenger == null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"    no messenger");
                    }
                    return;
                }
            }
            catch (Exception e) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("   getting messenger failed with " + e));
                }
                return;
            }
            Message msg = this.endpoint.newMessage();
            try {
                msg.setString(PingRequest, this.localPeerId);
                messenger.sendMessage(msg);
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   message sent");
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block9;
                LOG.debug((Object)("  failed with " + e));
            }
        }
    }

    private synchronized void gcClients() {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"GC CLIENTS starts");
        }
        if (this.clients == null || this.clients.size() == 0) {
            return;
        }
        PeerConnection pConn = null;
        int i = 0;
        while (i < this.clients.size()) {
            block8: {
                try {
                    pConn = (PeerConnection)this.clients.elementAt(i);
                    long time = System.currentTimeMillis();
                    if (!pConn.isConnected() || pConn.getLease() < time) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("GC CLIENT: drop " + pConn.getPeer()));
                            LOG.debug((Object)("        lease= " + pConn.getLease()));
                            LOG.debug((Object)(" current time= " + time));
                            LOG.debug((Object)("    connected= " + pConn.isConnected()));
                        }
                        this.clients.removeElementAt(i);
                        pConn.close();
                        --i;
                    }
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block8;
                    LOG.debug((Object)("gcClient failed " + e));
                }
            }
            ++i;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"GC RENDEZVOUS done");
        }
    }

    private synchronized void gcRdvs() {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"GC Rendezvous starts");
        }
        if (this.rendezVous == null) {
            return;
        }
        PeerConnection pConn = null;
        int i = 0;
        while (i < this.rendezVous.size()) {
            block8: {
                try {
                    pConn = (PeerConnection)this.rendezVous.elementAt(i);
                    long time = System.currentTimeMillis();
                    if (!pConn.isConnected() || pConn.getLease() < time) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("GC RDV: drop " + pConn.getPeer()));
                            LOG.debug((Object)("        lease= " + pConn.getLease()));
                            LOG.debug((Object)(" current time= " + time));
                            LOG.debug((Object)("    connected= " + pConn.isConnected()));
                        }
                        this.rendezVous.removeElementAt(i);
                        pConn.close();
                        this.removedRendezVous.add(pConn);
                        --i;
                    }
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block8;
                    LOG.debug((Object)("ping failed " + e));
                }
            }
            ++i;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"GC RENDEZVOUS done");
        }
    }

    private void gc() {
        this.gcClients();
        this.gcRdvs();
    }

    private synchronized void clientIsConnected(String peer) {
        if (this.clients == null) {
            return;
        }
        PeerConnection pConn = null;
        int i = 0;
        while (i < this.clients.size()) {
            try {
                pConn = (PeerConnection)this.clients.elementAt(i);
                if (pConn.getPeer().equals(peer)) {
                    pConn.connect();
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
    }

    private void processPingReply(Message msg) {
        String peer = msg.getString(PingReply);
        this.clientIsConnected(peer);
    }

    private void processPingRequest(Message msg) {
        EndpointMessenger messenger = null;
        try {
            block10: {
                String peer = msg.getString(PingRequest);
                try {
                    messenger = this.endpoint.getMessenger(this.mkAddress(peer, this.pName, this.pParam));
                    if (messenger == null) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"    no messenger");
                        }
                        return;
                    }
                }
                catch (Exception e1) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("   getting messenger failed with " + e1));
                    }
                    return;
                }
                Message msg2 = this.endpoint.newMessage();
                try {
                    msg2.setString(PingReply, this.localPeerId);
                    messenger.sendMessage(msg2);
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"   message sent");
                    }
                }
                catch (Exception e1) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block10;
                    LOG.debug((Object)("  failed with " + e1));
                }
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void generateEvent(int type, String peer) {
        if (this.applisteners.size() > 0) {
            RendezvousEvent newevent = new RendezvousEvent(this, type, peer);
            int i = 0;
            while (i < this.applisteners.size()) {
                RendezvousListener rl = (RendezvousListener)this.applisteners.elementAt(i);
                rl.rendezvousEvent(newevent);
                ++i;
            }
        }
    }

    private boolean updatePropHeader(Message msg, int defaultTTL, String serviceName, String serviceParam) throws IOException {
        RendezVousPropagateMessage propHdr;
        block12: {
            propHdr = null;
            if (defaultTTL > 10) {
                defaultTTL = 10;
            }
            try {
                InputStream ip;
                MessageElement elem = msg.getElement(this.headerName);
                if (elem != null) {
                    msg.removeElement(this.headerName);
                }
                MessageElement elem2 = null;
                elem2 = msg.getElement("RendezVousPropagate");
                if (elem2 != null) {
                    msg.removeElement("RendezVousPropagate");
                }
                if (elem == null) {
                    elem = elem2;
                }
                if (elem != null && (ip = elem.getStream()) != null) {
                    propHdr = new RendezVousPropagateMessage(ip);
                    int msgTTL = propHdr.getTTL();
                    if (msgTTL > defaultTTL) {
                        msgTTL = defaultTTL;
                    }
                    if (msgTTL < 1) {
                        return false;
                    }
                    propHdr.setTTL(--msgTTL);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block12;
                LOG.debug((Object)"Error updating the header", (Throwable)e);
            }
        }
        if (propHdr == null) {
            propHdr = new RendezVousPropagateMessage();
            propHdr.setTTL(defaultTTL);
            if (serviceName == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"No destination - discard");
                }
                return false;
            }
            propHdr.setDestSName(serviceName);
            propHdr.setDestSParam(serviceParam);
            propHdr.setMsgId(this.createMsgId());
            this.addMsgId(propHdr.getMsgId());
        }
        propHdr.addToPath(this.localPeerId);
        msg.addElement(msg.newMessageElement(this.headerName, this.textXml, propHdr.getInputStream()));
        msg.addElement(msg.newMessageElement("RendezVousPropagate", this.textXml, propHdr.getInputStream()));
        return true;
    }

    private synchronized void addMsgId(String id) {
        block6: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("addMsgId " + id));
            }
            if (this.isMsgIdRecorded(id)) {
                return;
            }
            if (this.msgIds.size() >= 1000) {
                try {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"   remove id");
                    }
                    this.msgIds.removeElementAt(0);
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block6;
                    LOG.warn((Object)("addMsgId failed to remove oldest element: " + e));
                }
            }
        }
        this.msgIds.addElement(id);
    }

    private synchronized boolean isMsgIdRecorded(String id) {
        boolean found = this.msgIds.contains(id);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"isMsgIsRecorded:");
            LOG.debug((Object)("    id= " + id));
            LOG.debug((Object)("status= " + found));
        }
        return found;
    }

    private String createMsgId() {
        return String.valueOf(System.currentTimeMillis());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FilterListener
    implements EndpointFilterListener {
        private Category LOG = Category.getInstance((String)(class$net$jxta$impl$rendezvous$RendezVousServiceImpl == null ? (class$net$jxta$impl$rendezvous$RendezVousServiceImpl = FilterListener.class$("net.jxta.impl.rendezvous.RendezVousServiceImpl")) : class$net$jxta$impl$rendezvous$RendezVousServiceImpl).getName());
        static /* synthetic */ Class class$net$jxta$impl$rendezvous$RendezVousServiceImpl;

        public Message processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            block9: {
                try {
                    RendezVousPropagateMessage propHdr;
                    MessageElement el = message.getElement(RendezVousServiceImpl.this.headerName);
                    if (el == null) {
                        el = message.getElement("RendezVousPropagate");
                    }
                    if ((propHdr = new RendezVousPropagateMessage(el.getStream())).getTTL() <= 0) {
                        if (this.LOG.isEnabledFor(Priority.DEBUG)) {
                            this.LOG.debug((Object)"Dead on arrival");
                        }
                        return null;
                    }
                    if (propHdr.hasInPath(RendezVousServiceImpl.this.localPeerId)) {
                        if (this.LOG.isEnabledFor(Priority.DEBUG)) {
                            this.LOG.debug((Object)"Loopback");
                        }
                        return null;
                    }
                    if (RendezVousServiceImpl.this.isMsgIdRecorded(propHdr.getMsgId())) {
                        if (this.LOG.isEnabledFor(Priority.DEBUG)) {
                            this.LOG.debug((Object)"Feedback");
                        }
                        return null;
                    }
                }
                catch (Exception neverMind) {
                    if (!this.LOG.isEnabledFor(Priority.DEBUG)) break block9;
                    this.LOG.debug((Object)("Filter failed " + neverMind));
                }
            }
            return message;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public class GCTask
    extends TimerTask {
        RendezVousServiceImpl rendezvous = null;

        public GCTask(RendezVousServiceImpl r) {
            this.rendezvous = r;
        }

        public void run() {
            this.rendezvous.gc();
        }
    }

    private class PropagateListener
    implements EndpointListener {
        private RendezVousServiceImpl rdv = null;

        public PropagateListener(RendezVousServiceImpl rdv) {
            this.rdv = rdv;
        }

        public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            MessageElement el = null;
            RendezVousPropagateMessage propHdr = null;
            try {
                el = message.getElement(RendezVousServiceImpl.this.headerName);
                if (el == null && (el = message.getElement("RendezVousPropagate")) == null) {
                    return;
                }
                propHdr = new RendezVousPropagateMessage(el.getStream());
            }
            catch (Exception neverMind) {
                return;
            }
            if (propHdr.getMsgId() == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Received a message without msgid. Drop it.");
                }
                return;
            }
            String sName = propHdr.getDestSName();
            String sParam = propHdr.getDestSParam();
            this.rdv.processReceivedMessage(message, propHdr.getMsgId(), sName, sParam, srcAddr, dstAddr);
        }
    }
}

