/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import net.jxta.endpoint.Message;
import net.jxta.impl.util.PriorityQueue;
import net.jxta.impl.util.Timer;
import org.apache.log4j.Category;

class IncomingMessageQueue
extends PriorityQueue {
    private static final Category LOG = Category.getInstance((Class)(class$net$jxta$impl$util$IncomingMessageQueue == null ? (class$net$jxta$impl$util$IncomingMessageQueue = IncomingMessageQueue.class$("net.jxta.impl.util.IncomingMessageQueue")) : class$net$jxta$impl$util$IncomingMessageQueue));
    int capacity;
    int total;
    long nextExpected;
    static /* synthetic */ Class class$net$jxta$impl$util$IncomingMessageQueue;

    IncomingMessageQueue(int size) {
        this.initialize(size, 2);
        this.capacity = size;
    }

    protected boolean lessThan(Object o1, Object o2) {
        return ((IncomingMessage)o1).seq < ((IncomingMessage)o2).seq;
    }

    public synchronized void put(Message msg, long seq) {
        this.put(new IncomingMessage(msg, seq));
        ++this.total;
        this.notifyAll();
    }

    public synchronized void setNextExpected(long nextExpected) {
        this.nextExpected = nextExpected;
    }

    public synchronized long popUntilBreakInSequence(long lastSeq) {
        while (this.top() != null) {
            IncomingMessage msg = (IncomingMessage)this.top();
            if (lastSeq + 1L != msg.seq) break;
            lastSeq = msg.seq;
            this.pop();
            --this.total;
        }
        return lastSeq;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized Message popNext() {
        im = (IncomingMessage)this.top();
        if (im != null) ** GOTO lbl9
        return null;
lbl-1000:
        // 1 sources

        {
            IncomingMessageQueue.LOG.debug((Object)("WATCH: less than expected, nextExpected = " + this.nextExpected + " seq = " + im.seq));
            this.pop();
            --this.total;
            im = (IncomingMessage)this.top();
lbl9:
            // 2 sources

            ** while (im != null && im.seq < this.nextExpected)
        }
lbl10:
        // 1 sources

        if (im != null && im.seq == this.nextExpected) {
            IncomingMessageQueue.LOG.debug((Object)("WATCH: got expected " + this.nextExpected));
            this.pop();
            --this.total;
            ++this.nextExpected;
            return im.msg;
        }
        return null;
    }

    public synchronized Message pop(long maxTimeout) throws InterruptedException {
        Timer t = new Timer();
        t.start();
        if (maxTimeout == -1L) {
            maxTimeout = Long.MAX_VALUE;
        }
        long timeLeft = maxTimeout;
        while (timeLeft > 0L) {
            timeLeft = maxTimeout - t.elapsed();
            if (timeLeft < 0L) break;
            IncomingMessage im = (IncomingMessage)this.top();
            if (im == null || im.seq > this.nextExpected) {
                LOG.debug((Object)("WATCH: waiting for " + this.nextExpected));
                this.wait(timeLeft);
                continue;
            }
            if (im.seq == this.nextExpected) {
                LOG.debug((Object)("WATCH: got expected " + this.nextExpected));
                this.pop();
                --this.total;
                ++this.nextExpected;
                return im.msg;
            }
            LOG.debug((Object)("WATCH: less than expected, nextExpected = " + this.nextExpected + " seq = " + im.seq));
            this.pop();
            --this.total;
        }
        LOG.debug((Object)"WATCH: returning null");
        return null;
    }

    public int getFreeSlots() {
        return this.capacity - this.total;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class IncomingMessage {
        Message msg;
        long seq;

        IncomingMessage(Message msg, long seq) {
            this.msg = msg;
            this.seq = seq;
        }
    }
}

