/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.test.endpoint;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageElementEnumeration;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.impl.endpoint.MessageWireFormat;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.util.StringEnumeration;

public class MessageTest
extends TestCase {
    MimeMediaType[] testTypes = new MimeMediaType[]{new MimeMediaType("text", "plain"), new MimeMediaType("text", "xml"), new MimeMediaType("pig-in-a", "poke")};

    public MessageTest(String name) {
        super(name);
    }

    public void testCreateElement() {
        try {
            MessageImpl m = new MessageImpl();
            Assert.assertTrue((m != null ? 1 : 0) != 0);
            MessageElement element1 = this.createElement(m, 1, "ding");
            m.addElement(element1);
            Assert.assertTrue((boolean)element1.getName().equals("ding:elem1"));
            this.checkElement(element1);
        }
        catch (Exception ex) {
            Assert.fail((String)("Threw " + ex));
        }
    }

    public void testCreateElementFromStream() {
        try {
            MessageImpl m = new MessageImpl();
            byte[] bytes = new byte[]{1, 2, 3, 4};
            BAIS bais = new BAIS(bytes);
            MessageElement el = m.newMessageElement("hi", null, bais);
            Assert.assertTrue((el != null ? 1 : 0) != 0);
            Assert.assertTrue((bais.read() == -1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)bais.isClosed());
            int i = 0;
            while (i < bytes.length) {
                Assert.assertTrue((el.getBytesOffset()[i] == bytes[i] ? 1 : 0) != 0);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.toString());
        }
    }

    public void testGetNames() {
        MessageImpl m = new MessageImpl();
        int i = 0;
        while (i < 40) {
            m.setBytes("el" + i, new byte[0]);
            StringEnumeration se = m.getNames();
            int j = i;
            while (j >= 0) {
                String s = se.nextString();
                Assert.assertEquals((Object)("el" + j), (Object)s);
                --j;
            }
            ++i;
        }
    }

    public void testWireFormatXML() {
        try {
            MessageImpl m = new MessageImpl();
            byte[] bytes = new byte[]{1, 2, 3, 4};
            BAIS bais = new BAIS(bytes);
            MessageElement el1 = m.newMessageElement("hi", new MimeMediaType("application/octet-stream"), bais);
            Assert.assertTrue((el1 != null ? 1 : 0) != 0);
            m.addElement(el1);
            String text = "This is &lt;text&gt; &amp; & <>";
            MessageElement el2 = m.newMessageElement("a string", new MimeMediaType("text/plain"), text.getBytes());
            Assert.assertTrue((el2 != null ? 1 : 0) != 0);
            m.addElement(el2);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.getXMLMessageFormat().writeMessage(baos, m);
            byte[] mbytes = baos.toByteArray();
            ByteArrayInputStream is = new ByteArrayInputStream(mbytes);
            MessageImpl m2 = new MessageImpl();
            this.getXMLMessageFormat().readMessage(is, m2);
            Assert.assertTrue((boolean)m.equals(m2));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.toString());
        }
    }

    public void testCreateElementFromStreamWithLength() {
        try {
            MessageImpl m = new MessageImpl();
            byte[] bytes = new byte[]{1, 2, 3, 4};
            BAIS bais = new BAIS(bytes);
            MessageElement el = m.newMessageElement("hi", null, bais, bytes.length - 1);
            Assert.assertTrue((el != null ? 1 : 0) != 0);
            Assert.assertTrue((bais.read() == 4 ? 1 : 0) != 0);
            Assert.assertTrue((!bais.isClosed() ? 1 : 0) != 0);
            int i = 0;
            while (i < bytes.length - 1) {
                Assert.assertTrue((el.getBytesOffset()[i] == bytes[i] ? 1 : 0) != 0);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.toString());
        }
    }

    public void testPush() {
        byte[] bytes = new byte[]{5, 6, 7, 8, 9, 10, 44};
        try {
            int t = 0;
            while (t < 2) {
                MessageImpl m = new MessageImpl();
                Assert.assertTrue((m != null ? 1 : 0) != 0);
                if (t == 0) {
                    m.setBytes("n:abc", bytes);
                } else {
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                    MessageElement el = m.newMessageElement("n:abc", new MimeMediaType("text/xml"), bais);
                }
                MessageElement el = m.getElement("n:abc");
                Assert.assertTrue((boolean)el.getName().equals("n:abc"));
                Assert.assertTrue((el.getType() == null ? 1 : 0) != 0);
                Assert.assertTrue((el.getOffset() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((el.getLength() == bytes.length ? 1 : 0) != 0);
                byte[] bs = el.getBytesOffset();
                Assert.assertTrue((bs.length == bytes.length ? 1 : 0) != 0);
                int i = 0;
                while (i < bytes.length) {
                    Assert.assertTrue((bytes[i] == bs[i] ? 1 : 0) != 0);
                    ++i;
                }
                ++t;
            }
        }
        catch (Exception ex) {
            Assert.fail((String)ex.toString());
        }
    }

    public void testPop() {
        byte[] bytes = new byte[]{1, 2, 3, 4, 5, 6, 45};
        try {
            int t = 0;
            while (t < 2) {
                byte[] bs;
                MessageImpl m = new MessageImpl();
                MimeMediaType type = new MimeMediaType("this", "that");
                MessageElement el = m.newMessageElement("myspace:yourplace", type, bytes);
                m.addElement(el);
                if (t == 0) {
                    bs = m.getBytes("myspace:yourplace");
                } else {
                    InputStream is = m.getElement("myspace:yourplace").getStream();
                    DataInputStream dis = new DataInputStream(is);
                    bs = new byte[is.available()];
                    dis.readFully(bs);
                }
                Assert.assertTrue((bs.length == bytes.length ? 1 : 0) != 0);
                int i = 0;
                while (i < bytes.length) {
                    Assert.assertTrue((bytes[i] == bs[i] ? 1 : 0) != 0);
                    ++i;
                }
                ++t;
            }
        }
        catch (Exception ex) {
            Assert.fail((String)ex.toString());
        }
    }

    public void testMessageGetElements() {
        Vector<MessageElement> v = new Vector<MessageElement>();
        MessageImpl m = new MessageImpl();
        Assert.assertTrue((m != null ? 1 : 0) != 0);
        int i = 0;
        while (i < 30) {
            MessageElement element = this.createElement(m, i);
            m.addElement(element);
            v.addElement(element);
            this.checkElements(m, v);
            ++i;
        }
    }

    public void testEqualsElement() {
        MessageImpl m = new MessageImpl();
        int i = 0;
        while (i < 100) {
            MessageElement element1 = this.createElement(m, i);
            MessageElement element2 = this.createElement(m, i);
            Assert.assertTrue((boolean)element1.equals(element2));
            ++i;
        }
    }

    public void testNotEqualsElement() {
        MessageElement element2 = null;
        MessageImpl m = new MessageImpl();
        int i = 0;
        while (i < 100) {
            MessageElement element1 = this.createElement(m, i);
            if (element2 != null) {
                Assert.assertTrue((!element1.equals(element2) ? 1 : 0) != 0);
            }
            element2 = element1;
            ++i;
        }
    }

    public void testClone() {
        MessageImpl m = new MessageImpl();
        int i = 0;
        while (i < 100) {
            MessageElement element2;
            MessageElement element1 = this.createElement(m, i);
            Assert.assertTrue((element1 == (element2 = (MessageElement)element1.clone()) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)element1.equals(element2));
            ++i;
        }
    }

    public void testRemoveElement() {
        try {
            MessageImpl m1 = new MessageImpl();
            MessageElement el1a = this.createElement(m1, 1);
            m1.addElement(el1a);
            m1.removeElement(el1a);
            MessageImpl m2 = new MessageImpl();
            Assert.assertTrue((boolean)m1.equals(m2));
            m1 = new MessageImpl();
            el1a = this.createElement(m1, 1);
            m1.addElement(el1a);
            MessageElement el1b = this.createElement(m1, 2);
            m1.addElement(el1b);
            m2 = new MessageImpl();
            Assert.assertTrue((!m1.equals(m2) ? 1 : 0) != 0);
            MessageElement el2b = this.createElement(m1, 2);
            m2.addElement(el2b);
            Assert.assertTrue((!m1.equals(m2) ? 1 : 0) != 0);
            m1.removeElement(el1a);
            Assert.assertTrue((boolean)m1.equals(m2));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.toString());
        }
    }

    public void testWireFormatNoElements() {
        try {
            MessageImpl m = new MessageImpl();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.getBinaryMessageFormat().writeMessage(baos, m);
            baos.close();
            byte[] bytes = baos.toByteArray();
            Assert.assertTrue((String)"Incorrect message magic[0]", (bytes[0] == 106 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Incorrect message magic[1]", (bytes[1] == 120 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Incorrect message magic[2]", (bytes[2] == 109 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Incorrect message magic[3]", (bytes[3] == 103 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Incorrect message version", (bytes[4] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[5] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[6] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[7] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[8] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((bytes.length == 9 ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Threw " + ex));
        }
    }

    public void testFormatOneElement() {
        try {
            int bi = 0;
            MessageImpl m = new MessageImpl();
            MessageElement el = this.createElement(m, 1);
            m.addElement(el);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.getBinaryMessageFormat().writeMessage(baos, m);
            baos.close();
            byte[] bytes = baos.toByteArray();
            Assert.assertTrue((String)"Incorrect message magic[0]", (bytes[bi++] == 106 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Incorrect message magic[1]", (bytes[bi++] == 120 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Incorrect message magic[2]", (bytes[bi++] == 109 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Incorrect message magic[3]", (bytes[bi++] == 103 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Incorrect message version", (bytes[bi++] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[bi++] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[bi++] == 1 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[bi++] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[bi++] == 4 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[bi++] == 100 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[bi++] == 105 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[bi++] == 110 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[bi++] == 103 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[bi++] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[bi++] == 1 ? 1 : 0) != 0);
            bi = this.checkWireElement(bytes, bi, 1, 2);
            Assert.assertTrue((bytes.length == bi ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Threw " + ex));
        }
    }

    public void testWireFormatManyElementsSameNamespace() {
        try {
            Vector<MessageElement> elements = new Vector<MessageElement>();
            boolean bi = false;
            MessageImpl m = new MessageImpl();
            int i = 0;
            while (i < 40) {
                MessageElement el = this.createElement(m, i);
                m.addElement(el);
                elements.addElement(el);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.getBinaryMessageFormat().writeMessage(baos, m);
                baos.close();
                byte[] bytes = baos.toByteArray();
                this.checkWireMessage(bytes, elements, true);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Threw " + ex));
        }
    }

    public void testWireFormatManyElementsManyNamespace() {
        try {
            Vector<MessageElement> elements = new Vector<MessageElement>();
            boolean bi = false;
            MessageImpl m = new MessageImpl();
            int i = 0;
            while (i < 40) {
                MessageElement el = this.createElement(m, i, "namespace" + i % 4);
                m.addElement(el);
                elements.addElement(el);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.getBinaryMessageFormat().writeMessage(baos, m);
                baos.close();
                byte[] bytes = baos.toByteArray();
                this.checkWireMessage(bytes, elements, false);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Threw " + ex));
        }
    }

    public void testMessageRead() {
        try {
            MessageImpl m = new MessageImpl();
            int i = 0;
            while (i < 30) {
                MessageElement el = this.createElement(m, i, "space" + i % 3);
                m.addElement(el);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.getBinaryMessageFormat().writeMessage(os, m);
                ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                MessageImpl m2 = new MessageImpl();
                this.getBinaryMessageFormat().readMessage(is, m2);
                Assert.assertTrue((boolean)m.equals(m2));
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail();
        }
    }

    MessageElement createElement(Message m, int n) {
        return this.createElement(m, n, "ding");
    }

    MessageElement createElement(Message m, int n, String namespace) {
        MimeMediaType type = this.testTypes[n % this.testTypes.length];
        int offset = new Random().nextInt(2);
        int usedLen = n + 10;
        int actualLen = usedLen + offset;
        byte[] b = new byte[actualLen];
        int i = 0;
        while (i < usedLen) {
            b[i + offset] = (byte)i;
            ++i;
        }
        MessageElement element = namespace == null ? m.newMessageElement("elem" + n, type, b, offset, usedLen) : m.newMessageElement(namespace + ":elem" + n, type, b, offset, usedLen);
        return element;
    }

    void checkElements(Message m, Vector v) {
        MessageElementEnumeration e = m.getElements();
        int cnt = 0;
        while (e.hasMoreElements()) {
            MessageElement el = (MessageElement)e.nextElement();
            if (!this.referenceIsIn(el, v)) {
                Assert.fail((String)("Unexpected element, " + el.getName() + ", found in message"));
            }
            this.checkElement(el);
            ++cnt;
        }
        Assert.assertTrue((v.size() == cnt ? 1 : 0) != 0);
    }

    void checkElement(MessageElement element) {
        String nsname = element.getName();
        String[] names = MessageElement.parseName(nsname);
        String namespace = names[0];
        String name = names[1];
        Assert.assertTrue((boolean)namespace.equals("ding"));
        Assert.assertTrue((boolean)name.substring(0, 4).equals("elem"));
        int n = 0;
        try {
            n = Integer.parseInt(name.substring(4));
        }
        catch (NumberFormatException ex) {
            Assert.fail((String)"Element name does not end with integer string");
        }
        int cnt = n + 10;
        Assert.assertTrue((boolean)element.getType().equals(this.testTypes[n % this.testTypes.length]));
        Assert.assertTrue((cnt == element.getLength() ? 1 : 0) != 0);
        try {
            InputStream is = element.getStream();
            int i = 0;
            while (i < cnt) {
                int d = is.read();
                Assert.assertTrue((String)("Entry " + i + " is " + d + " expected " + i), (d == i ? 1 : 0) != 0);
                ++i;
            }
            Assert.assertTrue((is.read() == -1 ? 1 : 0) != 0);
            byte[] bs = element.getBytesOffset();
            int offset = element.getOffset();
            int i2 = 0;
            while (i2 < cnt) {
                byte d = bs[i2 + offset];
                Assert.assertTrue((String)("Entry " + i2 + " is " + d + " expected " + i2), (d == i2 ? 1 : 0) != 0);
                ++i2;
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Threw " + ex));
        }
    }

    void checkWireMessage(byte[] bytes, Vector elements, boolean oneNamespace) {
        int bi = 0;
        elements = (Vector)elements.clone();
        int n = elements.size();
        Assert.assertTrue((String)"Incorrect message magic[0]", (bytes[bi++] == 106 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Incorrect message magic[1]", (bytes[bi++] == 120 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Incorrect message magic[2]", (bytes[bi++] == 109 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Incorrect message magic[3]", (bytes[bi++] == 103 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Incorrect message version", (bytes[bi++] == 0 ? 1 : 0) != 0);
        Hashtable<String, Integer> namespace2id = new Hashtable<String, Integer>();
        int namespaceCnt = oneNamespace ? 1 : (n < 4 ? n : 4);
        Assert.assertTrue((bytes[bi++] == namespaceCnt >> 8 ? 1 : 0) != 0);
        Assert.assertTrue((bytes[bi++] == (namespaceCnt & 0xFF) ? 1 : 0) != 0);
        if (oneNamespace) {
            Assert.assertTrue((bytes[bi++] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[bi++] == 4 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[bi++] == 100 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[bi++] == 105 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[bi++] == 110 ? 1 : 0) != 0);
            Assert.assertTrue((bytes[bi++] == 103 ? 1 : 0) != 0);
        } else {
            int ns = 0;
            while (ns < namespaceCnt) {
                String namespace = this.getWireString(bytes, bi);
                bi = this.skipWireString(bytes, bi);
                namespace2id.put(namespace, new Integer(ns + 2));
                ++ns;
            }
        }
        Assert.assertTrue((String)("Wrong element count at index " + bi), (bytes[bi++] == n >> 8 ? 1 : 0) != 0);
        Assert.assertTrue((bytes[bi++] == (n & 0xFF) ? 1 : 0) != 0);
        int i = 1;
        while (i <= n) {
            String namespace;
            int nsid;
            String name = this.getWireString(bytes, bi + 6);
            int ei = Integer.parseInt(name.substring(4));
            if (oneNamespace) {
                nsid = 2;
                namespace = "ding";
            } else {
                namespace = "namespace" + ei % 4;
                Integer nsidint = (Integer)namespace2id.get(namespace);
                nsid = nsidint;
            }
            MessageElement el = this.removeElement(elements, namespace + ":" + name);
            if (el == null) {
                Assert.fail((String)("Unexpected element at index " + bi + " named " + name));
            }
            bi = this.checkWireElement(bytes, bi, ei, nsid);
            ++i;
        }
        Assert.assertTrue((elements.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((bytes.length == bi ? 1 : 0) != 0);
    }

    int checkWireElement(byte[] bytes, int bi, int n, int namespaceId) {
        Assert.assertTrue((String)"Incorrect element magic[0]", (bytes[bi++] == 106 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Incorrect element magic[1]", (bytes[bi++] == 120 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Incorrect element magic[2]", (bytes[bi++] == 101 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Incorrect element magic[3]", (bytes[bi++] == 108 ? 1 : 0) != 0);
        Assert.assertTrue((String)("namespace id=" + bytes[bi]), (bytes[bi++] == namespaceId ? 1 : 0) != 0);
        Assert.assertTrue((bytes[bi++] == 1 ? 1 : 0) != 0);
        String name = "elem" + n;
        bi = this.checkWireString(bytes, bi, "elem" + n);
        bi = this.checkWireString(bytes, bi, this.testTypes[n % this.testTypes.length].toString());
        int len = n + 10;
        Assert.assertTrue((bytes[bi++] == (len >> 24 & 0xFF) ? 1 : 0) != 0);
        Assert.assertTrue((bytes[bi++] == (len >> 16 & 0xFF) ? 1 : 0) != 0);
        Assert.assertTrue((bytes[bi++] == (len >> 8 & 0xFF) ? 1 : 0) != 0);
        Assert.assertTrue((String)("at byte " + bi), (bytes[bi++] == (len >> 0 & 0xFF) ? 1 : 0) != 0);
        int i = 0;
        while (i < len) {
            Assert.assertTrue((bytes[bi++] == i ? 1 : 0) != 0);
            ++i;
        }
        return bi;
    }

    int checkWireString(byte[] bytes, int bi, String s) {
        byte[] nbytes = s.getBytes();
        int len = nbytes.length;
        Assert.assertTrue((bytes[bi++] == len >> 8 ? 1 : 0) != 0);
        Assert.assertTrue((bytes[bi++] == (len & 0xFF) ? 1 : 0) != 0);
        int i = 0;
        while (i < len) {
            Assert.assertTrue((String)("string wrong at byte " + i), (bytes[bi++] == nbytes[i] ? 1 : 0) != 0);
            ++i;
        }
        return bi;
    }

    String getWireString(byte[] bytes, int bi) {
        int len = (bytes[bi] << 8) + bytes[bi + 1];
        Assert.assertTrue((String)("Name too long: " + len), (len < 50 ? 1 : 0) != 0);
        try {
            return new String(bytes, bi + 2, len, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            Assert.fail((String)ex.toString());
            return null;
        }
    }

    int skipWireString(byte[] bytes, int bi) {
        int len = (bytes[bi] << 8) + bytes[bi + 1];
        Assert.assertTrue((String)("Name too long: " + len), (len < 50 ? 1 : 0) != 0);
        return bi + 2 + len;
    }

    void printMessage(String label, Message m) {
        System.out.println(label + ":");
        MessageElementEnumeration e = m.getElements();
        while (e.hasMoreElements()) {
            MessageElement el = (MessageElement)e.nextElement();
            this.printElement(el);
        }
    }

    void printElement(MessageElement el) {
        System.out.println(" name: " + el.getName());
        MimeMediaType type = el.getType();
        if (type != null) {
            System.out.println(" type: " + type);
        }
        if (type != null && type.getType().equals("text")) {
            System.out.println(" value: " + new String(el.getBytesOffset(), el.getOffset(), el.getLength()));
        } else {
            byte[] bytes = el.getBytesOffset();
            int end = el.getOffset() + el.getLength();
            int cnt = 0;
            int i = el.getOffset();
            while (i < end) {
                if (cnt == 0) {
                    System.out.print(" value: " + bytes[i]);
                    ++cnt;
                } else {
                    System.out.print(" " + bytes[i]);
                    ++cnt;
                }
                if (cnt == 20) {
                    System.out.println("");
                    cnt = 0;
                }
                ++i;
            }
            if (cnt != 0) {
                System.out.println("");
            }
        }
        System.out.println("");
    }

    void dumpBytes(byte[] bytes) {
        System.out.println("length = " + bytes.length);
        int i = 0;
        while (i < bytes.length) {
            System.out.print("b[" + i + "]=" + bytes[i] + " 0x" + Integer.toHexString(bytes[i]));
            char c = (char)bytes[i];
            if (c < ' ') {
                System.out.println();
            } else {
                System.out.println(" '" + c + "'");
            }
            ++i;
        }
    }

    boolean referenceIsIn(MessageElement el, Vector v) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            if (e.nextElement() != el) continue;
            return true;
        }
        return false;
    }

    MessageElement removeElement(Vector elements, String name) {
        int i = 0;
        while (i < elements.size()) {
            MessageElement el = (MessageElement)elements.get(i);
            if (el.getName().equals(name)) {
                elements.remove(i);
                return el;
            }
            ++i;
        }
        return null;
    }

    MessageWireFormat getXMLMessageFormat() {
        MimeMediaType type = new MimeMediaType("text/xml");
        return MessageWireFormatFactory.newMessageWireFormat(type);
    }

    MessageWireFormat getBinaryMessageFormat() {
        MimeMediaType type = new MimeMediaType("application/x-jxta-msg");
        return MessageWireFormatFactory.newMessageWireFormat(type);
    }

    public static void main(String[] args) {
        new TestRunner();
        TestRunner.main((String[])new String[]{"net.jxta.test.endpoint.MessageTest"});
    }

    static class BAIS
    extends ByteArrayInputStream {
        boolean closed = false;

        public BAIS(byte[] bytes) {
            super(bytes);
        }

        public void close() throws IOException {
            this.closed = true;
            super.close();
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

