/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicConnector;
import com.sun.media.CircularBuffer;
import com.sun.media.InputConnector;
import com.sun.media.OutputConnector;
import javax.media.Buffer;
import javax.media.Format;

public class BasicOutputConnector
extends BasicConnector
implements OutputConnector {
    protected InputConnector inputConnector = null;
    private boolean reset = false;

    public Format canConnectTo(InputConnector inputConnector, Format format) {
        if (this.getProtocol() != inputConnector.getProtocol()) {
            throw new RuntimeException("protocols do not match:: ");
        }
        return null;
    }

    public Format connectTo(InputConnector inputConnector, Format format) {
        Format format2 = this.canConnectTo(inputConnector, format);
        this.inputConnector = inputConnector;
        inputConnector.setOutputConnector(this);
        int n2 = Math.max(this.getSize(), inputConnector.getSize());
        this.circularBuffer = new CircularBuffer(n2);
        inputConnector.setCircularBuffer(this.circularBuffer);
        return null;
    }

    public Buffer getEmptyBuffer() {
        switch (this.protocol) {
            case 0: {
                if (!this.isEmptyBufferAvailable() && this.reset) {
                    return null;
                }
                this.reset = false;
                return this.circularBuffer.getEmptyBuffer();
            }
            case 1: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    this.reset = false;
                    while (!this.reset && !this.isEmptyBufferAvailable()) {
                        try {
                            this.circularBuffer.wait();
                        }
                        catch (Exception exception) {}
                    }
                    if (this.reset) {
                        Buffer buffer = null;
                        Object var3_4 = null;
                        return buffer;
                    }
                    Buffer buffer = this.circularBuffer.getEmptyBuffer();
                    this.circularBuffer.notifyAll();
                    Buffer buffer2 = buffer;
                    Object var3_5 = null;
                    return buffer2;
                }
            }
        }
        throw new RuntimeException();
    }

    public InputConnector getInputConnector() {
        return this.inputConnector;
    }

    public boolean isEmptyBufferAvailable() {
        return this.circularBuffer.canWrite();
    }

    public void reset() {
        CircularBuffer circularBuffer = this.circularBuffer;
        synchronized (circularBuffer) {
            this.reset = true;
            super.reset();
            if (this.inputConnector != null) {
                this.inputConnector.reset();
            }
            this.circularBuffer.notifyAll();
        }
    }

    public void writeReport() {
        switch (this.protocol) {
            case 0: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    if (this.reset) {
                        Object var2_3 = null;
                        return;
                    }
                    this.circularBuffer.writeReport();
                }
                this.getInputConnector().getModule().connectorPushed(this.getInputConnector());
                return;
            }
            case 1: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    if (this.reset) {
                        Object var2_4 = null;
                        return;
                    }
                    this.circularBuffer.writeReport();
                    this.circularBuffer.notifyAll();
                    Object var2_5 = null;
                    return;
                }
            }
        }
        throw new RuntimeException();
    }
}

