/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicClock;
import com.sun.media.BasicController;
import com.sun.media.BasicFilterModule;
import com.sun.media.BasicJMD;
import com.sun.media.BasicModule;
import com.sun.media.BasicPlayer;
import com.sun.media.BasicRendererModule;
import com.sun.media.BasicSinkModule;
import com.sun.media.BasicSourceModule;
import com.sun.media.BasicTrackControl;
import com.sun.media.GraphNode;
import com.sun.media.InputConnector;
import com.sun.media.JMD;
import com.sun.media.Log;
import com.sun.media.Module;
import com.sun.media.ModuleListener;
import com.sun.media.OutputConnector;
import com.sun.media.SimpleGraphBuilder;
import com.sun.media.StateTransistor;
import com.sun.media.controls.BitRateAdapter;
import com.sun.media.controls.FramePositioningAdapter;
import com.sun.media.controls.FrameRateAdapter;
import com.sun.media.controls.ProgressControl;
import com.sun.media.controls.ProgressControlAdapter;
import com.sun.media.controls.StringControlAdapter;
import com.sun.media.protocol.Streamable;
import com.sun.media.renderer.audio.AudioRenderer;
import com.sun.media.util.JMFI18N;
import com.sun.media.util.RTPInfo;
import com.sun.media.util.Resource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Codec;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.Demultiplexer;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.InternalErrorEvent;
import javax.media.Manager;
import javax.media.MediaTimeSetEvent;
import javax.media.NotRealizedError;
import javax.media.Owned;
import javax.media.PlugIn;
import javax.media.Renderer;
import javax.media.RestartingEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.StopAtTimeEvent;
import javax.media.StopByRequestEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.Track;
import javax.media.control.BitRateControl;
import javax.media.control.BufferControl;
import javax.media.control.FramePositioningControl;
import javax.media.control.FrameRateControl;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.renderer.VideoRenderer;
import javax.media.renderer.VisualContainer;

public class PlaybackEngine
extends BasicController
implements ModuleListener {
    protected BasicPlayer player;
    protected DataSource dsource;
    protected Vector modules;
    protected Vector filters;
    protected Vector sinks;
    protected Vector waitPrefetched;
    protected Vector waitStopped;
    protected Vector waitEnded;
    protected Vector waitResetted;
    protected Track[] tracks;
    protected Demultiplexer parser;
    protected BasicSinkModule masterSink = null;
    protected BasicSourceModule source;
    protected SlaveClock slaveClock;
    private boolean internalErrorOccurred = false;
    protected boolean prefetched = false;
    protected boolean started = false;
    private boolean dataPathBlocked = false;
    private boolean useMoreRenderBuffer = false;
    private boolean deallocated = false;
    public boolean prefetchEnabled = true;
    protected static boolean needSavingDB = false;
    private Time timeBeforeAbortPrefetch = null;
    private float rate = 1.0f;
    protected BitRateControl bitRateControl;
    protected FrameRateControl frameRateControl;
    protected FramePositioningControl framePositioningControl = null;
    private long latency = 0L;
    static boolean DEBUG = true;
    protected JMD jmd = null;
    protected Container container = null;
    public static boolean TRACE_ON = false;
    protected BasicTrackControl[] trackControls = new BasicTrackControl[0];
    protected ProgressControl progressControl;
    private long realizeTime;
    private long prefetchTime;
    static String NOT_CONFIGURED_ERROR;
    static String NOT_REALIZED_ERROR;
    static String STARTED_ERROR;
    String configError = "Failed to configure: " + this;
    String configIntError = "  The configure process is being interrupted.\n";
    String configInt2Error = "interrupted while the Processor is being configured.";
    String parseError = "failed to parse the input media.";
    protected String realizeError = "Failed to realize: " + this;
    protected String timeBaseError = "  Cannot manage the different time bases.\n";
    protected String genericProcessorError = "cannot handle the customized options set on the Processor.\nCheck jmf.log for full details.";
    String prefetchError = "Failed to prefetch: " + this;
    RTPInfo rtpInfo = null;
    boolean testedRTP = false;
    boolean prefetchLogged = false;
    long markedDataStartTime = 0L;
    boolean reportOnce = false;
    long lastBitRate = 0L;
    long lastStatsTime = 0L;
    static boolean USE_MASTER;
    static boolean USE_BACKUP;

    static {
        try {
            Toolkit.getDefaultToolkit();
        }
        catch (Throwable throwable) {
            DEBUG = false;
        }
        NOT_CONFIGURED_ERROR = "cannot be called before configured";
        NOT_REALIZED_ERROR = "cannot be called before realized";
        STARTED_ERROR = "cannot be called after started";
        USE_MASTER = true;
        USE_BACKUP = false;
    }

    public PlaybackEngine(BasicPlayer basicPlayer) {
        long l2 = System.currentTimeMillis();
        this.player = basicPlayer;
        this.createProgressControl();
        this.slaveClock = new SlaveClock();
        this.setClock(this.slaveClock);
        this.stopThreadEnabled = false;
        PlaybackEngine.profile("instantiation", l2);
    }

    protected synchronized void abortConfigure() {
        if (this.source != null) {
            this.source.abortRealize();
        }
    }

    protected synchronized void abortPrefetch() {
        this.timeBeforeAbortPrefetch = this.getMediaTime();
        this.doReset();
        int n2 = this.modules.size();
        int n3 = 0;
        while (n3 < n2) {
            StateTransistor stateTransistor = (StateTransistor)this.modules.elementAt(n3);
            stateTransistor.abortPrefetch();
            ++n3;
        }
        this.deallocated = true;
    }

    protected synchronized void abortRealize() {
        int n2 = this.modules.size();
        int n3 = 0;
        while (n3 < n2) {
            StateTransistor stateTransistor = (StateTransistor)this.modules.elementAt(n3);
            stateTransistor.abortRealize();
            ++n3;
        }
    }

    public boolean audioEnabled() {
        int n2 = 0;
        while (n2 < this.trackControls.length) {
            if (this.trackControls[n2].isEnabled() && this.trackControls[n2].getOriginalFormat() instanceof AudioFormat) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void bufferPrefetched(Module module) {
        if (!this.prefetchEnabled) {
            return;
        }
        if (module instanceof BasicSinkModule) {
            Vector vector = this.waitPrefetched;
            synchronized (vector) {
                if (this.waitPrefetched.contains(module)) {
                    this.waitPrefetched.removeElement(module);
                }
                if (this.waitPrefetched.isEmpty()) {
                    this.waitPrefetched.notifyAll();
                    if (!this.prefetchLogged) {
                        PlaybackEngine.profile("prefetch", this.prefetchTime);
                        this.prefetchLogged = true;
                    }
                    if (this.getState() != 600 && this.getTargetState() != 600) {
                        this.source.pause();
                    }
                    this.prefetched = true;
                }
            }
        }
    }

    protected GraphNode buildTrackFromGraph(BasicTrackControl basicTrackControl, GraphNode graphNode) {
        BasicModule basicModule = null;
        BasicModule basicModule2 = null;
        InputConnector inputConnector = null;
        OutputConnector outputConnector = null;
        boolean bl = true;
        Vector vector = new Vector(5);
        int n2 = 0;
        if (graphNode.plugin == null) {
            return null;
        }
        Log.setIndent(n2++);
        while (graphNode != null && graphNode.plugin != null) {
            basicModule = this.createModule(graphNode, vector);
            if (basicModule == null) {
                Log.error("Internal error: buildTrackFromGraph");
                graphNode.failed = true;
                return graphNode;
            }
            if (bl) {
                if (basicModule instanceof BasicRendererModule) {
                    basicTrackControl.rendererModule = (BasicRendererModule)basicModule;
                    if (this.useMoreRenderBuffer && basicTrackControl.rendererModule.getRenderer() instanceof AudioRenderer) {
                        this.setRenderBufferSize(basicTrackControl.rendererModule.getRenderer());
                    }
                } else if (basicModule instanceof BasicFilterModule) {
                    basicTrackControl.lastOC = basicModule.getOutputConnector(null);
                    basicTrackControl.lastOC.setFormat(graphNode.output);
                }
                bl = false;
            }
            inputConnector = basicModule.getInputConnector(null);
            inputConnector.setFormat(graphNode.input);
            if (basicModule2 != null) {
                outputConnector = basicModule.getOutputConnector(null);
                inputConnector = basicModule2.getInputConnector(null);
                outputConnector.setFormat(inputConnector.getFormat());
            }
            basicModule.setController(this);
            if (!basicModule.doRealize()) {
                Log.setIndent(n2--);
                graphNode.failed = true;
                return graphNode;
            }
            if (outputConnector != null && inputConnector != null) {
                this.connectModules(outputConnector, inputConnector, basicModule2);
            }
            basicModule2 = basicModule;
            graphNode = graphNode.prev;
        }
        basicModule2 = basicModule;
        do {
            basicModule2.setModuleListener(this);
            this.modules.addElement(basicModule2);
            basicTrackControl.modules.addElement(basicModule2);
            if (basicModule2 instanceof BasicFilterModule) {
                this.filters.addElement(basicModule2);
                continue;
            }
            if (!(basicModule2 instanceof BasicSinkModule)) continue;
            this.sinks.addElement(basicModule2);
        } while ((outputConnector = basicModule2.getOutputConnector(null)) != null && (inputConnector = outputConnector.getInputConnector()) != null && (basicModule2 = (BasicModule)inputConnector.getModule()) != null);
        basicTrackControl.firstOC.setFormat(basicTrackControl.getOriginalFormat());
        inputConnector = basicModule.getInputConnector(null);
        Format format = inputConnector.getFormat();
        if (format == null || !format.equals(basicTrackControl.getOriginalFormat())) {
            inputConnector.setFormat(basicTrackControl.getOriginalFormat());
        }
        this.connectModules(basicTrackControl.firstOC, inputConnector, basicModule);
        Log.setIndent(n2--);
        return null;
    }

    protected void connectModules(OutputConnector outputConnector, InputConnector inputConnector, BasicModule basicModule) {
        if (basicModule instanceof BasicRendererModule) {
            outputConnector.setProtocol(inputConnector.getProtocol());
        } else {
            inputConnector.setProtocol(outputConnector.getProtocol());
        }
        outputConnector.connectTo(inputConnector, inputConnector.getFormat());
    }

    protected BasicModule createModule(GraphNode graphNode, Vector vector) {
        PlugIn plugIn;
        BasicModule basicModule = null;
        if (graphNode.plugin == null) {
            return null;
        }
        if (vector.contains(graphNode.plugin)) {
            if (graphNode.cname == null || (plugIn = SimpleGraphBuilder.createPlugIn(graphNode.cname, -1)) == null) {
                Log.write("Failed to instantiate " + graphNode.cname);
                return null;
            }
        } else {
            plugIn = graphNode.plugin;
            vector.addElement(plugIn);
        }
        if ((graphNode.type == -1 || graphNode.type == 4) && plugIn instanceof Renderer) {
            basicModule = new BasicRendererModule((Renderer)plugIn);
        } else if ((graphNode.type == -1 || graphNode.type == 2) && plugIn instanceof Codec) {
            basicModule = new BasicFilterModule((Codec)plugIn);
        }
        if (DEBUG && basicModule != null) {
            basicModule.setJMD(this.jmd);
        }
        return basicModule;
    }

    public void createProgressControl() {
        StringControlAdapter stringControlAdapter = new StringControlAdapter();
        stringControlAdapter.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        StringControlAdapter stringControlAdapter2 = new StringControlAdapter();
        stringControlAdapter2.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        StringControlAdapter stringControlAdapter3 = new StringControlAdapter();
        stringControlAdapter3.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        StringControlAdapter stringControlAdapter4 = new StringControlAdapter();
        stringControlAdapter4.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        StringControlAdapter stringControlAdapter5 = new StringControlAdapter();
        stringControlAdapter5.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        StringControlAdapter stringControlAdapter6 = new StringControlAdapter();
        stringControlAdapter6.setValue(JMFI18N.getResource("mediaplayer.N/A"));
        this.progressControl = new ProgressControlAdapter(stringControlAdapter, stringControlAdapter2, stringControlAdapter3, stringControlAdapter4, stringControlAdapter6, stringControlAdapter5);
    }

    protected Component createVisualContainer(Vector vector) {
        Boolean bl = (Boolean)Manager.getHint(3);
        if (this.container == null) {
            this.container = bl == null || bl == false ? new HeavyPanel(vector) : new LightPanel(vector);
            this.container.setLayout(new FlowLayout());
            this.container.setBackground(Color.black);
            int n2 = 0;
            while (n2 < vector.size()) {
                Component component = (Component)vector.elementAt(n2);
                this.container.add(component);
                component.setSize(component.getPreferredSize());
                ++n2;
            }
        }
        return this.container;
    }

    public void dataBlocked(Module module, boolean bl) {
        this.dataPathBlocked = bl;
        if (bl) {
            this.resetPrefetchedList();
            this.resetResettedList();
        }
        if (this.getTargetState() != 600) {
            return;
        }
        if (bl) {
            this.localStop();
            this.setTargetState(600);
            this.sendEvent(new RestartingEvent(this, 600, 400, 600, this.getMediaTime()));
        } else {
            this.sendEvent(new StartEvent(this, 500, 600, 600, this.getMediaTime(), this.getTimeBase().getTime()));
        }
    }

    protected synchronized void doClose() {
        if (this.modules == null) {
            if (this.source != null) {
                this.source.doClose();
            }
            return;
        }
        if (this.getState() == 600) {
            this.localStop();
        }
        if (this.getState() == 500) {
            this.doReset();
        }
        int n2 = this.modules.size();
        int n3 = 0;
        while (n3 < n2) {
            StateTransistor stateTransistor = (StateTransistor)this.modules.elementAt(n3);
            stateTransistor.doClose();
            ++n3;
        }
        if (needSavingDB) {
            Resource.saveDB();
            needSavingDB = false;
        }
    }

    protected boolean doConfigure() {
        if (!this.doConfigure1()) {
            return false;
        }
        String[] stringArray = this.source.getOutputConnectorNames();
        this.trackControls = new BasicTrackControl[this.tracks.length];
        int n2 = 0;
        while (n2 < this.tracks.length) {
            this.trackControls[n2] = new PlayerTControl(this, this.tracks[n2], this.source.getOutputConnector(stringArray[n2]));
            ++n2;
        }
        return this.doConfigure2();
    }

    protected boolean doConfigure1() {
        long l2 = System.currentTimeMillis();
        this.modules = new Vector();
        this.filters = new Vector();
        this.sinks = new Vector();
        this.waitPrefetched = new Vector();
        this.waitStopped = new Vector();
        this.waitEnded = new Vector();
        this.waitResetted = new Vector();
        this.source.setModuleListener(this);
        this.source.setController(this);
        this.modules.addElement(this.source);
        if (!this.source.doRealize()) {
            Log.error(this.configError);
            if (this.source.errMsg != null) {
                Log.error("  " + this.source.errMsg + "\n");
            }
            this.player.processError = this.parseError;
            return false;
        }
        if (this.isInterrupted()) {
            Log.error(this.configError);
            Log.error(this.configIntError);
            this.player.processError = this.configInt2Error;
            return false;
        }
        this.parser = this.source.getDemultiplexer();
        if (this.parser == null) {
            Log.error(this.configError);
            Log.error("  Cannot obtain demultiplexer for the source.\n");
            this.player.processError = this.parseError;
            return false;
        }
        try {
            this.tracks = this.parser.getTracks();
        }
        catch (Exception exception) {
            Log.error(this.configError);
            Log.error("  Cannot obtain tracks from the demultiplexer: " + exception + "\n");
            this.player.processError = this.parseError;
            return false;
        }
        if (this.isInterrupted()) {
            Log.error(this.configError);
            Log.error(this.configIntError);
            this.player.processError = this.configInt2Error;
            return false;
        }
        PlaybackEngine.profile("parsing", l2);
        return true;
    }

    protected boolean doConfigure2() {
        Track track;
        if (this.parser.isPositionable() && this.parser.isRandomAccess() && (track = FramePositioningAdapter.getMasterTrack(this.tracks)) != null) {
            this.framePositioningControl = new FramePositioningAdapter(this.player, track);
        }
        return true;
    }

    protected void doDeallocate() {
    }

    protected synchronized void doFailedPrefetch() {
        int n2 = this.modules.size();
        int n3 = 0;
        while (n3 < n2) {
            StateTransistor stateTransistor = (StateTransistor)this.modules.elementAt(n3);
            stateTransistor.doFailedPrefetch();
            ++n3;
        }
        super.doFailedPrefetch();
    }

    protected synchronized void doFailedRealize() {
        int n2 = this.modules.size();
        int n3 = 0;
        while (n3 < n2) {
            StateTransistor stateTransistor = (StateTransistor)this.modules.elementAt(n3);
            stateTransistor.doFailedRealize();
            ++n3;
        }
        super.doFailedRealize();
    }

    protected synchronized boolean doPrefetch() {
        if (this.prefetched) {
            return true;
        }
        return this.doPrefetch1() && this.doPrefetch2();
    }

    protected boolean doPrefetch1() {
        if (this.timeBeforeAbortPrefetch != null) {
            this.doSetMediaTime(this.timeBeforeAbortPrefetch);
            this.timeBeforeAbortPrefetch = null;
        }
        this.prefetchTime = System.currentTimeMillis();
        this.resetPrefetchedList();
        if (!this.source.doPrefetch()) {
            Log.error(this.prefetchError);
            if (this.dsource != null) {
                Log.error("  Cannot prefetch the source: " + this.dsource.getLocator() + "\n");
            }
            return false;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.trackControls.length) {
            boolean bl2 = this.trackControls[n2].prefetchFailed;
            if (!bl2 || this.getState() <= 400) {
                if (this.trackControls[n2].prefetchTrack()) {
                    bl = true;
                    if (bl2) {
                        if (!this.manageTimeBases()) {
                            Log.error(this.prefetchError);
                            Log.error(this.timeBaseError);
                            return false;
                        }
                        this.doSetMediaTime(this.getMediaTime());
                    }
                } else {
                    this.trackControls[n2].prError();
                    if (this.trackControls[n2].isTimeBase() && !this.manageTimeBases()) {
                        Log.error(this.prefetchError);
                        Log.error(this.timeBaseError);
                        this.player.processError = this.timeBaseError;
                        return false;
                    }
                    if (this.trackControls[n2].getFormat() instanceof AudioFormat && this.trackControls[n2].rendererFailed) {
                        this.player.processError = "cannot open the audio device.";
                    }
                }
            }
            ++n2;
        }
        if (!bl) {
            Log.error(this.prefetchError);
            return false;
        }
        this.player.processError = null;
        return true;
    }

    protected boolean doPrefetch2() {
        if (this.prefetchEnabled) {
            Vector vector = this.waitPrefetched;
            synchronized (vector) {
                this.source.doStart();
                try {
                    if (!this.waitPrefetched.isEmpty()) {
                        this.waitPrefetched.wait(3000L);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.prefetched = true;
        this.deallocated = false;
        return true;
    }

    protected synchronized boolean doRealize() {
        return this.doRealize1() && this.doRealize2();
    }

    protected boolean doRealize1() {
        Log.comment("Building flow graph for: " + this.dsource.getLocator() + "\n");
        this.realizeTime = System.currentTimeMillis();
        boolean bl = false;
        int n2 = 0;
        int n3 = this.getNumTracks();
        int n4 = 0;
        while (n4 < this.trackControls.length) {
            if (this.trackControls[n4].isEnabled()) {
                Log.setIndent(0);
                Log.comment("Building Track: " + n4);
                if (this.trackControls[n4].buildTrack(n2, n3)) {
                    bl = true;
                    this.trackControls[n4].setEnabled(true);
                } else {
                    if (this.trackControls[n4].isCustomized()) {
                        Log.error(this.realizeError);
                        this.trackControls[n4].prError();
                        this.player.processError = this.genericProcessorError;
                        return false;
                    }
                    this.trackControls[n4].setEnabled(false);
                    Log.warning("Failed to handle track " + n4);
                    this.trackControls[n4].prError();
                }
                if (this.isInterrupted()) {
                    Log.error(this.realizeError);
                    Log.error("  The graph building process is being interrupted.\n");
                    this.player.processError = "interrupted while the player is being constructed.";
                    return false;
                }
                ++n2;
                Log.write("\n");
            }
            ++n4;
        }
        if (!bl) {
            Log.error(this.realizeError);
            this.player.processError = "input media not supported: " + this.getCodecList();
            return false;
        }
        return true;
    }

    protected boolean doRealize2() {
        if (!this.manageTimeBases()) {
            Log.error(this.realizeError);
            Log.error(this.timeBaseError);
            this.player.processError = this.timeBaseError;
            return false;
        }
        Log.comment("Here's the completed flow graph:");
        this.traceGraph(this.source);
        Log.write("\n");
        PlaybackEngine.profile("graph building", this.realizeTime);
        this.realizeTime = System.currentTimeMillis();
        this.updateFormats();
        if (DEBUG) {
            this.jmd.initGraph(this.source);
        }
        PlaybackEngine.profile("realize, post graph building", this.realizeTime);
        return true;
    }

    protected synchronized void doReset() {
        Vector vector = this.waitResetted;
        synchronized (vector) {
            BasicSinkModule basicSinkModule;
            this.resetResettedList();
            int n2 = this.modules.size();
            int n3 = n2 - 1;
            while (n3 >= 0) {
                BasicModule basicModule = (BasicModule)this.modules.elementAt(n3);
                if (!basicModule.prefetchFailed()) {
                    basicModule.reset();
                }
                --n3;
            }
            n2 = this.sinks.size();
            int n4 = 0;
            while (n4 < n2) {
                basicSinkModule = (BasicSinkModule)this.sinks.elementAt(n4);
                if (!basicSinkModule.prefetchFailed()) {
                    basicSinkModule.triggerReset();
                }
                ++n4;
            }
            if (!this.waitResetted.isEmpty()) {
                try {
                    this.waitResetted.wait(3000L);
                }
                catch (Exception exception) {}
            }
            n2 = this.sinks.size();
            int n5 = 0;
            while (n5 < n2) {
                basicSinkModule = (BasicSinkModule)this.sinks.elementAt(n5);
                if (!basicSinkModule.prefetchFailed()) {
                    basicSinkModule.doneReset();
                }
                ++n5;
            }
        }
        this.prefetched = false;
    }

    protected void doSetMediaTime(Time time) {
        this.slaveClock.setMediaTime(time);
        Time time2 = this.source.setPosition(time, 0);
        if (time2 == null) {
            time2 = time;
        }
        int n2 = this.sinks.size();
        int n3 = 0;
        while (n3 < n2) {
            BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(n3);
            basicSinkModule.doSetMediaTime(time);
            basicSinkModule.setPreroll(time.getNanoseconds(), time2.getNanoseconds());
            ++n3;
        }
    }

    public synchronized float doSetRate(float f2) {
        if (f2 <= 0.0f) {
            f2 = 1.0f;
        }
        if (f2 == this.rate) {
            return f2;
        }
        f2 = this.masterSink == null ? this.getClock().setRate(f2) : this.masterSink.doSetRate(f2);
        int n2 = this.modules.size();
        int n3 = 0;
        while (n3 < n2) {
            BasicModule basicModule = (BasicModule)this.modules.elementAt(n3);
            if (basicModule != this.masterSink) {
                basicModule.doSetRate(f2);
            }
            ++n3;
        }
        this.rate = f2;
        return f2;
    }

    protected synchronized void doStart() {
        if (this.started) {
            return;
        }
        this.doStart1();
        this.doStart2();
    }

    protected void doStart1() {
        if (this.dsource instanceof CaptureDevice || this.isRTP()) {
            this.reset();
        }
        this.resetPrefetchedList();
        this.resetStoppedList();
        this.resetEndedList();
        int n2 = 0;
        while (n2 < this.trackControls.length) {
            if (this.trackControls[n2].isEnabled()) {
                this.trackControls[n2].startTrack();
            }
            ++n2;
        }
    }

    protected void doStart2() {
        this.source.doStart();
        this.started = true;
        this.prefetched = true;
    }

    protected synchronized void doStop() {
        if (!this.started) {
            return;
        }
        this.doStop1();
        this.doStop2();
    }

    protected void doStop1() {
        this.resetPrefetchedList();
        this.source.doStop();
        int n2 = 0;
        while (n2 < this.trackControls.length) {
            if (this.trackControls[n2].isEnabled()) {
                this.trackControls[n2].stopTrack();
            }
            ++n2;
        }
    }

    protected void doStop2() {
        if (!this.prefetchEnabled) {
            this.source.pause();
        }
        this.started = false;
    }

    protected BasicSinkModule findMasterSink() {
        int n2 = 0;
        while (n2 < this.trackControls.length) {
            if (this.trackControls[n2].isEnabled() && this.trackControls[n2].rendererModule != null && this.trackControls[n2].rendererModule.getClock() != null) {
                return this.trackControls[n2].rendererModule;
            }
            ++n2;
        }
        return null;
    }

    public void formatChanged(Module module, Format format, Format format2) {
        Log.comment(String.valueOf(String.valueOf(module)) + ": input format changed: " + format2);
        if (module instanceof BasicRendererModule && format instanceof VideoFormat && format2 instanceof VideoFormat) {
            Dimension dimension = ((VideoFormat)format).getSize();
            Dimension dimension2 = ((VideoFormat)format2).getSize();
            if (!(dimension2 == null || dimension != null && dimension.equals(dimension2))) {
                this.sendEvent(new SizeChangeEvent(this, dimension2.width, dimension2.height, 1.0f));
            }
        }
    }

    public void formatChangedFailure(Module module, Format format, Format format2) {
        if (!this.internalErrorOccurred) {
            this.sendEvent(new InternalErrorEvent(this, "Internal module " + module + ": failed to handle a data format change!"));
            this.internalErrorOccurred = true;
            this.close();
        }
    }

    public void framesBehind(Module module, float f2, InputConnector inputConnector) {
        while (inputConnector != null) {
            OutputConnector outputConnector = inputConnector.getOutputConnector();
            if (outputConnector == null || (module = outputConnector.getModule()) == null || !(module instanceof BasicFilterModule)) break;
            BasicFilterModule basicFilterModule = (BasicFilterModule)module;
            basicFilterModule.setFramesBehind(f2);
            inputConnector = module.getInputConnector(null);
        }
    }

    protected long getBitRate() {
        return this.source.getBitsRead();
    }

    public String getCNAME() {
        if (this.rtpInfo == null && (this.rtpInfo = (RTPInfo)this.dsource.getControl("com.sun.media.util.RTPInfo")) == null) {
            return null;
        }
        return this.rtpInfo.getCNAME();
    }

    String getCodecList() {
        String string = "";
        int n2 = 0;
        while (n2 < this.trackControls.length) {
            Format format = this.trackControls[n2].getOriginalFormat();
            if (format != null && format.getEncoding() != null) {
                string = String.valueOf(string) + format.getEncoding();
                if (format instanceof VideoFormat) {
                    string = String.valueOf(string) + " video";
                } else if (format instanceof AudioFormat) {
                    string = String.valueOf(string) + " audio";
                }
                if (n2 + 1 < this.trackControls.length) {
                    string = String.valueOf(string) + ", ";
                }
            }
            ++n2;
        }
        return string;
    }

    public Control[] getControls() {
        Vector<Object> vector = new Vector<Object>();
        int n2 = this.modules == null ? 0 : this.modules.size();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            Module module = (Module)this.modules.elementAt(n4);
            Object[] objectArray = module.getControls();
            if (objectArray != null) {
                int n5 = 0;
                while (n5 < objectArray.length) {
                    vector.addElement(objectArray[n5]);
                    ++n5;
                }
            }
            ++n4;
        }
        n2 = vector.size();
        if (this.videoEnabled() && this.frameRateControl == null) {
            this.frameRateControl = new FrameRateAdapter(this.player, 0.0f, 0.0f, 30.0f, false){

                public Component getControlComponent() {
                    return null;
                }

                public Object getOwner() {
                    return PlaybackEngine.this.player;
                }

                public float setFrameRate(float f2) {
                    this.value = f2;
                    return -1.0f;
                }
            };
        }
        if (this.bitRateControl == null) {
            this.bitRateControl = new BitRateA(0, -1, -1, false);
        }
        if (this.frameRateControl != null) {
            ++n3;
        }
        if (this.bitRateControl != null) {
            ++n3;
        }
        if (this.framePositioningControl != null) {
            ++n3;
        }
        if (DEBUG) {
            ++n3;
        }
        Control[] controlArray = new Control[n2 + n3 + this.trackControls.length];
        n4 = 0;
        while (n4 < n2) {
            controlArray[n4] = (Control)vector.elementAt(n4);
            ++n4;
        }
        if (this.bitRateControl != null) {
            controlArray[n2++] = this.bitRateControl;
        }
        if (this.frameRateControl != null) {
            controlArray[n2++] = this.frameRateControl;
        }
        if (this.framePositioningControl != null) {
            controlArray[n2++] = this.framePositioningControl;
        }
        if (DEBUG) {
            controlArray[n2++] = this.jmd;
        }
        n4 = 0;
        while (n4 < this.trackControls.length) {
            controlArray[n2 + n4] = this.trackControls[n4];
            ++n4;
        }
        return controlArray;
    }

    public Time getDuration() {
        return this.source.getDuration();
    }

    public GainControl getGainControl() {
        return (GainControl)this.getControl("javax.media.GainControl");
    }

    public long getLatency() {
        return this.latency;
    }

    int getNumTracks() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.trackControls.length) {
            if (this.trackControls[n3].isEnabled()) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    protected PlugIn getPlugIn(BasicModule basicModule) {
        if (basicModule instanceof BasicSourceModule) {
            return ((BasicSourceModule)basicModule).getDemultiplexer();
        }
        if (basicModule instanceof BasicFilterModule) {
            return ((BasicFilterModule)basicModule).getCodec();
        }
        if (basicModule instanceof BasicRendererModule) {
            return ((BasicRendererModule)basicModule).getRenderer();
        }
        return null;
    }

    public Time getStartLatency() {
        if (this.state == 100 || this.state == 200) {
            this.throwError(new NotRealizedError("Cannot get start latency from an unrealized controller"));
        }
        return Controller.LATENCY_UNKNOWN;
    }

    public TimeBase getTimeBase() {
        return this.getClock().getTimeBase();
    }

    public Component getVisualComponent() {
        Vector<Component> vector = new Vector<Component>(1);
        if (this.modules == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.modules.size()) {
            Component component;
            BasicModule basicModule = (BasicModule)this.modules.elementAt(n2);
            PlugIn plugIn = this.getPlugIn(basicModule);
            if (plugIn instanceof VideoRenderer && (component = ((VideoRenderer)plugIn).getComponent()) != null) {
                vector.addElement(component);
            }
            ++n2;
        }
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return (Component)vector.elementAt(0);
        }
        return this.createVisualContainer(vector);
    }

    public void internalErrorOccurred(Module module) {
        if (!this.internalErrorOccurred) {
            this.sendEvent(new InternalErrorEvent(this, "Internal module " + module + " failed!"));
            this.internalErrorOccurred = true;
            this.close();
        }
    }

    protected boolean isConfigurable() {
        return true;
    }

    public boolean isRTP() {
        if (this.testedRTP) {
            return this.rtpInfo != null;
        }
        this.rtpInfo = (RTPInfo)this.dsource.getControl("com.sun.media.util.RTPInfo");
        this.testedRTP = true;
        return this.rtpInfo != null;
    }

    static boolean isRawVideo(Format format) {
        return format instanceof RGBFormat || format instanceof YUVFormat;
    }

    protected BasicModule lastModule(BasicModule basicModule) {
        InputConnector inputConnector;
        OutputConnector outputConnector = basicModule.getOutputConnector(null);
        while (outputConnector != null && (inputConnector = outputConnector.getInputConnector()) != null) {
            basicModule = (BasicModule)inputConnector.getModule();
            outputConnector = basicModule.getOutputConnector(null);
        }
        return basicModule;
    }

    protected synchronized void localStop() {
        super.stop();
    }

    boolean manageTimeBases() {
        this.masterSink = this.findMasterSink();
        return this.updateMasterTimeBase();
    }

    public void markedDataArrived(Module module, Buffer buffer) {
        if (module instanceof BasicSourceModule) {
            this.markedDataStartTime = this.getMediaNanoseconds();
        } else {
            long l2 = this.getMediaNanoseconds() - this.markedDataStartTime;
            if (l2 > 0L && l2 < 1000000000L) {
                if (!this.reportOnce) {
                    Log.comment("Computed latency for video: " + l2 / 1000000L + " ms\n");
                    this.reportOnce = true;
                }
                this.latency = (l2 + this.latency) / 2L;
            }
        }
    }

    public void mediaEnded(Module module) {
        if (module instanceof BasicSinkModule) {
            Vector vector = this.waitEnded;
            synchronized (vector) {
                if (this.waitEnded.contains(module)) {
                    this.waitEnded.removeElement(module);
                }
                if (this.waitEnded.isEmpty()) {
                    this.started = false;
                    this.stopControllerOnly();
                    this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                    this.slaveClock.reset(USE_MASTER);
                } else if (module == this.masterSink) {
                    this.slaveClock.reset(USE_BACKUP);
                }
            }
        }
    }

    public void pluginTerminated(Module module) {
        if (!this.internalErrorOccurred) {
            this.sendEvent(new ControllerClosedEvent(this));
            this.internalErrorOccurred = true;
            this.close();
        }
    }

    static void profile(String string, long l2) {
        Log.profile("Profile: " + string + ": " + (System.currentTimeMillis() - l2) + " ms\n");
    }

    protected synchronized void reset() {
        if (this.started || !this.prefetched || this.dataPathBlocked) {
            return;
        }
        this.doReset();
    }

    protected void resetBitRate() {
        this.source.resetBitsRead();
    }

    private void resetEndedList() {
        Vector vector = this.waitEnded;
        synchronized (vector) {
            this.waitEnded.removeAllElements();
            int n2 = this.sinks.size();
            int n3 = 0;
            while (n3 < n2) {
                BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(n3);
                if (!basicSinkModule.prefetchFailed()) {
                    this.waitEnded.addElement(basicSinkModule);
                }
                ++n3;
            }
            this.waitEnded.notifyAll();
        }
    }

    private void resetPrefetchedList() {
        Vector vector = this.waitPrefetched;
        synchronized (vector) {
            this.waitPrefetched.removeAllElements();
            int n2 = this.sinks.size();
            int n3 = 0;
            while (n3 < n2) {
                BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(n3);
                if (!basicSinkModule.prefetchFailed()) {
                    this.waitPrefetched.addElement(basicSinkModule);
                }
                ++n3;
            }
            this.waitPrefetched.notifyAll();
        }
    }

    private void resetResettedList() {
        Vector vector = this.waitResetted;
        synchronized (vector) {
            this.waitResetted.removeAllElements();
            int n2 = this.sinks.size();
            int n3 = 0;
            while (n3 < n2) {
                BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(n3);
                if (!basicSinkModule.prefetchFailed()) {
                    this.waitResetted.addElement(basicSinkModule);
                }
                ++n3;
            }
            this.waitResetted.notifyAll();
        }
    }

    private void resetStoppedList() {
        Vector vector = this.waitStopped;
        synchronized (vector) {
            this.waitStopped.removeAllElements();
            int n2 = this.sinks.size();
            int n3 = 0;
            while (n3 < n2) {
                BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(n3);
                if (!basicSinkModule.prefetchFailed()) {
                    this.waitStopped.addElement(basicSinkModule);
                }
                ++n3;
            }
            this.waitStopped.notifyAll();
        }
    }

    public void resetted(Module module) {
        Vector vector = this.waitResetted;
        synchronized (vector) {
            if (this.waitResetted.contains(module)) {
                this.waitResetted.removeElement(module);
            }
            if (this.waitResetted.isEmpty()) {
                this.waitResetted.notifyAll();
            }
        }
    }

    public synchronized void setMediaTime(Time time) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError("Cannot set media time on a unrealized controller"));
        }
        if (time.getNanoseconds() == this.getMediaNanoseconds()) {
            return;
        }
        this.reset();
        this.timeBeforeAbortPrefetch = null;
        this.doSetMediaTime(time);
        this.doPrefetch();
        this.sendEvent(new MediaTimeSetEvent(this, time));
    }

    public static void setMemoryTrace(boolean bl) {
        TRACE_ON = bl;
    }

    public void setProgressControl(ProgressControl progressControl) {
        this.progressControl = progressControl;
    }

    protected void setRenderBufferSize(Renderer renderer) {
        BufferControl bufferControl = (BufferControl)renderer.getControl("javax.media.control.BufferControl");
        if (bufferControl != null) {
            bufferControl.setBufferLength(2000L);
        }
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        try {
            this.source = BasicSourceModule.createModule(dataSource);
        }
        catch (IOException iOException) {
            Log.warning("Input DataSource: " + dataSource);
            Log.warning("  Failed with IO exception: " + iOException.getMessage());
            throw iOException;
        }
        catch (IncompatibleSourceException incompatibleSourceException) {
            Log.warning("Input DataSource: " + dataSource);
            Log.warning("  is not compatible with the MediaEngine.");
            Log.warning("  It's likely that the DataSource is required to extend PullDataSource;");
            Log.warning("  and that its source streams implement the Seekable interface ");
            Log.warning("  and with random access capability.");
            throw incompatibleSourceException;
        }
        if (this.source == null) {
            throw new IncompatibleSourceException();
        }
        if (DEBUG && this.jmd == null) {
            String string = "PlugIn Viewer";
            if (dataSource != null && dataSource.getLocator() != null) {
                string = dataSource.getLocator().toString();
                String string2 = dataSource.getLocator().getProtocol();
                if (string2 != null && ((string2 = string2.toLowerCase()).equals("file") || string2.startsWith("http") || string2.equals("ftp"))) {
                    this.useMoreRenderBuffer = true;
                }
            }
            this.jmd = new BasicJMD(string);
        }
        if (DEBUG) {
            this.source.setJMD(this.jmd);
        }
        this.source.setController(this);
        this.dsource = dataSource;
        if (this.dsource instanceof Streamable && !((Streamable)((Object)this.dsource)).isPrefetchable()) {
            this.prefetchEnabled = false;
            this.dataPathBlocked = true;
        }
        if (this.dsource instanceof CaptureDevice) {
            this.prefetchEnabled = false;
        }
    }

    public void setStopTime(Time time) {
        if (this.getState() < 300) {
            this.throwError(new NotRealizedError("Cannot set stop time on an unrealized controller."));
        }
        if (this.getStopTime() != null && this.getStopTime().getNanoseconds() != time.getNanoseconds()) {
            this.sendEvent(new StopTimeChangeEvent(this, time));
        }
        if (this.getState() == 600 && time != Clock.RESET && time.getNanoseconds() < this.getMediaNanoseconds()) {
            this.localStop();
            this.setStopTime(Clock.RESET);
            this.sendEvent(new StopAtTimeEvent(this, this.getState(), 500, this.getTargetState(), this.getMediaTime()));
        } else {
            this.getClock().setStopTime(time);
            int n2 = this.sinks.size();
            int n3 = 0;
            while (n3 < n2) {
                BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(n3);
                basicSinkModule.setStopTime(time);
                ++n3;
            }
        }
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        this.getClock().setTimeBase(timeBase);
        if (this.sinks == null) {
            return;
        }
        int n2 = this.sinks.size();
        int n3 = 0;
        while (n3 < n2) {
            BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(n3);
            basicSinkModule.setTimeBase(timeBase);
            ++n3;
        }
    }

    public synchronized void stop() {
        super.stop();
        this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    public void stopAtTime(Module module) {
        if (module instanceof BasicSinkModule) {
            Vector vector = this.waitStopped;
            synchronized (vector) {
                if (this.waitStopped.contains(module)) {
                    this.waitStopped.removeElement(module);
                }
                if (this.waitStopped.isEmpty() || this.waitEnded.size() == 1 && this.waitEnded.contains(module)) {
                    this.started = false;
                    this.stopControllerOnly();
                    this.setStopTime(Clock.RESET);
                    this.sendEvent(new StopAtTimeEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                    this.slaveClock.reset(USE_MASTER);
                } else if (module == this.masterSink) {
                    this.slaveClock.reset(USE_BACKUP);
                }
            }
        }
    }

    void traceGraph(BasicModule basicModule) {
        String[] stringArray = basicModule.getOutputConnectorNames();
        int n2 = 0;
        while (n2 < stringArray.length) {
            Module module;
            OutputConnector outputConnector = basicModule.getOutputConnector(stringArray[n2]);
            InputConnector inputConnector = outputConnector.getInputConnector();
            if (inputConnector != null && (module = inputConnector.getModule()) != null) {
                Log.write("  " + this.getPlugIn(basicModule));
                Log.write("     connects to: " + this.getPlugIn((BasicModule)module));
                Log.write("     format: " + outputConnector.getFormat());
                this.traceGraph((BasicModule)module);
            }
            ++n2;
        }
    }

    public void updateFormats() {
        int n2 = 0;
        while (n2 < this.trackControls.length) {
            this.trackControls[n2].updateFormat();
            ++n2;
        }
    }

    boolean updateMasterTimeBase() {
        int n2 = this.sinks.size();
        if (this.masterSink != null) {
            this.slaveClock.setMaster(this.masterSink.getClock());
        } else {
            this.slaveClock.setMaster(null);
        }
        int n3 = 0;
        while (n3 < n2) {
            BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(n3);
            if (basicSinkModule != this.masterSink && !basicSinkModule.prefetchFailed()) {
                try {
                    basicSinkModule.setTimeBase(this.slaveClock.getTimeBase());
                }
                catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
                    return false;
                }
            }
            ++n3;
        }
        return true;
    }

    public void updateRates() {
        if (this.getState() < 300) {
            return;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 == this.lastStatsTime ? this.lastBitRate : (long)((double)this.getBitRate() * 8.0 / (double)(l2 - this.lastStatsTime) * 1000.0);
        long l4 = (this.lastBitRate + l3) / 2L;
        if (this.bitRateControl != null) {
            this.bitRateControl.setBitRate((int)l4);
        }
        this.lastBitRate = l3;
        this.lastStatsTime = l2;
        this.resetBitRate();
        int n2 = 0;
        while (n2 < this.trackControls.length) {
            this.trackControls[n2].updateRates(l2);
            ++n2;
        }
        this.source.checkLatency();
    }

    public boolean videoEnabled() {
        int n2 = 0;
        while (n2 < this.trackControls.length) {
            if (this.trackControls[n2].isEnabled() && this.trackControls[n2].getOriginalFormat() instanceof VideoFormat) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    class BitRateA
    extends BitRateAdapter
    implements Owned {
        public BitRateA(int n2, int n3, int n4, boolean bl) {
            super(n2, n3, n4, bl);
        }

        public Component getControlComponent() {
            return null;
        }

        public Object getOwner() {
            return PlaybackEngine.this.player;
        }

        public int setBitRate(int n2) {
            this.value = n2;
            return this.value;
        }
    }

    class SlaveClock
    implements Clock {
        Clock master;
        Clock current;
        BasicClock backup = new BasicClock();

        SlaveClock() {
            this.current = this.backup;
        }

        public long getMediaNanoseconds() {
            return this.current.getMediaNanoseconds();
        }

        public Time getMediaTime() {
            return this.current.getMediaTime();
        }

        public float getRate() {
            return this.current.getRate();
        }

        public Time getStopTime() {
            return this.backup.getStopTime();
        }

        public Time getSyncTime() {
            return this.current.getSyncTime();
        }

        public TimeBase getTimeBase() {
            return this.current.getTimeBase();
        }

        public Time mapToTimeBase(Time time) throws ClockStoppedException {
            return this.current.mapToTimeBase(time);
        }

        protected void reset(boolean bl) {
            if (this.master != null && bl) {
                this.current = this.master;
            } else {
                if (this.master != null) {
                    BasicClock basicClock = this.backup;
                    synchronized (basicClock) {
                        boolean bl2 = false;
                        if (this.backup.getState() == 1) {
                            this.backup.stop();
                            bl2 = true;
                        }
                        this.backup.setMediaTime(this.master.getMediaTime());
                        if (bl2) {
                            this.backup.syncStart(this.backup.getTimeBase().getTime());
                        }
                    }
                }
                this.current = this.backup;
            }
        }

        public void setMaster(Clock clock) {
            block2: {
                this.master = clock;
                Clock clock2 = this.current = clock == null ? this.backup : clock;
                if (clock == null) break block2;
                try {
                    this.backup.setTimeBase(clock.getTimeBase());
                }
                catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {}
            }
        }

        public void setMediaTime(Time time) {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                if (this.backup.getState() == 1) {
                    this.backup.stop();
                    this.backup.setMediaTime(time);
                    this.backup.syncStart(this.backup.getTimeBase().getTime());
                } else {
                    this.backup.setMediaTime(time);
                }
            }
        }

        public float setRate(float f2) {
            return this.backup.setRate(f2);
        }

        public void setStopTime(Time time) {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                this.backup.setStopTime(time);
            }
        }

        public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                this.backup.setTimeBase(timeBase);
            }
        }

        public void stop() {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                this.backup.stop();
            }
        }

        public void syncStart(Time time) {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                if (this.backup.getState() != 1) {
                    this.backup.syncStart(time);
                }
            }
        }
    }

    class PlayerTControl
    extends BasicTrackControl
    implements Owned {
        protected PlayerGraphBuilder gb;

        public PlayerTControl(PlaybackEngine playbackEngine2, Track track, OutputConnector outputConnector) {
            super(playbackEngine2, track, outputConnector);
        }

        public boolean buildTrack(int n2, int n3) {
            if (this.gb == null) {
                this.gb = new PlayerGraphBuilder(this.engine);
            } else {
                this.gb.reset();
            }
            boolean bl = this.gb.buildGraph(this);
            this.gb = null;
            return bl;
        }

        protected FrameRateControl frameRateControl() {
            return PlaybackEngine.this.frameRateControl;
        }

        public Object getOwner() {
            return PlaybackEngine.this.player;
        }

        public boolean isTimeBase() {
            int n2 = 0;
            while (n2 < this.modules.size()) {
                if (this.modules.elementAt(n2) == PlaybackEngine.this.masterSink) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        protected ProgressControl progressControl() {
            return PlaybackEngine.this.progressControl;
        }
    }

    class PlayerGraphBuilder
    extends SimpleGraphBuilder {
        protected PlaybackEngine engine;

        PlayerGraphBuilder(PlaybackEngine playbackEngine2) {
            this.engine = playbackEngine2;
        }

        protected GraphNode buildTrackFromGraph(BasicTrackControl basicTrackControl, GraphNode graphNode) {
            return this.engine.buildTrackFromGraph((PlayerTControl)basicTrackControl, graphNode);
        }
    }

    class HeavyPanel
    extends Panel
    implements VisualContainer {
        public HeavyPanel(Vector vector) {
        }
    }

    class LightPanel
    extends Container
    implements VisualContainer {
        public LightPanel(Vector vector) {
        }
    }
}

